/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill.op;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.formplugin.bill.matchbill.op.NegativeBillRedOpPlugin;

public class NegativeBillRevokeOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(NegativeBillRevokeOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("matchstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    String matchStatus = bill.getString("matchstatus");
                    if (!MatchBillConstant.MatchStatusEnum.UN_PROCESS.getCode().equals(matchStatus) && !StringUtils.isBlank((CharSequence)matchStatus)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u5904\u7406\u7684\u8d1f\u6570\u5f00\u7968\u7533\u8bf7\u5355\u4e0d\u652f\u6301\u53d6\u6d88\u5339\u914d\u3002", (String)"NegativeBillRevokeOpPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Object[] ids = new NegativeBillRedOpPlugin().getMatchBillIdArrByOriginalBill(e.getDataEntities());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"cancel_match", (String)"sim_match_bill", (Object[])ids, (OperateOption)this.operateOption);
        if (!operationResult.isSuccess()) {
            LOGGER.info("\u8d1f\u6570\u5f00\u7968\u7533\u8bf7\u5355\u53d6\u6d88\u5339\u914d" + OperationConstant.getErrorMsg((OperationResult)operationResult));
            throw new KDBizException(OperationConstant.getErrorMsg((OperationResult)operationResult));
        }
    }
}

