/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BrowserHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginPreviewIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.util.Dto.CheckResult;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillCommonCustomEvent;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeMethod;
import kd.sdk.annotation.SdkDeprecated;

public abstract class AbstractInvoiceOriginalBillWorkbenchPlugin
extends AbstractListPlugin {
    private static ImmutableMultimap<String, String> BILL_STATUS_OPERATION = new ImmutableMultimap.Builder().putAll((Object)BillStatusEnum.TEMP_SAVE.getCode(), (Object[])new String[]{""}).putAll((Object)BillStatusEnum.IN_AUDIT.getCode(), (Object[])new String[]{""}).putAll((Object)BillStatusEnum.AUDIT_SUCCESS.getCode(), (Object[])new String[]{"issuepush", "bill_process", "bill_process_preview", "addrelateinvoice", "cancelrelateinvoice"}).putAll((Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode(), (Object[])new String[]{"issuepush", "bill_process", "bill_process_preview", "addrelateinvoice", "cancelrelateinvoice"}).build();

    @SdkDeprecated
    public static boolean operationOriginalBill(String billStatus, String itemKey) {
        return StringUtils.isNotBlank((CharSequence)billStatus) && !BILL_STATUS_OPERATION.get((Object)billStatus).contains((Object)itemKey);
    }

    @SdkDeprecated
    public static String getOriginalBillStatuNameByCode(String code) {
        BillStatusEnum[] billStatus = BillStatusEnum.values();
        return Stream.of(billStatus).filter(statu -> statu.getCode().equals(code)).map(BillStatusEnum::getName).findFirst().orElse("");
    }

    @Deprecated
    protected void billProcess(DynamicObject[] bills) {
        this.billProcess(bills, false);
    }

    protected void billProcess(DynamicObject[] bills, boolean isTempSave) {
        HashMap<String, Object> map = new HashMap<String, Object>(bills.length);
        map.put("step", "process");
        if (isTempSave) {
            map.put("tempSavePreview", true);
        }
        this.openWorkBench((AbstractFormPlugin)this, bills, map);
    }

    public void checkBillPreviewSpecialCodeRemark(DynamicObject[] previewBills) {
        DynamicObject[] redBills;
        if (previewBills.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (Arrays.stream(previewBills).anyMatch(bill -> "B".equals(bill.getString("billsourcetype"))) && Arrays.stream(previewBills).anyMatch(bill -> !"B".equals(bill.getString("billsourcetype")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ea2\u51b2\u5355\u636e\u4e0d\u80fd\u4e0e\u5176\u4ed6\u7c7b\u578b\u5355\u636e\u4e00\u8d77\u9884\u89c8\u5f00\u7968\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        ArrayList redList = Lists.newArrayListWithCapacity((int)previewBills.length);
        HashMap<String, String> redConfirmBillNoMap = new HashMap<String, String>();
        for (DynamicObject bill2 : previewBills) {
            if (BillHelper.isRedInfo((DynamicObject)bill2)) {
                redList.add(bill2.getPkValue());
            }
            if (!RedConfirmHelper.isRedConfirmBill((DynamicObject)bill2)) continue;
            String billNo1 = bill2.getString("billno");
            String redConfirmBillNo = bill2.getString("infocode");
            if (StringUtils.isEmpty((CharSequence)redConfirmBillNo)) continue;
            if (redConfirmBillNoMap.containsKey(bill2.getString("infocode"))) {
                String billNo2 = (String)redConfirmBillNoMap.get(redConfirmBillNo);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u548c\u5355\u636e%2$s\u7ed1\u5b9a\u7684\u7ea2\u5b57\u786e\u5b9a\u5355\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_38", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo1, billNo2));
            }
            redConfirmBillNoMap.put(bill2.getString("infocode"), bill2.getString("billno"));
        }
        if (redList.size() > 0 && !this.isSpecialInvoice((AbstractFormPlugin)this, redBills = BusinessDataServiceHelper.load((Object[])redList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill")), "isPreview")) {
            return;
        }
        CheckResult result = OriginalBillFormEditUtil.checkNormalRedReasonInfo((DynamicObject[])previewBills, (Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE);
        ArrayList errMsgList = result.getErrMsgList();
        if (!errMsgList.isEmpty()) {
            String errMsg = String.join((CharSequence)"\r\n", errMsgList);
            ViewUtil.openConfirm((String)"normal_red_invoice", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ea2\u5b57\u666e\u7968\u6570\u636e\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u4fee\u6b63", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)errMsg);
            return;
        }
        ArrayList updateList = result.getUpdateList();
        if (!updateList.isEmpty()) {
            ImcSaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        this.billProcessPreView(previewBills);
    }

    public void billProcessPreView(DynamicObject[] bills) {
        HashMap param = Maps.newHashMap();
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_SHOW_INVOICE, (DynamicObject[])bills);
        try {
            this.checkWorkbenchData((AbstractFormPlugin)this, bills, true);
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        param.put("pks", Arrays.stream(bills).map(DataEntityBase::getPkValue).toArray());
        ViewUtil.openDialog((AbstractFormPlugin)this, (Map)param, (String)"sim_ori_preview", (String)"sim_ori_preview");
    }

    public void openWorkBench(AbstractFormPlugin plugin, DynamicObject[] bills, Map<String, Object> param) {
        boolean isTempSavePreview = param.get("tempSavePreview") != null && (Boolean)param.get("tempSavePreview") != false;
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)plugin, (ImcPermItemEnum)(isTempSavePreview ? ImcPermItemEnum.IMC_SIM_BILL_TEMP_SAVE_PREVIEW : ImcPermItemEnum.IMC_SIM_BILL_PROCESS), (DynamicObject[])bills);
        try {
            this.checkWorkbenchData(plugin, bills, false, param);
        }
        catch (Exception e) {
            plugin.getView().showTipNotification(e.getMessage());
            return;
        }
        boolean isPreview = "preview".equals(param.get("step"));
        boolean tempSavePreview = param.get("tempSavePreview") != null && (Boolean)param.get("tempSavePreview") != false;
        param.put("pks", Arrays.stream(bills).sorted(Comparator.comparing(k -> k.getString("originbillseq"), Comparator.reverseOrder())).map(DataEntityBase::getPkValue).toArray());
        if (!tempSavePreview && (isPreview || !InvoiceUtils.isAllEInvoice((Object)bills[0].getString("invoicetype")) || "1".equals(ImcConfigUtil.getValue((String)"sim_original_bill", (String)"force_old_workbench")))) {
            if (isPreview) {
                new BillCommonCustomEvent().showMergeTips(plugin, param.get("isMergeBill") != null && (Boolean)param.get("isMergeBill") != false, bills);
            }
            ViewUtil.openDialog((AbstractFormPlugin)plugin, param, (String)"sim_bill_process", (String)"sim_bill_process");
            return;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        int itemCount = 0;
        for (DynamicObject alleBill : bills) {
            totalAmount = totalAmount.add(alleBill.getBigDecimal("totalamount"));
            itemCount += alleBill.getInt("itemcount");
        }
        param.put("totalamount", totalAmount);
        param.put("itemcount", itemCount);
        param.put("tempSavePreview", tempSavePreview);
        ViewUtil.openDialog((AbstractFormPlugin)plugin, param, (String)"sim_alle_bill_process", (String)"sim_alle_bill_process");
    }

    public void openPartWorkBench(ListSelectedRowCollection rows) {
        HashMap<String, Object> partMap = new HashMap<String, Object>(rows.getPrimaryKeyValues().length);
        partMap.put("step", "process");
        partMap.put("pageSource", "pratiques");
        Object[] primaryKeyValues = rows.getPrimaryKeyValues();
        try {
            this.checkPartWorkbenchData((AbstractFormPlugin)this, primaryKeyValues);
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        partMap.put("pks", primaryKeyValues);
        ViewUtil.openDialog((AbstractFormPlugin)this, partMap, (String)"sim_split_process", (String)"sim_split_process");
    }

    public boolean isSpecialInvoice(AbstractFormPlugin that, DynamicObject[] dynamicObjects, String isPreviewKey) {
        Map<String, List<String>> isExsit = AbstractInvoiceOriginalBillWorkbenchPlugin.checkRedSpecial(dynamicObjects);
        if (!isExsit.isEmpty()) {
            switch (isExsit.keySet().iterator().next()) {
                case "isnull": {
                    List<String> isnull = isExsit.get("isnull");
                    that.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u7ea2\u5b57\u4fe1\u606f\u8868\u540e\u518d\u5f00\u7968", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", isnull), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    that.getPageCache().remove("select_bill_issyetype");
                    return false;
                }
                case "isNotExsit": {
                    List<String> isNotExsit = isExsit.get("isNotExsit");
                    AbstractInvoiceOriginalBillWorkbenchPlugin.oneKeyNegInvoiceCheck(dynamicObjects, isNotExsit);
                    ViewUtil.openConfirm((String)isPreviewKey, (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u5bf9\u5e94\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6821\u9a8c\u53ef\u7ea2\u51b2\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\u5f00\u7968\uff1f", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7ee7\u7eed\u5f00\u7968", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_40", (String)"imc-sim-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", isNotExsit)));
                    return false;
                }
            }
        }
        return true;
    }

    @SdkDeprecated
    public static Map<String, List<String>> checkRedSpecial(DynamicObject[] dynamicObjects) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        List isSaler = Arrays.stream(dynamicObjects).filter(o -> o.getString("applicant").equals(RedInfoConstant.ApplicantEnum.SALER.getCode())).collect(Collectors.toList());
        if (isSaler.size() > 0) {
            ArrayList billNos = Lists.newArrayListWithCapacity((int)isSaler.size());
            for (DynamicObject object : isSaler) {
                if (!StringUtils.isEmpty((CharSequence)object.getString("infocode")) || !StringUtils.isEmpty((CharSequence)object.getString("blueinvoicecode")) && !StringUtils.isEmpty((CharSequence)object.getString("blueinvoiceno"))) continue;
                billNos.add(object.getString("billno"));
            }
            if (!billNos.isEmpty()) {
                result.put("isnull", billNos);
                return result;
            }
        } else {
            List isnull = Arrays.stream(dynamicObjects).filter(o -> StringUtils.isBlank((CharSequence)o.getString("infocode"))).collect(Collectors.toList());
            if (isnull.size() > 0) {
                List billnos = isnull.stream().map(o -> o.getString("billno")).collect(Collectors.toList());
                result.put("isnull", billnos);
                return result;
            }
        }
        HashMap infoMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("infocode"))) continue;
            infoMap.put(dynamicObject.getString("infocode"), dynamicObject);
        }
        if (!infoMap.isEmpty()) {
            ArrayList billnos = Lists.newArrayListWithCapacity((int)infoMap.size());
            infoMap.forEach((key, value) -> {
                DynamicObject bill = (DynamicObject)value;
                String[] infocodeArr = key.split(",");
                DynamicObject[] isExsit = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id,infocode", (QFilter[])new QFilter("infocode", "in", (Object)infocodeArr).and("org", "=", bill.getDynamicObject("orgid").getPkValue()).toArray());
                if (isExsit.length > 0 && isExsit.length == infocodeArr.length) {
                    DynamicObject origianlBill = Arrays.stream(dynamicObjects).filter(o -> o.getString("infocode").equals(key)).findFirst().get();
                    OriginalBillFormEditUtil.checkInfoCode((String)key, (String)origianlBill.getString("billno"), null, (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)origianlBill.get("orgid")));
                } else {
                    billnos.add(bill.getString("billno"));
                }
            });
            if (!billnos.isEmpty()) {
                result.put("isNotExsit", billnos);
            }
        }
        return result;
    }

    @SdkDeprecated
    public static void oneKeyNegInvoiceCheck(DynamicObject[] dynamicObjects, List<String> isNotExsit) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            String infocode;
            String[] split;
            if (!isNotExsit.contains(dynamicObject.getString("billno")) || (split = (infocode = dynamicObject.getString("infocode")).split(",")).length <= 1) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6b63", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno")));
        }
    }

    public void checkPartWorkbenchData(AbstractFormPlugin plugin, Object[] primaryKeyValues) {
        this.workbenchNormalCheck(primaryKeyValues);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        this.checkBillItemLimitSize(bills);
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)plugin, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_BILL_PRATIQUES_PART, (DynamicObject[])bills);
        int lessThanZeroSize = 0;
        ArrayList<Object> mergeRulePk = new ArrayList<Object>(bills.length);
        for (DynamicObject bill : bills) {
            ApiResult apiResult;
            OriginalBillPluginPreviewIssueControl.checkDescription("\u624b\u5de5\u5904\u7406", bill.getString("billsourcetype"));
            if ("2".equals(bill.getString("confirmstate"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u975e\u201c\u5df2\u7533\u8bf7\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (!"0".equals(bill.getString("validstate"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u201c\u6b63\u5e38\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (AbstractInvoiceOriginalBillWorkbenchPlugin.operationOriginalBill(bill.getString("billstatus"), "bill_process")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%1$s)\u7684\u5355\u636e\u5ba1\u6279\u72b6\u6001\u4e3a%2$s,\u4e0d\u5141\u8bb8\u624b\u5de5\u5904\u7406", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), AbstractInvoiceOriginalBillWorkbenchPlugin.getOriginalBillStatuNameByCode(bill.getString("billstatus"))));
            }
            if ("2".equals(bill.getString("taxationstyle")) || bill.getBigDecimal("deduction").compareTo(BigDecimal.ZERO) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%s)\u7684\u5355\u636e\u5305\u542b\u5dee\u989d,\u4e0d\u5141\u8bb8\u624b\u5de5\u5904\u7406", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
            }
            if ("1".equals(bill.getString("closestatus"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%s)\u7684\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u5df2\u5173\u95ed\u201d\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
            }
            if (AllEleAuthHelper.isElePaper((Object)bill.getString("iselepaper")) && !"00".equals(bill.getString("specialtype"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u7535\u7eb8\u7968\u7684\u7279\u6b8a\u7968\u79cd,\u4e0d\u5141\u8bb8\u624b\u5de5\u5904\u7406\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
            }
            if (InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype"))) {
                if (InvoiceSpecialType.allEleSpecialType((String)bill.getString("specialtype"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%s)\u6570\u7535\u7968\u7279\u6b8a\u884c\u4e1a\u4e0d\u5141\u8bb8\u624b\u5de5\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                }
                String taxationStyle = bill.getString("taxationstyle");
                if (TaxedTypeEnum.alleTaxedTypeDeduction((String)taxationStyle)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%s)\u6570\u7535\u7968\u5dee\u989d\u5f00\u7968\u4e0d\u5141\u8bb8\u624b\u5de5\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                }
            }
            if (!(apiResult = BillValidaterHelper.validBillInvoice((DynamicObject)bill, (boolean)false, (BillCheckProcessDto)new BillCheckProcessDto(Boolean.valueOf(true), true))).getSuccess()) {
                throw new KDBizException(apiResult.getMessage());
            }
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (int i = 0; i < items.size(); ++i) {
                if (((DynamicObject)items.get(i)).getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%1$s)\u7b2c(%2$s)\u884c\u660e\u7ec6\u91d1\u989d\u4e3a0\uff0c\u624b\u5de5\u5904\u7406\u4e0d\u652f\u6301\u91d1\u989d\u4e3a0\u7684\u660e\u7ec6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_41", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), i + 1));
            }
            if (bill.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                ++lessThanZeroSize;
            }
            EquipmentHelper.checkJQBH((DynamicObject[])new DynamicObject[]{bill});
            DynamicObject mergeRule = bill.getDynamicObject("mergerule");
            if (mergeRule == null) continue;
            mergeRulePk.add(mergeRule.getPkValue());
        }
        if (lessThanZeroSize == bills.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5355\u636e\u6027\u8d28\u4e0d\u80fd\u90fd\u662f\u8d1f\u6570\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (bills.length <= 1) {
            return;
        }
        for (DynamicObject bill : bills) {
            String systemSource = bill.getString("systemsource");
            if ("AR_FINARBILL".equals(systemSource) || "AR_BUSBILL".equals(systemSource)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4ece\u5e94\u6536\u5355\u4e0b\u63a8\uff0c\u4e0d\u7b26\u5408\u5355\u636e\u5408\u5e76\u6761\u4ef6\uff0c\u4e0d\u652f\u6301\u4f7f\u7528\u672c\u5f00\u7968\u6d41\u7a0b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_46", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (!"XKQJ".equals(systemSource)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4ece\u9500\u552e\u53d1\u7968\u5355\u4e0b\u63a8\uff0c\u4e0d\u7b26\u5408\u5355\u636e\u5408\u5e76\u6761\u4ef6\uff0c\u4e0d\u652f\u6301\u4f7f\u7528\u672c\u5f00\u7968\u6d41\u7a0b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_47", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] mergeRules = BusinessDataServiceHelper.load((Object[])mergeRulePk.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_merge_rule_strategy"));
        LinkedHashMap mergeHead = BillMergeMethod.getMergeBillMap((DynamicObject[])bills, Stream.of(mergeRules).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v, (v1, v2) -> v1)));
        if (mergeHead.entrySet().size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u6ee1\u8db3\u5355\u636e\u5408\u5e76\u6761\u4ef6\uff0c\u4e0d\u652f\u6301\u4f7f\u7528\u672c\u5f00\u7968\u6d41\u7a0b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    @Deprecated
    protected void checkWorkbenchData(AbstractFormPlugin plugin, DynamicObject[] bills, boolean isPreview) {
        this.checkWorkbenchData(plugin, bills, isPreview, new HashMap<String, Object>(1));
    }

    protected void checkWorkbenchData(AbstractFormPlugin plugin, DynamicObject[] bills, boolean isPreview, Map<String, Object> openWorkbenchParams) {
        if (bills.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        boolean isTempSavePreview = openWorkbenchParams.get("tempSavePreview") != null && (Boolean)openWorkbenchParams.get("tempSavePreview") != false;
        for (DynamicObject obj : bills) {
            if (isPreview && AbstractInvoiceOriginalBillWorkbenchPlugin.checkBlueInvoiceOriginalBill(obj)) {
                plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%s)\u7684\u5355\u636e\u5305\u542b\u591a\u4e2a\u84dd\u7968\u4ee3\u7801\u548c\u84dd\u7968\u53f7\u7801,\u4e0d\u5141\u8bb8\u9884\u89c8\u5f00\u7968", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.getString("billno")), Integer.valueOf(2000));
                return;
            }
            this.checkBillStatus(isPreview, obj, isTempSavePreview);
            ApiResult apiResult = BillValidaterHelper.validBillInvoice((DynamicObject)obj, (boolean)false, (BillCheckProcessDto)new BillCheckProcessDto(Boolean.valueOf(true), true));
            if (apiResult.getSuccess()) continue;
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Deprecated
    public void checkBillStatus(boolean isPreview, DynamicObject obj) {
        this.checkBillStatus(isPreview, obj, false);
    }

    private void checkBillStatus(boolean isPreview, DynamicObject obj, boolean isTempSavePreview) {
        boolean elePaper = AllEleAuthHelper.isElePaper((Object)obj.getString("iselepaper"));
        if (isPreview && obj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 && !BillHelper.isFilledBlue((DynamicObject)obj)) {
            if (StringUtils.isBlank((CharSequence)obj.getString("applicant")) && InvoiceUtils.isSpecialInvoice((String)obj.getString("invoicetype")) && !elePaper) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%S]:\u672a\u586b\u5199\u8d2d\u65b9\u7533\u8bf7\u4fe1\u606f\uff0c\u4e0d\u652f\u6301\u9884\u89c8\u5f00\u7968", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.getString("billno")));
            }
            if (InvoiceUtils.isAllEInvoice((Object)obj.getString("invoicetype")) || elePaper) {
                String infoCode = obj.getString("infocode");
                String blueInvoiceNo = obj.getString("blueinvoiceno");
                String blueInoviceType = obj.getString("blueinvoicetype");
                Date blueIssueTime = obj.getDate("originalissuetime");
                if (StringUtils.isBlank((CharSequence)infoCode) || StringUtils.isBlank((CharSequence)blueInvoiceNo) || StringUtils.isBlank((CharSequence)blueInoviceType) || null == blueIssueTime) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u672a\u8865\u5145\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u6216\u5f85\u51b2\u84dd\u7968\u53f7\u7801\u6216\u5f85\u51b2\u53d1\u7968\u5f00\u7968\u65e5\u671f\u6216\u5f85\u51b2\u53d1\u7968\u5f00\u7968\u79cd\u7c7b\uff0c\u4e0d\u652f\u6301\u9884\u89c8\u5f00\u7968", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_29", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.getString("billno")));
                }
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u672a\u8865\u5145\u84dd\u7968\u6216\u7ea2\u5b57\u4fe1\u606f\u8868\u4fe1\u606f\uff0c\u4e0d\u652f\u6301\u9884\u89c8\u5f00\u7968", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.getString("billno")));
            }
        }
        if ("2".equals(obj.getString("confirmstate"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u975e\u201c\u5df2\u7533\u8bf7\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!"0".equals(obj.getString("validstate"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u201c\u6b63\u5e38\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if ("1".equals(obj.getString("closestatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u672a\u5173\u95ed\u201d\u7684\u5355\u636e\u8fdb\u884c\u5904\u7406\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_31", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if (!isTempSavePreview && AbstractInvoiceOriginalBillWorkbenchPlugin.operationOriginalBill(obj.getString("billstatus"), isPreview ? "bill_process_preview" : "bill_process")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7(%1$s)\u7684\u5355\u636e\u5ba1\u6279\u72b6\u6001\u4e3a%2$s,\u4e0d\u5141\u8bb8%3$s", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_42", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.getString("billno"), AbstractInvoiceOriginalBillWorkbenchPlugin.getOriginalBillStatuNameByCode(obj.getString("billstatus")), isPreview ? ResManager.loadKDString((String)"\u9884\u89c8\u5f00\u7968", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u636e\u5904\u7406", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_34", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        }
    }

    @SdkDeprecated
    public static boolean checkBlueInvoiceOriginalBill(DynamicObject bill) {
        String originalInvoiceCode = bill.getString("blueinvoicecode");
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode)) {
            return originalInvoiceCode.contains(";");
        }
        return false;
    }

    protected void workbenchNormalCheck(Object[] primaryKeyValues) {
        if (primaryKeyValues.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        int limitCount = BillHelper.getBillLimitCount();
        if (primaryKeyValues.length > limitCount) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6700\u591a\u63d0\u4ea4%s\u4e2a\u5355\u636e", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_43", (String)"imc-sim-formplugin", (Object[])new Object[0]), limitCount));
        }
        if (BrowserHelper.isIE()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u6d41\u7545\u7684\u4f53\u9a8c\uff0c\u8bf7\u4f7f\u7528\u975eIE\u5185\u6838\u7684\u6d4f\u89c8\u5668\uff0c\u63a8\u8350\u4f7f\u7528\u6700\u65b0\u7248\u8c37\u6b4c\u6d4f\u89c8\u5668", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_37", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    protected void checkBillItemLimitSize(DynamicObject[] bills) {
        int itemLimitCount = BillHelper.getBillItemLimitCount();
        Integer itemSize = Arrays.stream(bills).map(bill -> bill.getDynamicObjectCollection("sim_original_bill_item").size()).reduce(0, (n1, n2) -> n1 + n2);
        if (itemSize > itemLimitCount) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u6b21\u63d0\u4ea4\u7684\u5355\u636e\u660e\u7ec6\u884c\u6570\u4e0d\u80fd\u8d85\u8fc7%s", (String)"AbstractInvoiceOriginalBillWorkbenchPlugin_45", (String)"imc-sim-formplugin", (Object[])new Object[0]), itemLimitCount));
        }
    }
}

