/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.EstateLeaseConstant;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.bill.originalbill.control.InvoiceOriginalFormControl;

public class InvoiceOriginalAllEDeductionPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    public void registerListener(EventObject e) {
        InvoiceOriginalFormControl.addTextEditClickListener((AbstractFormPlugin)this, (String[])new String[]{"etaxinvoiceno", "deductioninvoicecode", "deductioninvoiceno"});
        this.addF7SelectListener("specialindustrynumber");
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String billProperties = (String)this.getModel().getValue("billproperties");
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("orgid"));
        QFilter qFilter = new QFilter("invoiceamount", "1".equals(billProperties) ? ">" : "<", (Object)BigDecimal.ZERO);
        qFilter.and("orgid", "=", (Object)orgId);
        switch (control.getKey()) {
            case "etaxinvoiceno": {
                qFilter.and("invoicetype", "in", (Object)InvoiceUtils.getAllEInvoiceType());
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_vatinvoice", (String)control.getKey(), (boolean)true, (boolean)false, null, null, null);
                break;
            }
            case "deductioninvoicecode": 
            case "deductioninvoiceno": {
                EntryGrid grid = (EntryGrid)this.getControl("deductions");
                int selectRows = grid.getSelectRows()[0];
                String evidenceType = (String)this.getModel().getValue("evidencetype", selectRows);
                if ("02".equals(evidenceType) || "03".equals(evidenceType)) {
                    qFilter.and("invoicetype", "not in", (Object)InvoiceUtils.getAllEInvoiceType());
                } else {
                    qFilter.and("orgid", "=", (Object)-1);
                }
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_vatinvoice", (String)control.getKey(), (boolean)true, (boolean)false, null, null, null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        ArrayList list = Lists.newArrayList();
        Control source = (Control)evt.getSource();
        block3 : switch (key = source.getKey()) {
            case "specialindustrynumber": {
                String specialType;
                switch (specialType = (String)this.getModel().getValue("specialtype")) {
                    case "E03": {
                        list.add(new QFilter("estatetype", "=", (Object)"buildInfo"));
                        break block3;
                    }
                    case "E06": {
                        list.add(new QFilter("estatetype", "=", (Object)"estateLeaseInfo"));
                        break block3;
                    }
                    case "E05": {
                        list.add(new QFilter("estatetype", "=", (Object)"estateSaleInfo"));
                    }
                }
            }
        }
        evt.setCustomQFilters((List)list);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal oriAmount = (BigDecimal)model.getValue("orievidenceamount", rowIndex);
        BigDecimal rowEvidenceAmount = (BigDecimal)model.getValue("evidenceamount", rowIndex);
        BigDecimal rowDeductionAmount = (BigDecimal)model.getValue("deductionamount", rowIndex);
        block9 : switch (e.getProperty().getName()) {
            case "deductionamount": {
                BigDecimal deductionAmount = (BigDecimal)changeData.getNewValue();
                if (rowEvidenceAmount.compareTo(BigDecimal.ZERO) != 0 && rowDeductionAmount.compareTo(rowEvidenceAmount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6263\u9664\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u51ed\u8bc1\u91d1\u989d", (String)"InvoiceOriginalAllEDeductionPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    model.setValue("deductionamount", changeData.getOldValue(), changeData.getRowIndex());
                    return;
                }
                if (oriAmount.compareTo(BigDecimal.ZERO) != 0 && deductionAmount.compareTo(oriAmount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6263\u9664\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u91d1\u989d", (String)"InvoiceOriginalAllEDeductionPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    model.setValue("deductionamount", changeData.getOldValue(), changeData.getRowIndex());
                    return;
                }
                BigDecimal sumDeduction = this.calaDeductionAmount();
                BigDecimal invoiceAmount = (BigDecimal)model.getValue("invoiceamount");
                if (invoiceAmount.compareTo(BigDecimal.ZERO) != 0 && sumDeduction.compareTo(invoiceAmount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u603b\u8ba1\u6263\u9664\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u91d1\u989d", (String)"InvoiceOriginalAllEDeductionPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    model.setValue("deductionamount", changeData.getOldValue(), changeData.getRowIndex());
                    return;
                }
                this.getModel().setValue("deduction", (Object)sumDeduction);
                break;
            }
            case "evidenceamount": {
                BigDecimal evidenceAmount = (BigDecimal)changeData.getNewValue();
                if (oriAmount.compareTo(BigDecimal.ZERO) != 0 && evidenceAmount.compareTo(oriAmount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u91d1\u989d", (String)"InvoiceOriginalAllEDeductionPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    model.setValue("evidenceamount", changeData.getOldValue(), changeData.getRowIndex());
                    return;
                }
                if (rowDeductionAmount.compareTo(BigDecimal.ZERO) == 0 || rowDeductionAmount.compareTo(evidenceAmount) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u6b21\u6263\u9664\u91d1\u989d", (String)"InvoiceOriginalAllEDeductionPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                model.setValue("evidenceamount", changeData.getOldValue(), changeData.getRowIndex());
                return;
            }
            case "etaxinvoiceno": 
            case "deductioninvoicecode": 
            case "deductioninvoiceno": {
                this.invoiceCodeNoChange(changeData);
                break;
            }
            case "specialtype": {
                this.setValue(EstateLeaseConstant.ESTATE_ALL_INFO_STRING, null);
                break;
            }
            case "specialindustrynumber": {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("specialindustrynumber");
                if (dynamicObject == null) break;
                switch (dynamicObject.getString("estatetype")) {
                    case "buildInfo": {
                        this.setValue(EstateLeaseConstant.BUILD_INFO_STRING, dynamicObject);
                        break block9;
                    }
                    case "estateLeaseInfo": {
                        this.setValue(EstateLeaseConstant.ESTATE_LEASE_INFO_STRING, dynamicObject);
                        break block9;
                    }
                    case "estateSaleInfo": {
                        this.setValue(EstateLeaseConstant.ESTATE_SALE_INFO_STRING, dynamicObject);
                    }
                }
            }
        }
    }

    public void setValue(String[] strings, DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            for (String string : strings) {
                this.getModel().setValue(string, (Object)dynamicObject.getString(string));
            }
            this.getModel().setValue("simpleaddress", dynamicObject.get("simpleaddress"));
        } else {
            for (String string : strings) {
                this.getModel().setValue(string, null);
            }
            this.getModel().setValue("simpleaddress", null);
        }
    }

    private void invoiceCodeNoChange(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        String evidenceType = (String)model.getValue("evidencetype", rowIndex);
        if (!("01".equals(evidenceType) || "02".equals(evidenceType) || "03".equals(evidenceType))) {
            return;
        }
        String eTaxInvoiceNo = (String)model.getValue("etaxinvoiceno", rowIndex);
        String invoiceCode = (String)model.getValue("deductioninvoicecode", rowIndex);
        String invoiceNo = (String)model.getValue("deductioninvoiceno", rowIndex);
        if ("01".equals(evidenceType) && StringUtils.isBlank((CharSequence)eTaxInvoiceNo) || !"01".equals(evidenceType) && (StringUtils.isBlank((CharSequence)invoiceCode) || StringUtils.isBlank((CharSequence)invoiceNo))) {
            this.setInvoiceNotExist(model, rowIndex);
            return;
        }
        QFilter qFilter = new QFilter("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)model.getValue("orgid")));
        if ("01".equals(evidenceType)) {
            qFilter.and(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)"", (String)eTaxInvoiceNo)).and("invoicetype", "in", (Object)InvoiceUtils.getAllEInvoiceType());
        } else {
            qFilter.and(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo)).and("invoicetype", "not in", (Object)InvoiceUtils.getAllEInvoiceType());
        }
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicecode", "invoiceno", "issuetime", "totalamount"), (QFilter[])qFilter.toArray());
        if (invoice == null) {
            this.setInvoiceNotExist(model, rowIndex);
            return;
        }
        this.setInvoiceExist(model, invoice, rowIndex);
    }

    private void setInvoiceExist(IDataModel model, DynamicObject invoice, int rowIndex) {
        model.setValue("orievidenceamount", (Object)invoice.getBigDecimal("totalamount"), rowIndex);
        model.setValue("invoicedate", invoice.get("issuetime"), rowIndex);
        model.setValue("evidenceamount", (Object)invoice.getBigDecimal("totalamount"), rowIndex);
    }

    private void setInvoiceNotExist(IDataModel model, int rowIndex) {
        model.setValue("orievidenceamount", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("invoicedate", null, rowIndex);
        model.setValue("evidenceamount", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("deductionamount", (Object)BigDecimal.ZERO, rowIndex);
    }

    private BigDecimal calaDeductionAmount() {
        if (CallbackHelperUtil.isFromArIssueBill((String)((String)this.getModel().getValue("systemsource")))) {
            return (BigDecimal)this.getModel().getValue("deduction");
        }
        DynamicObjectCollection deductionItems = this.getModel().getEntryEntity("deductions");
        return deductionItems.stream().map(deductionItem -> deductionItem.getBigDecimal("deductionamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("deletedeductionentry".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getModel().setValue("deduction", (Object)this.calaDeductionAmount());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (null == returnData) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicecode", "invoiceno", "issuetime", "totalamount"), (QFilter[])new QFilter("id", "=", list.get(0).getPrimaryKeyValue()).toArray());
        IDataModel model = this.getModel();
        EntryGrid grid = (EntryGrid)this.getControl("deductions");
        int selectRows = grid.getSelectRows()[0];
        this.setInvoiceExist(model, invoice, selectRows);
        String actionId = event.getActionId();
        model.beginInit();
        switch (actionId) {
            case "etaxinvoiceno": {
                model.setValue("etaxinvoiceno", (Object)invoice.getString("invoiceno"), selectRows);
                break;
            }
            case "deductioninvoicecode": 
            case "deductioninvoiceno": {
                model.setValue("deductioninvoicecode", (Object)invoice.getString("invoicecode"), selectRows);
                model.setValue("deductioninvoiceno", (Object)invoice.getString("invoiceno"), selectRows);
            }
        }
        model.endInit();
        this.getView().updateView("etaxinvoiceno", selectRows);
        this.getView().updateView("deductioninvoicecode", selectRows);
        this.getView().updateView("deductioninvoiceno", selectRows);
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }
}

