/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.imc.bdm.common.constant.BillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class InvoiceOriginalBillWorkFlowListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(InvoiceOriginalBillWorkFlowListPlugin.class);

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("mergelable".equals(args.getFieldName())) {
            args.setCancel(true);
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)row.getPrimaryKeyValue());
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.size() == 0) {
                    return rows;
                }
                DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
                if (properties.containsKey((Object)"mergelable")) {
                    boolean isQueryAudit = true;
                    if (properties.containsKey((Object)"billstatus")) {
                        isQueryAudit = rows.stream().anyMatch(row -> BillStatusEnum.IN_AUDIT.getCode().equals(row.getString("billstatus")));
                    }
                    if (isQueryAudit) {
                        Map auditorsMap = InvoiceOriginalBillWorkFlowListPlugin.this.getNextAuditors(rows.stream().filter(row -> BillStatusEnum.IN_AUDIT.getCode().equals(row.getString("billstatus"))).map(row -> row.getPkValue().toString()).collect(Collectors.toList()));
                        for (DynamicObject row2 : rows) {
                            row2.set("mergelable", (Object)"");
                            String auditor = (String)auditorsMap.get(row2.getPkValue().toString());
                            if (!StringUtils.isNotBlank((CharSequence)auditor)) continue;
                            row2.set("mergelable", (Object)auditor);
                        }
                    }
                }
                return rows;
            }
        });
    }

    private Map<String, String> getNextAuditors(List<String> pkIds) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> auditorsMap = new HashMap<String, String>(pkIds.size());
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])pkIds.toArray(new String[0]));
        Set entries = allPro.entrySet();
        for (Map.Entry entry : entries) {
            List node = (List)entry.getValue();
            String nodeName = "";
            StringBuilder participantName = new StringBuilder();
            StringBuilder msg = new StringBuilder();
            try {
                for (int i = 0; i < node.size(); ++i) {
                    nodeName = ((BizProcessStatus)node.get(i)).getCurrentNodeName();
                    String auditor = ((BizProcessStatus)node.get(i)).getParticipantName();
                    if (StringUtils.isBlank((CharSequence)auditor)) continue;
                    participantName.append(',').append(auditor);
                    if (i != 3) continue;
                    participantName.append("...");
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)nodeName)) {
                    msg.append(nodeName);
                    if (StringUtils.isNotBlank((CharSequence)participantName)) {
                        msg.append('/').append(participantName.toString().replaceFirst(",", ""));
                    }
                }
            }
            catch (Exception e) {
                log.info("InvoiceOriginalBillWorkFlowListPlugin>>>\u83b7\u53d6\u5ba1\u6279\u4eba\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
            }
            auditorsMap.put((String)entry.getKey(), msg.toString());
        }
        return auditorsMap;
    }
}

