/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.control.InvoiceOriginalFormControl;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;

public class InvoiceSpecifyWorkbenchPlugin
extends AbstractFormPlugin {
    private static final String MATCH_TYPE = "matchtype";
    private static final String[] PURCHASE_LIST = new String[]{"02", "E16", "E24"};

    public void registerListener(EventObject e) {
        InvoiceOriginalFormControl.addTextEditClickListener((AbstractFormPlugin)this, (String[])new String[]{"infocode", "blueinvoiceno"});
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        switch (key) {
            case "infocode": {
                this.getPageCache().put("selectRow", String.valueOf(entryEntity.getSelectRows()[0]));
                this.openRedConfirmBillView((DynamicObject)entrys.get(entryEntity.getSelectRows()[0]));
                break;
            }
            case "blueinvoiceno": {
                this.getPageCache().put("selectRow", String.valueOf(entryEntity.getSelectRows()[0]));
                this.openVatInvoiceListView((DynamicObject)entrys.get(entryEntity.getSelectRows()[0]));
                break;
            }
            case "btn_ok": {
                this.specifyDataProcess();
            }
        }
    }

    private void specifyDataProcess() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String orgId = params.get("orgid").toString();
        try (DLock lock = DLock.create((String)("SpecifyMatch:" + orgId));){
            if (!lock.tryLock(1000L)) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            HashSet blueInvoice = Sets.newHashSetWithExpectedSize((int)0);
            HashSet redConfirm = Sets.newHashSetWithExpectedSize((int)0);
            int blueNum = 0;
            int redNum = 0;
            HashMap specifyDataCollection = Maps.newHashMapWithExpectedSize((int)0);
            for (DynamicObject entry : entryEntity) {
                DynamicObjectCollection objects = new DynamicObjectCollection();
                if ("0".equals(entry.getString(MATCH_TYPE))) {
                    if (StringUtils.isEmpty((CharSequence)entry.getString("blueinvoiceno")) || StringUtils.isEmpty((CharSequence)entry.getString("redreason"))) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u84dd\u7968\u4e0e\u7ea2\u51b2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceSpecifyWorkbenchPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    String invoiceNo = entry.getString("blueinvoiceno");
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("invoiceno", "=", (Object)invoiceNo).toArray());
                    if (invoice == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u53d1\u7968\u53f7\u7801\u586b\u5199\u6709\u8bef", (String)"InvoiceSpecifyWorkbenchPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    if ("1".equals(invoice.getString("occupystatus"))) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\uff0c\u53d1\u7968[%2%s]\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceSpecifyWorkbenchPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq"), invoiceNo));
                        return;
                    }
                    if (entry.getBigDecimal("amount").abs().compareTo(invoice.getBigDecimal("remainredamount").abs()) != 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u84dd\u7968\u91d1\u989d\u4e0e\u586b\u5199\u91d1\u989d\u4e0d\u5339\u914d", (String)"InvoiceSpecifyWorkbenchPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    if (entry.getBigDecimal("tax").abs().compareTo(invoice.getBigDecimal("canredtaxamount").abs()) != 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u84dd\u7968\u7a0e\u989d\u4e0e\u586b\u5199\u7a0e\u989d\u4e0d\u5339\u914d", (String)"InvoiceSpecifyWorkbenchPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    objects.add((Object)invoice);
                    blueInvoice.add(entry.getString("blueinvoiceno"));
                    ++blueNum;
                }
                if ("1".equals(entry.getString(MATCH_TYPE))) {
                    if (StringUtils.isEmpty((CharSequence)entry.getString("infocode"))) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceSpecifyWorkbenchPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    String[] billNos = entry.getString("infocode").split(",");
                    for (int i = 0; i < billNos.length; ++i) {
                        billNos[i] = billNos[i].trim();
                        redConfirm.add(billNos[i]);
                        ++redNum;
                    }
                    DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter("number", "in", (Object)billNos).toArray());
                    if (redConfirmBills == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u586b\u5199\u6709\u8bef", (String)"InvoiceSpecifyWorkbenchPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                        return;
                    }
                    BigDecimal amount = BigDecimal.ZERO;
                    BigDecimal tax = BigDecimal.ZERO;
                    BigDecimal needAmount = entry.getBigDecimal("amount");
                    for (DynamicObject redConfirmBill : redConfirmBills) {
                        if ("1".equals(redConfirmBill.getString("occupystatus"))) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355[%2%s]\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceSpecifyWorkbenchPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq"), redConfirmBill.getString("number")));
                            return;
                        }
                        amount = amount.add(redConfirmBill.getBigDecimal("invoiceamount"));
                        tax = tax.add(redConfirmBill.getBigDecimal("totaltax"));
                        objects.add((Object)redConfirmBill);
                    }
                    BigDecimal negativeBillDiff = SystemParameterHelper.getSimParameterBigDecimal((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)redConfirmBills[0].get("org")), (String)"negativebilldiff");
                    if (MathUtils.isZero((BigDecimal)negativeBillDiff)) {
                        if (amount.compareTo(needAmount) != 0) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u7ea2\u5b57\u786e\u8ba4\u5355\u91d1\u989d\u4e0e\u586b\u5199\u91d1\u989d\u4e0d\u5339\u914d", (String)"InvoiceSpecifyWorkbenchPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                            return;
                        }
                        if (tax.compareTo(entry.getBigDecimal("tax")) != 0) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\uff0c\u6307\u5b9a\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d\u4e0e\u586b\u5199\u7a0e\u989d\u4e0d\u5339\u914d", (String)"InvoiceSpecifyWorkbenchPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq")));
                            return;
                        }
                    } else {
                        BigDecimal redConfirmDiff;
                        BigDecimal configDiff = negativeBillDiff.abs();
                        if (configDiff.subtract(redConfirmDiff = tax.abs().subtract(entry.getBigDecimal("tax").abs()).abs()).compareTo(BigDecimal.ZERO) < 0) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\uff0c\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a\uff1a%2$s\uff0c\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s", (String)"InvoiceSpecifyWorkbenchPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getString("seq"), redConfirmDiff.stripTrailingZeros().toPlainString(), configDiff));
                        }
                    }
                }
                specifyDataCollection.put(entry.getString("matchbillid"), objects);
            }
            if (blueInvoice.size() != blueNum) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u91cd\u590d\u9009\u62e9\u540c\u4e00\u5f20\u84dd\u7968", (String)"InvoiceSpecifyWorkbenchPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (redConfirm.size() != redNum) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u91cd\u590d\u9009\u62e9\u540c\u4e00\u5f20\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"InvoiceSpecifyWorkbenchPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveSpecifyData(entryEntity, specifyDataCollection);
            this.getView().close();
        }
    }

    private void saveSpecifyData(DynamicObjectCollection entryEntity, Map<String, DynamicObjectCollection> specifyDataMap) {
        ArrayList matchBillList = Lists.newArrayListWithCapacity((int)0);
        HashSet redConfirmBillNo = Sets.newHashSetWithExpectedSize((int)0);
        DynamicObjectCollection redConfirmBillCollection = new DynamicObjectCollection();
        DynamicObjectCollection invoiceCollection = new DynamicObjectCollection();
        for (DynamicObject entry : entryEntity) {
            HashSet invoiceNo = Sets.newHashSetWithExpectedSize((int)0);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            List jsonArray = (List)params.get("data");
            DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
            for (JSONObject jsonObject : jsonArray) {
                if (!jsonObject.getString("id").equals(entry.getString("matchbillid"))) continue;
                DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)jsonObject, (DynamicObject)matchBill, (boolean)true);
                break;
            }
            if (null == matchBill.get("billno")) {
                return;
            }
            DynamicObjectCollection specifyDataCollection = specifyDataMap.get(entry.getString("matchbillid"));
            DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
            if ("0".equals(entry.getString(MATCH_TYPE))) {
                matchBill.set("matchtarget", (Object)"3");
                DynamicObject invoice = (DynamicObject)specifyDataCollection.get(0);
                invoice.set("occupystatus", (Object)"1");
                invoiceCollection.add((Object)invoice);
                invoiceNo.add(invoice.getPkValue().toString());
                for (DynamicObject item : items) {
                    item.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                    DynamicObjectCollection subEntryEntity = item.getDynamicObjectCollection("subentryentity");
                    DynamicObject entryData = subEntryEntity.addNew();
                    entryData.set("oriinvoiceid", invoice.getPkValue());
                    entryData.set("oriitemseq", (Object)-1);
                    entryData.set("oriinvoicecode", (Object)invoice.getString("invoicecode"));
                    entryData.set("oriinvoiceno", (Object)invoice.getString("invoiceno"));
                    entryData.set("pushstatus", (Object)"-1");
                    entryData.set("oriitemamount", (Object)invoice.getBigDecimal("invoiceamount"));
                    entryData.set("oriitemtax", (Object)invoice.getBigDecimal("totaltax"));
                }
                matchBill.set("redreason", (Object)entry.getString("redreason"));
                matchBill.set("matchamount", (Object)entry.getBigDecimal("amount"));
                matchBill.set("matchtax", (Object)entry.getBigDecimal("tax"));
                matchBill.set("matchinvoicenum", (Object)invoiceNo.size());
                matchBill.set("matchtotalamount", (Object)entry.getBigDecimal("tax").add(entry.getBigDecimal("amount")));
            }
            if ("1".equals(entry.getString(MATCH_TYPE))) {
                matchBill.set("matchtarget", (Object)"2");
                for (DynamicObject item : items) {
                    item.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                    DynamicObjectCollection redConfirmEntryEntity = item.getDynamicObjectCollection("confirmsubentryentity");
                    for (DynamicObject redConfirmBill : specifyDataCollection) {
                        redConfirmBill.set("occupystatus", (Object)"1");
                        redConfirmBillCollection.add((Object)redConfirmBill);
                        redConfirmBillNo.add(redConfirmBill.getString("number"));
                        DynamicObject entryData = redConfirmEntryEntity.addNew();
                        entryData.set("confirminfocode", (Object)redConfirmBill.getString("number"));
                        entryData.set("redconfirmpk", redConfirmBill.getPkValue());
                        entryData.set("confirmoriinvoicecode", (Object)redConfirmBill.getString("originalinvoicecode"));
                        entryData.set("confirmoriinvoiceno", (Object)redConfirmBill.getString("originalinvoiceno"));
                    }
                }
                matchBill.set("matchamount", (Object)entry.getBigDecimal("amount"));
                matchBill.set("matchinvoicenum", (Object)redConfirmBillNo.size());
                matchBill.set("matchtax", (Object)entry.getBigDecimal("tax"));
                matchBill.set("matchtotalamount", (Object)entry.getBigDecimal("tax").add(entry.getBigDecimal("amount")));
            }
            matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
            matchBill.set(MATCH_TYPE, (Object)"0");
            matchBill.set("matchtime", (Object)MinusBillMatchHelper.getMatchTime());
            matchBillList.add(matchBill);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])redConfirmBillCollection.toArray((Object[])new DynamicObject[redConfirmBillCollection.size()])));
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])invoiceCollection.toArray((Object[])new DynamicObject[invoiceCollection.size()])));
        WideInvoiceSevice.dealWideInvoiceOccupyStatus((List)invoiceCollection);
        this.getView().returnDataToParent((Object)matchBillList);
    }

    private void openRedConfirmBillView(DynamicObject bill) {
        Map fatherParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = fatherParams.get("orgid");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("buyername", bill.get("buyername"));
        params.put("buyertaxno", bill.get("buyertaxno"));
        params.put("salertaxno", bill.get("salertaxno"));
        String[] split = bill.getString("infocode").split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtils.trim((String)split[i]);
        }
        params.put("infocode", split);
        params.put("originalinvoicecode", bill.get("billblueinvoicecode"));
        params.put("originalinvoiceno", bill.get("billblueinvoiceno"));
        params.put("org", Long.parseLong(String.valueOf(org)));
        ViewUtil.openDialog((AbstractFormPlugin)this, null, params, (String)"sim_redconfirmbill_choose", (String)"infocode", (boolean)true);
    }

    private void openVatInvoiceListView(DynamicObject bill) {
        String billBlueInvoiceNo;
        QFilter purchaseInvoice = new QFilter("salername", "=", (Object)bill.getString("buyername")).and("specialtype", "in", (Object)PURCHASE_LIST);
        QFilter notPurchaseInvoice = new QFilter("buyername", "=", (Object)bill.getString("buyername")).and("specialtype", "not in", (Object)PURCHASE_LIST);
        QFilter qFilter = purchaseInvoice.or(notPurchaseInvoice);
        qFilter.and("occupystatus", "!=", (Object)"1");
        qFilter.and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray);
        qFilter.and("issuetype", "=", (Object)"0");
        qFilter.and("orgid", "=", (Object)Long.parseLong(String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("orgid"))));
        qFilter.and("remainredamount", "=", (Object)bill.getBigDecimal("amount").abs());
        qFilter.and("canredtaxamount", "=", (Object)bill.getBigDecimal("tax").abs());
        if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(bill.getString("invoicetype"))) {
            qFilter.and("invoicetype", "in", (Object)new String[]{"028", "004", "08xdp"});
        }
        if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(bill.getString("invoicetype"))) {
            qFilter.and("invoicetype", "in", (Object)new String[]{"026", "007", "10xdp", "025"});
        }
        if (StringUtils.isNotBlank((CharSequence)(billBlueInvoiceNo = bill.getString("billblueinvoiceno")))) {
            String billBlueInvoiceCode = bill.getString("billblueinvoicecode");
            qFilter.and(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)billBlueInvoiceCode, (String)billBlueInvoiceNo));
        }
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_choose_vatinvoice", (String)"blueinvoiceno");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (null == returnData) {
            return;
        }
        int selectRow = Integer.parseInt(this.getPageCache().get("selectRow"));
        switch (actionId) {
            case "infocode": {
                this.getModel().setValue("infocode", (Object)returnData.toString().substring(1, returnData.toString().length() - 1), selectRow);
                break;
            }
            case "blueinvoiceno": {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue(), (String)"sim_vatinvoice");
                this.getModel().setValue("blueinvoiceno", (Object)dynamicObject.getString("invoiceno"), selectRow);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        List jsonArray = (List)params.get("data");
        IDataModel model = this.getModel();
        for (JSONObject object : jsonArray) {
            int row = this.getModel().createNewEntryRow("entryentity");
            model.setValue("billno", (Object)object.getString("billno"), row);
            model.setValue("matchbillid", (Object)object.getString("id"), row);
            model.setValue("buyername", (Object)object.getString("buyername"), row);
            model.setValue("buyertaxno", (Object)object.getString("buyertaxno"), row);
            model.setValue("salertaxno", (Object)object.getString("salertaxno"), row);
            model.setValue("amount", (Object)object.getBigDecimal("applyamount").setScale(2, RoundingMode.HALF_UP).toPlainString(), row);
            model.setValue("tax", (Object)object.getBigDecimal("applytax").setScale(2, RoundingMode.HALF_UP).toPlainString(), row);
            model.setValue("invoicetype", (Object)object.getString("invoicetype"), row);
            model.setValue("oriredreason", (Object)object.getString("redreason"), row);
            model.setValue("billblueinvoicecode", (Object)object.getString("blueinvoicecode"), row);
            model.setValue("billblueinvoiceno", (Object)object.getString("blueinvoiceno"), row);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
        if (MATCH_TYPE.equals(eventName)) {
            if ("0".equals(this.getModel().getValue(MATCH_TYPE))) {
                this.getModel().setValue("infocode", (Object)"", entryEntity.getSelectRows()[0]);
                if (StringUtils.isNotBlank((Object)this.getModel().getValue("oriredreason"))) {
                    this.getModel().setValue("redreason", this.getModel().getValue("oriredreason"), entryEntity.getSelectRows()[0]);
                    this.getView().setEnable(Boolean.valueOf(false), entryEntity.getSelectRows()[0], new String[]{"redreason"});
                }
            } else {
                this.getModel().setValue("blueinvoiceno", (Object)"", entryEntity.getSelectRows()[0]);
                this.getModel().setValue("redreason", (Object)"", entryEntity.getSelectRows()[0]);
            }
        }
    }
}

