/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.dto.allele.AllEleTaxPlatformResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.formplugin.bill.originalbill.util.SelectDeviceUtil;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;

public class OperationSelectDevicePlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(OperationSelectDevicePlugin.class);
    public static final String PREPARE = "prepare";
    public static final String ISSUEPUSH = "issuepush";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PREPARE});
        this.addClickListeners(new String[]{ISSUEPUSH});
    }

    public void afterCreateNewData(EventObject e) {
        SelectDeviceUtil.initSelectDeviceView((AbstractFormPlugin)this);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        String orgIdStr = this.getPageCache().get("orgid");
        long orgIdCache = StringUtils.isBlank((CharSequence)orgIdStr) ? RequestContext.get().getOrgId() : Long.parseLong(orgIdStr);
        PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)orgIdCache, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_OPEN_INVOICE);
        HashMap params = Maps.newHashMap();
        String invoiceType = this.getPageCache().get("invoicetype");
        String salerTaxNo = this.getPageCache().get("salertaxno");
        String isElePaper = this.getPageCache().get("iselepaper");
        LOGGER.info("selectDeviceClickKey:" + key);
        params.put("salertaxno", salerTaxNo);
        boolean is2MQ = ISSUEPUSH.equals(key);
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"jqbh", "terminalno"});
            params.put("account", this.getModel().getValue("account"));
            this.getPageCache().put("operateKey", ISSUEPUSH);
            if (is2MQ && AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)params)) {
                return;
            }
        } else {
            Object deviceNo = this.getModel().getValue("jqbh");
            Object terminalNo = this.getModel().getValue("terminalno");
            if (Objects.isNull(deviceNo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u7968\u8bbe\u5907", (String)"OperationSelectDevicePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgIdCache);
            EquipmentHelper.checkTerminalNo((String)((String)deviceNo), (String)saleInfo.getSaleTaxNo(), (String)((String)terminalNo));
        }
        OperationSelectDevicePlugin.setReturnParams(params, is2MQ, this.getModel());
        this.getView().returnDataToParent((Object)params);
        this.getView().close();
    }

    public static void setReturnParams(HashMap<String, Object> params, boolean is2MQ, IDataModel model) {
        params.put("jqbh", model.getValue("jqbh"));
        params.put("deviceNo", model.getValue("jqbh"));
        params.put("terminalNo", model.getValue("terminalno"));
        params.put("account", model.getValue("account"));
        params.put("isMergeBill", model.getValue("ismergebill"));
        params.put("isMergeBillDetail", model.getValue("ismergebilldetail"));
        params.put("is2MQ", is2MQ);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("jqbh".equals(e.getProperty().getName())) {
            String equipmentNo = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)equipmentNo)) {
                return;
            }
            String orgIdCache = this.getPageCache().get("orgid");
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)(StringUtils.isNotEmpty((CharSequence)orgIdCache) ? Long.parseLong(orgIdCache) : RequestContext.get().getOrgId()));
            EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)equipmentNo, (String)saleInfo.getSaleTaxNo(), (String)"terminalno", (boolean)false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if ("bdm_tax_login".equals(event.getActionId())) {
            this.autoAllLoginCallback(this, event);
        }
    }

    public void autoAllLoginCallback(AbstractFormPlugin that, ClosedCallBackEvent event) {
        AllEleTaxPlatformResponseDTO response = (AllEleTaxPlatformResponseDTO)event.getReturnData();
        if (null == response) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u7535\u7968\u8d26\u53f7\u767b\u5f55\u5931\u8d25", (String)"OperationSelectDevicePlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        HashMap params = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)that.getPageCache().get("operateKey"))) {
            OperationSelectDevicePlugin.setReturnParams(params, true, that.getView().getModel());
            that.getView().returnDataToParent((Object)params);
            that.getView().close();
        } else {
            SelectDeviceUtil.setCreditQuota((AbstractFormPlugin)that, (String)that.getPageCache().get("salertaxno"), (BigDecimal)new BigDecimal(that.getPageCache().get("confirmAmount")), (boolean)true);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && (PREPARE.equals(key = ((Button)source).getKey()) || ISSUEPUSH.equals(key))) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            JSONArray idArr = (JSONArray)parameter.getCustomParam("pks");
            boolean antiReplayControlFlag = BillRiskControlService.riskControl((Object[])idArr.toArray(), (String)"sim_original_bill", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ISSUE, (AbstractFormPlugin)this, (String)key);
            evt.setCancel(antiReplayControlFlag);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if ((PREPARE.equals(callBackId) || ISSUEPUSH.equals(callBackId)) && event.getResult() == MessageBoxResult.Yes) {
            BillRiskControlService.unlockRiskRecord((AbstractFormPlugin)this);
            Button button = new Button();
            LOGGER.info("selectDeviceClickconfirmCallBack:" + callBackId);
            button.setKey(callBackId);
            ClickEvent clickEvent = new ClickEvent((Object)button);
            this.click((EventObject)clickEvent);
        }
    }
}

