/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.constant.CommonConstant;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.invoice.ReductionTaxTypeEnum;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.SaleAddrAndPayeeDTO;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.InvTitleSettingHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.helper.invoice.ReduceOnePoint5Helper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.DrawerStrategyDTO;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.file.util.Handle;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.enums.SeatClassTypeEnum;
import kd.imc.sim.common.enums.TransportTypeEnum;
import kd.imc.sim.common.enums.TravelerCardTypeEnum;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.common.helper.InvTitleMatchHelper;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.cache.GoodsInfoCacheHelper;
import kd.imc.sim.common.helper.cache.InvoiceTitleCacheHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.CoalTypeCodeEnum;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.model.invoice.ZzstsglEnum;
import kd.imc.sim.common.service.InvoiceAllESpecialCheckService;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.utils.AllEleLqAddressSplitUtil;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.AbstractOriginalBillImportPlugin;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginAddControl;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class OriginalBillImportPlugin
extends AbstractOriginalBillImportPlugin
implements SimFormPluginConstellationUntrans {
    private static final Log LOGGER = LogFactory.getLog(OriginalBillImportPlugin.class);
    private static final String TEMPLATE_DIR = "excel_templates";
    private static final String TEMPLATE_JSON_NAME = "originalBill.json";
    private static final String TEMPLATE_EXTRA_JSON_NAME = "originalBillSpecialType.json";
    public static final int GOODSNAME_LENGTH = 92;
    public static final int UNIT_LENGTH = 22;
    public static final int SPECIFICATION_LENGTH = 40;

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        EquipmentUtil.bindDevNoByOrg((AbstractFormPlugin)this, (String)"jqbh", (Long)RequestContext.get().getOrgId(), null);
    }

    protected void uploadFile(String filepath, InputStream inputStream, Workbook workbook) {
        PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (ImcPermItemEnum)ImcPermItemEnum.BDM_TITLE_IMPORT);
        String suffix = filepath.substring(filepath.lastIndexOf(46));
        String errFileName = ExcelHelper.getErrorExcelFileName((String)filepath, (String)suffix);
        if (ExcelHelper.isExcelFile((String)suffix)) {
            try {
                int startRow = 2;
                int dataNum = workbook.getSheetAt(0).getLastRowNum() - startRow + 1;
                if (dataNum < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5145\u6570\u636e\u518d\u5f15\u5165", (String)"OriginalBillImportPlugin_130", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                if (dataNum > 20000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u5f15\u516520000\u884c\u660e\u7ec6\u4fe1\u606f", (String)"OriginalBillImportPlugin_131", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                List fileFieldList = ExcelHelper.readTemplate((String)TEMPLATE_DIR, (String)TEMPLATE_JSON_NAME);
                ExcelHelper.replaceFieldName((List)fileFieldList, (String)"sim_original_bill");
                List fileFields = ExcelHelper.getFileFields((Row)workbook.getSheetAt(0).getRow(startRow - 1), (List)fileFieldList);
                this.dealSetGbkRuleMethod(workbook, fileFields, startRow);
                Map<String, FileField> fieldMap = fileFields.stream().collect(Collectors.toMap(FileField::getFieldCode, t -> t, (v1, v2) -> v1));
                ConcurrentHashMap<String, String> errMap = new ConcurrentHashMap<String, String>(dataNum >> 1);
                List list = ExcelHelper.doParse((Workbook)workbook, (List)fileFields, (int)startRow, (boolean)true, errMap);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5145\u6570\u636e\u518d\u5f15\u5165", (String)"OriginalBillImportPlugin_130", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                Sheet extraSheet = workbook.getSheet(ResManager.loadKDString((String)"2-\u7279\u5b9a\u4e1a\u52a1\u4fe1\u606f\uff08\u4ec5\u6570\u7535\u7968\u9002\u7528\uff09", (String)"OriginalBillImportPlugin_132", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                List<Map<String, Object>> extraList = new ArrayList<Map<String, Object>>(4);
                Map<String, FileField> extraFieldMap = new HashMap<String, FileField>();
                if (extraSheet != null) {
                    List extraFileFieldList = ExcelHelper.readTemplate((String)TEMPLATE_DIR, (String)TEMPLATE_EXTRA_JSON_NAME);
                    List extraFileFields = ExcelHelper.getFileFields((Row)extraSheet.getRow(startRow), (List)extraFileFieldList);
                    extraFieldMap = extraFileFields.stream().collect(Collectors.toMap(FileField::getFieldCode, t -> t, (v1, v2) -> v1));
                    extraList = ExcelHelper.doParse((Sheet)extraSheet, (List)extraFileFields, (int)(startRow + 1), (boolean)true, errMap);
                }
                this.fillOrgInfo(list);
                this.fillInData(list);
                this.fillInExtraData(extraList);
                Map<String, Object> returnMap = this.checkOriginalBill(list, fieldMap, extraList, extraFieldMap, errMap);
                List objs = (List)returnMap.get("objs");
                BillMatchHelper billMatchHelper = new BillMatchHelper();
                billMatchHelper.matchAll(objs, "1");
                BotpHelper.dealPushArFields((DynamicObject[])objs.toArray(new DynamicObject[0]));
                this.removeSpecialChars(objs);
                ImcSaveServiceHelper.save((List)objs);
                int successSize = Integer.parseInt(returnMap.get("successSize").toString());
                if (successSize != list.size()) {
                    ExcelHelper.showErrorResult((Workbook)workbook, (int)list.size(), (int)successSize, errMap, (String)errFileName, (AbstractFormPlugin)this, (String)"sim_original_bill_import", (String)"sim_inv_import_result");
                    return;
                }
                super.resetFile();
                this.getView().returnDataToParent((Object)"refresh");
                this.getView().close();
            }
            catch (Exception e) {
                this.getView().showErrorNotification(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.toString() : e.getMessage());
                LOGGER.error("\u539f\u59cb\u5355\u636e\u5bfc\u5165\u51fa\u9519", (Throwable)e);
            }
        }
    }

    private void dealSetGbkRuleMethod(Workbook workbook, List<FileField> fileFields, int startRow) {
        String fieldCode;
        Row hss;
        int i;
        Sheet sheet = workbook.getSheetAt(0);
        if (null == sheet) {
            return;
        }
        HashSet<Integer> idxSet = new HashSet<Integer>(fileFields.size());
        int rowNum = sheet.getLastRowNum();
        block2: for (i = startRow; i <= rowNum; ++i) {
            hss = sheet.getRow(i);
            if (!ExcelHelper.isRowNotEmpty((Row)hss) || hss.getPhysicalNumberOfCells() <= 0) continue;
            try {
                for (FileField field : fileFields) {
                    fieldCode = field.getFieldCode();
                    if (!"invoicetype".equals(fieldCode)) continue;
                    int index = field.getColIndex() - 1;
                    String invoiceType = ExcelHelper.getStringValueFromCell((Cell)hss.getCell(index));
                    if (StringUtils.isBlank((CharSequence)invoiceType) && StringUtils.isNotBlank((CharSequence)field.getDefaultValue())) {
                        invoiceType = field.getDefaultValue();
                    }
                    if (InvoiceType.checkIsTaxInvoice((String)invoiceType)) continue;
                    idxSet.add(i);
                    continue block2;
                }
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
        for (i = startRow; i <= rowNum; ++i) {
            if (!idxSet.contains(i) || !ExcelHelper.isRowNotEmpty((Row)(hss = sheet.getRow(i))) || hss.getPhysicalNumberOfCells() <= 0) continue;
            for (FileField field : fileFields) {
                fieldCode = field.getFieldCode();
                if ("buyertaxno".equals(fieldCode) || "buyername".equals(fieldCode) || "buyerbank".equals(fieldCode) || "buyeraddr".equals(fieldCode)) {
                    field.setGbkLength(Boolean.valueOf(false));
                    continue;
                }
                if (!"salertaxno".equals(fieldCode) && !"salername".equals(fieldCode) && !"salerbank".equals(fieldCode) && !"saleraddr".equals(fieldCode)) continue;
                field.setGbkLength(Boolean.valueOf(false));
            }
        }
    }

    private void removeSpecialChars(List<DynamicObject> objs) {
        String specialChars = ImcConfigUtil.getValue((String)CacheKeyEnum.SIM_REPLACE_SPCIAL_CHARACTERS.getConfigType(), (String)CacheKeyEnum.SIM_REPLACE_SPCIAL_CHARACTERS.getConfigKey());
        boolean isRepalce = StringUtils.isNotBlank((CharSequence)specialChars);
        if (isRepalce) {
            for (DynamicObject bill : objs) {
                DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items) {
                    this.replaceItemSpecialChars(item, specialChars);
                }
            }
        }
    }

    private void replaceItemSpecialChars(DynamicObject item, String specialChars) {
        try {
            String[] charArray = specialChars.split(",");
            String goodsName = item.getString("goodsname");
            for (String c : charArray) {
                goodsName = this.getReplacedChar(goodsName, c);
            }
            item.set("goodsname", (Object)goodsName);
            item.set("origoodsname", (Object)goodsName);
            String specification = item.getString("specification");
            for (String c : charArray) {
                specification = this.getReplacedChar(specification, c);
            }
            item.set("specification", (Object)specification);
            item.set("orispecification", (Object)specification);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getReplacedChar(String goodsName, String c) {
        if (StringUtils.isBlank((CharSequence)goodsName)) {
            return goodsName;
        }
        String result = goodsName.replace(c, "");
        if (!result.contains(c)) {
            return result;
        }
        return this.getReplacedChar(result, c);
    }

    private void fillInExtraData(List<Map<String, Object>> extraList) {
        for (int i = 0; i < extraList.size(); ++i) {
            Map<String, Object> extraBill = extraList.get(i);
            String billNo = (String)extraBill.get("billno");
            if (StringUtils.isBlank((CharSequence)billNo)) {
                extraBill.put("billno", "extrabillno" + i);
            }
            String evidenceType = (String)extraBill.getOrDefault("evidencetype", "");
            extraBill.put("evidencetype", InvoiceConstant.ALL_E_DEDUCTION_MAP.getOrDefault(evidenceType, ""));
        }
    }

    private Map<String, Object> checkOriginalBill(List<Map<String, Object>> list, Map<String, FileField> fieldMap, List<Map<String, Object>> extraList, Map<String, FileField> extraFieldMap, Map<String, String> errMap) {
        String originalBillStatus = BillHelper.getBillStatusByTableName((String)"sim_original_bill", (String)"1");
        String comprehensiveStatus = BillHelper.getComprehensiveStatusByBillStatus((String)originalBillStatus);
        Map invoiceListMap = list.stream().collect(Collectors.groupingBy(map -> (String)map.get("billno"), LinkedHashMap::new, Collectors.toList()));
        Map extraMap = extraList.stream().collect(Collectors.groupingBy(k -> (String)k.get("billno"), LinkedHashMap::new, Collectors.toList()));
        Set entries = invoiceListMap.entrySet();
        ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService();
        CountDownLatch countdownlatch = new CountDownLatch(entries.size());
        AtomicLong successSize = new AtomicLong(0L);
        int serialNo = 9999;
        String batchNumber = "100_" + UUID.getBatchNumber() + '_';
        List originBillDynamicObjectList = Collections.synchronizedList(new ArrayList(invoiceListMap.size()));
        RequestContext context = RequestContext.get();
        HashSet<String> importFieldSet = new HashSet<String>(fieldMap.size());
        for (Map.Entry<String, FileField> entry : fieldMap.entrySet()) {
            importFieldSet.add(entry.getKey());
        }
        List isvFieldList = ExcelHelper.getIsvFieldList(fieldMap);
        HashMap isvValMap = new HashMap(16);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sim_original_bill");
        HashMap orgOperatorNumberPkMap = new HashMap(4);
        HashMap orgBueryAddrMap = new HashMap(4);
        HashMap orgSaleAddrAndPayeeDTOMap = new HashMap(4);
        HashMap orgIssueInvSettingMap = new HashMap(4);
        HashMap orgIsTobaccoEnterpriseMap = new HashMap(4);
        HashMap orgCheckPhoneMap = new HashMap(4);
        HashMap orgTaxOrgIdMap = new HashMap(4);
        HashMap orgDrawerStrategyMap = new HashMap(4);
        for (Map.Entry entry : entries) {
            ((Map)((List)entry.getValue()).get(0)).put("originbillseq", batchNumber + serialNo);
            --serialNo;
            executorService.execute(() -> {
                Row invoiceRow;
                try {
                    BigDecimal totalAmountAllDiscount;
                    BigDecimal totalTax;
                    DrawerStrategyDTO drawerStrategy;
                    long taxOrgId;
                    String checkPhone;
                    boolean isTobaccoEnterprise;
                    boolean isHint;
                    boolean isSplit;
                    DynamicObject issueInvSetting;
                    SaleAddrAndPayeeDTO saleAddrAndPaye;
                    Map<Object, Object> operatorNumberPkMap;
                    RequestContext.copyAndSet((RequestContext)context);
                    Map originalBill = (Map)((List)entry.getValue()).get(0);
                    invoiceRow = (Row)originalBill.get("row");
                    boolean checkFlag = true;
                    String error = "";
                    if (StringUtils.isBlank(originalBill.get("orgid"))) {
                        ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("billno")), (String)String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801%s\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (String)"OriginalBillImportPlugin_313", (String)"imc-sim-formplugin", (Object[])new Object[0]), originalBill.get("orgcode")), (Map)errMap);
                        return;
                    }
                    Long orgId = Long.parseLong(originalBill.get("orgid").toString());
                    if (PermissionServiceHelper.checkPermission((Long)Long.parseLong(RequestContext.get().getUserId()), (Long)orgId, (String)"sim", (String)"sim_original_bill", (String)ImcPermItemEnum.IMC_IMPORT.getPermId()) != 1) {
                        ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("billno")), (String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7ec4\u7ec7\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5bfc\u5165\u6743\u9650", (String)"OriginalBillImportPlugin_314", (String)"imc-sim-formplugin", (Object[])new Object[0]), originalBill.get("orgcode")), (Map)errMap);
                        return;
                    }
                    DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
                    DynamicObjectUtil.map2DynamicObject((Map)originalBill, (DynamicObject)bill);
                    bill.set("creator", (Object)RequestContext.get().getUserId());
                    if (orgOperatorNumberPkMap.containsKey(orgId)) {
                        operatorNumberPkMap = (Map<Object, Object>)orgOperatorNumberPkMap.get(orgId);
                    } else {
                        Map operatorMap = BusinessDataServiceHelper.loadFromCache((String)"bdm_operator_info", (String)"number", (QFilter[])ImcBaseDataHelper.getOperatorFilter((Object)orgId).toArray());
                        operatorNumberPkMap = operatorMap.values().stream().collect(Collectors.toMap(k -> k.get("number"), DataEntityBase::getPkValue));
                        orgOperatorNumberPkMap.put(orgId, operatorNumberPkMap);
                    }
                    Map<String, DynamicObject> bueryAddrMap = this.getBueryAddrMap(orgBueryAddrMap, orgId, (String)originalBill.get("buyername"));
                    if (orgSaleAddrAndPayeeDTOMap.containsKey(orgId)) {
                        saleAddrAndPaye = (SaleAddrAndPayeeDTO)orgSaleAddrAndPayeeDTOMap.get(orgId);
                    } else {
                        saleAddrAndPaye = OriginalBillPluginAddControl.getAddrAndPayee((SaleInfo)TaxUtils.getSaleInfoByOrg((Long)orgId), (DynamicObject)bill);
                        orgSaleAddrAndPayeeDTOMap.put(orgId, saleAddrAndPaye);
                    }
                    if (orgIssueInvSettingMap.containsKey(orgId)) {
                        issueInvSetting = (DynamicObject)orgIssueInvSettingMap.get(orgId);
                        isSplit = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"));
                        isHint = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"));
                    } else {
                        issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)orgId);
                        isSplit = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"));
                        isHint = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"));
                        orgIssueInvSettingMap.put(orgId, issueInvSetting);
                    }
                    if (orgIsTobaccoEnterpriseMap.containsKey(orgId)) {
                        isTobaccoEnterprise = (Boolean)orgIsTobaccoEnterpriseMap.get(orgId);
                    } else {
                        isTobaccoEnterprise = TaxUtils.isTobaccoEnterprise((String)saleAddrAndPaye.getSaleTaxNo().toUpperCase());
                        orgIsTobaccoEnterpriseMap.put(orgId, isTobaccoEnterprise);
                    }
                    if (orgCheckPhoneMap.containsKey(orgId)) {
                        checkPhone = (String)orgCheckPhoneMap.get(orgId);
                    } else {
                        checkPhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)orgId);
                        orgCheckPhoneMap.put(orgId, checkPhone);
                    }
                    if (orgTaxOrgIdMap.containsKey(orgId)) {
                        taxOrgId = (Long)orgTaxOrgIdMap.get(orgId);
                    } else {
                        taxOrgId = RedInfoHelper.getTaxOrgId((String)saleAddrAndPaye.getSaleTaxNo());
                        orgTaxOrgIdMap.put(orgId, taxOrgId);
                    }
                    if (orgDrawerStrategyMap.containsKey(orgId)) {
                        drawerStrategy = (DrawerStrategyDTO)orgDrawerStrategyMap.get(orgId);
                    } else {
                        drawerStrategy = DrawerStrategyHelper.getDrawerStrategyFromCache((Long)orgId);
                        orgDrawerStrategyMap.put(orgId, drawerStrategy);
                    }
                    DynamicObject devDynamicObject = StringUtils.isBlank((Object)this.getModel().getValue("jqbh")) ? BusinessDataServiceHelper.newDynamicObject((String)"bdm_tax_equipment") : EquipmentUtil.getEquipmentDynamicObject((Long)orgId, (Object)this.getModel().getValue("jqbh"));
                    try {
                        this.matchingOriginalBill((List)entry.getValue(), saleAddrAndPaye, orgId);
                    }
                    catch (MsgException e) {
                        error = e.getErrorMsg();
                    }
                    Object salerTaxNo = originalBill.get("salertaxno");
                    Object invoiceType = originalBill.get("invoicetype");
                    if (AllEleAuthHelper.elePaperSetValue(salerTaxNo, invoiceType)) {
                        originalBill.put("iselepaper", "1");
                    }
                    boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)invoiceType)) || "1".equals(originalBill.get("iselepaper"));
                    QFilter qFilter = new QFilter("orgid", "=", (Object)orgId).and("billno", "=", entry.getKey());
                    if (StringUtils.isNotEmpty((CharSequence)error)) {
                        ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("billno")), (String)error, (Map)errMap);
                        return;
                    }
                    if (QueryServiceHelper.exists((String)"sim_original_bill", (QFilter[])qFilter.toArray())) {
                        ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("billno")), (String)ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0b\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728", (String)"OriginalBillImportPlugin_134", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        return;
                    }
                    List extraBillList = (List)extraMap.get(entry.getKey());
                    this.fillInAndCheckSpecialTypeData(originalBill, extraBillList);
                    if (!this.checkMotorVehicle((List)entry.getValue(), fieldMap, errMap)) {
                        checkFlag = false;
                    }
                    this.fillInOperator(operatorNumberPkMap, originalBill);
                    this.fillInSaleAndBuyerData(originalBill, saleAddrAndPaye, bueryAddrMap);
                    HashMap<String, String> billErrMap = new HashMap<String, String>(((List)entry.getValue()).size());
                    this.checkOrigianlBillMain(billErrMap, originalBill, fieldMap);
                    this.checkDeduction(originalBill, entry, fieldMap, billErrMap);
                    this.checkDiscount(entry, fieldMap, billErrMap);
                    this.fillInDrawerInfo(drawerStrategy, devDynamicObject, originalBill);
                    if (billErrMap.size() != 0) {
                        errMap.putAll(billErrMap);
                        checkFlag = false;
                    }
                    DynamicObject originBillDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
                    DynamicObjectUtil.map2DynamicObject((Map)originalBill, (DynamicObject)originBillDynamicObject);
                    ExcelHelper.setIsvField((DynamicObject)originBillDynamicObject, (Map)originalBill, (MainEntityType)mainEntityType, (List)isvFieldList, (Map)isvValMap);
                    BigDecimal totalAmount = totalTax = BigDecimal.ZERO;
                    BigDecimal totalTaxAmount = totalTax;
                    BigDecimal totalTaxAmountAllDiscount = totalAmountAllDiscount = BigDecimal.ZERO;
                    List itemList = (List)entry.getValue();
                    DynamicObjectCollection originBillDynamicObjectCollection = originBillDynamicObject.getDynamicObjectCollection("sim_original_bill_item");
                    HashSet<String> taxRateSet = new HashSet<String>(originBillDynamicObjectCollection.size());
                    try {
                        String specialType;
                        HashSet<Integer> tobaccoHashSet = new HashSet<Integer>();
                        int allDiscountSize = 0;
                        BigDecimal allDiscountAmount = null;
                        HashSet<Integer> allDiscountSet = new HashSet<Integer>();
                        String deduction = null;
                        String remark = (String)originalBill.get("invoiceremark");
                        boolean isCut = InvoiceUtils.isCutRemark((Long)orgId);
                        if (isAllEle) {
                            if (String.valueOf(remark).length() > 450) {
                                if (isCut) {
                                    remark = InvoiceUtils.cutRemarkChar((String)remark, (int)450);
                                } else {
                                    ExcelHelper.setErrorMessage((Row)((Row)((Map)list.get(0)).get("row")), (FileField)((FileField)fieldMap.get("invoiceremark")), (String)String.format(ResManager.loadKDString((String)"\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7:%s\u5b57\u7b26", (String)"OriginalBillImportPlugin_326", (String)"imc-sim-formplugin", (Object[])new Object[0]), 450), (Map)errMap);
                                    checkFlag = false;
                                }
                            }
                        } else if (GBKUtils.getGBKLength((String)remark) > 230) {
                            if (isCut) {
                                remark = GBKUtils.cutGBKString((String)remark, (int)230);
                            } else {
                                ExcelHelper.setErrorMessage((Row)((Row)((Map)list.get(0)).get("row")), (FileField)((FileField)fieldMap.get("invoiceremark")), (String)String.format(ResManager.loadKDString((String)"\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7:%s\u5b57\u8282,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"OriginalBillImportPlugin_327", (String)"imc-sim-formplugin", (Object[])new Object[0]), 230), (Map)errMap);
                                checkFlag = false;
                            }
                        }
                        originalBill.put("invoiceremark", remark);
                        ArrayList<Map<String, Object>> newItemList = new ArrayList<Map<String, Object>>();
                        for (int i = 0; i < itemList.size(); ++i) {
                            String rowType;
                            String deductionItem;
                            Map originalItemMap = (Map)itemList.get(i);
                            String policylogo = (String)originalItemMap.get("policylogo");
                            if (StringUtils.isBlank((CharSequence)policylogo)) {
                                originalItemMap.put("policylogo", "0");
                            }
                            Row row = (Row)originalItemMap.get("row");
                            if (!((Boolean)originalItemMap.get("flag")).booleanValue()) {
                                checkFlag = false;
                            }
                            if (!StringUtils.isEmpty((CharSequence)(deductionItem = (String)originalItemMap.get("deduction")))) {
                                deduction = deductionItem;
                            }
                            if ("0".equals(rowType = (String)originalItemMap.get("rowtype"))) {
                                String allDiscountAmountStr;
                                if (i != 0) {
                                    checkFlag = false;
                                    ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("amount")), (String)ResManager.loadKDString((String)"\u6574\u5355\u6298\u6263\u9700\u4f4d\u4e8e\u5355\u636e\u9996\u884c", (String)"OriginalBillImportPlugin_135", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                                }
                                if (StringUtils.isEmpty((CharSequence)(allDiscountAmountStr = (String)originalItemMap.get("amount")))) {
                                    checkFlag = false;
                                    ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("amount")), (String)ResManager.loadKDString((String)"\u6574\u5355\u6298\u6263\uff0c\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_136", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                                } else {
                                    allDiscountAmount = new BigDecimal(allDiscountAmountStr);
                                }
                                if (MathUtils.isZero((BigDecimal)new BigDecimal(allDiscountAmountStr))) {
                                    checkFlag = false;
                                    ExcelHelper.setErrorMessage((Row)row, (FileField)((FileField)fieldMap.get("amount")), (String)ResManager.loadKDString((String)"\u6574\u5355\u6298\u6263\uff0c\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"OriginalBillImportPlugin_137", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                                }
                                ++allDiscountSize;
                                allDiscountSet.add(1);
                                continue;
                            }
                            boolean normalRowTypeCheckFlag = this.normalRowType(fieldMap, errMap, isSplit, isHint, isTobaccoEnterprise, tobaccoHashSet, originalItemMap, row, isAllEle, originalBill);
                            if (!normalRowTypeCheckFlag) {
                                checkFlag = false;
                            }
                            newItemList.add(originalItemMap);
                            if (allDiscountAmount != null && "2".equals(rowType)) {
                                totalAmountAllDiscount = totalAmountAllDiscount.add(new BigDecimal(originalItemMap.get("amount").toString()));
                                totalTaxAmountAllDiscount = totalTaxAmountAllDiscount.add(new BigDecimal(originalItemMap.get("taxamount").toString()));
                            }
                            if (null != originalItemMap.get("tax")) {
                                totalTaxAmount = totalTaxAmount.add(new BigDecimal(originalItemMap.get("taxamount").toString()));
                                totalAmount = totalAmount.add(new BigDecimal(originalItemMap.get("amount").toString()));
                                totalTax = totalTax.add(new BigDecimal(originalItemMap.get("tax").toString()));
                            } else {
                                checkFlag = false;
                            }
                            allDiscountSet.add(0);
                        }
                        for (Map originalItemMap : itemList) {
                            String rowType = (String)originalItemMap.get("rowtype");
                            if (totalAmount.compareTo(BigDecimal.ZERO) >= 0 || totalTaxAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                            if (allDiscountAmount != null) {
                                checkFlag = false;
                                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("rowtype")), (String)ResManager.loadKDString((String)"\u8d1f\u6570\u5355\u636e\u4e0d\u5141\u8bb8\u6709\u6574\u5355\u6298\u6263\u884c", (String)"OriginalBillImportPlugin_138", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                            }
                            if (!"1".equals(rowType) && !"0".equals(rowType)) continue;
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("rowtype")), (String)ResManager.loadKDString((String)"\u8d1f\u6570\u5355\u636e\u4e0d\u5141\u8bb8\u6709\u6298\u6263\u884c\u6216\u6574\u5355\u6298\u6263", (String)"OriginalBillImportPlugin_139", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        }
                        if (allDiscountAmount != null) {
                            if (!StringUtils.isEmpty(deduction)) {
                                checkFlag = false;
                                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("amount")), (String)ResManager.loadKDString((String)"\u6574\u5355\u6298\u6263\uff0c\u4e0d\u5141\u8bb8\u6709\u6263\u9664\u989d", (String)"OriginalBillImportPlugin_140", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                            }
                            if ("1".equals(originalBill.get("hsbz"))) {
                                if (allDiscountAmount.compareTo(totalTaxAmountAllDiscount) >= 0) {
                                    checkFlag = false;
                                    ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("discountamount")), (String)String.format(ResManager.loadKDString((String)"\u6574\u5355\u6298\u6263\u884c\u7684\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e%s", (String)"OriginalBillImportPlugin_259", (String)"imc-sim-formplugin", (Object[])new Object[0]), totalTaxAmountAllDiscount), (Map)errMap);
                                }
                            } else if (allDiscountAmount.compareTo(totalAmountAllDiscount) >= 0) {
                                checkFlag = false;
                                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("discountamount")), (String)String.format(ResManager.loadKDString((String)"\u6574\u5355\u6298\u6263\u884c\u7684\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e%s", (String)"OriginalBillImportPlugin_259", (String)"imc-sim-formplugin", (Object[])new Object[0]), totalAmountAllDiscount), (Map)errMap);
                            }
                        }
                        if (allDiscountSet.size() == 1 && (Integer)allDiscountSet.iterator().next() == 1) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("billno")), (String)ResManager.loadKDString((String)"\u4e0d\u80fd\u5168\u90e8\u4e3a\u6574\u5355\u6298\u6263\u884c", (String)"OriginalBillImportPlugin_142", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        }
                        if (allDiscountSize > 1) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("billno")), (String)ResManager.loadKDString((String)"\u6574\u5355\u6298\u6263\u884c\u53ea\u80fd\u6709\u4e00\u884c", (String)"OriginalBillImportPlugin_143", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        }
                        if (allDiscountAmount != null && !MathUtils.bigDecimalIsNegativeValue(allDiscountAmount)) {
                            allDiscountAmount = allDiscountAmount.negate();
                        }
                        BigDecimal surplusAllDiscountAmount = allDiscountAmount;
                        for (int i = 0; i < newItemList.size(); ++i) {
                            Map originalItemMap = (Map)newItemList.get(i);
                            this.saveOriginBillItem(originalBill, originBillDynamicObjectCollection, originalItemMap, i);
                            String itemTaxRate = (String)originalItemMap.get("taxrate");
                            if (StringUtils.isNotBlank((CharSequence)itemTaxRate)) {
                                taxRateSet.add(itemTaxRate);
                            }
                            if (allDiscountAmount == null || "1".equals(originalItemMap.get("rowtype")) || "3".equals(((Map)newItemList.get(i)).get("rowtype"))) continue;
                            if (surplusAllDiscountAmount != null && !MathUtils.bigDecimalIsNegativeValue((BigDecimal)surplusAllDiscountAmount)) {
                                surplusAllDiscountAmount = surplusAllDiscountAmount.negate();
                            }
                            boolean isLastLine = false;
                            if (i == newItemList.size() - 1) {
                                isLastLine = true;
                            }
                            Map<String, Object> newDiscountMap = this.addZKLineByAllDiscount(allDiscountAmount, totalAmountAllDiscount, totalTaxAmountAllDiscount, originalItemMap, itemTaxRate, isLastLine, surplusAllDiscountAmount);
                            surplusAllDiscountAmount = (BigDecimal)newDiscountMap.get("surplusAllDiscountAmount");
                            newItemList.add(++i, newDiscountMap);
                            this.saveOriginBillItem(originalBill, originBillDynamicObjectCollection, newDiscountMap, i);
                            totalTaxAmount = totalTaxAmount.add(new BigDecimal(newDiscountMap.get("taxamount").toString()));
                            totalAmount = totalAmount.add(new BigDecimal(newDiscountMap.get("amount").toString()));
                            totalTax = totalTax.add(new BigDecimal(newDiscountMap.get("tax").toString()));
                        }
                        if (!InvoiceUtils.isAllEInvoice((Object)originalBill.get("invoicetype").toString()) && tobaccoHashSet.size() == 2) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("goodscode")), (String)ResManager.loadKDString((String)"\u5f00\u5177\u5377\u70df\u53d1\u7968\uff1a\u660e\u7ec6\u53ea\u80fd\u6709\u5377\u70df\u660e\u7ec6\u3002", (String)"OriginalBillImportPlugin_144", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                        }
                        if (StringUtils.isBlank((CharSequence)(specialType = originBillDynamicObject.getString("specialtype"))) || StringUtils.equals((CharSequence)specialType, (CharSequence)"00")) {
                            if ((Integer)tobaccoHashSet.iterator().next() == 1) {
                                originBillDynamicObject.set("specialtype", (Object)(InvoiceUtils.isAllEInvoice((Object)originBillDynamicObject.getString("invoicetype")) ? "E18" : "11"));
                            } else if ((Integer)tobaccoHashSet.iterator().next() == 0) {
                                originBillDynamicObject.set("specialtype", (Object)"00");
                            }
                        }
                        if (!this.checkAllEleSpecialType(errMap, originalBill, originBillDynamicObject, extraFieldMap, fieldMap, itemList)) {
                            checkFlag = false;
                        }
                        if (checkFlag && !this.checkAllEleDeduction(errMap, originalBill, originBillDynamicObject, extraFieldMap, fieldMap)) {
                            checkFlag = false;
                        }
                        if (checkFlag && !this.checkAllEleCoalQuality(errMap, originalBill, originBillDynamicObject, extraFieldMap, fieldMap)) {
                            checkFlag = false;
                        }
                        if (totalAmount.compareTo(BigDecimal.ZERO) > 0 && !this.checkOrigianlBillCustPhoneAndEmail(errMap, originalBill, fieldMap, checkPhone)) {
                            checkFlag = false;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("\u660e\u7ec6\u6821\u9a8c\u51fa\u9519" + e.getMessage(), (Throwable)e);
                        checkFlag = false;
                    }
                    if (totalTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                        if (StringUtils.isNotBlank(originalBill.get("infocode"))) {
                            DynamicObject redInfo;
                            if (isAllEle) {
                                QFilter filter = ImcBaseDataHelper.getRedConfirmFilter((Object)orgId).and(new QFilter("applicant", "=", (Object)"2")).and(new QFilter("number", "=", originalBill.get("infocode")));
                                redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)false), (QFilter[])filter.toArray());
                            } else {
                                QFilter filter = ImcBaseDataHelper.getRedConfirmFilter((Object)orgId).and(new QFilter("applicant", "=", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode())).and(new QFilter("infocode", "=", originalBill.get("infocode")));
                                redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)false), (QFilter[])filter.toArray());
                            }
                            if (null == redInfo) {
                                checkFlag = false;
                                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("infocode")), (String)String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868/\u7ea2\u5b57\u786e\u8ba4\u5355%s\u4e0d\u5b58\u5728", (String)"OriginalBillImportPlugin_315", (String)"imc-sim-formplugin", (Object[])new Object[0]), originalBill.get("infocode")), (Map)errMap);
                            } else if ("sim_red_confirm_bill".equals(redInfo.getDataEntityType().getName())) {
                                originBillDynamicObject.set("redreason", (Object)RedConfirmBillRedReasonEnum.getBillCodeByCode((String)redInfo.getString("redreason")));
                                originBillDynamicObject.set("originalissuetime", (Object)redInfo.getDate("originalissuetime"));
                                originBillDynamicObject.set("blueinvoicetype", (Object)redInfo.getString("originalinvoicetype"));
                                originBillDynamicObject.set("blueinvoicecode", (Object)redInfo.getString("originalinvoicecode"));
                                originBillDynamicObject.set("blueinvoiceno", (Object)redInfo.getString("originalinvoiceno"));
                            } else {
                                originBillDynamicObject.set("originalissuetime", (Object)redInfo.getDate("originalissuetime"));
                                originBillDynamicObject.set("blueinvoicecode", (Object)redInfo.getString("originalinvoicecode"));
                                originBillDynamicObject.set("blueinvoiceno", (Object)redInfo.getString("originalinvoiceno"));
                            }
                        } else if (StringUtils.isNotBlank(originalBill.get("blueinvoiceno"))) {
                            QFilter filter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)(originalBill.get("blueinvoicecode") + ""), (String)(originalBill.get("blueinvoiceno") + "")).and("orgid", "=", (Object)orgId);
                            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "issuetime", "invoicetype"), (QFilter[])filter.toArray());
                            if (null == invoice) {
                                checkFlag = false;
                                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("blueinvoiceno")), (String)ResManager.loadKDString((String)"\u84dd\u7968\u4e0d\u5b58\u5728", (String)"OriginalBillImportPlugin_316", (String)"imc-sim-formplugin", (Object[])new Object[0]), (Map)errMap);
                            } else {
                                originBillDynamicObject.set("originalissuetime", (Object)invoice.getDate("issuetime"));
                                originBillDynamicObject.set("blueinvoicetype", (Object)invoice.getString("invoicetype"));
                                originBillDynamicObject.set("redreason", (Object)RedConfirmBillRedReasonEnum.getBillCodeByStr((String)((String)originalBill.get("redreason"))));
                            }
                        } else if (StringUtils.isNotBlank(originalBill.get("redreason"))) {
                            originBillDynamicObject.set("redreason", (Object)RedConfirmBillRedReasonEnum.getBillCodeByStr((String)((String)originalBill.get("redreason"))));
                        }
                        if (isAllEle) {
                            originBillDynamicObject.set("salerorbuyer", (Object)"0");
                        } else {
                            originBillDynamicObject.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
                        }
                    } else {
                        originBillDynamicObject.set("redreason", null);
                        originBillDynamicObject.set("blueinvoicecode", null);
                        originBillDynamicObject.set("blueinvoiceno", null);
                        originBillDynamicObject.set("infocode", null);
                    }
                    if (checkFlag) {
                        successSize.getAndAdd(((List)entry.getValue()).size());
                        originBillDynamicObject.set("billtaxrate", taxRateSet.size() == 1 ? taxRateSet.toArray()[0] : null);
                        originBillDynamicObject.set("billstatus", (Object)originalBillStatus);
                        originBillDynamicObject.set("comprehensivestatus", (Object)comprehensiveStatus);
                        originBillDynamicObject.set("taxorg", (Object)taxOrgId);
                        this.writeBillMainData(originBillDynamicObject, totalAmount, totalTax, totalTaxAmount);
                        this.writeBillShowConfig(originBillDynamicObject, importFieldSet);
                        originBillDynamicObject.set("itemcount", (Object)originBillDynamicObject.getDynamicObjectCollection("sim_original_bill_item").size());
                        originBillDynamicObjectList.add(originBillDynamicObject);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u5355\u636e\u7f16\u53f7%s\u6821\u9a8c\u51fa\u9519", entry.getKey()), (Throwable)e);
                    invoiceRow = (Row)((Map)((List)entry.getValue()).get(0)).get("row");
                    ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)((FileField)fieldMap.get("billno")), (String)e.getMessage(), (Map)errMap);
                }
                finally {
                    countdownlatch.countDown();
                }
            });
        }
        try {
            countdownlatch.await();
            executorService.shutdown();
        }
        catch (Exception e) {
            throw new KDBizException(e.toString());
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
        returnMap.put("successSize", successSize.intValue());
        returnMap.put("objs", originBillDynamicObjectList);
        return returnMap;
    }

    private boolean checkMotorVehicle(List<Map<String, Object>> entry, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        boolean flag = true;
        for (Map<String, Object> originalBill : entry) {
            Row invoiceRow = (Row)originalBill.get("row");
            if (!"E14".equals(originalBill.get("specialtype")) || "1".equals(originalBill.get("rowtype"))) continue;
            if (!"08xdp".equals(originalBill.get("invoicetype"))) {
                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("invoicetype"), (String)ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u53ea\u80fd\u5f00\u6570\u7535\u4e13\u7968", (String)"OriginalBillImportPlugin_278", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                flag = false;
            }
            if (!"\u8f86".equals(originalBill.get("unit"))) {
                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("unit"), (String)ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u660e\u7ec6\u5355\u4f4d\u5fc5\u586b,\u4e14\u5fc5\u987b\u4e3a\u201c\u8f86\u201d", (String)"OriginalBillImportPlugin_279", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                flag = false;
            }
            if (StringUtils.isBlank((Object)originalBill.get("unitprice"))) {
                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("unitprice"), (String)ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u660e\u7ec6\u5355\u4ef7\u5fc5\u586b", (String)"OriginalBillImportPlugin_280", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                flag = false;
            }
            try {
                Integer.parseInt(originalBill.get("num").toString());
            }
            catch (NumberFormatException e) {
                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("num"), (String)ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u660e\u7ec6\u6570\u91cf\u5fc5\u586b,\u4e14\u5fc5\u987b\u4e3a\u6574\u6570", (String)"OriginalBillImportPlugin_281", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                flag = false;
            }
        }
        return flag;
    }

    private void fillInAndCheckSpecialTypeData(Map<String, Object> originalBill, List<Map<String, Object>> extraBillList) {
        boolean flag;
        Map<String, Object> extraBill;
        if (CollectionUtils.isEmpty(extraBillList)) {
            return;
        }
        String invoiceType = (String)originalBill.get("invoicetype");
        Object isElePaper = originalBill.get("iselepaper");
        if (!InvoiceUtils.isAllEInvoice((Object)invoiceType) && !AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            return;
        }
        String taxedType = (String)originalBill.get("taxationstyle");
        if (TaxedTypeEnum.all_e_deduction.getValue().equals(taxedType)) {
            this.fillInAlleDeduction(originalBill, extraBillList);
        } else {
            originalBill.put("deduction", "0");
        }
        if (StringUtils.isNotEmpty((CharSequence)((String)originalBill.get("coaltypecode")))) {
            this.fillInAlleCoalQuality(originalBill, extraBillList);
        }
        if (CollectionUtils.isEmpty(extraBill = extraBillList.get(0))) {
            return;
        }
        String specialType = (String)originalBill.get("specialtype");
        if (!InvoiceSpecialType.allEleSpecialType((String)specialType)) {
            return;
        }
        if (StringUtils.equals((CharSequence)specialType, (CharSequence)"E04")) {
            originalBill.put("freights", extraBillList);
        } else if (StringUtils.equals((CharSequence)specialType, (CharSequence)"E09")) {
            originalBill.put("travelers", extraBillList);
        } else if (StringUtils.equals((CharSequence)specialType, (CharSequence)"E05")) {
            flag = (Boolean)originalBill.get("flag");
            ArrayList coBuyerList = new ArrayList(extraBillList.size());
            ArrayList estateSaleList = new ArrayList(extraBillList.size());
            String cobuyerFlag = "0";
            for (int i = 0; i < extraBillList.size(); ++i) {
                if (!((Boolean)extraBillList.get(i).get("flag")).booleanValue()) {
                    flag = Boolean.FALSE;
                }
                if ("\u662f".equals(extraBillList.get(i).get("cobuyerflag") + "")) {
                    cobuyerFlag = "1";
                    HashMap<String, Object> coBuyerMap = new HashMap<String, Object>();
                    if (Handle.isEmpty((Object)extraBillList.get(i).get("cobuyer")) && Handle.isEmpty((Object)extraBillList.get(i).get("cobuyercardtype")) && Handle.isEmpty((Object)extraBillList.get(i).get("cobuyercardno"))) continue;
                    coBuyerMap.put("cobuyer", extraBillList.get(i).get("cobuyer"));
                    coBuyerMap.put("cobuyercardtype", TravelerCardTypeEnum.getCodeByDesc((String)((String)extraBillList.get(i).get("cobuyercardtype"))));
                    coBuyerMap.put("cobuyercardno", extraBillList.get(i).get("cobuyercardno"));
                    coBuyerMap.put("extra_row", extraBillList.get(i).get("row"));
                    coBuyerList.add(coBuyerMap);
                }
                HashMap<String, Object> estateSaleMap = new HashMap<String, Object>();
                if (Handle.isEmpty((Object)extraBillList.get(i).get("estateid_E05")) && Handle.isEmpty((Object)extraBillList.get(i).get("simpleaddress_E05")) && Handle.isEmpty((Object)extraBillList.get(i).get("detailaddress_E05")) && Handle.isEmpty((Object)extraBillList.get(i).get("estatecode_E05")) && Handle.isEmpty((Object)extraBillList.get(i).get("onlinecontracteno")) && Handle.isEmpty((Object)extraBillList.get(i).get("landtaxno_E05")) && Handle.isEmpty((Object)extraBillList.get(i).get("approvedprice_E05")) && Handle.isEmpty((Object)extraBillList.get(i).get("actualturnover_E05")) && Handle.isEmpty((Object)extraBillList.get(i).get("areaunit_E05"))) continue;
                estateSaleMap.put("saleestatecode", extraBillList.get(i).get("estatecode_E05"));
                estateSaleMap.put("onlinecontracteno", extraBillList.get(i).get("onlinecontracteno"));
                String simpleAddress = extraBillList.get(i).get("simpleaddress_E05") + "";
                Map adrressMap = AllEleLqAddressSplitUtil.split((String)simpleAddress);
                estateSaleMap.put("saleprincename", adrressMap.get("province"));
                estateSaleMap.put("salecityname", adrressMap.get("city"));
                estateSaleMap.put("saledetailaddress", extraBillList.get(i).get("detailaddress_E05"));
                estateSaleMap.put("salelandtaxno", extraBillList.get(i).get("landtaxno_E05"));
                String crosscitysign = extraBillList.get(i).get("crosscitysign_E05") + "";
                if ("\u662f".equals(crosscitysign)) {
                    estateSaleMap.put("salecrosscitysign", "1");
                } else {
                    estateSaleMap.put("salecrosscitysign", "0");
                }
                estateSaleMap.put("assessmenttaxamount", extraBillList.get(i).get("approvedprice_E05"));
                estateSaleMap.put("actualtotalamount", extraBillList.get(i).get("actualturnover_E05"));
                estateSaleMap.put("saleestateid", extraBillList.get(i).get("estateid_E05"));
                estateSaleMap.put("saleunit", extraBillList.get(i).get("areaunit_E05"));
                estateSaleMap.put("extra_row", extraBillList.get(i).get("row"));
                estateSaleList.add(estateSaleMap);
            }
            coBuyerList.remove(null);
            estateSaleList.remove(null);
            originalBill.put("estatesales", estateSaleList);
            originalBill.put("cobuyerflag", cobuyerFlag);
            originalBill.put("cobuyers", coBuyerList);
            originalBill.put("flag", flag);
        } else if (StringUtils.equals((CharSequence)specialType, (CharSequence)"E07")) {
            originalBill.put("vehichevesselships", extraBillList);
        } else if (StringUtils.equals((CharSequence)specialType, (CharSequence)"E06")) {
            flag = (Boolean)originalBill.get("flag");
            ArrayList estateLeaseList = new ArrayList(extraBillList.size());
            for (Map<String, Object> stringObjectMap : extraBillList) {
                if (!((Boolean)stringObjectMap.get("flag")).booleanValue()) {
                    flag = false;
                }
                HashMap<String, Object> estateLeaseMap = new HashMap<String, Object>();
                if (Handle.isEmpty((Object)stringObjectMap.get("estateid_E06")) && Handle.isEmpty((Object)stringObjectMap.get("simpleaddress_E06")) && Handle.isEmpty((Object)stringObjectMap.get("detailaddress_E06")) && Handle.isEmpty((Object)stringObjectMap.get("startleasedate_E06")) && Handle.isEmpty((Object)stringObjectMap.get("endleasedate_E06")) && Handle.isEmpty((Object)stringObjectMap.get("crosscitysign_E06")) && Handle.isEmpty((Object)stringObjectMap.get("areaunit_E06")) && Handle.isEmpty((Object)stringObjectMap.get("carbrandno"))) continue;
                estateLeaseMap.put("saleestateid", stringObjectMap.get("estateid_E06"));
                String simpleAddress = stringObjectMap.get("simpleaddress_E06") + "";
                Map adrressMap = AllEleLqAddressSplitUtil.split((String)simpleAddress);
                estateLeaseMap.put("saleprincename", adrressMap.get("province"));
                estateLeaseMap.put("salecityname", adrressMap.get("city"));
                estateLeaseMap.put("saledetailaddress", stringObjectMap.get("detailaddress_E06"));
                String crosscitysign = stringObjectMap.get("crosscitysign_E06") + "";
                if ("\u662f".equals(crosscitysign)) {
                    estateLeaseMap.put("salecrosscitysign", "1");
                } else {
                    estateLeaseMap.put("salecrosscitysign", "0");
                }
                estateLeaseMap.put("saleunit", stringObjectMap.get("areaunit_E06"));
                estateLeaseMap.put("leasestartdate", stringObjectMap.get("startleasedate_E06"));
                estateLeaseMap.put("leaseenddate", stringObjectMap.get("endleasedate_E06"));
                estateLeaseMap.put("carbrandno", stringObjectMap.get("carbrandno"));
                estateLeaseMap.put("extra_row", stringObjectMap.get("row"));
                estateLeaseList.add(estateLeaseMap);
            }
            estateLeaseList.remove(null);
            originalBill.put("estatesales", estateLeaseList);
            originalBill.put("flag", flag);
        }
        Set<Map.Entry<String, Object>> entries = extraBill.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (!entry.getKey().endsWith(specialType)) continue;
            originalBill.put(entry.getKey().replace('_' + specialType, ""), entry.getValue());
        }
        originalBill.put("extra_row", extraBill.get("row"));
        String crossCitySign = (String)originalBill.get("crosscitysign");
        if (StringUtils.isNotBlank((CharSequence)crossCitySign)) {
            originalBill.put("crosscitysign", "\u662f".equals(crossCitySign) ? "1" : "0");
        }
    }

    private void fillInAlleDeduction(Map<String, Object> originalBill, List<Map<String, Object>> extraBillList) {
        BigDecimal sumDeduction = BigDecimal.ZERO;
        for (Map<String, Object> extraBill : extraBillList) {
            String deductionAmountStr = (String)extraBill.get("deductionamount");
            if (!StringUtils.isNotBlank((CharSequence)deductionAmountStr)) continue;
            if (BigDecimalUtil.isNumber((String)deductionAmountStr)) {
                sumDeduction = sumDeduction.add(new BigDecimal(deductionAmountStr));
                continue;
            }
            extraBill.put("deductionamount", "");
        }
        originalBill.put("deductions", extraBillList);
        originalBill.put("deduction", sumDeduction.stripTrailingZeros().toPlainString());
    }

    private void fillInOperator(Map<Object, Object> operatorNumberPkMap, Map<String, Object> originalBill) {
        Object operatorNumber;
        String invoiceType = (String)originalBill.get("invoicetype");
        Object isElePaper = originalBill.get("iselepaper");
        if ((InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) && (operatorNumber = originalBill.get("operator")) != null) {
            originalBill.put("operator", operatorNumberPkMap.get(operatorNumber));
        }
    }

    private Map<String, Object> addZKLineByAllDiscount(BigDecimal allDiscountAmount, BigDecimal totalAmount, BigDecimal totalTaxAmount, Map<String, Object> originalItemMap, String itemTaxRate, boolean isLastLine, BigDecimal surplusAllDiscountAmount) {
        BigDecimal discountTax;
        BigDecimal discountAmount;
        BigDecimal discountTaxAmount;
        HashMap<String, Object> newDiscountMap = new HashMap<String, Object>(originalItemMap.size());
        if ("1".equals(originalItemMap.get("hsbz"))) {
            BigDecimal itemTaxAmount = new BigDecimal(originalItemMap.get("taxamount").toString());
            discountTaxAmount = isLastLine ? surplusAllDiscountAmount : itemTaxAmount.divide(totalTaxAmount, 20, 4).multiply(allDiscountAmount).setScale(2, 4);
            surplusAllDiscountAmount = surplusAllDiscountAmount.subtract(discountTaxAmount);
            discountAmount = discountTaxAmount.divide(BigDecimal.ONE.add(new BigDecimal(itemTaxRate)), 2, 4);
            discountTax = discountTaxAmount.subtract(discountAmount);
        } else {
            BigDecimal itemAmount = new BigDecimal(originalItemMap.get("amount").toString());
            discountAmount = isLastLine ? surplusAllDiscountAmount : itemAmount.divide(totalAmount, 20, 4).multiply(allDiscountAmount).setScale(2, 4);
            surplusAllDiscountAmount = surplusAllDiscountAmount.subtract(discountAmount);
            discountTax = discountAmount.multiply(new BigDecimal(itemTaxRate)).setScale(2, 4);
            discountTaxAmount = discountAmount.add(discountTax);
        }
        originalItemMap.forEach(newDiscountMap::put);
        this.clearDiscountRowData(newDiscountMap);
        newDiscountMap.put("tax", discountTax);
        newDiscountMap.put("amount", discountAmount);
        newDiscountMap.put("taxamount", discountTaxAmount);
        newDiscountMap.put("surplusAllDiscountAmount", surplusAllDiscountAmount);
        return newDiscountMap;
    }

    private DynamicObject saveOriginBillItem(Map<String, Object> originalBill, DynamicObjectCollection originBillItem, Map<String, Object> originalItemMap, int index) {
        DynamicObject billItem = originBillItem.addNew();
        DynamicObjectUtil.map2DynamicObject(originalItemMap, (DynamicObject)billItem);
        if ("3".equals(originalItemMap.get("rowtype"))) {
            billItem.set("rowtype", (Object)"2");
        }
        billItem.set("seq", (Object)(index + 1));
        this.writeRemainAmount(originalBill, billItem);
        return billItem;
    }

    private boolean normalRowType(Map<String, FileField> fieldMap, Map<String, String> errMap, boolean isSplit, boolean isHint, boolean isTobaccoEnterprise, HashSet<Integer> tobaccoHashSet, Map<String, Object> originalItemMap, Row row, boolean isAllEle, Map<String, Object> originalBill) {
        String goodsCode;
        DynamicObject taxClassCode;
        boolean checkFlag = true;
        if (!this.checkItemCommon(originalItemMap, fieldMap, errMap, isHint, isSplit)) {
            checkFlag = false;
        }
        if ((taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)(goodsCode = (String)originalItemMap.get("goodscode")))) == null) {
            checkFlag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodscode"), (String)ResManager.loadKDString((String)"\u8be5\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u6709\u8bef\uff0c\u5e94\u4e3a19\u4f4d\u6709\u6548\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"OriginalBillImportPlugin_148", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else {
            originalItemMap.put("taxratecodeid", taxClassCode.getPkValue());
            originalItemMap.put("goodssimplename", taxClassCode.getString("simplename"));
            if (TaxUtils.isTobaccoGoods((String)goodsCode)) {
                tobaccoHashSet.add(1);
                if (!InvoiceUtils.isAllEInvoice((Object)originalItemMap.get("invoicetype").toString()) && !isTobaccoEnterprise) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodscode"), (String)ResManager.loadKDString((String)"\u5f00\u5177\u5377\u70df\u53d1\u7968\uff1a\u975e\u5377\u70df\u4f01\u4e1a\uff0c\u4e0d\u5141\u8bb8\u5f00\u5377\u70df\u660e\u7ec6\u53d1\u7968\u3002", (String)"OriginalBillImportPlugin_149", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            } else {
                tobaccoHashSet.add(0);
            }
            if (!EnterpriseHelper.isLqptChannel((String)(originalBill.get("salertaxno") + "")) && CoalTypeCodeEnum.coalTypeGoodsCode.contains(goodsCode) && StringUtils.isEmpty((CharSequence)(originalItemMap.get("coaltypecode") + ""))) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("coaltypecode"), (String)ResManager.loadKDString((String)"\u7164\u70ad\u79cd\u7c7b\u5fc5\u586b", (String)"OriginalBillImportPlugin_317", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
        if (!this.checkTaxpremarkAndTaxRate(originalItemMap, fieldMap, errMap)) {
            checkFlag = false;
        }
        if (!this.checkPriceNum(originalItemMap, fieldMap, errMap, isAllEle)) {
            checkFlag = false;
        }
        if (checkFlag) {
            boolean elePaper;
            String specialType = (String)originalItemMap.get("specialtype");
            Object isElePaper = originalItemMap.get("iselepaper");
            boolean bl = elePaper = InvoiceUtils.isAllEInvoice((Object)((String)originalItemMap.get("invoicetype"))) || AllEleAuthHelper.isElePaper((Object)isElePaper);
            if (elePaper && ("E06".equals(specialType) || "E05".equals(specialType)) && "2".equals(originalItemMap.get("rowtype"))) {
                String num;
                String unitPrice = (String)originalItemMap.get("unitprice");
                if (StringUtils.isBlank((CharSequence)unitPrice)) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u7279\u5b9a\u4e1a\u52a1\u7c7b\u578b\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_150", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
                if (StringUtils.isBlank((CharSequence)(num = (String)originalItemMap.get("num")))) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("num"), (String)ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u7279\u5b9a\u4e1a\u52a1\u7c7b\u578b\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_151", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
        }
        return checkFlag;
    }

    private void fillInDrawerInfo(DrawerStrategyDTO strategy, DynamicObject devDynamicObject, Map<String, Object> originalBill) {
        originalBill.put("drawer", this.getDrawer(strategy, devDynamicObject, originalBill, "drawer"));
        originalBill.put("payee", this.getDrawer(strategy, devDynamicObject, originalBill, "payee"));
        originalBill.put("reviewer", this.getDrawer(strategy, devDynamicObject, originalBill, "reviewer"));
    }

    private String getDrawer(DrawerStrategyDTO strategy, DynamicObject devDynamicObject, Map<String, Object> originalBill, String key) {
        String str = (String)originalBill.get(key);
        switch (this.getStrategy(strategy, key)) {
            case "0": {
                str = RequestContext.get().getUserName();
                break;
            }
            case "1": {
                String currentName = RequestContext.get().getUserName();
                if ("payee".equals(key) || "reviewer".equals(key)) {
                    currentName = "";
                }
                str = StringUtils.isBlank((CharSequence)str) ? currentName : str;
                break;
            }
            case "2": {
                str = devDynamicObject.getString(key);
                break;
            }
            case "3": 
            case "4": {
                str = this.getSPecialUser(strategy, key);
            }
        }
        return str;
    }

    private String getStrategy(DrawerStrategyDTO strategy, String key) {
        String strategyStr = "0";
        switch (key) {
            case "drawer": {
                strategyStr = strategy.getDrawerStrategy();
                break;
            }
            case "reviewer": {
                strategyStr = strategy.getReviewerStrategy();
                break;
            }
            case "payee": {
                strategyStr = strategy.getPayeeStrategy();
            }
        }
        return strategyStr;
    }

    private String getSPecialUser(DrawerStrategyDTO strategy, String key) {
        String speicialUser = "";
        switch (key) {
            case "drawer": {
                speicialUser = strategy.getDrawerName();
                break;
            }
            case "reviewer": {
                speicialUser = strategy.getReviewerName();
                break;
            }
            case "payee": {
                speicialUser = strategy.getPayeeName();
            }
        }
        return speicialUser;
    }

    private boolean checkItemCommon(Map<String, Object> originalItemMap, Map<String, FileField> fieldMap, Map<String, String> errMap, boolean isHint, boolean isSplit) {
        String simpleName;
        String specification;
        String unit;
        boolean flag = true;
        Row row = (Row)originalItemMap.get("row");
        String goodsName = (String)originalItemMap.get("goodsname");
        if (StringUtils.isBlank((CharSequence)goodsName)) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodsname"), (String)ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_152", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (StringUtils.isNotBlank((CharSequence)(unit = (String)originalItemMap.get("unit"))) && GBKUtils.getGBKLength((String)unit) > 22) {
            if (isSplit) {
                originalItemMap.put("unit", GBKUtils.cutGBKString((String)unit, (int)22));
            } else if (isHint) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unit"), (String)ApiErrCodeEnum.INVOICE_OPEN_GOODUNIT.getMsg(), errMap);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(specification = (String)originalItemMap.get("specification"))) && GBKUtils.getGBKLength((String)specification) > 40) {
            if (isSplit) {
                originalItemMap.put("specification", GBKUtils.cutGBKString((String)specification, (int)40));
            } else if (isHint) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("specification"), (String)ApiErrCodeEnum.INVOICE_OPEN_SPECIFICATION.getMsg(), errMap);
            }
        }
        if (((simpleName = "*" + originalItemMap.get("goodssimplename") + "*") + goodsName).length() > 100 && isSplit) {
            originalItemMap.put("goodsname", StringUtils.substring((String)(simpleName + goodsName), (int)0, (int)100));
        } else if (goodsName.length() > 100 && isHint) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodsname"), (String)ApiErrCodeEnum.INVOICE_OPEN_GOODNAMELENGTH.getMsg(), errMap);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchingOriginalBill(List<Map<String, Object>> invoiceList, SaleAddrAndPayeeDTO saleAddrAndPaye, long orgId) {
        try {
            BillValidaterHelper.setSaleInfoByTaxNo(invoiceList, (SaleAddrAndPayeeDTO)saleAddrAndPaye);
            LOGGER.info("\u5339\u914d\u8d2d\u65b9\u62ac\u5934\uff1a{}", (Object)invoiceList.size());
            InvTitleMatchHelper.matchInvTitle(invoiceList, (Long)orgId);
            boolean goodsInfoSwitch = this.getGoodsInfoSwitch(orgId);
            boolean isCompletion = MaterialToGoodsInfoHelp.getCompletion((long)orgId);
            LOGGER.info(String.format("OriginalBillImportPlugin checkOriginalBill: %s", goodsInfoSwitch));
            HashMap<String, List<DynamicObject>> goodsNameMap = new HashMap(invoiceList.size());
            Map<String, List<Object>> goodsCodeMap = new HashMap<String, List<DynamicObject>>(invoiceList.size());
            if (goodsInfoSwitch || isCompletion) {
                HashSet codeSet = Sets.newHashSet();
                HashSet nameSet = Sets.newHashSet();
                HashSet hashSet = Sets.newHashSet();
                MaterialToGoodsInfoHelp.intiQuerySet((Set)codeSet, (Set)nameSet, (Set)hashSet, invoiceList);
                MaterialInfoUtil.getInstance((long)orgId, (Set)nameSet, (Set)codeSet, (Set)hashSet, (boolean)false);
                goodsNameMap = GoodsInfoCacheHelper.getGoodsInfoList((String)"name", (Long)orgId, (Set)nameSet);
                goodsCodeMap = GoodsInfoCacheHelper.getGoodsInfoList((String)"number", (Long)orgId, (Set)codeSet);
            }
            HashMap checkGoodsCodeMap = new HashMap(8);
            if (goodsInfoSwitch) {
                for (Map map : invoiceList) {
                    String spbm = (String)map.get("spbm");
                    String goodsName = (String)map.get("goodsname");
                    if (this.checkGoodsInfo(map)) {
                        LOGGER.info(String.format("\u7f16\u53f7\uff1a%s\uff0c\u540d\u79f0\uff1a%s\u6570\u636e\u5df2\u5b8c\u6574\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u5f00\u7968\u9879\u6620\u5c04", spbm, goodsName));
                        continue;
                    }
                    this.fillInGoodsInfo(map, goodsNameMap, goodsCodeMap, false, false);
                    if (goodsCodeMap.containsKey(spbm) || goodsNameMap.containsKey(goodsName)) {
                        LOGGER.info(String.format("\u540d\u79f0\u4f5c\u4e3a\u5f00\u7968\u9879\u5df2\u7ecf\u5339\u914d\u5b8c\u6210\uff0c\u76f4\u63a5\u8fd4\u56de code:%s name:%s", spbm, goodsName));
                        continue;
                    }
                    MaterialToGoodsInfoHelp.matchGoodsInfoJournal((Map)map, (String)spbm, (String)goodsName);
                    String goodsCode = (String)checkGoodsCodeMap.get(goodsName);
                    if (StringUtils.isBlank((CharSequence)goodsCode)) {
                        MaterialToGoodsInfoHelp.setGoodsInfoByInstitute((Map)map, checkGoodsCodeMap);
                        continue;
                    }
                    map.put("goodscode", goodsCode);
                }
                return;
            }
            if (isCompletion) {
                boolean isCompletionPolicylogo = MaterialToGoodsInfoHelp.getCompletionPolicylogo((long)orgId);
                for (Map<String, Object> detail : invoiceList) {
                    this.fillInGoodsInfo(detail, goodsNameMap, goodsCodeMap, true, isCompletionPolicylogo);
                }
            }
        }
        catch (MsgException msg) {
            throw msg;
        }
        catch (Exception e) {
            LOGGER.error("\u5f00\u7968\u7533\u8bf7\u5355\u5bfc\u5165\u5339\u914d\u7269\u6599\u5f02\u5e38 " + e.getMessage());
        }
        finally {
            MaterialInfoUtil.clear();
        }
    }

    private void writeDefaultData(Map<String, Object> map) {
        map.put("creator", RequestContext.get().getUserId());
        map.put("jqbh", this.getModel().getValue("jqbh"));
        map.put("confirmstate", "0");
        map.put("validstate", "0");
        map.put("split", "1");
        map.put("priority", "0");
        map.put("billsource", "1");
        map.put("systemsource", "Kingdee_Excel");
        map.put("billsourcetype", "A");
    }

    private void writeBillMainData(DynamicObject obj, BigDecimal invoiceAmount, BigDecimal totalTax, BigDecimal totalTaxAmount) {
        obj.set("billdate", (Object)new Date());
        obj.set("createdate", (Object)new Date());
        obj.set("buyertaxno", (Object)obj.getString("buyertaxno").toUpperCase());
        totalTaxAmount = totalTaxAmount.setScale(2, 4);
        obj.set("totalamount", (Object)totalTaxAmount);
        obj.set("oldtotalamount", (Object)totalTaxAmount);
        invoiceAmount = invoiceAmount.setScale(2, 4);
        obj.set("invoiceamount", (Object)invoiceAmount);
        obj.set("surplusamount", (Object)invoiceAmount);
        totalTax = totalTax.setScale(2, 4);
        obj.set("totaltax", (Object)totalTax);
        obj.set("surplustax", (Object)totalTax);
        obj.set("billproperties", (Object)(totalTaxAmount.compareTo(BigDecimal.ZERO) >= 0 ? "1" : "-1"));
        obj.set("producttype", (Object)"1");
    }

    private void writeBillShowConfig(DynamicObject obj, Set<String> importFieLdSet) {
        if (!importFieLdSet.contains("showbuyerbank") || obj.get("showbuyerbank") == null) {
            obj.set("showbuyerbank", (Object)SystemParameterHelper.getBdmParameterBoolean((long)RequestContext.get().getOrgId(), (String)"showbuyerbank"));
        }
        if (!importFieLdSet.contains("showbuyeraddresstel") || obj.get("showbuyeraddresstel") == null) {
            obj.set("showbuyeraddresstel", (Object)SystemParameterHelper.getBdmParameterBoolean((long)RequestContext.get().getOrgId(), (String)"showbuyeraddresstel"));
        }
        if (!importFieLdSet.contains("showsalerbank") || obj.get("showsalerbank") == null) {
            obj.set("showsalerbank", (Object)SystemParameterHelper.getBdmParameterBoolean((long)RequestContext.get().getOrgId(), (String)"showsalerbank"));
        }
        if (!importFieLdSet.contains("showsaleraddresstel") || obj.get("showsaleraddresstel") == null) {
            obj.set("showsaleraddresstel", (Object)SystemParameterHelper.getBdmParameterBoolean((long)RequestContext.get().getOrgId(), (String)"showsaleraddresstel"));
        }
    }

    private void writeRemainAmount(Map<String, Object> originalBill, DynamicObject originalItem) {
        originalItem.set("taxamount", (Object)originalItem.getBigDecimal("taxamount").setScale(2, 4));
        originalItem.set("amount", (Object)originalItem.getBigDecimal("amount").setScale(2, 4));
        originalItem.set("tax", (Object)originalItem.getBigDecimal("tax").setScale(2, 4));
        String hsbz = (String)originalBill.get("hsbz");
        originalItem.set("remainvalidamount", "0".equals(hsbz) ? originalItem.get("amount") : originalItem.get("taxamount"));
        originalItem.set("remainvalidtax", originalItem.get("tax"));
        originalItem.set("remainvalidnum", originalItem.get("num"));
    }

    private void checkDiscount(Map.Entry<String, List<Map<String, Object>>> entry, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        BigDecimal discountRate;
        String firstDiscountRate;
        List<Map<String, Object>> items = entry.getValue();
        Map<String, Object> firstRow = items.get(0);
        String firstRowtype = (String)firstRow.get("rowtype");
        if ("1".equals(firstRowtype)) {
            ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("rowtype"), (String)ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u4e0d\u5141\u8bb8\u4e3a\u6298\u6263\u884c", (String)"OriginalBillImportPlugin_157", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (StringUtils.isNotBlank((CharSequence)(firstDiscountRate = (String)firstRow.get("discountrate"))) && ((discountRate = new BigDecimal(firstDiscountRate)).compareTo(BigDecimal.ONE) >= 0 || discountRate.compareTo(BigDecimal.ZERO) <= 0)) {
            ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("discountrate"), (String)ResManager.loadKDString((String)"\u6298\u6263\u7387\u4e0d\u5408\u6cd5", (String)"OriginalBillImportPlugin_158", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        for (int i = 1; i < items.size(); ++i) {
            String amount;
            Map<String, Object> item = items.get(i);
            String rowType = (String)item.get("rowtype");
            if (!"1".equals(rowType) || StringUtils.isBlank((CharSequence)(amount = (String)item.get("amount")))) continue;
            String taxRate = (String)item.get("taxrate");
            Map<String, Object> preItem = items.get(i - 1);
            String deductionStr = (String)preItem.get("deduction");
            String preItemRowType = (String)preItem.get("rowtype");
            String preItemAmount = StringUtils.isBlank((Object)preItem.get("amount")) ? "0" : (String)preItem.get("amount");
            String preTaxRate = (String)preItem.getOrDefault("taxrate", "");
            if ("0".equals(preItemRowType)) {
                ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("rowtype"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u4e0a\u4e00\u884c\u4e0d\u5141\u8bb8\u662f\u6574\u5355\u6298\u6263\u884c", (String)"OriginalBillImportPlugin_159", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else if ("1".equals(preItemRowType)) {
                ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("rowtype"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u4e0a\u4e00\u884c\u4e0d\u5141\u8bb8\u662f\u6298\u6263\u884c", (String)"OriginalBillImportPlugin_160", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                BigDecimal calcAmount;
                BigDecimal bigDecimal = calcAmount = StringUtils.isBlank((CharSequence)deductionStr) ? new BigDecimal(amount) : new BigDecimal(amount).subtract(new BigDecimal(deductionStr));
                if (calcAmount.abs().compareTo(new BigDecimal(preItemAmount).abs()) > 0) {
                    if (MathUtils.isZero((BigDecimal)new BigDecimal(preItemAmount))) {
                        ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("rowtype"), (String)ResManager.loadKDString((String)"\u586b\u4e86\u6298\u6263\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"OriginalBillImportPlugin_161", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    } else {
                        ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("rowtype"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u88ab\u6298\u6263\u884c", (String)"OriginalBillImportPlugin_162", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                }
            }
            if (new BigDecimal(amount).compareTo(BigDecimal.ZERO) >= 0) {
                ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("rowtype"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e0", (String)"OriginalBillImportPlugin_163", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (new BigDecimal(preItemAmount).compareTo(BigDecimal.ZERO) <= 0) {
                ExcelHelper.setErrorMessage((Row)((Row)item.get("row")), (FileField)fieldMap.get("rowtype"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u4e0a\u4e00\u884c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (String)"OriginalBillImportPlugin_164", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (!preTaxRate.equals(taxRate)) {
                ExcelHelper.setErrorMessage((Row)((Row)item.get("row")), (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"\u6298\u6263\u884c\u5e94\u4e0e\u88ab\u6298\u6263\u884c\u7a0e\u7387\u4e00\u81f4", (String)"OriginalBillImportPlugin_165", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            item.put("policycontants", preItem.get("policycontants"));
            item.put("policylogo", preItem.get("policylogo"));
            item.put("goodsname", preItem.get("goodsname"));
            item.put("goodscode", preItem.get("goodscode"));
            item.put("goodssimplename", preItem.get("goodssimplename"));
            item.put("origoodsname", preItem.get("origoodsname"));
        }
    }

    private void checkDeduction(Map<String, Object> originalBill, Map.Entry<String, List<Map<String, Object>>> entry, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        BigDecimal deduction;
        String amountStr;
        List<Map<String, Object>> list = entry.getValue();
        Map<String, Object> firstRow = list.get(0);
        String invoiceType = (String)originalBill.get("invoicetype");
        String taxAtionstyle = (String)originalBill.get("taxationstyle");
        Object isElePaper = originalBill.get("iselepaper");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            if (StringUtils.isBlank((CharSequence)taxAtionstyle)) {
                taxAtionstyle = TaxedTypeEnum.normal.getValue();
            }
        } else {
            taxAtionstyle = StringUtils.isNotBlank((Object)firstRow.get("deduction")) ? TaxedTypeEnum.deduction.getValue() : TaxedTypeEnum.normal.getValue();
            originalBill.put("taxationstyle", taxAtionstyle);
        }
        if (TaxedTypeEnum.normal.getValue().equals(taxAtionstyle) || TaxedTypeEnum.all_e_reduced_tax.getValue().equals(taxAtionstyle)) {
            return;
        }
        if (list.stream().filter(o -> "2".equals(o.get("rowtype")) || "3".equals(o.get("rowtype"))).count() > 1L) {
            ExcelHelper.setErrorMessage((Row)((Row)list.get(0).get("row")), (FileField)fieldMap.get("deduction"), (String)ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u884c\u5546\u54c1\u884c", (String)"OriginalBillImportPlugin_166", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return;
        }
        if (list.stream().anyMatch(o -> "0".equals(o.get("rowtype")))) {
            for (Map<String, Object> item : list) {
                String rowType = (String)item.get("rowtype");
                if (!"0".equals(rowType)) continue;
                ExcelHelper.setErrorMessage((Row)((Row)item.get("row")), (FileField)fieldMap.get("deduction"), (String)ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u4e0d\u5141\u8bb8\u6709\u6574\u5355\u6298\u6263\u884c", (String)"OriginalBillImportPlugin_167", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                return;
            }
        }
        if (StringUtils.isBlank((CharSequence)(amountStr = (String)firstRow.get("amount")))) {
            return;
        }
        try {
            deduction = new BigDecimal((String)firstRow.get("deduction"));
            if (deduction.compareTo(BigDecimal.ZERO) == 0 && !TaxedTypeEnum.all_e_deduction_full.getValue().equals(taxAtionstyle)) {
                ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("deduction"), (String)ResManager.loadKDString((String)"\u6263\u9664\u989d\u4e0d\u80fd\u4e3a0", (String)"OriginalBillImportPlugin_168", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                return;
            }
        }
        catch (Exception e) {
            deduction = BigDecimal.ZERO;
            firstRow.put("deduction", "0");
        }
        BigDecimal amount = new BigDecimal(amountStr);
        if (amount.compareTo(BigDecimal.ZERO) > 0 && deduction.compareTo(BigDecimal.ZERO) < 0) {
            ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("deduction"), (String)ResManager.loadKDString((String)"\u6b63\u6570\u5355\u636e\uff0c\u6263\u9664\u989d\u9700\u8981\u5927\u4e8e0", (String)"OriginalBillImportPlugin_169", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else if (amount.compareTo(BigDecimal.ZERO) < 0 && deduction.compareTo(BigDecimal.ZERO) != 0) {
            ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("deduction"), (String)ResManager.loadKDString((String)"\u8d1f\u6570\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u6709\u6263\u9664\u989d", (String)"OriginalBillImportPlugin_170", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (amount.abs().compareTo(deduction.abs()) < 0) {
            ExcelHelper.setErrorMessage((Row)((Row)firstRow.get("row")), (FileField)fieldMap.get("deduction"), (String)ResManager.loadKDString((String)"\u6263\u9664\u989d\u4e0d\u80fd\u5927\u4e8e\u660e\u7ec6\u91d1\u989d", (String)"OriginalBillImportPlugin_171", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
    }

    private boolean checkPriceNum(Map<String, Object> item, Map<String, FileField> fieldMap, Map<String, String> errMap, boolean isAllEle) {
        boolean flag = true;
        Row row = (Row)item.get("row");
        String hsbz = (String)item.get("hsbz");
        String unitPrice = (String)item.get("unitprice");
        if (!BigDecimalUtil.isNumber((String)unitPrice)) {
            unitPrice = "";
            item.put("unitprice", "");
        } else {
            int maxLen = PriceHelper.getMaxPriceAllLen((boolean)isAllEle);
            if (unitPrice.replace("-", "").length() > maxLen) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)String.format(ResManager.loadKDString((String)"\u5355\u4ef7\u6700\u591a%s\u4f4d\u6570(\u5305\u542b\u5c0f\u6570\u70b9)", (String)"OriginalBillImportPlugin_172", (String)"imc-sim-formplugin", (Object[])new Object[0]), maxLen), errMap);
            } else {
                try {
                    unitPrice = PriceHelper.getStrValue((String)unitPrice, (String)"\u5355\u4ef7", (boolean)isAllEle);
                }
                catch (KDBizException e) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)e.getMessage(), errMap);
                }
            }
        }
        String num = (String)item.get("num");
        if (!BigDecimalUtil.isNumber((String)num)) {
            num = "";
            item.put("num", "");
        } else if (num.replace("-", "").length() > 16) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("num"), (String)ResManager.loadKDString((String)"\u6570\u91cf\u6700\u591a16\u4f4d\u6570(\u5305\u542b\u5c0f\u6570\u70b9)", (String)"OriginalBillImportPlugin_174", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else {
            try {
                num = UnitPriceHelper.getNumStrValue((String)num, (String)"\u6570\u91cf");
            }
            catch (KDBizException e) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("num"), (String)e.getMessage(), errMap);
            }
        }
        String amount = (String)item.get("amount");
        if (StringUtils.isNotBlank((CharSequence)amount)) {
            amount = new BigDecimal(amount).setScale(2, 4).toString();
            item.put("amount", amount);
        }
        String deduction = (String)item.get("deduction");
        String taxRate = (String)item.get("taxrate");
        String tax = (String)item.get("tax");
        if (StringUtils.isNotBlank((CharSequence)tax)) {
            tax = new BigDecimal(tax).setScale(2, 4).toString();
            item.put("tax", tax);
        }
        if (StringUtils.isBlank((CharSequence)taxRate)) {
            flag = false;
        } else if (StringUtils.isNotBlank((CharSequence)amount)) {
            if (StringUtils.isBlank((CharSequence)tax)) {
                tax = this.calcTax(taxRate, hsbz, amount, deduction).toPlainString();
                tax = this.getTaxByReducedAllE(item, new BigDecimal(tax)).toPlainString();
                item.put("tax", tax);
            } else {
                BigDecimal calcTax = this.calcTax(taxRate, "0", "0".equals(hsbz) ? amount : new BigDecimal(amount).subtract(new BigDecimal(tax)).toString(), deduction);
                BigDecimal wc = (calcTax = this.getTaxByReducedAllE(item, calcTax)).subtract(new BigDecimal(tax)).abs();
                if (wc.compareTo(InvoiceConstant.DIFFF_06) > 0) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u91d1\u989d\u4e58\u4ee5\u7a0e\u7387\u4e0e\u7a0e\u989d\u7684\u8bef\u5dee\u8d85\u8fc7\u9650\u52360.06", (String)"OriginalBillImportPlugin_176", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
        }
        item.put("oriunitprice", unitPrice);
        if (flag && StringUtils.isNotBlank((CharSequence)amount)) {
            if (StringUtils.isNotBlank((CharSequence)unitPrice) && StringUtils.isNotBlank((CharSequence)num)) {
                BigDecimal calcAmount = new BigDecimal(unitPrice).multiply(new BigDecimal(num)).setScale(2, 4);
                if (calcAmount.subtract(new BigDecimal(amount)).abs().compareTo(InvoiceConstant.DIFF_01) > 0) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u5355\u4ef7\u6570\u91cf\u91d1\u989d\u8bef\u5dee\u5927\u4e8e0.01", (String)"OriginalBillImportPlugin_177", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                } else {
                    this.fillInPrice(amount, tax, hsbz, num, unitPrice, item, isAllEle);
                }
            } else if (StringUtils.isNotBlank((CharSequence)unitPrice) && StringUtils.isBlank((CharSequence)num)) {
                try {
                    num = UnitPriceHelper.calcNum((BigDecimal)new BigDecimal(amount), (BigDecimal)new BigDecimal(unitPrice)).toPlainString();
                }
                catch (KDBizException e) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("num"), (String)e.getMessage(), errMap);
                }
                item.put("num", num);
                this.fillInPrice(amount, tax, hsbz, num, unitPrice, item, isAllEle);
            } else if (StringUtils.isBlank((CharSequence)unitPrice) && StringUtils.isNotBlank((CharSequence)num)) {
                try {
                    unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)new BigDecimal(amount), (BigDecimal)new BigDecimal(num), (boolean)isAllEle).toPlainString();
                }
                catch (KDBizException e) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)e.getMessage(), errMap);
                }
                this.fillInPrice(amount, tax, hsbz, num, unitPrice, item, isAllEle);
                item.put("oriunitprice", "0".equals(hsbz) ? item.get("unitprice") : item.get("taxunitprice"));
            } else if (StringUtils.isNotBlank((CharSequence)amount) && StringUtils.isNotBlank((CharSequence)tax)) {
                String taxAmount = "0".equals(hsbz) ? new BigDecimal(amount).add(new BigDecimal(tax)).setScale(2, 4).toPlainString() : amount;
                amount = "1".equals(hsbz) ? new BigDecimal(amount).subtract(new BigDecimal(tax)).setScale(2, 4).toPlainString() : amount;
                item.put("taxamount", taxAmount);
                item.put("amount", amount);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)unitPrice) && new BigDecimal(unitPrice).compareTo(BigDecimal.ZERO) < 0) {
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"OriginalBillImportPlugin_178", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        return flag;
    }

    private BigDecimal getTaxByReducedAllE(Map<String, Object> item, BigDecimal calcTax) {
        if (InvoiceUtils.isAllEInvoice((Object)item.get("invoicetype")) && new BigDecimal("0.015").compareTo(new BigDecimal(String.valueOf(item.get("taxrate")))) == 0 && ZzstsglEnum.TEN.getDescription().equals(item.get("policycontants"))) {
            calcTax = "0".equals(item.get("hsbz")) ? ReduceOnePoint5Helper.getTaxAmountBHS((BigDecimal)new BigDecimal((String)item.get("amount")), (BigDecimal)new BigDecimal((String)item.get("taxrate")), (String)((String)item.get("goodscode"))) : ReduceOnePoint5Helper.getTaxAmountHS((BigDecimal)new BigDecimal((String)item.get("amount")), (BigDecimal)new BigDecimal((String)item.get("taxrate")), (String)((String)item.get("goodscode")));
        }
        return calcTax;
    }

    private void fillInPrice(String amountStr, String tax, String hsbz, String num, String unitPrice, Map<String, Object> item, boolean isAllEle) {
        if ("0".equals(hsbz)) {
            BigDecimal taxAmount = new BigDecimal(amountStr).add(new BigDecimal(tax));
            item.put("taxamount", taxAmount.toPlainString());
            item.put("amount", amountStr);
            item.put("unitprice", unitPrice);
            BigDecimal numBig = new BigDecimal(num);
            String taxRate = (String)item.get("taxrate");
            if (!StringUtils.isBlank((CharSequence)unitPrice)) {
                BigDecimal taxUnitPriceByBHS = PriceHelper.getTaxUnitPriceByBHS((BigDecimal)new BigDecimal(taxRate), (BigDecimal)numBig, (BigDecimal)taxAmount, (BigDecimal)new BigDecimal(unitPrice), (boolean)isAllEle);
                item.put("taxunitprice", taxUnitPriceByBHS.toPlainString());
            }
        } else {
            BigDecimal amount = new BigDecimal(amountStr).subtract(new BigDecimal(tax));
            item.put("taxamount", amountStr);
            item.put("amount", amount.toPlainString());
            item.put("taxunitprice", unitPrice);
            BigDecimal numBig = new BigDecimal(num);
            String taxRate = (String)item.get("taxrate");
            if (!StringUtils.isBlank((CharSequence)unitPrice)) {
                BigDecimal unitPriceByHS = PriceHelper.getUnitPriceByHS((BigDecimal)new BigDecimal(taxRate), (BigDecimal)numBig, (BigDecimal)amount, (BigDecimal)new BigDecimal(unitPrice), (boolean)isAllEle);
                item.put("unitprice", unitPriceByHS.toPlainString());
            }
        }
    }

    private BigDecimal calcTax(String taxRateStr, String hsbz, String amountStr, String deductionStr) {
        BigDecimal taxRate = new BigDecimal(taxRateStr);
        BigDecimal amount = new BigDecimal(amountStr).subtract(StringUtils.isBlank((CharSequence)deductionStr) ? BigDecimal.ZERO : new BigDecimal(deductionStr));
        BigDecimal tax = "0".equals(hsbz) ? amount.multiply(taxRate).divide("0.015".equals(taxRateStr) ? new BigDecimal("1.035") : BigDecimal.ONE, 2, 4) : amount.multiply(taxRate).divide(BigDecimal.ONE.add("0.015".equals(taxRateStr) ? new BigDecimal("0.05") : taxRate), 2, 4);
        return tax;
    }

    private boolean checkTaxpremarkAndTaxRate(Map<String, Object> itemMap, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        boolean flag = true;
        Row row = (Row)itemMap.get("row");
        String taxRate = (String)itemMap.get("taxrate");
        String invoiceType = (String)itemMap.get("invoicetype");
        String zzstsgl = (String)itemMap.get("policycontants");
        String taxpremark = (String)itemMap.get("policylogo");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && "0.015".equals(taxRate) && ("0".equals(taxpremark) || !ZzstsglEnum.TEN.getDescription().equals(zzstsgl))) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a\u51cf\u63091.5,\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u4e3a\u4eab\u53d7,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5fc5\u987b\u4e3a\u63095%%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%%\u8ba1\u5f81", (String)"OriginalBillImportPlugin_321", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (StringUtils.isBlank((CharSequence)taxRate)) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_179", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else if (BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) == 0) {
            if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"0\u7a0e\u7387\u4e0d\u5141\u8bb8\u5f00\u4e13\u7968", (String)"OriginalBillImportPlugin_180", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if ("0".equals(taxpremark)) {
                zzstsgl = "\u666e\u901a\u96f6\u7a0e\u7387";
                itemMap.put("policycontants", "\u666e\u901a\u96f6\u7a0e\u7387");
            } else if (!("\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl) || "\u51fa\u53e3\u9000\u7a0e".equals(zzstsgl))) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u7387\u4e3a\u96f6, \u4eab\u53d7\u4f18\u60e0\u5185\u5bb9\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u4e3a[\u51fa\u53e3\u9000\u7a0e\uff0c\u514d\u7a0e\uff0c\u4e0d\u5f81\u7a0e]\u4e2d\u7684\u4e00\u79cd", (String)"OriginalBillImportPlugin_185", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        } else if ("1".equals(taxpremark) && ("\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl) || "\u51fa\u53e3\u9000\u7a0e".equals(zzstsgl))) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u4eab\u53d7\u4f18\u60e0\u5185\u5bb9\u4e0d\u5408\u6cd5", (String)"OriginalBillImportPlugin_186", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if ("1".equals(taxpremark)) {
            if (StringUtils.isBlank((CharSequence)zzstsgl)) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_187", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        } else if (StringUtils.isBlank((CharSequence)taxRate) || BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) != 0) {
            itemMap.put("policycontants", "");
        }
        return flag;
    }

    private void checkOrigianlBillMain(Map<String, String> errMap, Map<String, Object> originalBill, Map<String, FileField> fieldMap) {
        String buyerEmail;
        String buyerPhone;
        String buyerTaxNo;
        this.checkNull(errMap, originalBill, fieldMap.get("buyername"));
        String invoiceType = (String)originalBill.get("invoicetype");
        Object isElePaper = originalBill.get("iselepaper");
        String buyerProperty = (String)originalBill.get("buyerproperty");
        if ("0".equals(buyerProperty)) {
            buyerTaxNo = (String)originalBill.get("buyertaxno");
            if (StringUtils.isNotBlank((CharSequence)buyerTaxNo)) {
                this.checkTaxNo(errMap, originalBill, fieldMap.get("buyertaxno"), true);
                if (!RegexUtil.isNsrsbh((String)buyerTaxNo, (boolean)true)) {
                    ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("buyertaxno"), (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"OriginalBillImportPlugin_188", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            } else if (!InvoiceUtils.isCommonInvoice((String)invoiceType)) {
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("buyertaxno"), (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_189", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        } else if ("1".equals(buyerProperty)) {
            if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("buyerproperty"), (String)ResManager.loadKDString((String)"\u4e2a\u4eba\u4e0d\u5141\u8bb8\u5f00\u4e13\u7968", (String)"OriginalBillImportPlugin_190", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (StringUtils.isNotBlank((CharSequence)(buyerTaxNo = (String)originalBill.get("buyertaxno"))) && !RegexUtil.isNsrsbh((String)((String)originalBill.get("buyertaxno")), (boolean)true)) {
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("buyertaxno"), (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"OriginalBillImportPlugin_191", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
        if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
            this.checkNull(errMap, originalBill, fieldMap.get("buyerbank"));
            this.checkNull(errMap, originalBill, fieldMap.get("buyeraddr"));
        }
        if (!InvoiceUtils.isAllEInvoice((Object)invoiceType) && !AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            this.checkNull(errMap, originalBill, fieldMap.get("salerbank"));
            this.checkNull(errMap, originalBill, fieldMap.get("saleraddr"));
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerPhone = (String)originalBill.get("buyerphone"))) && !StringUtils.isPhoneNumberValid((String)buyerPhone) && MsgAuthSettingCacheHelper.isCheckPhone((long)RequestContext.get().getOrgId())) {
            ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("buyerphone"), (String)ResManager.loadKDString((String)"\u4ea4\u4ed8\u624b\u673a\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u624b\u673a\u683c\u5f0f", (String)"OriginalBillImportPlugin_192", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (StringUtils.isNotBlank((CharSequence)(buyerEmail = (String)originalBill.get("buyeremail")))) {
            String[] strArr = buyerEmail.split(";");
            if (strArr.length > 10) {
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("buyeremail"), (String)ResManager.loadKDString((String)"'\u4ea4\u4ed8\u90ae\u7bb1'\u4e0d\u80fd\u8d85\u8fc710\u4e2a", (String)"OriginalBillImportPlugin_193", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                for (String str : strArr) {
                    if (StringUtils.isEmail((String)str)) continue;
                    ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("buyeremail"), (String)ResManager.loadKDString((String)"'\u4ea4\u4ed8\u90ae\u7bb1'\u683c\u5f0f\u9519\u8bef", (String)"OriginalBillImportPlugin_194", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    break;
                }
            }
        }
    }

    private boolean checkAllEleSpecialType(Map<String, String> errMap, Map<String, Object> originalBill, DynamicObject billObject, Map<String, FileField> extraFieldMap, Map<String, FileField> fieldMap, List<Map<String, Object>> itemList) {
        String simpleAddress;
        String invoiceType = (String)originalBill.get("invoicetype");
        String specialType = (String)originalBill.get("specialtype");
        Object isElePaper = originalBill.get("iselepaper");
        if (!InvoiceUtils.isAllEInvoice((Object)invoiceType) && !AllEleAuthHelper.isElePaper((Object)isElePaper)) {
            if (InvoiceSpecialType.allEleSpecialType((String)specialType)) {
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("specialtype"), (String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u79cd\u7c7b\u4e3a\u3010%1$s\u3011,\u4e0d\u652f\u6301\u6570\u7535\u7684\u7279\u6b8a\u7968\u79cd\u3010%2$s\u3011", (String)"OriginalBillImportPlugin_260", (String)"imc-sim-formplugin", (Object[])new Object[0]), InvoiceType.getDescription((String)invoiceType), InvoiceSpecialType.InvoiceSpecialTypeEnum.getDescriptionByCode((String)specialType)), errMap);
                return false;
            }
            return true;
        }
        if (!InvoiceSpecialType.allEleSpecialType((String)specialType)) {
            return true;
        }
        Row row = (Row)originalBill.get("extra_row");
        boolean checkFlag = true;
        if (row == null) {
            ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("billno"), (String)ResManager.loadKDString((String)"\u8868\u201c2-\u7279\u5b9a\u4e1a\u52a1\u4fe1\u606f\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u5f00\u7968\u7533\u8bf7\u7f16\u53f7", (String)"OriginalBillImportPlugin_268", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            checkFlag = false;
            return checkFlag;
        }
        if (!((Boolean)originalBill.get("flag")).booleanValue()) {
            checkFlag = false;
        }
        if (StringUtils.isNotBlank((CharSequence)(simpleAddress = (String)originalBill.get("simpleaddress")))) {
            DynamicObject adminDivision = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_admindivision", (QFilter[])new QFilter("name", "=", (Object)simpleAddress).toArray());
            if (adminDivision == null) {
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("simpleaddress_" + specialType), (String)String.format(ResManager.loadKDString((String)"%s\u4e0d\u6b63\u786e", (String)"OriginalBillImportPlugin_196", (String)"imc-sim-formplugin", (Object[])new Object[0]), "E03".equals(specialType) ? ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730", (String)"OriginalBillImportPlugin_197", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u5730\u5740", (String)"OriginalBillImportPlugin_198", (String)"imc-sim-formplugin", (Object[])new Object[0])), errMap);
                originalBill.put("simpleaddress", "error");
                checkFlag = false;
            } else {
                billObject.set("simpleaddress", adminDivision.getPkValue());
            }
        }
        switch (specialType) {
            case "E03": {
                if (this.checkAllEleBuildType(specialType, row, originalBill, extraFieldMap, errMap)) break;
                checkFlag = false;
                break;
            }
            case "E06": {
                if (this.checkAllEleEstateSaleType(billObject, specialType, originalBill, extraFieldMap, errMap, fieldMap)) break;
                checkFlag = false;
                break;
            }
            case "E05": {
                if (this.checkAllEleEstateSaleType(billObject, specialType, originalBill, extraFieldMap, errMap, fieldMap)) break;
                checkFlag = false;
                break;
            }
            case "E04": {
                if (this.checkAllEleFreight(row, originalBill, extraFieldMap, errMap, fieldMap)) break;
                checkFlag = false;
                break;
            }
            case "E01": {
                if (this.checkAllEleOil(originalBill, fieldMap, errMap)) break;
                checkFlag = false;
                break;
            }
            case "E18": {
                if (this.checkAllEleTobacco(originalBill, fieldMap, errMap, itemList)) break;
                checkFlag = false;
                break;
            }
            case "E12": {
                if (this.checkFarmProduceSale(originalBill, fieldMap, errMap, itemList)) break;
                checkFlag = false;
                break;
            }
            case "E09": {
                boolean flag = this.checkTravelerIsAllNull(originalBill);
                if (flag) {
                    checkFlag = true;
                    break;
                }
                if (this.checkAllEleTraveler(row, originalBill, billObject, extraFieldMap, errMap, fieldMap)) break;
                checkFlag = false;
                break;
            }
            case "E07": {
                if (!this.checkAllEleVesselVehiche(row, originalBill, billObject, extraFieldMap, errMap, fieldMap)) {
                    checkFlag = false;
                }
                if (!checkFlag) break;
                this.setVesselVehicheShipPeriodDateMethod(originalBill, billObject);
            }
        }
        if (InvoiceSpecialType.allEleSpecialOneRow((String)specialType) && billObject.getDynamicObjectCollection("sim_original_bill_item").stream().filter(item -> "2".equals(item.getString("rowtype"))).count() > 1L) {
            checkFlag = false;
            ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("specialtype"), (String)String.format(ResManager.loadKDString((String)"%s\u53ea\u5141\u8bb8\u6709\u4e00\u884c\u5546\u54c1\u884c", (String)"OriginalBillImportPlugin_199", (String)"imc-sim-formplugin", (Object[])new Object[0]), InvoiceSpecialType.InvoiceSpecialTypeEnum.getDescriptionByCode((String)specialType)), errMap);
        }
        return checkFlag;
    }

    private void setVesselVehicheShipPeriodDateMethod(Map<String, Object> originalBill, DynamicObject billObject) {
        List vesselVehicheShipList = (List)originalBill.get("vehichevesselships");
        DynamicObjectCollection dynamicObjectCollection = billObject.getDynamicObjectCollection("vehichevesselships");
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            Map vesselShipMap = (Map)vesselVehicheShipList.get(i);
            String periodDate = vesselShipMap.get("periodstartdate") + " " + vesselShipMap.get("periodenddate");
            dynamicObject.set("perioddate", (Object)periodDate);
        }
    }

    private boolean checkAllEleVesselVehiche(Row row, Map<String, Object> originalBillMap, DynamicObject originalBillObject, Map<String, FileField> extraFieldMap, Map<String, String> errMap, Map<String, FileField> fieldMap) {
        boolean checkFlag = true;
        List vesselVehicheShipList = (List)originalBillMap.get("vehichevesselships");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)vesselVehicheShipList)) {
            checkFlag = false;
            String errorMsg = ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u660e\u7ec6\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!", (String)"BillValidaterHelper_134", (String)"imc-sim-service", (Object[])new Object[0]);
            ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("billno"), (String)errorMsg, errMap);
        } else {
            int count;
            String invoiceType = originalBillObject.getString("invoicetype");
            if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                checkFlag = false;
                String errorMsg = ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u7279\u6b8a\u7968\u79cd\u53ea\u5141\u8bb8\u5f00\u5177\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", (String)"BillValidaterHelper_131", (String)"imc-sim-service", (Object[])new Object[0]);
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("billno"), (String)errorMsg, errMap);
            }
            if ((count = vesselVehicheShipList.size()) > 1) {
                checkFlag = false;
                String errorMsg = ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u5206\u5f55\u6570\u636e\u53ea\u9650\u4e00\u884c", (String)"BillValidaterHelper_130", (String)"imc-sim-service", (Object[])new Object[0]);
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("billno"), (String)errorMsg, errMap);
            }
            DynamicObjectCollection dynamicObjectCollection = originalBillObject.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject itemObject : dynamicObjectCollection) {
                String unit = itemObject.getString("unit");
                String rowtype = itemObject.getString("rowtype");
                if (!"2".equals(rowtype) || "\u8f86".equals(unit)) continue;
                checkFlag = false;
                String errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5546\u54c1\u660e\u7ec6\uff0c\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"BillValidaterHelper_133", (String)"imc-sim-service", (Object[])new Object[0]);
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("billno"), (String)errorMsg, errMap);
            }
        }
        int seq = 1;
        for (Map vesselShipMap : vesselVehicheShipList) {
            if (this.checkMapValueNull(vesselShipMap, "policyno")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("policyno"), (String)ResManager.loadKDString((String)"\u4fdd\u9669\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_288", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String policyNoLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4fdd\u9669\u5355\u53f7\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26", (String)"OriginalBillImportPlugin_289", (String)"imc-sim-formplugin", (Object[])new Object[0]), seq);
                String policyNo = vesselShipMap.get("policyno").toString();
                if (policyNo.length() > 40) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("policyno"), (String)policyNoLenError, errMap);
                }
            }
            if (this.checkMapValueNull(vesselShipMap, "periodstartdate")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("periodstartdate"), (String)ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_304", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String periodStartDate = vesselShipMap.get("periodstartdate").toString();
                boolean flag = InvoiceCheckService.isValidDateFormat((String)periodStartDate);
                if (!flag) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("periodstartdate"), (String)ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u662f\uff1ayyyy-MM", (String)"OriginalBillImportPlugin_306", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
            if (this.checkMapValueNull(vesselShipMap, "periodenddate")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("periodenddate"), (String)ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_305", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String periodEndDate = vesselShipMap.get("periodenddate").toString();
                boolean flag = InvoiceCheckService.isValidDateFormat((String)periodEndDate);
                if (!flag) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("periodstartdate"), (String)ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u662f\uff1ayyyy-MM", (String)"OriginalBillImportPlugin_307", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
            String periodDate = vesselShipMap.get("periodstartdate") + " " + vesselShipMap.get("periodenddate");
            if (StringUtils.isBlank((CharSequence)periodDate)) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("perioddate"), (String)ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_290", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String periodDateLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u662f\uff1ayyyy-MM+\u7a7a\u683c+yyyy-MM", (String)"OriginalBillImportPlugin_291", (String)"imc-sim-formplugin", (Object[])new Object[0]), seq);
                try {
                    InvoiceCheckService.checkFormat((String)periodDate, (String)periodDateLenError);
                }
                catch (MsgException msgException) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("perioddate"), (String)periodDateLenError, errMap);
                }
                String periodDateComparedError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u591f\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"OriginalBillImportPlugin_302", (String)"imc-sim-formplugin", (Object[])new Object[0]), seq);
                try {
                    InvoiceCheckService.checkComparedDate((String)periodDate, (String)periodDateComparedError);
                }
                catch (MsgException msgException) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("perioddate"), (String)periodDateComparedError, errMap);
                }
            }
            if (this.checkMapValueNull(vesselShipMap, "shipsno")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("shipsno"), (String)ResManager.loadKDString((String)"\u8f66\u724c\u53f7\u3001\u8239\u8236\u767b\u8bb0\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_292", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String shipsNoLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26", (String)"OriginalBillImportPlugin_293", (String)"imc-sim-formplugin", (Object[])new Object[0]), seq);
                String shipsNo = vesselShipMap.get("shipsno").toString();
                if (shipsNo.length() > 40) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("shipsno"), (String)shipsNoLenError, errMap);
                }
            }
            if (this.checkMapValueNull(vesselShipMap, "vehiclecode")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehiclecode"), (String)ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u7801\u3001\u8f66\u67b6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_294", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String vehicelCodeLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8f66\u8f86\u8bc6\u522b\u4ee3\u7801/\u8f66\u67b6\u53f7\u7801\u4e0d\u80fd\u8d85\u8fc717\u4e2a\u5b57\u7b26", (String)"OriginalBillImportPlugin_295", (String)"imc-sim-formplugin", (Object[])new Object[0]), seq);
                String vehicelCode = vesselShipMap.get("vehiclecode").toString();
                if (vehicelCode.length() > 17) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehiclecode"), (String)vehicelCodeLenError, errMap);
                }
            }
            if (this.checkMapValueNull(vesselShipMap, "vehiclevesselamount")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehiclevesselamount"), (String)ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_296", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String vehiclevesselamount = vesselShipMap.get("vehiclevesselamount").toString();
                String amountError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ee3\u6536\u8f66\u8239\u7a0e\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceAllESpecialCheckService_115", (String)"imc-sim-common", (Object[])new Object[0]), seq);
                try {
                    this.checkAmountRule(vehiclevesselamount, amountError);
                }
                catch (MsgException msgException) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehiclevesselamount"), (String)amountError, errMap);
                }
                String vehicleVesselAmountLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ee3\u6536\u8f66\u8239\u7a0e\u91d1\u989d\u6574\u6570\u4f4d\u4e0d\u80fd\u591f\u8d85\u8fc713\u4f4d", (String)"OriginalBillImportPlugin_297", (String)"imc-sim-formplugin", (Object[])new Object[0]), seq);
                try {
                    this.checkAmountLength(new BigDecimal(vehiclevesselamount), vehicleVesselAmountLenError, 13);
                }
                catch (MsgException e) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehiclevesselamount"), (String)vehicleVesselAmountLenError, errMap);
                }
            }
            if (this.checkMapValueNull(vesselShipMap, "vehiclelateamount")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehiclelateamount"), (String)ResManager.loadKDString((String)"\u6ede\u7eb3\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_298", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String vehicleLateAmount = vesselShipMap.get("vehiclelateamount").toString();
                String amountError2 = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6ede\u7eb3\u91d1\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceAllESpecialCheckService_116", (String)"imc-sim-common", (Object[])new Object[0]), seq);
                try {
                    this.checkAmountRule(vehicleLateAmount, amountError2);
                }
                catch (MsgException msgException) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehiclelateamount"), (String)amountError2, errMap);
                }
                String vehicleLateAmountLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6ede\u7eb3\u91d1\u91d1\u989d\u6574\u6570\u4f4d\u4e0d\u80fd\u591f\u8d85\u8fc713\u4f4d", (String)"OriginalBillImportPlugin_299", (String)"imc-sim-formplugin", (Object[])new Object[0]), seq);
                try {
                    this.checkAmountLength(new BigDecimal(vehicleLateAmount), vehicleLateAmountLenError, 13);
                }
                catch (MsgException e) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehiclelateamount"), (String)vehicleLateAmountLenError, errMap);
                }
            }
            if (this.checkMapValueNull(vesselShipMap, "vehicletotalamount")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehicletotalamount"), (String)ResManager.loadKDString((String)"\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_300", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                continue;
            }
            String toalAmount = vesselShipMap.get("vehicletotalamount").toString();
            String amountError3 = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5408\u8ba1\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceAllESpecialCheckService_117", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            try {
                this.checkAmountRule(toalAmount, amountError3);
            }
            catch (MsgException msgException) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehicletotalamount"), (String)amountError3, errMap);
            }
            String totalAmountLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5408\u8ba1\u91d1\u989d\u6570\u4f4d\u4e0d\u80fd\u591f\u8d85\u8fc713\u4f4d", (String)"OriginalBillImportPlugin_301", (String)"imc-sim-formplugin", (Object[])new Object[0]), seq);
            try {
                this.checkAmountLength(new BigDecimal(toalAmount), totalAmountLenError, 13);
            }
            catch (MsgException e) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("vehicletotalamount"), (String)totalAmountLenError, errMap);
            }
        }
        return checkFlag;
    }

    private boolean checkTravelerIsAllNull(Map<String, Object> originalBillMap) {
        List travelerList = (List)originalBillMap.get("travelers");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)travelerList)) {
            int num = 0;
            for (Map travelerMap : travelerList) {
                Object traveler = travelerMap.get("traveler");
                Object cardType = travelerMap.get("travelercardtype");
                Object cardNo = travelerMap.get("travelercardno");
                Object travelDate = travelerMap.get("traveldate");
                Object startPlace = travelerMap.get("travelerstartplace");
                Object endPlace = travelerMap.get("travelerendplace");
                Object transportType = travelerMap.get("travelertransporttype");
                Object seatClass = travelerMap.get("travelerseatclass");
                Object[] objects = new Object[]{traveler, cardType, cardNo, travelDate, startPlace, endPlace, transportType, seatClass};
                int count = 0;
                for (Object object : objects) {
                    if (!StringUtils.isBlank((Object)object)) continue;
                    ++count;
                }
                if (objects.length != count) continue;
                ++num;
            }
            return travelerList.size() == num && num > 0;
        }
        return false;
    }

    private boolean checkAllEleTraveler(Row row, Map<String, Object> originalBillMap, DynamicObject billObject, Map<String, FileField> extraFieldMap, Map<String, String> errMap, Map<String, FileField> fieldMap) {
        boolean checkFlag = true;
        List travelerList = (List)originalBillMap.get("travelers");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)travelerList)) {
            checkFlag = false;
        } else {
            DynamicObjectCollection itemObjectCollection = billObject.getDynamicObjectCollection("sim_original_bill_item");
            int count = BillValidaterHelper.countItemNumMethod((DynamicObjectCollection)itemObjectCollection, null);
            if (count > 1) {
                checkFlag = false;
                String errorMsg = ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u53ea\u652f\u6301\u4e00\u884c\u5546\u54c1\u660e\u7ec6", (String)"BillValidaterHelper_129", (String)"imc-sim-service", (Object[])new Object[0]);
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("billno"), (String)errorMsg, errMap);
            }
        }
        for (Map travelerMap : travelerList) {
            if (this.checkMapValueNull(travelerMap, "traveler")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("traveler"), (String)ResManager.loadKDString((String)"\u51fa\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_269", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(travelerMap, "travelercardtype")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("travelercardtype"), (String)ResManager.loadKDString((String)"\u51fa\u884c\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_270", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(travelerMap, "travelercardno")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("travelercardno"), (String)ResManager.loadKDString((String)"\u51fa\u884c\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_271", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(travelerMap, "traveldate")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("traveldate"), (String)ResManager.loadKDString((String)"\u51fa\u884c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_272", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(travelerMap, "travelerstartplace")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("travelerstartplace"), (String)ResManager.loadKDString((String)"\u51fa\u53d1\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_273", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(travelerMap, "travelerendplace")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("travelerendplace"), (String)ResManager.loadKDString((String)"\u5230\u8fbe\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_211", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(travelerMap, "travelertransporttype")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("travelertransporttype"), (String)ResManager.loadKDString((String)"\u4ea4\u901a\u5de5\u5177\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_274", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                continue;
            }
            String transportType = (String)travelerMap.get("travelertransporttype");
            List list = TransportTypeEnum.getTransportDescList();
            if (!list.contains(transportType)) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("travelertransporttype"), (String)ResManager.loadKDString((String)"\u4ea4\u901a\u5de5\u5177\u7c7b\u578b\u5e94\u8be5\u662f\u98de\u673a\u3001\u706b\u8f66\u3001\u957f\u9014\u6c7d\u8f66\u3001\u516c\u5171\u4ea4\u901a\u3001\u51fa\u79df\u8f66\u3001\u6c7d\u8f66\u3001\u8239\u8236\u3001\u5176\u4ed6\u4e2d\u7684\u4e00\u79cd", (String)"OriginalBillImportPlugin_275", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (!TransportTypeEnum.FLIGHT.getDesc().equals(transportType) && !TransportTypeEnum.TRAIN.getDesc().equals(transportType) && !TransportTypeEnum.SHIP.getDesc().equals(transportType)) continue;
            if (this.checkMapValueNull(travelerMap, "travelerseatclass")) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("travelerseatclass"), (String)ResManager.loadKDString((String)"\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_276", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                continue;
            }
            String seatClass = (String)travelerMap.get("travelerseatclass");
            List seatClassList = SeatClassTypeEnum.getSeatClassNameByDesc((String)transportType);
            if (seatClassList.contains(seatClass)) continue;
            checkFlag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("travelerseatclass"), (String)ResManager.loadKDString((String)"\u4ea4\u901a\u5de5\u5177\u7c7b\u4e0e\u5ea7\u4f4d\u7b49\u7ea7\u4e24\u8005\u4e0d\u5339\u914d", (String)"OriginalBillImportPlugin_277", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (checkFlag) {
            this.dealFormatTravelerDataMethod(billObject);
        }
        return checkFlag;
    }

    private void dealFormatTravelerDataMethod(DynamicObject billObject) {
        DynamicObjectCollection travelerCollection = billObject.getDynamicObjectCollection("travelers");
        for (DynamicObject travelerObject : travelerCollection) {
            String travelerCardType = travelerObject.getString("travelercardtype");
            travelerObject.set("travelercardtype", (Object)TravelerCardTypeEnum.getCodeByDesc((String)travelerCardType));
            String transportType = travelerObject.getString("travelertransporttype");
            travelerObject.set("travelertransporttype", (Object)TransportTypeEnum.getCodeByDesc((String)transportType));
        }
    }

    private boolean checkFarmProduceSale(Map<String, Object> originalBill, Map<String, FileField> fieldMap, Map<String, String> errMap, List<Map<String, Object>> itemList) {
        String invoiceType = (String)originalBill.get("invoicetype");
        boolean isSuccess = true;
        if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            isSuccess = false;
            Row invoiceRow = (Row)originalBill.get("row");
            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("invoicetype"), (String)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u81ea\u4ea7\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968", (String)"OriginalBillImportPlugin_309", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (itemList != null && !itemList.isEmpty()) {
            for (Map<String, Object> originalItemMap : itemList) {
                Row row = (Row)originalItemMap.get("row");
                BigDecimal taxRateDecimalValue = BigDecimal.TEN;
                try {
                    taxRateDecimalValue = new BigDecimal((String)originalItemMap.get("taxrate"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String policyLogo = (String)originalItemMap.get("policylogo");
                String policyContant = (String)originalItemMap.get("policycontants");
                if (!"1".equals(policyLogo)) {
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policylogo"), (String)ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u5fc5\u987b\u4e3a\uff1a\u4eab\u53d7", (String)"OriginalBillImportPlugin_310", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    isSuccess = false;
                }
                if (!"\u514d\u7a0e".equals(policyContant)) {
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("policycontants"), (String)ResManager.loadKDString((String)"\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5fc5\u987b\u4e3a\u514d\u7a0e", (String)"OriginalBillImportPlugin_311", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    isSuccess = false;
                }
                if (taxRateDecimalValue.compareTo(BigDecimal.ZERO) == 0) continue;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u7a0e\u7387\u5fc5\u987b\u4e3a0", (String)"OriginalBillImportPlugin_312", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                isSuccess = false;
            }
        }
        return isSuccess;
    }

    private boolean checkAllEleTobacco(Map<String, Object> originalBill, Map<String, FileField> fieldMap, Map<String, String> errMap, List<Map<String, Object>> itemList) {
        boolean checkTobacco = true;
        if (itemList != null && !itemList.isEmpty()) {
            for (Map<String, Object> originalItemMap : itemList) {
                String goodsCode = (String)originalItemMap.get("goodscode");
                Row row = (Row)originalItemMap.get("row");
                if (InvoiceUtils.isAllEInvoice((Object)originalItemMap.get("invoicetype").toString()) || !StringUtils.isNotEmpty((CharSequence)goodsCode) || TaxUtils.isTobaccoGoods((String)goodsCode)) continue;
                checkTobacco = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodscode"), (String)ResManager.loadKDString((String)"\u5377\u70df\u53d1\u7968\u4e0d\u80fd\u9009\u62e9\u975e\u5377\u70df\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"OriginalBillImportPlugin_202", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
        return checkTobacco;
    }

    private boolean checkAllEleOil(Map<String, Object> originalBill, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        boolean checkOil = true;
        String xmdw = (String)originalBill.get("unit");
        String rowtype = (String)originalBill.get("rowtype");
        if (!"1".equals(rowtype)) {
            String xmsl;
            if (StringUtils.isEmpty((CharSequence)xmdw) || !Arrays.asList(GoodsInfoConstant.getOilUnit()).contains(xmdw)) {
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("unit"), (String)ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5355\u4f4d\u3002\u6210\u54c1\u6cb9\u53ea\u80fd\u4f7f\u7528\u201c\u5428\u201d\u6216\u201c\u5347\u201d\u4e3a\u5355\u4f4d\uff01", (String)"OriginalBillImportPlugin_206", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                checkOil = false;
            }
            if (StringUtils.isEmpty((CharSequence)(xmsl = (String)originalBill.get("num"))) || 0 == BigDecimal.valueOf(0L).compareTo(new BigDecimal(xmsl))) {
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("num"), (String)ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u6570\u91cf\u3002\u6210\u54c1\u6cb9\u660e\u7ec6\u7684\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u80050", (String)"OriginalBillImportPlugin_207", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                checkOil = false;
            }
        }
        return checkOil;
    }

    private boolean checkAllEleFreight(Row row, Map<String, Object> originalBill, Map<String, FileField> extraFieldMap, Map<String, String> errMap, Map<String, FileField> fieldMap) {
        boolean checkFreight = true;
        List freights = (List)originalBill.get("freights");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)freights)) {
            ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("specialtype"), (String)ResManager.loadKDString((String)"\u7279\u5b9a\u4e1a\u52a1\u7c7b\u578b\u4e3a\u8d27\u7269\u8fd0\u8f93\uff08\u6570\u7535\u7968\uff09-\u7279\u5b9a\u4e1a\u52a1\u4fe1\u606f\u9875-\u8d27\u7269\u8fd0\u8f93\u670d\u52a1\u5fc5\u586b", (String)"OriginalBillImportPlugin_208", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            checkFreight = false;
        }
        for (Map freightItem : freights) {
            if (this.checkMapValueNull(freightItem, "startplace")) {
                checkFreight = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("startplace"), (String)ResManager.loadKDString((String)"\u8d77\u8fd0\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_209", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(freightItem, "endplace")) {
                checkFreight = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("endplace"), (String)ResManager.loadKDString((String)"\u5230\u8fbe\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_211", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(freightItem, "transporttype")) {
                checkFreight = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("transporttype"), (String)ResManager.loadKDString((String)"\u8fd0\u8f93\u5de5\u5177\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_213", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else if (!InvoiceAllESpecialCheckService.transportTypeSet.contains(freightItem.get("transporttype"))) {
                checkFreight = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("transporttype"), (String)ResManager.loadKDString((String)"\u8fd0\u8f93\u5de5\u5177\u79cd\u7c7b\u5e94\u8be5\u662f\u94c1\u8def\u8fd0\u8f93\u3001\u516c\u8def\u8fd0\u8f93\u3001\u6c34\u8def\u8fd0\u8f93\u3001\u822a\u7a7a\u8fd0\u8f93\u3001\u7ba1\u9053\u8fd0\u8f93\u3001\u5176\u5b83\u8fd0\u8f93\u5de5\u5177\u4e2d\u7684\u4e00\u79cd", (String)"OriginalBillImportPlugin_214", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(freightItem, "licenseplate")) {
                checkFreight = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("licenseplate"), (String)ResManager.loadKDString((String)"\u8fd0\u8f93\u5de5\u5177\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_215", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (!this.checkMapValueNull(freightItem, "transportgoods")) continue;
            checkFreight = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("transportgoods"), (String)ResManager.loadKDString((String)"\u8fd0\u8f93\u8d27\u7269\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_217", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        return checkFreight;
    }

    private boolean checkAllEleEstateSaleType(DynamicObject billObject, String specialType, Map<String, Object> originalBill, Map<String, FileField> extraFieldMap, Map<String, String> errMap, Map<String, FileField> fieldMap) {
        boolean checkEstate = true;
        List estatesales = (List)originalBill.get("estatesales");
        String specialTypeStr = InvoiceSpecialType.InvoiceSpecialTypeEnum.getDescriptionByCode((String)specialType);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)estatesales)) {
            checkEstate = false;
            ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("specialtype"), (String)ResManager.loadKDString((String)"\u7279\u5b9a\u4e1a\u52a1\u7c7b\u578b\u4e3a%1$s\uff08\u6570\u7535\u7968\uff09-\u7279\u5b9a\u4e1a\u52a1\u4fe1\u606f\u9875-%1$s\u5fc5\u586b", (String)"OriginalBillImportPlugin_282", (String)"imc-sim-formplugin", (Object[])new Object[]{specialTypeStr}), errMap);
        }
        long itemSize = billObject.getDynamicObjectCollection("sim_original_bill_item").stream().filter(item -> "2".equals(item.getString("rowtype"))).count();
        if ((long)estatesales.size() != itemSize) {
            checkEstate = false;
            ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("specialtype"), (String)ResManager.loadKDString((String)"\u7279\u5b9a\u4e1a\u52a1\u7c7b\u578b\u4e3a%1$s\uff08\u6570\u7535\u7968\uff09-\u7279\u5b9a\u4e1a\u52a1\u4fe1\u606f\u9875-%1$s\u660e\u7ec6\u4e0e\u5546\u54c1\u884c\u660e\u7ec6\u884c\u4e0d\u4e00\u81f4", (String)"OriginalBillImportPlugin_287", (String)"imc-sim-formplugin", (Object[])new Object[]{specialTypeStr}), errMap);
        }
        if ("E05".equals(specialType)) {
            String cobuyerflag = originalBill.get("cobuyerflag") + "";
            List cobuyers = (List)originalBill.get("cobuyers");
            if ("1".equals(cobuyerflag) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)cobuyers)) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("specialtype"), (String)ResManager.loadKDString((String)"\u7279\u5b9a\u4e1a\u52a1\u7c7b\u578b\u4e3a\u4e0d\u52a8\u4ea7\u9500\u552e\uff08\u6570\u7535\u7968\uff09-\u7279\u5b9a\u4e1a\u52a1\u4fe1\u606f\u9875-\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u6807\u5fd7\u4e3a\u662f\u65f6\u5171\u540c\u8d2d\u4e70\u65b9\u4fe1\u606f\u5fc5\u586b", (String)"OriginalBillImportPlugin_283", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if ("1".equals(cobuyerflag) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)cobuyers)) {
                for (int i = 0; i < cobuyers.size(); ++i) {
                    Map cobuyerMap = (Map)cobuyers.get(i);
                    Row extraRow = (Row)cobuyerMap.get("extra_row");
                    if (this.checkMapValueNull(cobuyerMap, "cobuyer")) {
                        checkEstate = false;
                        ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("cobuyer"), (String)ResManager.loadKDString((String)"\u5171\u540c\u8d2d\u4e70\u65b9\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_284", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                    if (this.checkMapValueNull(cobuyerMap, "cobuyercardtype")) {
                        checkEstate = false;
                        ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("cobuyercardtype"), (String)ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_285", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                    if (!this.checkMapValueNull(cobuyerMap, "cobuyercardno")) continue;
                    checkEstate = false;
                    ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("cobuyercardno"), (String)ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_286", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
        }
        for (int i = 0; i < estatesales.size(); ++i) {
            Map estatesaleMap = (Map)estatesales.get(i);
            Row extraRow = (Row)estatesaleMap.get("extra_row");
            if (this.checkMapValueNull(estatesaleMap, "saleprincename")) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("simpleaddress_" + specialType), (String)ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_219", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            String detailAddress = (String)estatesaleMap.get("saledetailaddress");
            if (this.checkMapValueNull(estatesaleMap, "saledetailaddress")) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("detailaddress_" + specialType), (String)ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_220", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else if (!InvoiceAllESpecialCheckService.checkDetailAddress((String)detailAddress)) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("detailaddress_" + specialType), (String)ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740\u5fc5\u987b\u5305\u542b\u201c\u8857\u3001\u8def\u3001\u6751\u3001\u4e61\u3001\u9547\u3001\u9053\u3001\u5df7\u3001\u53f7\u201d\u7b49\u5173\u952e\u8bcd\u4e4b\u4e00", (String)"OriginalBillImportPlugin_227", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (Handle.isNotEmpty((Object)detailAddress) && detailAddress.length() > 80) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("simpleaddress_" + specialType), (String)ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740\u957f\u5ea6\u9650\u5236\u4e3a80\u5b57\u7b26", (String)"OriginalBillImportPlugin_303", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(estatesaleMap, "salecrosscitysign")) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("crosscitysign_" + specialType), (String)ResManager.loadKDString((String)"\u8de8\u5730\u5e02\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_230", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(estatesaleMap, "saleunit")) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("areaunit_" + specialType), (String)ResManager.loadKDString((String)"\u9762\u79ef\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_231", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else {
                String areaUnit = (String)estatesaleMap.get("saleunit");
                if (!InvoiceCheckService.areaUnitSet.contains(areaUnit)) {
                    checkEstate = false;
                    ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("areaunit_" + specialType), (String)ResManager.loadKDString((String)"\u9762\u79ef\u5355\u4f4d\u5e94\u8be5\u5305\u542b\u5e73\u65b9\u7c73\u3001\u4ea9\u3001\u33a1\u3001\u5e73\u65b9\u5343\u7c73\u3001\u516c\u9877\u3001h\u33a1\u3001k\u33a1\u5173\u952e\u8bcd", (String)"OriginalBillImportPlugin_232", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
            if ("E05".equals(specialType)) {
                String actualTurnover;
                String approvedPrice = (String)estatesaleMap.get("assessmenttaxamount");
                if (StringUtils.isNotBlank((CharSequence)approvedPrice) && BigDecimalUtil.isNumber((String)approvedPrice) && new BigDecimal(approvedPrice).compareTo(BigDecimal.ZERO) < 0) {
                    checkEstate = false;
                    ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("approvedprice_" + specialType), (String)ResManager.loadKDString((String)"\u6838\u5b9a\u8ba1\u7a0e\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e0", (String)"OriginalBillImportPlugin_238", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
                if (StringUtils.isNotBlank((CharSequence)(actualTurnover = (String)estatesaleMap.get("actualtotalamount"))) && BigDecimalUtil.isNumber((String)actualTurnover) && new BigDecimal(actualTurnover).compareTo(BigDecimal.ZERO) < 0) {
                    checkEstate = false;
                    ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("actualturnover_" + specialType), (String)ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"OriginalBillImportPlugin_239", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
            }
            if (!"E06".equals(specialType)) continue;
            if (this.checkMapValueNull(estatesaleMap, "saleestateid")) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("estateid_" + specialType), (String)ResManager.loadKDString((String)"\u623f\u5c4b\u4ea7\u6743\u8bc1\u4e66/\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_233", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (this.checkMapValueNull(estatesaleMap, "leasestartdate")) {
                checkEstate = false;
                ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("startleasedate_" + specialType), (String)ResManager.loadKDString((String)"\u79df\u8d41\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_234", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (!this.checkMapValueNull(estatesaleMap, "leaseenddate")) continue;
            checkEstate = false;
            ExcelHelper.setErrorMessage((Row)extraRow, (FileField)extraFieldMap.get("endleasedate_" + specialType), (String)ResManager.loadKDString((String)"\u79df\u8d41\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_235", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        return checkEstate;
    }

    private boolean checkAllEleBuildType(String specialType, Row row, Map<String, Object> originalBill, Map<String, FileField> extraFieldMap, Map<String, String> errMap) {
        String totalAddress;
        boolean checkBuild = true;
        if (this.checkMapValueNull(originalBill, "simpleaddress")) {
            checkBuild = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("simpleaddress_" + specialType), (String)ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_240", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        String detailAddress = (String)originalBill.get("detailaddress");
        if (checkBuild && (totalAddress = originalBill.get("simpleaddress") + (detailAddress == null ? "" : detailAddress)).length() > 120) {
            checkBuild = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("simpleaddress_" + specialType), (String)ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730+\u53d1\u751f\u5730\u8be6\u7ec6\u5730\u5740\u957f\u5ea6\u9650\u5236\u4e3a120\u5b57\u7b26", (String)"OriginalBillImportPlugin_241", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (this.checkMapValueNull(originalBill, "crosscitysign")) {
            checkBuild = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("crosscitysign_" + specialType), (String)ResManager.loadKDString((String)"\u8de8\u5730\u5e02\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_230", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (this.checkMapValueNull(originalBill, "buildingname")) {
            checkBuild = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("buildingname_" + specialType), (String)ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_242", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        return checkBuild;
    }

    private boolean checkAllEleDeduction(Map<String, String> errMap, Map<String, Object> originalBill, DynamicObject bill, Map<String, FileField> extraFieldMap, Map<String, FileField> fieldMap) {
        String taxationStyle = (String)originalBill.get("taxationstyle");
        if (!TaxedTypeEnum.all_e_deduction.getValue().equals(taxationStyle)) {
            return true;
        }
        List deductionList = (List)originalBill.get("deductions");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)deductionList)) {
            ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("taxationstyle"), (String)ResManager.loadKDString((String)"\u5f81\u7a0e\u65b9\u5f0f\u4e3a\u5dee\u989d\u5f81\u7a0e-\u5dee\u989d\u5f00\u7968\uff0c\u5dee\u989d\u660e\u7ec6\u5fc5\u586b", (String)"OriginalBillImportPlugin_244", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return false;
        }
        boolean checkFlag = true;
        HashMap<String, JSONObject> deducInvoiceMap = new HashMap<String, JSONObject>();
        block23: for (Map deductionItem : deductionList) {
            Row row = (Row)deductionItem.get("row");
            if (!((Boolean)deductionItem.get("flag")).booleanValue()) {
                checkFlag = false;
            }
            boolean invoiceExists = false;
            String evidenceType = (String)deductionItem.get("evidencetype");
            if (StringUtils.isBlank((CharSequence)evidenceType)) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("etaxinvoiceno"), (String)ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_267", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                continue;
            }
            switch (evidenceType) {
                case "01": {
                    if (this.checkMapValueNull(deductionItem, "etaxinvoiceno")) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("etaxinvoiceno"), (String)ResManager.loadKDString((String)"\u6570\u7535\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_245", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                        break;
                    }
                    QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)"", (String)((String)deductionItem.get("etaxinvoiceno"))).and("orgid", "=", (Object)RequestContext.get().getOrgId());
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "totalamount", "issuetime"), (QFilter[])qFilter.toArray());
                    if (invoice == null) break;
                    invoiceExists = true;
                    deductionItem.put("orievidenceamount", invoice.getBigDecimal("totalamount"));
                    deductionItem.put("invoicedate", DateUtils.format((Date)invoice.getDate("issuetime")));
                    this.fillInMapValue(deductionItem, "evidenceamount", invoice.getBigDecimal("totalamount").stripTrailingZeros().toPlainString());
                    break;
                }
                case "02": 
                case "03": 
                case "04": {
                    String invoiceCode = (String)deductionItem.get("deductioninvoicecode");
                    String invoiceNo = (String)deductionItem.get("deductioninvoiceno");
                    if (!StringUtils.isNotBlank((CharSequence)invoiceCode) || !StringUtils.isNotBlank((CharSequence)invoiceNo)) break;
                    QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo).and("orgid", "=", (Object)RequestContext.get().getOrgId());
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "totalamount", "issuetime"), (QFilter[])qFilter.toArray());
                    if (invoice == null) break;
                    invoiceExists = true;
                    deductionItem.put("orievidenceamount", invoice.getBigDecimal("totalamount"));
                    deductionItem.put("invoicedate", DateUtils.format((Date)invoice.getDate("issuetime")));
                    this.fillInMapValue(deductionItem, "evidenceamount", invoice.getBigDecimal("totalamount").stripTrailingZeros().toPlainString());
                }
            }
            String evidenceAmountStr = (String)deductionItem.get("evidenceamount");
            BigDecimal evidenceAmount = BigDecimal.ZERO;
            if (StringUtils.isBlank((CharSequence)evidenceAmountStr) || !BigDecimalUtil.isNumber((String)evidenceAmountStr)) {
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("evidenceamount"), (String)ResManager.loadKDString((String)"\u51ed\u8bc1\u5408\u8ba1\u91d1\u989d\u5fc5\u586b", (String)"OriginalBillImportPlugin_246", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                checkFlag = false;
            } else {
                evidenceAmount = new BigDecimal(evidenceAmountStr);
            }
            String deductionAmountStr = (String)deductionItem.get("deductionamount");
            BigDecimal deductionAmount = BigDecimal.ZERO;
            if (StringUtils.isBlank((CharSequence)deductionAmountStr) || !BigDecimalUtil.isNumber((String)deductionAmountStr)) {
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("deductionamount"), (String)ResManager.loadKDString((String)"\u672c\u6b21\u6263\u9664\u91d1\u989d\u5fc5\u586b", (String)"OriginalBillImportPlugin_247", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                checkFlag = false;
            } else {
                deductionAmount = new BigDecimal(deductionAmountStr);
            }
            if (evidenceAmount.compareTo(BigDecimal.ZERO) != 0 && deductionAmount.compareTo(evidenceAmount) > 0) {
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("deductionamount"), (String)ResManager.loadKDString((String)"\u672c\u6b21\u6263\u9664\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u51ed\u8bc1\u5408\u8ba1\u91d1\u989d", (String)"OriginalBillImportPlugin_248", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                checkFlag = false;
            }
            if (StringUtils.isNotBlank((CharSequence)evidenceType)) {
                if (evidenceType.length() != 2 || !evidenceType.startsWith("0")) {
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("evidencetype"), (String)ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b\u9519\u8bef", (String)"OriginalBillImportPlugin_249", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    checkFlag = false;
                } else {
                    String subEvidenceType = evidenceType.replace("0", "");
                    if (subEvidenceType.length() != 1 || !BigDecimalUtil.isNumber((String)subEvidenceType)) {
                        ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("evidencetype"), (String)ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b\u9519\u8bef", (String)"OriginalBillImportPlugin_249", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                        checkFlag = false;
                    }
                }
            }
            switch (evidenceType) {
                case "01": {
                    if (this.checkMapValueNull(deductionItem, "invoicedate")) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("invoicedate"), (String)ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_250", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                    deductionItem.put("deductioninvoicecode", "");
                    deductionItem.put("deductioninvoiceno", "");
                    JSONObject json = this.getJsonObject(deducInvoiceMap, deductionItem, (String)deductionItem.get("etaxinvoiceno"), invoiceExists);
                    if (null == json || !invoiceExists) continue block23;
                    BigDecimal oriInvoiceAmount = json.getBigDecimal("orievidenceamount");
                    if (deductionAmount.abs().compareTo(oriInvoiceAmount.abs()) <= 0) continue block23;
                    throw new MsgException(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\u3001\u53d1\u7968\u53f7\u7801%2$s,\u6263\u9664\u91d1\u989d\u8d85\u8fc7\u53d1\u7968\u91d1\u989d", (String)"OriginalBillImportPlugin_261", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                case "02": 
                case "03": 
                case "04": {
                    if (this.checkMapValueNull(deductionItem, "deductioninvoicecode")) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("deductioninvoicecode"), (String)ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_252", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                    if (this.checkMapValueNull(deductionItem, "deductioninvoiceno")) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("deductioninvoiceno"), (String)ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_253", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                    if (this.checkMapValueNull(deductionItem, "invoicedate")) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("invoicedate"), (String)ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_250", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                    deductionItem.put("etaxinvoiceno", "");
                    JSONObject json = this.getJsonObject(deducInvoiceMap, deductionItem, "" + deductionItem.get("invoicecode") + deductionItem.get("invoiceno"), invoiceExists);
                    if (null == json || !invoiceExists) continue block23;
                    BigDecimal oriInvoiceAmount = json.getBigDecimal("orievidenceamount");
                    if (deductionAmount.abs().compareTo(oriInvoiceAmount.abs()) <= 0) continue block23;
                    throw new MsgException(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\u3001\u53d1\u7968\u53f7\u7801%2$s,\u6263\u9664\u91d1\u989d\u8d85\u8fc7\u53d1\u7968\u91d1\u989d", (String)"OriginalBillImportPlugin_261", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                case "08": 
                case "09": {
                    deductionItem.put("deductioninvoicecode", "");
                    deductionItem.put("deductioninvoiceno", "");
                    deductionItem.put("etaxinvoiceno", "");
                    deductionItem.put("invoicedate", "");
                    if (!this.checkMapValueNull(deductionItem, "deductionremark")) continue block23;
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("deductionremark"), (String)ResManager.loadKDString((String)"\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_254", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    break;
                }
                default: {
                    deductionItem.put("deductioninvoicecode", "");
                    deductionItem.put("deductioninvoiceno", "");
                    deductionItem.put("etaxinvoiceno", "");
                    deductionItem.put("invoicedate", "");
                }
            }
        }
        if (checkFlag) {
            DynamicObjectCollection deductions = bill.getDynamicObjectCollection("deductions");
            deductions.clear();
            for (Map deduction : deductionList) {
                DynamicObject billItem = deductions.addNew();
                DynamicObjectUtil.map2DynamicObject((Map)deduction, (DynamicObject)billItem);
            }
        }
        return checkFlag;
    }

    private JSONObject getJsonObject(HashMap<String, JSONObject> deducInvoiceMap, Map<String, Object> deductionItem, String key, boolean invoiceExists) {
        JSONObject json = deducInvoiceMap.get(key);
        String deductionAmountStr = (String)deductionItem.get("deductionamount");
        BigDecimal deductionAmount = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((CharSequence)deductionAmountStr) && BigDecimalUtil.isNumber((String)deductionAmountStr)) {
            deductionAmount = new BigDecimal(deductionAmountStr);
        }
        if (null == json && invoiceExists) {
            json = new JSONObject();
            json.put("orievidenceamount", deductionItem.get("orievidenceamount"));
            json.put("deductionamount", (Object)deductionAmount);
            deducInvoiceMap.put(key, json);
        } else if (null != json && invoiceExists) {
            json = deducInvoiceMap.get(key);
            json.put("deductionamount", (Object)json.getBigDecimal("deductionamount").add(deductionAmount));
        }
        return json;
    }

    private boolean checkOrigianlBillCustPhoneAndEmail(Map<String, String> errMap, Map<String, Object> originalBill, Map<String, FileField> fieldMap, String checkPhone) {
        String invoiceType = (String)originalBill.get("invoicetype");
        if (InvoiceUtils.isEtcInvoice((String)invoiceType) && CheckPhoneEnum.DEFAULT.getCode().equals(checkPhone)) {
            String buyerPhone = (String)originalBill.get("buyerphone");
            String buyerEmail = (String)originalBill.get("buyeremail");
            if (StringUtils.isBlank((CharSequence)buyerPhone) && StringUtils.isBlank((CharSequence)buyerEmail)) {
                ExcelHelper.setErrorMessage((Row)((Row)originalBill.get("row")), (FileField)fieldMap.get("buyerphone"), (String)ResManager.loadKDString((String)"\u5f00\u7535\u5b50\u7968\u65f6\u4ea4\u4ed8\u624b\u673a\u4e0e\u4ea4\u4ed8\u90ae\u7bb1\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"OriginalBillImportPlugin_255", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                return false;
            }
        }
        return true;
    }

    private void fillInData(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size(); ++i) {
            String discountAmountStr;
            Map<String, Object> map = list.get(i);
            String billNo = (String)map.get("billno");
            if (StringUtils.isBlank((CharSequence)billNo)) {
                map.put("billno", "billno" + i);
            }
            this.convertExcelDataToDbData(map);
            this.writeDefaultData(map);
            String rowType = (String)map.get("rowtype");
            if ("1".equals(rowType)) {
                discountAmountStr = (String)map.get("amount");
                if (StringUtils.isNotBlank((CharSequence)discountAmountStr) && BigDecimalUtil.isNumber((String)discountAmountStr)) {
                    BigDecimal discountAmount = new BigDecimal(discountAmountStr).setScale(2, 4);
                    if (!MathUtils.bigDecimalIsNegativeValue((BigDecimal)discountAmount)) {
                        discountAmount = discountAmount.negate();
                    }
                    map.put("amount", discountAmount.toPlainString());
                }
                if ("2".equals(list.get(i - 1).get("rowtype"))) {
                    list.get(i - 1).put("rowtype", "3");
                }
                this.clearDiscountRowData(map);
            } else if ("0".equals(rowType)) {
                String discountAmount = (String)map.get("discountamount");
                if (StringUtils.isNotBlank((CharSequence)discountAmount) && BigDecimalUtil.isNumber((String)discountAmount)) {
                    map.put("amount", BigDecimalUtil.transToPoint((String)discountAmount));
                } else {
                    map.put("amount", "");
                }
                this.clearDiscountRowData(map);
            }
            map.put("rowtype", rowType);
            discountAmountStr = (String)map.get("discountamount");
            if (!StringUtils.isNotBlank((CharSequence)discountAmountStr)) continue;
            map.put("discountamount", "");
            map.put("rowtype", "3");
            HashMap<String, Object> discountMap = new HashMap<String, Object>(map.size());
            map.forEach(discountMap::put);
            this.clearDiscountRowData(discountMap);
            discountMap.put("tax", "");
            BigDecimal discountAmount = new BigDecimal(discountAmountStr).setScale(2, 4);
            if (!MathUtils.bigDecimalIsNegativeValue((BigDecimal)discountAmount)) {
                discountAmount = discountAmount.negate();
            }
            discountMap.put("amount", discountAmount.toPlainString());
            list.add(++i, discountMap);
        }
    }

    private void clearDiscountRowData(Map<String, Object> discountMap) {
        discountMap.put("unitprice", "");
        discountMap.put("taxunitprice", "");
        discountMap.put("num", "");
        discountMap.put("rowtype", "1");
        discountMap.put("discountamount", "");
        discountMap.put("discountrate", "");
        discountMap.put("specification", "");
        discountMap.put("unit", "");
        discountMap.put("deduction", "");
    }

    private void fillInSaleAndBuyerData(Map<String, Object> map, SaleAddrAndPayeeDTO info, Map<String, DynamicObject> bueryAddrMap) {
        String buyertaxno = "";
        String buyerbank = "";
        String buyeraddr = "";
        String buyerphone = "";
        String buyeremail = "";
        boolean isPerson = "1".equals(map.get("buyerproperty"));
        String buyername = (String)map.get("buyername");
        this.fillInMapValue(map, "oribuyername", buyername);
        this.fillInMapValue(map, "oribuyeraddr", map.get("buyeraddr"));
        this.fillInMapValue(map, "oribuyerbank", map.get("buyerbank"));
        DynamicObject obj = bueryAddrMap.get(buyername);
        if (obj != null) {
            if (!isPerson) {
                buyertaxno = obj.getString("taxno");
                buyerbank = obj.getString("openingbank");
                buyeraddr = obj.getString("addr");
            }
            buyerphone = obj.getString("mobilephone");
            buyeremail = obj.getString("email");
        }
        this.fillInMapValue(map, "buyertaxno", buyertaxno);
        this.fillInMapValue(map, "buyeraddr", buyeraddr);
        this.fillInMapValue(map, "buyerbank", buyerbank);
        this.fillInMapValue(map, "buyerphone", buyerphone);
        this.fillInMapValue(map, "buyeremail", buyeremail);
        this.fillInMapValue(map, "salername", info.getSaleName());
        this.fillInMapValue(map, "salertaxno", info.getSaleTaxNo());
        this.fillInMapValue(map, "saleraddr", info.getInvoiceAddr());
        this.fillInMapValue(map, "salerbank", info.getOpenUserBank());
    }

    private void convertExcelDataToDbData(Map<String, Object> map) {
        String deduction;
        String discountRate;
        String discountAmount;
        String invoiceType = (String)map.get("invoicetype");
        map.put("invoicetype", StringUtils.isNotBlank((CharSequence)(invoiceType = InvoiceType.getCodeByDesc((String)invoiceType))) ? invoiceType : InvoiceType.ALL_E_SPECIAL.getTypeCode());
        String hsbz = (String)map.get("hsbz");
        hsbz = (String)InvoiceConstant.HSBZ_MAP.get(hsbz);
        map.put("hsbz", StringUtils.isNotBlank((CharSequence)hsbz) ? hsbz : "1");
        String buyerProperty = (String)map.get("buyerproperty");
        buyerProperty = (String)InvoiceConstant.BUYER_PROPERTY_MAP.get(buyerProperty);
        map.put("buyerproperty", StringUtils.isNotBlank((CharSequence)buyerProperty) ? buyerProperty : "0");
        String rowType = (String)map.getOrDefault("rowtype", "\u666e\u901a\u5546\u54c1\u884c");
        rowType = (String)InvoiceConstant.ROWTYPE_MAP.get(rowType);
        map.put("rowtype", StringUtils.isNotBlank((CharSequence)rowType) ? rowType : "2");
        String taxpremark = (String)map.get("policylogo");
        taxpremark = (String)InvoiceConstant.TAXPREMARK_MAP.get(taxpremark);
        map.put("policylogo", StringUtils.isNotBlank((CharSequence)taxpremark) ? taxpremark : "");
        String taxRate = (String)map.get("taxrate");
        if (StringUtils.isNotBlank((CharSequence)taxRate)) {
            map.put("taxrate", TaxRateUtil.convertTaxRate((String)taxRate));
        }
        if (!BigDecimalUtil.isNumber((String)(discountAmount = (String)map.get("discountamount")))) {
            map.put("discountamount", "");
        }
        if (StringUtils.isNotBlank((CharSequence)(discountRate = (String)map.get("discountrate")))) {
            discountRate = BigDecimalUtil.isNumber((String)discountRate) ? TaxRateUtil.convertTaxRate((String)discountRate) : "";
            map.put("discountrate", discountRate);
        }
        String amount = (String)map.get("amount");
        if (StringUtils.isBlank((CharSequence)discountAmount) && StringUtils.isNotBlank((CharSequence)discountRate) && StringUtils.isNotBlank((CharSequence)amount)) {
            discountAmount = new BigDecimal(amount).multiply(new BigDecimal(discountRate)).toString();
            if (new BigDecimal(amount).compareTo(BigDecimal.ZERO) > 0) {
                discountAmount = new BigDecimal(discountAmount).negate().toString();
            }
            map.put("discountamount", discountAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)(deduction = (String)map.get("deduction")))) {
            if (BigDecimalUtil.isNumber((String)deduction)) {
                map.put("deduction", BigDecimalUtil.transToPoint((String)deduction));
            } else {
                map.put("deduction", "");
            }
        }
        map.put("specialtype", InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeByExcelDescription((String)((String)map.get("specialtype"))));
        if (!InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            map.put("taxationstyle", "0");
        } else {
            String taxedType = (String)map.getOrDefault("taxationstyle", "0");
            map.put("taxationstyle", StringUtils.isNotBlank((CharSequence)(taxedType = (String)InvoiceConstant.TAXEDTYPE_MAP.get(taxedType))) ? taxedType : "0");
        }
        String coalTypeCode = (String)map.get("coaltypecode");
        if (StringUtils.isNotBlank((CharSequence)coalTypeCode)) {
            map.put("coaltypecode", CoalTypeCodeEnum.getCodeByDesc((String)coalTypeCode));
        }
        String reductionTaxType = (String)map.get("reductiontaxtype");
        map.put("reductiontaxtype", ReductionTaxTypeEnum.getCodeByDesc((String)reductionTaxType));
    }

    protected void downloadTemplate() {
        this.downloadTemplate(TEMPLATE_DIR, "\u5f00\u7968\u7533\u8bf7\u5355\u5bfc\u5165\u6a21\u677f.xlsx", TEMPLATE_JSON_NAME);
    }

    private void fillOrgInfo(List<Map<String, Object>> list) {
        HashSet<String> orgCodeSet = new HashSet<String>(1);
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            if (!StringUtils.isNotBlank((Object)map.get("orgcode"))) continue;
            orgCodeSet.add(map.get("orgcode") + "");
        }
        Map receiverObj = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "in", orgCodeSet).toArray());
        HashMap<String, Long> orgMap = new HashMap<String, Long>(1);
        for (DynamicObject org : receiverObj.values()) {
            orgMap.put(org.getString("number"), org.getLong("id"));
        }
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            if (StringUtils.isNotBlank((Object)map.get("orgcode"))) {
                map.put("orgid", orgMap.get(map.get("orgcode")));
                continue;
            }
            map.put("orgid", RequestContext.get().getOrgId());
        }
    }

    private void fillInAlleCoalQuality(Map<String, Object> originalBill, List<Map<String, Object>> extraBillList) {
        originalBill.put("coalheat", extraBillList.get(0).get("coalheat"));
        originalBill.put("totalsulfurindry", extraBillList.get(0).get("totalsulfurindry"));
        originalBill.put("dryashfreevolatilematter", extraBillList.get(0).get("dryashfreevolatilematter"));
    }

    private boolean checkAllEleCoalQuality(Map<String, String> errMap, Map<String, Object> originalBill, DynamicObject bill, Map<String, FileField> extraFieldMap, Map<String, FileField> fieldMap) {
        boolean checkFlag = true;
        if (StringUtils.isNotEmpty((CharSequence)((String)originalBill.get("coaltypecode")))) {
            Row row = (Row)originalBill.get("extra_row");
            if (StringUtils.isNotEmpty((CharSequence)((String)originalBill.get("coalheat"))) && ((String)originalBill.get("coalheat")).length() > 10) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("coalheat"), (String)ResManager.loadKDString((String)"\u7164\u70ad\u8d28\u91cf\u4fe1\u606f\u6bcf\u5343\u514b\u7164\u70ad\u53d1\u70ed\u91cf(\u5343\u5361)\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57\u7b26", (String)"OriginalBillImportPlugin_318", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)originalBill.get("totalsulfurindry"))) && ((String)originalBill.get("totalsulfurindry")).length() > 10) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("totalsulfurindry"), (String)ResManager.loadKDString((String)"\u7164\u70ad\u8d28\u91cf\u4fe1\u606f\u5e72\u57fa\u5168\u786b(%)\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57\u7b26", (String)"OriginalBillImportPlugin_319", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)originalBill.get("dryashfreevolatilematter"))) && ((String)originalBill.get("dryashfreevolatilematter")).length() > 10) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)extraFieldMap.get("dryashfreevolatilematter"), (String)ResManager.loadKDString((String)"\u7164\u70ad\u8d28\u91cf\u4fe1\u606f\u5e72\u71e5\u65e0\u7070\u57fa\u6325\u53d1\u5206(%)\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57\u7b26", (String)"OriginalBillImportPlugin_320", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
        return checkFlag;
    }

    private Map<String, DynamicObject> getBueryAddrMap(Map<Long, Map<String, DynamicObject>> orgBueryAddrMap, long orgId, String buyerName) {
        Map<String, DynamicObject> bueryAddrMap = new HashMap<String, DynamicObject>(4);
        DynamicObject invTitleSetting = InvTitleSettingHelper.getInvTitleSetting((Long)orgId);
        if (null == invTitleSetting || !invTitleSetting.getBoolean("iscomplete")) {
            return bueryAddrMap;
        }
        if (orgBueryAddrMap.containsKey(orgId)) {
            bueryAddrMap = orgBueryAddrMap.get(orgId);
        }
        if (!bueryAddrMap.containsKey(buyerName)) {
            bueryAddrMap.put(buyerName, InvoiceTitleCacheHelper.getInvoiceTitleByBuyerName((Long)orgId, (String)buyerName));
            orgBueryAddrMap.put(orgId, bueryAddrMap);
        }
        return bueryAddrMap;
    }
}

