/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginSelectInvoiceControl;

public class OriginalSelectInvoicePlugin
extends AbstractFormPlugin {
    public static final String ENTRY_ENTITY = "entryentity";
    public static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        OriginSelectInvoiceControl.initData((AbstractFormPlugin)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            String operateKey = this.getPageCache().get("operateKey");
            this.checkPermission(operateKey);
            OriginSelectInvoiceControl.opRedWorkbench((AbstractFormPlugin)this);
        }
    }

    private void checkPermission(String operateKey) {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject dynamicObject : entryEntity) {
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("orgid"));
            switch (operateKey) {
                case "bill_red": {
                    PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.SIM_RED);
                    break;
                }
                case "bill_red_reopen": {
                    PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.SIM_RED_REOPEN);
                    break;
                }
                case "bill_invalid": {
                    PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.INV_ABOLISH);
                    break;
                }
                case "bill_invalid_reopen": {
                    PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.IMC_RE_ISSUE);
                    break;
                }
                case "bill_reopen": {
                    PermissionHelper.checkPermission((String)"sim", (String)"sim_original_bill", (long)orgId, (ImcPermItemEnum)ImcPermItemEnum.IMC_REOPEN);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.selectAllRows();
    }

    private void selectAllRows() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity(ENTRY_ENTITY);
        int size = entryentity.size();
        int[] rows = new int[size];
        for (int i = 0; i < size; ++i) {
            rows[i] = i;
        }
        grid.selectRows(rows, 0);
    }
}

