/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.sim.common.helper.OriginalBillHelper;
import kd.imc.sim.formplugin.bill.originalbill.op.validator.InvoiceOriginalBillDeleteValidator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceOriginalBillDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        ArrayList<String> fieldKey = new ArrayList<String>(Arrays.asList("orgid", "billno", "billsource", "billstatus", "confirmstate", "billsourcetype", "invoicecode", "invoiceno", "invoicestatus", "blueinvoicecode", "blueinvoiceno", "blueinvoiceitemid", "amount", "tax"));
        e.getFieldKeys().addAll(fieldKey);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InvoiceOriginalBillDeleteValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        RequestContext context = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"disassociate_invoice", () -> {
            RequestContext.copyAndSet((RequestContext)context);
            ArrayList<Pair> invalidInvoiceCodeNo = new ArrayList<Pair>(bills.length);
            ArrayList<DynamicObject> redBills = new ArrayList<DynamicObject>(bills.length);
            for (DynamicObject bill : bills) {
                String billSourceType = bill.getString("billsourcetype");
                if (StringUtils.isBlank((String)billSourceType) || "A".equals(billSourceType) || "D".equals(billSourceType)) continue;
                if ("C".equals(billSourceType)) {
                    invalidInvoiceCodeNo.add(Pair.of((Object)bill.getString("invoicecode"), (Object)bill.getString("invoiceno")));
                    continue;
                }
                redBills.add(bill);
            }
            OriginalBillHelper.invalidBillDelete(invalidInvoiceCodeNo);
            OriginalBillHelper.redBillDelete(redBills, invalidInvoiceCodeNo);
            DeleteServiceHelper.delete((String)"sim_bill_relation", (QFilter[])new QFilter("tbillid", "in", (Object)Stream.of(bills).map(DataEntityBase::getPkValue).toArray()).toArray());
        });
    }
}

