/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billpreview;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.billpreview.BillPreviewData;

public class InvoicingPreviewPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btn_pre", "btn_next"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        try {
            int currentRow = Integer.parseInt(this.getView().getPageCache().get("CurrentRow"));
            List datasList = JSON.parseArray((String)this.getPageCache().get("Bill" + currentRow), BillPreviewData.class);
            int num = datasList.size();
            int invoiceIndex = Integer.parseInt(this.getView().getPageCache().get("invoiceIndex"));
            if (num == 1) {
                return;
            }
            switch (control.getKey()) {
                case "btn_pre": {
                    if (invoiceIndex == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u5f20", (String)"InvoicingPreviewPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getPageCache().put("invoiceIndex", String.valueOf(invoiceIndex - 1));
                    this.refreshBill();
                    break;
                }
                case "btn_next": {
                    if (invoiceIndex + 1 >= num) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u5f20", (String)"InvoicingPreviewPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getPageCache().put("invoiceIndex", String.valueOf(invoiceIndex + 1));
                    this.refreshBill();
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"InvoicingPreviewPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("entryentity".equals(key)) {
            int currentRow = evt.getRow();
            this.getPageCache().put("CurrentRow", String.valueOf(currentRow));
            this.getPageCache().put("invoiceIndex", "0");
            this.refreshBill();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String key = (String)this.getView().getFormShowParameter().getCustomParam("key");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_invoice_preview_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_invoice_preview_data"), (QFilter[])new QFilter("originbillseq", "=", (Object)key).toArray());
        if (dynamicObjects.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5730\u5740\u9519\u8bef\u6216\u94fe\u63a5\u5df2\u8fc7\u671f", (String)"InvoicingPreviewPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (DateUtils.timeDifference((Date)dynamicObjects[0].getDate("expiretime"), (Date)new Date()) > 0L) {
            DeleteServiceHelper.delete((String)"sim_invoice_preview_data", (QFilter[])new QFilter("originbillseq", "=", (Object)key).toArray());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94fe\u63a5\u5df2\u8fc7\u671f", (String)"InvoicingPreviewPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (dynamicObjects[0].getString("password").isEmpty()) {
            this.initPlgin(dynamicObjects);
        } else {
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)0);
            customParams.put("password", dynamicObjects[0].getString("password"));
            ViewUtil.openDialog((AbstractFormPlugin)this, (Map)customParams, (String)"sim_enter_password", (String)"sim_enter_password");
        }
    }

    private void initPlgin(DynamicObject[] dynamicObjects) {
        for (int i = 0; i < dynamicObjects.length; ++i) {
            List datasList = JSON.parseArray((String)dynamicObjects[i].getString("jsonstring_tag"), BillPreviewData.class);
            this.setEntryEntity(dynamicObjects[i], i);
            this.getPageCache().put("Bill" + i, SerializationUtils.toJsonString((Object)datasList));
        }
        this.getPageCache().put("CurrentRow", "0");
        this.getPageCache().put("invoiceIndex", "0");
        this.refreshBill();
    }

    private void setEntryEntity(DynamicObject dynamicObject, int billIndex) {
        IDataModel modelDetail = this.getView().getControl("entryentity").getModel();
        modelDetail.createNewEntryRow("entryentity");
        modelDetail.setValue("bill_amount", dynamicObject.get("amount"), billIndex);
        modelDetail.setValue("bill_tax", dynamicObject.get("totaltax"), billIndex);
        modelDetail.setValue("bill_total", dynamicObject.get("totalamount"), billIndex);
        modelDetail.setValue("bill_number", dynamicObject.get("billno"), billIndex);
    }

    private void refreshBill() {
        try {
            int currentRow = Integer.parseInt(this.getPageCache().get("CurrentRow"));
            List datasList = JSON.parseArray((String)this.getPageCache().get("Bill" + currentRow), BillPreviewData.class);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("flexpanelap21");
            if (((BillPreviewData)datasList.get(0)).getInvoicetype().contains("xdp")) {
                showParameter.setFormId("sim_preview_ele");
            } else {
                showParameter.setFormId("sim_preview_sk");
            }
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"InvoicingPreviewPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("sim_enter_password".equals(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            boolean returnData = (Boolean)closedCallBackEvent.getReturnData();
            if (returnData) {
                String key = (String)this.getView().getFormShowParameter().getCustomParam("key");
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_invoice_preview_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_invoice_preview_data"), (QFilter[])new QFilter("originbillseq", "=", (Object)key).toArray());
                this.initPlgin(dynamicObjects);
            }
        }
    }
}

