/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.decalaration.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.InvTitleSettingHelper;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.dto.bgd.config.BgdConfig;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.InvTitleMatchHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.declarationbill.helper.BgdHelper;
import kd.imc.sim.formplugin.match.BillMatchHelper;

public class Bgd2OriginalBillPlugin
extends AbstractConvertPlugIn {
    private Log LOGGER = LogFactory.getLog(Bgd2OriginalBillPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        block19: {
            List selectedRows = e.getSelectedRows();
            String fields = "transmodename,tradecurr,dealexchangerate,dealtotalfromamount,dealtotalamount,issuetotalamount,billno,entryid,items.issueamount,items.taxrate,items.taxratecodeid,items.gname,org";
            DynamicObject[] bgds = BusinessDataServiceHelper.load((String)"sim_declaration_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().toArray()).toArray());
            HashSet<Long> orgPks = new HashSet<Long>();
            boolean isPushSuccessBgd = "1".equals(ImcConfigUtil.getValue((String)"onlyPushSuccessBgd", (String)"onlyPushSuccessBgd"));
            HashSet<Long> failPks = new HashSet<Long>();
            String errorMsg = "";
            try {
                for (DynamicObject bill : bgds) {
                    orgPks.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.getDynamicObject("org")));
                    try {
                        if (StringUtils.isBlank((CharSequence)bill.getString("billno"))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u5173\u5355\u7edf\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"Bgd2OriginalBillPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        }
                        if (StringUtils.isBlank((CharSequence)bill.getString("transmodename"))) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u6210\u4ea4\u65b9\u5f0f\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                        }
                        if (StringUtils.isBlank((CharSequence)bill.getString("entryid"))) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u51fa\u53e3\u62a5\u5173\u5355\u53f7\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                        }
                        if (null == bill.getDynamicObject("tradecurr")) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u6210\u4ea4\u5e01\u522b\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                        }
                        if (BigDecimalUtil.compareZero((BigDecimal)bill.getBigDecimal("dealexchangerate"))) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u6210\u4ea4\u6c47\u7387\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                        }
                        if (BigDecimalUtil.compareZero((BigDecimal)bill.getBigDecimal("dealtotalfromamount"))) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u6210\u4ea4\u603b\u4ef7\uff08\u539f\u5e01\uff09\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                        }
                        if (BigDecimalUtil.compareZero((BigDecimal)bill.getBigDecimal("dealtotalamount"))) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u6210\u4ea4\u603b\u4ef7\uff08\u4eba\u6c11\u5e01\uff09\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                        }
                        if (BigDecimalUtil.compareZero((BigDecimal)bill.getBigDecimal("issuetotalamount"))) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u5f00\u7968\u603b\u4ef7\uff08\u4eba\u6c11\u5e01\uff09\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                        }
                        DynamicObjectCollection items2 = bill.getDynamicObjectCollection("items");
                        if (items2.size() == 0) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u7f3a\u5c11\u660e\u7ec6", (String)"Bgd2OriginalBillPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno")));
                        }
                        for (int i = 0; i < items2.size(); ++i) {
                            DynamicObject item = (DynamicObject)items2.get(i);
                            int rowSeq = i + 1;
                            if (BigDecimalUtil.compareZero((BigDecimal)item.getBigDecimal("issueamount"))) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u7b2c%2$s\u884c\u660e\u7ec6\u5f00\u7968\u603b\u4ef7\uff08\u4eba\u6c11\u5e01\uff09\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), rowSeq));
                            }
                            if (!StringUtils.isBlank((CharSequence)item.getString("gname"))) continue;
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u5173\u5355\uff1a%1$s\u7b2c%2$s\u884c\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u5fc5\u586b", (String)"Bgd2OriginalBillPlugin_24", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), rowSeq));
                        }
                    }
                    catch (KDBizException e1) {
                        failPks.add(bill.getLong("id"));
                        errorMsg = e1.getMessage();
                        if (isPushSuccessBgd) continue;
                        throw e1;
                    }
                }
                if (bgds.length == failPks.size()) {
                    throw new KDBizException(errorMsg);
                }
                String failPksStr = "";
                if (failPks.size() > 0) {
                    failPksStr = JSONObject.toJSONString(failPks);
                }
                this.getOption().setVariableValue("failPks", failPksStr);
                if (orgPks.size() > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u7ec4\u7ec7\u7684\u62a5\u5173\u5355\u8fdb\u884c\u4e0b\u63a8", (String)"Bgd2OriginalBillPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                if (UnitTestHelper.isUnitTest()) break block19;
                throw ex;
            }
        }
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        String failPks = this.getOption().getVariableValue("failPks");
        if (StringUtils.isNotBlank((CharSequence)failPks)) {
            JSONArray failPkArray = JSONObject.parseArray((String)failPks);
            HashSet failPkSet = new HashSet(failPkArray);
            e.getQFilters().add(new QFilter("id", "not in", failPkSet));
        }
        e.addSrcField("billno");
        e.addSrcField("entryid");
        e.addSrcField("iedate");
        e.addSrcField("ddate");
        e.addSrcField("ieportname");
        e.addSrcField("ieport");
        e.addSrcField("custrafmodename");
        e.addSrcField("transportinfo");
        e.addSrcField("supvmodecddename");
        e.addSrcField("cutModeName");
        e.addSrcField("contractno");
        e.addSrcField("curtradenationcodename");
        e.addSrcField("custradecountryname");
        e.addSrcField("distinateportname");
        e.addSrcField("despportcodename");
        e.addSrcField("wraptypename");
        e.addSrcField("attadocucdstr");
        e.addSrcField("markno");
        e.addSrcField("packno");
        e.addSrcField("transmodename");
        e.addSrcField("tradecurr");
        e.addSrcField("dealexchangerate");
        e.addSrcField("dealtotalfromamount");
        e.addSrcField("dealtotalamount");
        e.addSrcField("issuetotalamount");
        e.addSrcField("feecurr");
        e.addSrcField("feeexchangerate");
        e.addSrcField("feeMark");
        e.addSrcField("feeamount");
        e.addSrcField("insurcurr");
        e.addSrcField("insurexchangerate");
        e.addSrcField("insurMark");
        e.addSrcField("insurrate");
        e.addSrcField("insurlocalamount");
        e.addSrcField("othercurr");
        e.addSrcField("feerate");
        e.addSrcField("issuefromamount");
        e.addSrcField("tradecurrcode");
        e.addSrcField("org");
        e.addSrcField("issuerule");
        e.addSrcField("issueamount");
        e.addSrcField("taxrate");
        e.addSrcField("taxratecodeid");
        e.addSrcField("gname");
        e.addSrcField("gmodel");
        e.addSrcField("gunitname");
        e.addSrcField("unit1name");
        e.addSrcField("unit2name");
        e.addSrcField("unit2name");
    }

    public void afterConvert(AfterConvertEventArgs e) {
        String tgtName = this.getTgtMainType().getName();
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(tgtName);
        Map srcfldPro = e.getFldProperties();
        HashMap<String, DynamicObject> billNoMap = new HashMap<String, DynamicObject>();
        ArrayList<BillVo> billVos = new ArrayList<BillVo>();
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>();
        DynamicObject org = null;
        Long orgPk = null;
        DynamicObject[] currencys = BusinessDataServiceHelper.load((String)"bd_currency", (String)"number,name", null);
        Map<Object, String> currencyMap = Arrays.stream(currencys).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o.getString("name")));
        int itemEntitySeq = 0;
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] originalBillItems = targetExtDataEntitySet.FindByEntityKey("sim_original_bill_item");
        this.goodsMatch(extendedDataEntities);
        for (ExtendedDataEntity entity : extendedDataEntities) {
            DynamicObject bill = entity.getDataEntity();
            List sourceBillRows = (List)entity.getValue("ConvertSource");
            DynamicObject sourceRow = (DynamicObject)sourceBillRows.get(0);
            String hsbz = bill.getString("hsbz");
            boolean isIncludeTax = "1".equalsIgnoreCase(hsbz);
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTax = BigDecimal.ZERO;
            orgPk = (Long)((DynamicProperty)srcfldPro.get("org")).getValue((Object)sourceRow);
            if (null == org) {
                org = TaxUtils.getOrgDynamicObject((Long)orgPk);
            }
            bill.set("salername", (Object)org.getString("epinfo.name"));
            bill.set("salertaxno", (Object)org.getString("epinfo.number"));
            bills.add(bill);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bdm_customs_config", (Long)orgPk);
            DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bdm_customs_config", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_customs_config"), (QFilter[])baseDataFilter.toArray());
            Map<Object, DynamicObject> configMap = Arrays.stream(configs).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
            DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
            Long issueRulePk = (Long)((DynamicProperty)srcfldPro.get("issuerule")).getValue((Object)sourceRow);
            DynamicObject issueRule = configMap.get(issueRulePk);
            BgdConfig baseConfig = BgdHelper.getBaseConfig((DynamicObject)issueRule);
            if (StringUtils.isNotBlank((CharSequence)baseConfig.getRemarkKeys())) {
                this.setRemark(srcfldPro, sourceRow, baseConfig, bill, currencyMap);
            }
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) || "1".equals(bill.getString("iselepaper"));
            int oriItemsLength = items2.size();
            for (int i = 0; i < oriItemsLength; ++i) {
                Object unitName;
                String numConfig;
                String specConfig;
                ExtendedDataEntity itemConstruct = originalBillItems[itemEntitySeq];
                ++itemEntitySeq;
                DynamicObject item = itemConstruct.getDataEntity();
                DynamicObject source = (DynamicObject)((List)itemConstruct.getValue("ConvertSource")).get(0);
                String taxRate = item.getString("taxrate");
                BigDecimal taxAmount = item.getBigDecimal("amount");
                BigDecimal amount = taxAmount.divide(new BigDecimal(taxRate).add(BigDecimal.ONE), 2, RoundingMode.HALF_UP);
                BigDecimal tax = taxAmount.subtract(amount);
                String taxationStype = bill.getString("taxationstyle");
                String policyConstants = item.getString("policycontants");
                if (ReducedHelper.isReduced((Object)taxationStype) && ReducedHelper.isSpecialCalc((Object)policyConstants)) {
                    tax = ReducedHelper.calcTaxWithoutTax((Object)policyConstants, (BigDecimal)amount);
                }
                item.set("taxamount", (Object)taxAmount);
                item.set("amount", (Object)amount);
                item.set("tax", (Object)tax);
                BigDecimal num = item.getBigDecimal("num");
                if (!BigDecimalUtil.compareZero((BigDecimal)num)) {
                    BigDecimal taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle);
                    BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle);
                    item.set("taxunitprice", (Object)taxUnitPrice);
                    item.set("unitprice", (Object)unitPrice);
                }
                if ("1".equals(specConfig = baseConfig.getSpecConfig())) {
                    String specName = (String)((DynamicProperty)srcfldPro.get("gmodel")).getValue((Object)source);
                    if (StringUtils.isNotBlank((CharSequence)specName)) {
                        if (InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) && specName.length() > 40) {
                            specName = specName.substring(0, 40);
                        } else if (!InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) && GBKUtils.getGBKLength((String)specName) > 40) {
                            specName = GBKUtils.cutGBKString((String)specName, (int)40);
                        }
                    }
                    item.set("specification", (Object)specName);
                    item.set("orispecification", (Object)specName);
                }
                if ("3".equals(numConfig = baseConfig.getNumConfig())) {
                    unitName = ((DynamicProperty)srcfldPro.get("gunitname")).getValue((Object)source);
                    item.set("unit", unitName);
                } else if ("1".equals(numConfig)) {
                    unitName = ((DynamicProperty)srcfldPro.get("unit1name")).getValue((Object)source);
                    item.set("unit", unitName);
                } else {
                    unitName = ((DynamicProperty)srcfldPro.get("unit2name")).getValue((Object)source);
                    item.set("unit", unitName);
                }
                item.set("oriunit", item.get("unit"));
                item.set("remainvalidnum", (Object)num);
                item.set("remainvalidtax", (Object)tax);
                if (isIncludeTax) {
                    item.set("remainvalidamount", (Object)taxAmount);
                } else {
                    item.set("remainvalidamount", (Object)amount);
                }
                item.set("oritaxamount", (Object)taxAmount);
                invoiceAmount = invoiceAmount.add(amount);
                totalAmount = totalAmount.add(taxAmount);
                totalTax = totalTax.add(tax);
            }
            bill.set("totalamount", (Object)totalAmount);
            bill.set("invoiceamount", (Object)invoiceAmount);
            bill.set("oldtotalamount", (Object)totalAmount);
            bill.set("totaltax", (Object)totalTax);
            bill.set("surplustax", (Object)totalTax);
            bill.set("surplusamount", (Object)invoiceAmount);
            billNoMap.put(bill.getString("billno"), bill);
            BillVo billVo = new BillVo();
            billVo.setBuyerName(bill.getString("buyername"));
            billVo.setSellerName(bill.getString("salername"));
            billVo.setBillNo(bill.getString("billno"));
            billVo.setBuyerProperty(Integer.parseInt(bill.getString("buyerproperty")));
            billVo.setOrgId(orgPk);
            billVos.add(billVo);
        }
        DynamicObject invTitleSetting = InvTitleSettingHelper.getInvTitleSetting(orgPk);
        InvTitleMatchHelper.matchInvTitle(billVos, (boolean)true, (DynamicObject)invTitleSetting);
        for (BillVo billVo : billVos) {
            DynamicObject bill = (DynamicObject)billNoMap.get(billVo.getBillNo());
            bill.set("buyertaxno", (Object)billVo.getBuyerTaxpayerId());
            bill.set("buyeraddr", (Object)billVo.getBuyerAddressAndTel());
            bill.set("oribuyeraddr", (Object)billVo.getBuyerAddressAndTel());
            bill.set("buyerbank", (Object)billVo.getSellerBankAndAccount());
            bill.set("oribuyerbank", (Object)billVo.getSellerBankAndAccount());
            bill.set("oribuyername", (Object)billVo.getBuyerName());
        }
        BillValidaterHelper.setSaleInfo((DynamicObject)((DynamicObject)bills.get(0)));
        for (DynamicObject bill : bills) {
            if (StringUtils.isBlank((CharSequence)bill.getString("salerbank"))) {
                bill.set("salerbank", (Object)((DynamicObject)bills.get(0)).getString("salerbank"));
            }
            if (!StringUtils.isBlank((CharSequence)bill.getString("saleraddr"))) continue;
            bill.set("saleraddr", (Object)((DynamicObject)bills.get(0)).getString("saleraddr"));
        }
        BillMatchHelper billMatchHelper = new BillMatchHelper();
        DynamicObject[] drawerStrategyArr = DrawerStrategyHelper.queryDrawerStrategyByOrg(orgPk);
        DynamicObject defaultDrawerStrategy = BusinessDataServiceHelper.newDynamicObject((String)"bdm_drawer_strategy");
        defaultDrawerStrategy.set("drawerstrategy", (Object)"1,1,1");
        Set entries = billNoMap.entrySet();
        for (Map.Entry entry : entries) {
            billMatchHelper.matchDrawer((DynamicObject)entry.getValue(), drawerStrategyArr, defaultDrawerStrategy);
        }
        billMatchHelper.matchSplitOrMergeRule(orgPk.longValue(), bills, "");
    }

    private void goodsMatch(ExtendedDataEntity[] extBills) {
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>();
        for (ExtendedDataEntity entity : extBills) {
            DynamicObject bill = entity.getDataEntity();
            bills.add(bill);
        }
        BgdConfig config = new BgdConfig();
        config.setTaxClassCodeObjMap(TaxClassCodeCheckHelper.getTaxClassCodeObjMap());
        BgdHelper.goodsMatch(bills, (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)((DynamicObject)bills.get(0)).get("orgid")), (BgdConfig)config);
    }

    private void setRemark(Map<String, DynamicProperty> srcfldPro, DynamicObject sourceRow, BgdConfig baseConfig, DynamicObject bill, Map<Object, String> currencyMap) {
        String splitRemark;
        String remarkKeys = baseConfig.getRemarkKeys();
        Map showFiledsMap = baseConfig.getShowFiledsMap();
        Set showFields = baseConfig.getShowFields();
        String[] array = remarkKeys.split(",");
        StringBuilder remarkBuilder = new StringBuilder();
        int lastIndex = array.length - 1;
        HashSet fields = new HashSet();
        Collections.addAll(fields, "feecurr", "insurcurr", "tradecurr", "othercurr");
        HashSet decimalValueSet = new HashSet();
        HashSet decimal4ValueSet = new HashSet();
        Collections.addAll(decimal4ValueSet, "dealexchangerate", "feeexchangerate", "insurexchangerate", "otherexchangerate", "dollarexchangerate");
        Collections.addAll(decimalValueSet, "feerate", "insurrate", "otherrate", "feeamount", "insurlocalamount", "otherlocalamount", "dealtotalfromamount", "dealtotalamount", "issuefromamount", "issuetotalamount", "totalpushamount", "totalunpushamount");
        String string = splitRemark = "\u6362\u884c".equalsIgnoreCase(baseConfig.getSplitRemark()) ? System.lineSeparator() : baseConfig.getSplitRemark();
        if ("&amp;".equals(splitRemark)) {
            splitRemark = "&";
        }
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            String filedValue;
            String key = array[i];
            DynamicProperty dynamicProperty = srcfldPro.get(key);
            Object value = null == dynamicProperty ? "" : srcfldPro.get(key).getValue((Object)sourceRow);
            if (decimalValueSet.contains(key)) {
                if (null != value) {
                    value = ((BigDecimal)value).stripTrailingZeros().setScale(2, RoundingMode.HALF_UP);
                }
            } else if (decimal4ValueSet.contains(key)) {
                if (null != value) {
                    value = ((BigDecimal)value).stripTrailingZeros().setScale(4, RoundingMode.HALF_UP);
                }
            } else if (value instanceof BigDecimal) {
                value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
            }
            if (fields.contains(key)) {
                value = currencyMap.get(value);
            }
            if (value instanceof DynamicObject) {
                DynamicObject curr = (DynamicObject)value;
                value = curr.getString("name");
            }
            if (value instanceof Date) {
                value = DateUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
            }
            if (value == null) {
                value = "";
            }
            if ("dealtotalfromamount".equals(key)) {
                Object currCode = srcfldPro.get("tradecurrcode").getValue((Object)sourceRow);
                value = currCode + " " + value;
            }
            if (null != (filedValue = (String)showFiledsMap.get(key))) {
                value = filedValue + value;
            }
            remarkBuilder.append(value);
            if (j != lastIndex) {
                remarkBuilder.append(splitRemark);
            }
            ++j;
        }
        String invoiceRemark = remarkBuilder.toString();
        if (InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype"))) {
            if (invoiceRemark.length() > 450) {
                invoiceRemark = invoiceRemark.substring(0, 450);
            }
        } else if (GBKUtils.getGBKLength((String)invoiceRemark) > 230) {
            invoiceRemark = GBKUtils.cutGBKString((String)invoiceRemark, (int)230);
        }
        bill.set("invoiceremark", (Object)invoiceRemark);
    }
}

