/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.giftreceipt;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.SaleAddrAndPayeeDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.billcenter.SimGiftReceiptService;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GiftReceiptFormPlugin
extends AbstractFormPlugin
implements SimFormPluginConstellationUntrans {
    private static final Log LOGGER = LogFactory.getLog(GiftReceiptFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        DynamicObject giftSetting;
        DynamicObject bosOrg;
        long orgId;
        IDataModel model = this.getModel();
        Long billcenterId = (Long)this.getView().getFormShowParameter().getCustomParam("billcenterId");
        if (billcenterId != null) {
            this.initGiftFromBillCenter(billcenterId);
        }
        if ((orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)(bosOrg = (DynamicObject)model.getValue("org")))) != 0L) {
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
            SaleAddrAndPayeeDTO defaultAddrAndPayee = TaxUtils.getDefaultAddrAndPayee((SaleInfo)saleInfo);
            model.setValue("salername", (Object)saleInfo.getSaleName());
            model.setValue("salertaxno", (Object)saleInfo.getSaleTaxNo());
            model.setValue("saleraddr", (Object)defaultAddrAndPayee.getInvoiceAddr());
            model.setValue("salerbank", (Object)defaultAddrAndPayee.getOpenUserBank());
            model.setValue("topremark", (Object)bosOrg.getString("name"));
        }
        if (billcenterId == null && (giftSetting = BusinessDataServiceHelper.loadSingle((String)"bdm_st_qr_code_manage", (String)"invoicetype", (QFilter[])new QFilter("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)model.getValue("org"))).toArray())) != null) {
            model.setValue("availableinvoicetype", (Object)giftSetting.getString("invoicetype"));
        }
    }

    private void initGiftFromBillCenter(Long billcenterId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"sim_isomerism_bill_data", (String)"", (QFilter[])new QFilter("id", "=", (Object)billcenterId).toArray());
        if (bill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8d26\u5355\u4e2d\u5fc3\u6570\u636e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"GiftReceiptFormPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"sim_isomerism_bill_data");
        IDataModel model = this.getModel();
        model.setValue("billcenterbillno", (Object)bill.getString("billno"));
        model.setValue("billcenterid", bill.getPkValue());
        model.setValue("source", (Object)"billcenter");
        model.setValue("org", bill.get("org"));
        DrawerInfo drawerInfo = DrawerStrategyHelper.getDrawerInfoNonOriginalBill(null, null, null, (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")), (Object)this.getModel().getValue("jqbh"));
        this.getModel().setValue("payee", (Object)drawerInfo.getPayee());
        this.getModel().setValue("reviewer", (Object)drawerInfo.getReviewer());
        this.getModel().setValue("drawer", (Object)drawerInfo.getDrawer());
        String remark = bill.getString("remark");
        if (StringUtils.isBlank((CharSequence)remark)) {
            remark = bill.getString("billno");
        }
        model.setValue("remark", (Object)remark);
        DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_isomerism_item_data");
        HashMap groupItemMap = new HashMap(items2.size());
        String systemCode = bill.getString("system_code");
        DynamicObject orgObject = bill.getDynamicObject("org");
        SimGiftReceiptService simGiftReceiptService = new SimGiftReceiptService();
        simGiftReceiptService.dealGroupGoodsItemMethod(systemCode, orgObject, groupItemMap, items2);
        LOGGER.info("initGiftFromBillCenter, groupItemMap:{}", groupItemMap);
        model.deleteEntryData("items");
        for (Map.Entry entryObject : groupItemMap.entrySet()) {
            String taxCodeNo;
            BigDecimal unPushAmount;
            DynamicObject item = (DynamicObject)entryObject.getValue();
            if (!"1".equals(item.getString("invoicable_switch")) || !"-1".equals(item.getString("rowpushstatus")) || (unPushAmount = item.getBigDecimal("unpushamount")).compareTo(BigDecimal.ZERO) <= 0) continue;
            int i = model.createNewEntryRow("items");
            DynamicObject goodsInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_goods_info", (String)String.join((CharSequence)",", "id", "name", "unit", "specifications", "taxcode", "privilegeflag", "privilegetype", "filter_tag"), (QFilter[])ImcBaseDataHelper.getGoodsInfoFilter((Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("org"))).and("number", "=", item.get("product_code")).toArray());
            model.setValue("goodsid", (Object)goodsInfo, i);
            if (goodsInfo != null) {
                taxCodeNo = goodsInfo.getDynamicObject("taxcode").getString("number");
                taxCodeNo = this.fillInTaxCode(taxCodeNo);
            } else {
                taxCodeNo = item.getString("tax_code");
            }
            LOGGER.info("initGiftFromBillCenter, taxCodeNo:{}", (Object)taxCodeNo);
            model.setValue("goodscode", (Object)taxCodeNo, i);
            model.setValue("goodsname", item.get("product_name"), i);
            String rowType = item.getString("line_property");
            String lineProperty = this.dealConvertLineProperty(rowType);
            model.setValue("rowtype", (Object)lineProperty, i);
            model.setValue("specification", (Object)item.getString("specification"), i);
            model.setValue("unit", item.get("product_unit"), i);
            model.setValue("num", item.get("unpushnum"), i);
            model.setValue("taxunitprice", item.get("product_price"), i);
            model.setValue("taxamount", (Object)unPushAmount, i);
            model.setValue("taxrate", (Object)TaxRateUtil.convertTaxRate((String)item.getBigDecimal("tax_rate").stripTrailingZeros().toPlainString()), i);
            model.setValue("tax", item.get("unpushtax"), i);
        }
    }

    private String fillInTaxCode(String mergeCode) {
        int length = mergeCode.length();
        if (length >= 19) {
            return mergeCode;
        }
        StringBuilder mergeCodeSb = new StringBuilder(mergeCode);
        for (int i = 0; i < 19 - length; ++i) {
            mergeCodeSb.append('0');
        }
        return mergeCodeSb.toString();
    }

    private String dealConvertLineProperty(String rowType) {
        if ("2".equals(rowType)) {
            return "0";
        }
        if ("1".equals(rowType)) {
            return "1";
        }
        return "0";
    }

    public void afterCopyData(EventObject e) {
        IDataModel model = this.getModel();
        int date = (Integer)model.getValue("validdate");
        if (date != 0) {
            Date createtime = (Date)model.getValue("createtime");
            model.setValue("expiringdate", (Object)DateUtils.addDay((Date)createtime, (int)date));
        } else {
            model.setValue("expiringdate", null);
        }
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)model.getValue("org"));
        EquipmentUtil.bindDevNoByOrg((AbstractFormPlugin)this, (String)"jqbh", (Long)orgId, null);
        DynamicObject accountObj = AllEleAuthHelper.getAccountByTaxNo((String)((String)model.getValue("salertaxno")));
        Pair accountList = AllEleAuthHelper.getAccountList((DynamicObject)accountObj, (boolean)true);
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"account", (Map)((Map)accountList.getValue()));
        String account = (String)model.getValue("salertaxno");
        if (StringUtils.isBlank((CharSequence)account) && StringUtils.isNotBlank((CharSequence)((CharSequence)accountList.getKey()))) {
            model.setValue("account", accountList.getKey());
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate oprate = (FormOperate)args.getSource();
        if ("newdiscount".equals(oprate.getOperateKey())) {
            DynamicObjectCollection items2 = this.getModel().getEntryEntity("items");
            if (items2.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5546\u54c1\u884c\uff0c\u8bf7\u5148\u6dfb\u52a0\u5546\u54c1\u884c\u518d\u6dfb\u52a0\u6298\u6263\u884c", (String)"GiftReceiptFormPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject item = (DynamicObject)items2.get(items2.size() - 1);
            if ("1".equals(item.getString("rowtype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u884c\u4e3a\u6298\u6263\u884c\uff0c\u4e0d\u80fd\u8fdb\u884c\u6dfb\u52a0\u6298\u6263\u884c", (String)"GiftReceiptFormPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("deleteentry".equals(oprate.getOperateKey())) {
            EntryGrid entry = (EntryGrid)this.getControl("items");
            int selectRow = entry.getSelectRows()[0];
            if (this.isNextDiscountRow(selectRow)) {
                this.getModel().deleteEntryRow("items", selectRow + 1);
            }
        } else if ("printpreview".equals(oprate.getOperateKey())) {
            OperationResult operationResult;
            Map moveConfig = ImcConfigUtil.getValue((String)"bdm_ismc_config_move");
            if (StringUtils.isBlank((CharSequence)((CharSequence)moveConfig.get("bdm_ismc_config_move_cloud_url"))) || StringUtils.isBlank((CharSequence)((CharSequence)moveConfig.get("bdm_ismc_config_move_cloud_accountid")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u79fb\u52a8\u4e91\u4fe1\u606f\uff0c\u65e0\u6cd5\u9884\u89c8\u6253\u5370\u3002", (String)"GiftReceiptFormPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (Objects.equal((Object)pkValue, (Object)0L) && !(operationResult = this.getView().invokeOperation("save", OperateOption.create())).isSuccess()) {
                args.setCancel(true);
            }
        } else if ("save".equals(oprate.getOperateKey())) {
            boolean flag;
            String billNo = (String)this.getModel().getValue("billno");
            if (StringUtils.isNotBlank((CharSequence)billNo) && billNo.length() > 1024) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c0f\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u8d85\u8fc71024\u4e2a\u5b57\u7b26", (String)"GiftReceiptFormPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            boolean bl = flag = GiftReceiptFormPlugin.containsChineseSymbol(billNo) || GiftReceiptFormPlugin.containsChineseSpecialSymbol(billNo);
            if (flag) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c0f\u7968\u6d41\u6c34\u53f7\u5b58\u5728\u975e\u6cd5\u7684\u4e2d\u6587\u6216\u7279\u6b8a\u5b57\u7b26\uff0c\u53ef\u53c2\u8003\u89c4\u5219:\u53ea\u652f\u6301\u6570\u5b57\uff0c\u5927\u5c0f\u5199\u82f1\u6587\u4ee5\u53ca\u90e8\u5206\u7279\u6b8a\u5b57\u7b26\uff1a!#$&'()*+,/:;=?@-._~%`", (String)"GiftReceiptFormPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static boolean containsChineseSymbol(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '\u4e00' || c > '\u9fa5') continue;
            return true;
        }
        return false;
    }

    public static boolean containsChineseSpecialSymbol(String input) {
        String regex = "[\u2000-\u2bff]|[\u2e00-\u2e7f]|[\u3000-\u303f]|[\u3100-\u312f]|[\u3200-\u32ff]|[\u3300-\u33ff]|[\u3400-\u4dbf]|[\u4dc0-\u4dff]|[\u4e00-\u9fff]|[\uf900-\ufaff]|[\ufe30-\ufe4f]|[\uff00-\uffef]";
        return input.matches(".*(" + regex + ").*");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("newdiscount".equals(afterDoOperationEventArgs.getOperateKey())) {
            EntryGrid entry = (EntryGrid)this.getControl("items");
            int selectRow = entry.getSelectRows()[0];
            IDataModel model = this.getModel();
            model.setValue("rowtype", (Object)"1", selectRow);
            int preSelect = selectRow - 1;
            if (selectRow >= 0) {
                model.beginInit();
                model.setValue("goodsname", model.getValue("goodsname", preSelect), selectRow);
                model.setValue("goodsid", model.getValue("goodsid", preSelect), selectRow);
                model.setValue("goodscode", model.getValue("goodscode", preSelect), selectRow);
                model.setValue("taxrate", model.getValue("taxrate", preSelect), selectRow);
                model.endInit();
                this.getView().updateView("goodsname", selectRow);
                this.getView().updateView("goodscode", selectRow);
                this.getView().updateView("taxrate", selectRow);
                this.getView().updateView("goodsid", selectRow);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        String propertyName = e.getProperty().getName();
        switch (e.getProperty().getName()) {
            case "goodsname": {
                this.updateNextDiscountRow(propertyName, changeData.getRowIndex());
                break;
            }
            case "goodsid": {
                String goodsName;
                DynamicObject goodsInfo = (DynamicObject)changeData.getNewValue();
                if (goodsInfo == null) break;
                DynamicObject taxCode = goodsInfo.getDynamicObject("taxcode");
                if (taxCode != null) {
                    taxCode = BusinessDataServiceHelper.loadSingle((Object)taxCode.getPkValue(), (String)"er_taxclasscode");
                    goodsName = String.format("*%s*%s", taxCode.getString("simplename"), goodsInfo.getString("name"));
                    model.setValue("goodscode", (Object)taxCode.getString("mergecode"), changeData.getRowIndex());
                } else {
                    goodsName = goodsInfo.getString("name");
                }
                model.setValue("goodsname", (Object)goodsName, changeData.getRowIndex());
                model.setValue("unit", (Object)goodsInfo.getString("unit"), changeData.getRowIndex());
                model.setValue("specification", (Object)goodsInfo.getString("specifications"), changeData.getRowIndex());
                model.setValue("taxrate", (Object)goodsInfo.getString("taxrate"), changeData.getRowIndex());
                BigDecimal taxUntiPrice = (BigDecimal)model.getValue("taxunitprice", changeData.getRowIndex());
                if (MathUtils.isNullOrZero((BigDecimal)taxUntiPrice)) {
                    String isTaxInclusive = goodsInfo.getString("isinclusive");
                    model.setValue("taxunitprice", goodsInfo.get("1".equals(isTaxInclusive) ? "price" : "prices"), changeData.getRowIndex());
                }
                this.updateNextDiscountRow(propertyName, changeData.getRowIndex());
                break;
            }
            case "taxunitprice": 
            case "num": {
                int rowIndex = changeData.getRowIndex();
                BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
                if (MathUtils.isNullOrZero((BigDecimal)newValue)) {
                    return;
                }
                if (newValue.compareTo(BigDecimal.ZERO) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u884c\u5355\u4ef7\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String)"GiftReceiptFormPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    model.setValue(propertyName, e.getChangeSet()[0].getOldValue(), rowIndex);
                    return;
                }
                boolean isElePaper = AllEleAuthHelper.elePaperSetValue((Object)this.getModel().getValue("salertaxno"), (Object)this.getModel().getValue("invoicetype"));
                boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)this.getModel().getValue("invoicetype"))) || isElePaper;
                model.setValue(propertyName, (Object)UnitPriceHelper.getNumValue((BigDecimal)newValue, (String)("num".equals(propertyName) ? "\u6570\u91cf" : "\u5355\u4ef7")), rowIndex);
                BigDecimal taxunitprice = (BigDecimal)model.getValue("taxunitprice", rowIndex);
                BigDecimal num = (BigDecimal)model.getValue("num", rowIndex);
                if (!MathUtils.isNullOrZero((BigDecimal)taxunitprice) && !MathUtils.isNullOrZero((BigDecimal)num)) {
                    model.setValue("taxamount", (Object)taxunitprice.multiply(num).setScale(2, 4), rowIndex);
                    break;
                }
                if (MathUtils.isNullOrZero((BigDecimal)taxunitprice) && !MathUtils.isNullOrZero((BigDecimal)num)) {
                    BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
                    model.setValue("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle));
                    break;
                }
                if (MathUtils.isNullOrZero((BigDecimal)taxunitprice) || !MathUtils.isNullOrZero((BigDecimal)num)) break;
                BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
                model.setValue("num", (Object)UnitPriceHelper.calcNum((BigDecimal)taxAmount, (BigDecimal)taxunitprice));
                break;
            }
            case "taxrate": {
                this.calcTax(changeData.getRowIndex());
                this.updateNextDiscountRow(propertyName, changeData.getRowIndex());
                break;
            }
            case "taxamount": {
                if ("taxamount".equals(propertyName)) {
                    BigDecimal taxAmount = (BigDecimal)e.getChangeSet()[0].getNewValue();
                    if (MathUtils.isNullOrZero((BigDecimal)taxAmount)) {
                        return;
                    }
                    if (taxAmount.compareTo(BigDecimal.ZERO) < 0 && "0".equals(model.getValue("rowtype"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u884c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"GiftReceiptFormPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        model.setValue(propertyName, e.getChangeSet()[0].getOldValue(), changeData.getRowIndex());
                        return;
                    }
                    if ("1".equals(model.getValue("rowtype"))) {
                        if (taxAmount.compareTo(BigDecimal.ZERO) > 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u884c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"GiftReceiptFormPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                            model.setValue(propertyName, e.getChangeSet()[0].getOldValue(), changeData.getRowIndex());
                            return;
                        }
                        BigDecimal preAmount = (BigDecimal)model.getValue("taxamount", changeData.getRowIndex() - 1);
                        if (preAmount.compareTo(taxAmount.abs()) < 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u884c\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5546\u54c1\u884c", (String)"GiftReceiptFormPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                            model.setValue(propertyName, e.getChangeSet()[0].getOldValue(), changeData.getRowIndex());
                            return;
                        }
                    }
                }
                this.calcTax(changeData.getRowIndex());
            }
        }
    }

    private void calcTax(int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        if (MathUtils.isNullOrZero((BigDecimal)taxAmount)) {
            return;
        }
        BigDecimal num = (BigDecimal)model.getValue("num", rowIndex);
        model.beginInit();
        boolean isElePaper = AllEleAuthHelper.elePaperSetValue((Object)this.getModel().getValue("salertaxno"), (Object)this.getModel().getValue("invoicetype"));
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)this.getModel().getValue("invoicetype"))) || isElePaper;
        model.setValue("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)isAllEle), rowIndex);
        model.endInit();
        this.getView().updateView("taxunitprice", rowIndex);
        String taxRate = (String)model.getValue("taxrate", rowIndex);
        if (StringUtils.isBlank((CharSequence)taxRate)) {
            return;
        }
        model.setValue("tax", (Object)TaxCalcUtil.calTax((BigDecimal)taxAmount, (BigDecimal)BigDecimal.ZERO, (String)taxRate, (boolean)true), rowIndex);
    }

    private void updateNextDiscountRow(String name, int rowIndex) {
        if (this.isNextDiscountRow(rowIndex)) {
            IDataModel model = this.getModel();
            model.setValue(name, model.getValue(name, rowIndex), rowIndex + 1);
        }
    }

    private boolean isNextDiscountRow(int rowIndex) {
        DynamicObjectCollection items2 = this.getModel().getEntryEntity("items");
        if (rowIndex == items2.getRowCount() - 1) {
            return false;
        }
        DynamicObject nextRow = (DynamicObject)items2.get(rowIndex + 1);
        return "1".equals(nextRow.getString("rowtype"));
    }
}

