/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.giftreceipt.op;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.sim.formplugin.billcenter.op.SimIsomerismBillGiftReceiptDisableOp;
import org.apache.commons.collections.CollectionUtils;

public class GiftReceiptDisableOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billcenterid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<Object> billCenterIdList = Arrays.stream(e.getDataEntities()).map(bill -> bill.get("billcenterid")).collect(Collectors.toList());
        this.updateBillCenterGiftStatus(billCenterIdList);
    }

    public void updateBillCenterGiftStatus(List<Object> billCenterIdList) {
        if (CollectionUtils.isNotEmpty(billCenterIdList)) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)String.join((CharSequence)",", "giftbillno", "giftstatus", "pushstatus", "sim_isomerism_item_data.rowpushstatus", "sim_isomerism_item_data.unpushamount", "sim_isomerism_item_data.unpushtax", "sim_isomerism_item_data.unpushnum", "sim_isomerism_item_data.avg_amount", "sim_isomerism_item_data.tax_amount", "sim_isomerism_item_data.product_quantity"), (QFilter[])new QFilter("id", "in", billCenterIdList).toArray());
            SimIsomerismBillGiftReceiptDisableOp simIsomerismBillGiftReceiptDisableOp = new SimIsomerismBillGiftReceiptDisableOp();
            for (DynamicObject bill : bills) {
                simIsomerismBillGiftReceiptDisableOp.setBillUnPush(bill);
            }
            ImcSaveServiceHelper.update((DynamicObject[])bills);
        }
    }
}

