/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.home;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.fs.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.PropertieUtil;

public class InvoiceHomeEquipmentPlugin
extends AbstractFormPlugin {
    protected HistogramChart customChart = null;
    protected static final List<String> names = new ArrayList<String>();
    protected static final List<Integer> values = new ArrayList<Integer>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"refresh"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("refresh".equals(key)) {
            DynamicObject[] orgDy = this.getAllCurrentDevlopmentOrg();
            this.initTool(orgDy);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    private DynamicObject[] getAllCurrentDevlopmentOrg() {
        QFilter filter = new QFilter("id", "in", (Object)OrgHelper.getChildrenOrgIds((long)RequestContext.get().getOrgId(), (boolean)true));
        return BusinessDataServiceHelper.load((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org", (boolean)true), (QFilter[])filter.toArray());
    }

    private void init() {
        DynamicObject[] orgDy = this.getAllCurrentDevlopmentOrg();
        if (orgDy != null && orgDy.length > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_echars"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_none"});
            this.initEchars(orgDy);
            this.paintChart();
            this.initTool(orgDy);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_echars"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_none"});
        }
    }

    private Map<String, Object> getAllOrgCurrentDevl(DynamicObject[] orgDy) {
        HashMap echarsMap = Maps.newHashMapWithExpectedSize((int)orgDy.length);
        HashMap equipmentMap = Maps.newHashMapWithExpectedSize((int)orgDy.length);
        for (DynamicObject object : orgDy) {
            DynamicObject[] equipmentDy = EquipmentUtil.getEquipmentDynamicObjectsByOrg((DynamicObject)object);
            echarsMap.put(object.getString("name"), equipmentDy.length);
            for (DynamicObject equipment : equipmentDy) {
                equipmentMap.put(equipment.getString("equipmentno"), equipment);
            }
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        result.put("echarsMap", echarsMap);
        result.put("equipmentMap", equipmentMap);
        return result;
    }

    private void initEchars(DynamicObject[] orgDy) {
        Map<String, Object> sourceMap = this.getAllOrgCurrentDevl(orgDy);
        Map echarsMap = (Map)sourceMap.get("echarsMap");
        ArrayList entries = new ArrayList(echarsMap.entrySet());
        entries.sort((o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue());
        entries = entries.size() > 10 ? entries.subList(0, 10) : entries;
        names.clear();
        values.clear();
        for (Map.Entry entry : entries) {
            names.add((String)entry.getKey());
            values.add((Integer)entry.getValue());
        }
    }

    private void initTool(DynamicObject[] orgDy) {
        Map<String, Object> sourceMap = this.getAllOrgCurrentDevl(orgDy);
        Map equipmentMap = (Map)sourceMap.get("equipmentMap");
        if (!equipmentMap.isEmpty()) {
            this.equipemntIsOnline(equipmentMap);
        }
    }

    private void equipemntIsOnline(Map<String, DynamicObject> equipmentMap) {
        String url;
        ArrayList onLineMap = Lists.newArrayListWithCapacity((int)equipmentMap.size());
        ArrayList underLineMap = Lists.newArrayListWithCapacity((int)equipmentMap.size());
        Set<Map.Entry<String, DynamicObject>> entries = equipmentMap.entrySet();
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<String, DynamicObject> next : entries) {
            DynamicObject value = next.getValue();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)(RequestContext.get().getTenantId() + next.getKey()));
            jsonObject.put("equipmentname", (Object)value.getString("equipmentname"));
            jsonObject.put("equipmentno", (Object)next.getKey());
            jsonArray.add((Object)jsonObject);
        }
        try {
            url = ComponentServiceHelper.getComponentUrl((String)"");
            if (StringUtils.isBlank((String)url)) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        try {
            String substring = url.substring(0, url.lastIndexOf(47));
            JSONObject jsonObject = ComponentServiceHelper.doPost((String)(substring + "/getClientOnline"), (String)jsonArray.toJSONString());
            JSONArray jsonArrayData = (JSONArray)jsonObject.get((Object)"data");
            for (Object o : jsonArrayData) {
                JSONObject data = (JSONObject)o;
                HashMap equipMap = Maps.newHashMapWithExpectedSize((int)4);
                equipMap.put("equipmentname", data.getString("equipmentname"));
                equipMap.put("equipmentno", data.getString("equipmentno"));
                if ("1".equals(data.getString("onlineStatus"))) {
                    equipMap.put("isonline", "\u221a");
                    onLineMap.add(equipMap);
                    continue;
                }
                equipMap.put("isonline", "\u00d7");
                underLineMap.add(equipMap);
            }
            onLineMap.addAll(underLineMap);
            IDataModel modelDetail = this.getControl("entryentity").getModel();
            this.getModel().deleteEntryData("entryentity");
            for (Map object : onLineMap) {
                int index = this.getModel().createNewEntryRow("entryentity");
                modelDetail.setValue("equipmentname", object.get("equipmentname"), index);
                modelDetail.setValue("equipmentno", object.get("equipmentno"), index);
                modelDetail.setValue("isonline", object.get("isonline"), index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintChart() {
        this.customChart = (HistogramChart)this.getControl("expchart");
        this.customChart.clearData();
        this.customChart.setDraggable(true);
        this.customChart.setShowTooltip(true);
        this.customChart.setTitleAlign(XAlign.left, YAlign.top);
        this.customChart.setMargin(Position.left, "30px");
        this.customChart.setMargin(Position.right, "10px");
        BarSeries barSeries = this.customChart.createBarSeries(ResManager.loadKDString((String)"\u8bbe\u5907\u6570\u91cf", (String)"InvoiceHomeEquipmentPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        if (names.size() < 5) {
            barSeries.setBarWidth("100");
        } else if (names.size() < 9) {
            barSeries.setBarWidth("50");
        } else if (names.size() < 11) {
            barSeries.setBarWidth("45");
        } else {
            barSeries.setBarWidth("4");
        }
        Axis xAxis = this.customChart.createXAxis(ResManager.loadKDString((String)"\u672a\u62a5\u9500\u516c\u53f8", (String)"InvoiceHomeEquipmentPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), AxisType.category);
        HashMap axisLabel = new HashMap();
        xAxis.setPropValue("axisLabel", axisLabel);
        xAxis.setCategorys(names);
        Axis yAxis = this.customChart.createYAxis(ResManager.loadKDString((String)"\u5355\u4f4d: \u4e2a ", (String)"InvoiceHomeEquipmentPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), AxisType.value);
        barSeries.setColor("#5F8AFF");
        for (Integer amount : values) {
            barSeries.addData((Number)amount);
        }
        this.setLableStyle(barSeries);
        this.setLinearGradient(barSeries);
        this.setLineColor(xAxis);
        this.setLineColor(yAxis);
        this.customChart.refresh();
    }

    private void setLableStyle(BarSeries barSeries) {
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.top);
        label.setColor("#5F8AFF");
        label.setFormatter("function(itemValue,index){var itemData = itemValue.value;return itemData.toFixed(0).replace(/\\d{1,3}(?=(\\d{3})+(\\.\\d*)?$)/g,'$&,');}");
        barSeries.setLabel(label);
        ArrayList<String> funPath = new ArrayList<String>();
        funPath.add("label");
        funPath.add("normal");
        funPath.add("formatter");
        barSeries.addFuncPath(funPath);
    }

    private void setLinearGradient(BarSeries barSeries) {
        ArrayList<String> funPath = new ArrayList<String>();
        funPath.add("itemStyle");
        funPath.add("normal");
        funPath.add("color");
        barSeries.addFuncPath(funPath);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 1, 0, 0, [{\"offset\": 0,\"color\": '#5E80EB'}, {\"offset\": 1, \"color\": '#83bff6'}])");
        normap.put("normal", map);
        barSeries.setPropValue("itemStyle", normap);
    }

    private void setLineColor(Axis axix) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#666666");
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

