/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestListDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleTaxPlatformResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.message.constant.RpaErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceBodyDTO;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceBodyResponseDTO;
import kd.imc.sim.common.dto.allele.AllEleUpdateInvoiceStatusRequestDTO;
import kd.imc.sim.common.helper.AllEleQueryListHelper;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import org.apache.commons.lang3.StringUtils;

public class InvoiceBatchAllEleRelatePlugin
extends AbstractFormPlugin {
    private static final Integer issueSuccess = 1;
    private static final Integer issueFailed = 3;

    public void afterCreateNewData(EventObject e) {
        String labelText;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String opt = (String)customParams.get("opt");
        if ("btn_revoke_ori".equals(opt)) {
            labelText = ResManager.loadKDString((String)"\u5982\u679c\u672a\u627e\u5230\u53d1\u7968\uff0c\u53ef\u70b9\u51fb\u3010\u9000\u56de\u5f00\u7968\u7533\u8bf7\u5355\u3011\u6309\u94ae\uff0c\u91cd\u65b0\u4e0b\u63a8\u5f00\u7968\u3002", (String)"InvoiceBatchAllEleRelatePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            this.getView().setVisible(Boolean.FALSE, new String[]{"barinvoice"});
        } else {
            labelText = ResManager.loadKDString((String)"\u5982\u679c\u672a\u627e\u5230\u53d1\u7968\uff0c\u53ef\u70b9\u51fb\u3010\u5f00\u7968\u3011\u6309\u94ae\uff0c\u91cd\u65b0\u53d1\u8d77\u5f00\u7968\u3002", (String)"InvoiceBatchAllEleRelatePlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_revoke_ori"});
        }
        ((Label)this.getControl("labeltext")).setText(labelText);
        customParams.put("requestPath", "queryList");
        if (!AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)customParams)) {
            this.queryList();
        }
        String result = (String)customParams.get("result");
        if (RpaErrorType.RPA_91339_INV_SUCCESS_NO_RESULT.getMessage().equals(result)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"barinvoice", "btn_revoke_ori"});
            ((Label)this.getControl("labeltext")).setText("");
            ((Label)this.getControl("labelap1")).setText(ResManager.loadKDString((String)"\u53d1\u7968\u4e0e\u8ba2\u5355\u5173\u8054\u3002", (String)"InvoiceBatchAllEleRelatePlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        String result = (String)this.getView().getFormShowParameter().getCustomParam("result");
        if (RpaErrorType.RPA_91339_INV_SUCCESS_NO_RESULT.getMessage().equals(result)) {
            return;
        }
        String error = this.getPageCache().get(((Object)((Object)this)).getClass().getName());
        if (StringUtils.isNotBlank((CharSequence)error)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() == 0) {
            if ("btn_revoke_ori".equals(this.getView().getFormShowParameter().getCustomParam("opt"))) {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u5df2\u6838\u5b9e\u672c\u9875\u9762\u53d1\u7968\u4e0e\u5f85\u5f00\u53d1\u7968\u4e0d\u7b26\uff0c\u9700\u8981\u9000\u56de\u5f00\u7968\u7533\u8bf7\u5355\uff1f", (String)"InvoiceBatchAllEleRelatePlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"btn_revoke_ori");
            } else {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u5df2\u6838\u5b9e\u672c\u9875\u9762\u53d1\u7968\u4e0e\u5f85\u5f00\u53d1\u7968\u4e0d\u7b26\uff0c\u9700\u8981\u7ee7\u7eed\u5f00\u7968\uff1f", (String)"InvoiceBatchAllEleRelatePlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"barinvoice");
            }
        }
    }

    private void queryList() {
        try {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            AllEleQueryInvoiceBodyDTO query = new AllEleQueryInvoiceBodyDTO();
            query.setRequest_path(AllEleInterfaceTypeEnum.PAGE_QUERY_INVOICE_BODY.getRequestPath());
            query.setBuyerTaxNo((String)customParams.get("buyertaxno"));
            query.setInvoiceType(Integer.parseInt(Objects.requireNonNull(InvoiceType.getBaseCodeByInvoiceTypeCode((String)((String)customParams.get("invoicetype"))))));
            query.setStartDate((String)customParams.get("issuetime"));
            query.setEndDate(DateUtils.format((Date)new Date()));
            BigDecimal invoiceAmount = (BigDecimal)customParams.get("invoiceamount");
            query.setInvoiceAmount(invoiceAmount == null ? BigDecimal.ZERO : invoiceAmount.setScale(2, 4));
            BigDecimal totalTax = (BigDecimal)customParams.get("totaltax");
            query.setTotalTaxAmount(totalTax == null ? BigDecimal.ZERO : totalTax.setScale(2, 4));
            BigDecimal totalAmount = (BigDecimal)customParams.get("totalamount");
            query.setTotalAmount(totalAmount == null ? BigDecimal.ZERO : totalAmount.setScale(2, 4));
            List allList = AllEleQueryListHelper.getAllList((String)((String)customParams.get("salertaxno")), (AllEleRequestListDTO)query, AllEleQueryInvoiceBodyResponseDTO.class);
            List invoiceNoArr = allList.stream().map(AllEleQueryInvoiceBodyResponseDTO::getInvoiceNo).collect(Collectors.toList());
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)"").and(OrgHelper.getIdFilter(invoiceNoArr, (String)"invoiceno"));
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"invoiceno", (QFilter[])qFilter.toArray());
            Set invoiceNoSet = invoiceCollection.stream().map(invoice -> invoice.getString("invoiceno")).collect(Collectors.toSet());
            allList = allList.stream().filter(invoice -> !invoiceNoSet.contains(invoice.getInvoiceNo())).collect(Collectors.toList());
            if (allList.size() == 0) {
                return;
            }
            this.getModel().batchCreateNewEntryRow("entryentity", allList.size());
            for (int i = 0; i < allList.size(); ++i) {
                AllEleQueryInvoiceBodyResponseDTO invoice2 = (AllEleQueryInvoiceBodyResponseDTO)allList.get(i);
                this.getModel().setValue("invoiceno", (Object)invoice2.getInvoiceNo(), i);
                this.getModel().setValue("issuetime", (Object)invoice2.getInvoiceDate(), i);
                this.getModel().setValue("buyername", (Object)invoice2.getBuyerName(), i);
                this.getModel().setValue("totalamount", (Object)invoice2.getTotalAmount(), i);
                this.getModel().setValue("totaltax", (Object)invoice2.getTotalTaxAmount(), i);
            }
        }
        catch (KDBizException e) {
            this.getPageCache().put(((Object)((Object)this)).getClass().getName(), "error");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"barinvoice", "btn_revoke_ori", "btnok"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"InvoiceBatchAllEleRelatePlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u5df2\u6838\u5b9e\u672c\u9875\u9762\u53d1\u7968\u4e0e\u5f85\u5f00\u53d1\u7968\u4e00\u81f4\uff0c\u9700\u5173\u8054\u5f85\u5f00\u53ca\u53d1\u7968\u6570\u636e\uff1f", (String)"InvoiceBatchAllEleRelatePlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"btnok");
                break;
            }
            case "barinvoice": {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u5df2\u6838\u5b9e\u672c\u9875\u9762\u53d1\u7968\u4e0e\u5f85\u5f00\u53d1\u7968\u4e0d\u7b26\uff0c\u9700\u8981\u7ee7\u7eed\u5f00\u7968\uff1f", (String)"InvoiceBatchAllEleRelatePlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"barinvoice");
                break;
            }
            case "btn_revoke_ori": {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u5df2\u6838\u5b9e\u672c\u9875\u9762\u53d1\u7968\u4e0e\u5f85\u5f00\u53d1\u7968\u4e0d\u7b26\uff0c\u9700\u8981\u9000\u56de\u5f00\u7968\u7533\u8bf7\u5355\uff1f", (String)"InvoiceBatchAllEleRelatePlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"btn_revoke_ori");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("bdm_tax_login".equals(closedCallBackEvent.getActionId())) {
            String requestPath;
            AllEleTaxPlatformResponseDTO response = (AllEleTaxPlatformResponseDTO)closedCallBackEvent.getReturnData();
            if (null == response) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u7535\u8d26\u53f7", (String)"InvoiceBatchAllEleRelatePlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            Map customParams = response.getCustomParams();
            switch (requestPath = (String)customParams.get("requestPath")) {
                case "queryList": {
                    this.queryList();
                    break;
                }
                case "viewinvoice": {
                    this.queryInvoiceFile();
                    break;
                }
                case "btnok": {
                    Object pk = this.getView().getFormShowParameter().getCustomParam("id");
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"sim_vatinvoice");
                    this.writebackInvoice(invoice);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle(customParams.get("id"), (String)"sim_vatinvoice");
        customParams.put("callbackId", messageBoxClosedEvent.getCallBackId());
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "btnok": {
                customParams.put("requestPath", "btnok");
                if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)customParams)) break;
                this.writebackInvoice(invoice);
                break;
            }
            case "barinvoice": {
                this.changeBaseInvoiceStates(invoice, issueFailed);
                IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{invoice});
                this.getView().returnDataToParent((Object)customParams);
                this.getView().close();
                break;
            }
            case "btn_revoke_ori": {
                this.getView().returnDataToParent((Object)customParams);
                this.getView().close();
            }
        }
    }

    private void changeBaseInvoiceStates(DynamicObject invoice, Integer status) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AllEleUpdateInvoiceStatusRequestDTO request = new AllEleUpdateInvoiceStatusRequestDTO();
        request.setRequest_path(AllEleInterfaceTypeEnum.UPDATE_INVOICE_STATUS.getRequestPath());
        request.setStatus(status);
        request.setSerialNo((String)formShowParameter.getCustomParam("orderno"));
        if (issueFailed.equals(status)) {
            request.setInvoiceNo("");
            request.setInvoiceDate("");
        } else {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int selectRow = entryGrid.getSelectRows()[0];
            request.setInvoiceNo((String)this.getModel().getValue("invoiceno", selectRow));
            request.setInvoiceDate((String)this.getModel().getValue("issuetime", selectRow));
        }
        request.setOfdUrl(invoice.getString("fileurl"));
        request.setPdfUrl(invoice.getString("pdffileurl"));
        request.setXmlUrl(invoice.getString("xmlfileurl"));
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)((String)formShowParameter.getCustomParam("salertaxno")), (AllEleRequestDTO)request, null);
        if (!response.getSuccess().booleanValue()) {
            throw new KDBizException(response.getDescription());
        }
    }

    private void writebackInvoice(DynamicObject invoice) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int selectRow = entryGrid.getSelectRows()[0];
        DynamicObject invoiceDown = this.createDownFileInvoice(selectRow);
        JSONObject responseJson = new JSONObject();
        responseJson.put("invoicecode", (Object)"");
        responseJson.put("invoiceno", this.getModel().getValue("invoiceno", selectRow));
        responseJson.put("issuetime", this.getModel().getValue("issuetime", selectRow));
        ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService();
        CountDownLatch countdownlatch = new CountDownLatch(3);
        String pdfFileUrl = (String)this.getModel().getValue("pdffileurl", selectRow);
        executorService.execute(() -> {
            for (int i = 1; i <= 3; ++i) {
                String url = "";
                try {
                    url = i == 2 && StringUtils.isNotBlank((CharSequence)pdfFileUrl) ? pdfFileUrl : InvoiceQueryControl.queryUrl((DynamicObject)invoiceDown, (int)i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                switch (i) {
                    case 1: {
                        responseJson.put("fileurl", (Object)url);
                        invoice.set("fileurl", (Object)url);
                        break;
                    }
                    case 2: {
                        invoice.set("pdffileurl", (Object)url);
                        break;
                    }
                    case 3: {
                        invoice.set("xmlfileurl", (Object)url);
                    }
                }
                countdownlatch.countDown();
            }
        });
        try {
            countdownlatch.await();
            executorService.shutdown();
        }
        catch (Exception e) {
            throw new KDBizException(e.toString());
        }
        this.changeBaseInvoiceStates(invoice, issueSuccess);
        invoice.set("issuesource", (Object)"12");
        IssueInvoiceService.handleIssueResponse((DynamicObject)invoice, (MsgResponse)MsgResponse.valueOfSuccess((String)responseJson.toJSONString()));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("callbackId", "btnok");
        this.getView().returnDataToParent((Object)customParams);
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("viewinvoice".equals(operateKey)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("requestPath", "viewinvoice");
            if (!AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)customParams)) {
                this.queryInvoiceFile();
            }
        }
    }

    private void queryInvoiceFile() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int selectRow = entryGrid.getSelectRows()[0];
        DynamicObject invoice = this.createDownFileInvoice(selectRow);
        String pdfUrl = InvoiceQueryControl.queryUrl((DynamicObject)invoice, (int)2);
        this.getModel().setValue("pdffileurl", (Object)pdfUrl, selectRow);
        this.getView().openUrl(AwsFpyService.replaceUrl((String)pdfUrl));
    }

    private DynamicObject createDownFileInvoice(int selectRow) {
        DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        invoice.set("issuetime", (Object)DateUtils.stringToDate((String)((String)this.getModel().getValue("issuetime", selectRow)), (String)"yyyy-MM-dd HH:mm:ss"));
        invoice.set("invoiceno", this.getModel().getValue("invoiceno", selectRow));
        invoice.set("specialtype", (Object)"");
        invoice.set("salertaxno", this.getView().getFormShowParameter().getCustomParam("salertaxno"));
        return invoice;
    }
}

