/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.service.AwsSyncInvoiceService;

public class AwsSyncInvoicePlugin
extends AbstractListPlugin {
    public void afterCreateNewData(EventObject e) {
        Date today = new Date();
        this.getModel().setValue("daterangefield_startdate", (Object)today);
        this.getModel().setValue("daterangefield_enddate", (Object)today);
        this.loadResult();
    }

    private void loadResult() {
        DynamicObjectCollection orgList;
        QFilter qFilter = new QFilter("enterprisemainorg", "=", (Object)"1").and("epinfo.number", "!=", null).and("epinfo.number", "!=", (Object)"");
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            qFilter.and(OrgHelper.getIdFilter((Collection)userHasPermOrgs.getHasPermOrgs()));
        }
        if (CollectionUtils.isEmpty((Collection)(orgList = QueryServiceHelper.query((String)"bdm_org", (String)String.join((CharSequence)",", "id", "name", "epinfo.name", "epinfo.number"), (QFilter[])qFilter.toArray())))) {
            return;
        }
        Map awsConfigMap = ImcConfigUtil.getValue((String)"dim_imc_config_fpy");
        Map<Object, Object> taxNoClientIdMap = new HashMap<String, String>(orgList.size());
        if ("1".equals(ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"use_tenant_clientid", "dim_imc_config_fpy_use_tenant_clientid"}))) {
            String clientId = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"clientid", "dim_imc_config_fpy_clientid"});
            for (DynamicObject org2 : orgList) {
                String taxNo = org2.getString("epinfo.number");
                taxNoClientIdMap.put(taxNo, clientId);
            }
        } else {
            QFilter enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("taxregnum", "in", (Object)orgList.stream().map(org -> org.getString("epinfo.number")).toArray());
            DynamicObjectCollection configResult = QueryServiceHelper.query((String)"er_bd_kdinvoicecloudcfg", (String)"id,org,taxregnum,firmname,client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{enableQFilter});
            taxNoClientIdMap = configResult.stream().collect(Collectors.toMap(k -> k.getString("taxregnum"), v -> v.getString("client_id"), (v1, v2) -> v1));
        }
        this.getModel().batchCreateNewEntryRow("entryentity", orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)orgList.get(i);
            String taxNo = dynamicObject.getString("epinfo.number");
            this.getModel().setValue("name", (Object)dynamicObject.getString("epinfo.name"), i);
            this.getModel().setValue("taxno", (Object)taxNo, i);
            this.getModel().setValue("orgname", (Object)dynamicObject.getString("name"), i);
            this.getModel().setValue("orgid", (Object)dynamicObject.getString("id"), i);
            this.getModel().setValue("clientid", taxNoClientIdMap.get(taxNo), i);
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        if ("beginsync".equals(evt.getItemKey())) {
            PermissionHelper.checkPermission((String)"bdm", (String)"bdm_his_sync_log", (long)0L, (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
            this.beginSyncAwsInvoice();
        } else {
            this.getView().close();
        }
    }

    private void beginSyncAwsInvoice() {
        this.checkSyncDate();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<String> taxNoList = new ArrayList<String>(selectRows.length);
        for (int rowId : selectRows) {
            String taxNo = (String)this.getModel().getValue("taxno", rowId);
            taxNoList.add(taxNo);
            String clientid = (String)this.getModel().getValue("clientid", rowId);
            if (!StringUtils.isBlank((CharSequence)clientid)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u5bf9\u5e94clientid\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\uff0c\u8bf7\u524d\u5f80\u7cfb\u7edf\u670d\u52a1\u4e91-\u300b\u57fa\u7840\u8d44\u6599-\u300b\u8d22\u52a1\u6570\u636e-\u300b\u53d1\u7968\u4e91\u914d\u7f6e\u4e2d\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"AwsSyncInvoicePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), taxNo));
        }
        QFilter filter = new QFilter("status", "=", (Object)"2").and("tax_no", "in", taxNoList).and("appid", "=", (Object)"sim");
        DynamicObjectCollection hisSyncLogList = QueryServiceHelper.query((String)"bdm_his_sync_log", (String)"tax_no", (QFilter[])new QFilter[]{filter});
        Set existTaxNoSet = hisSyncLogList.stream().map(sync -> sync.getString("tax_no")).collect(Collectors.toSet());
        int failCount = 0;
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(selectRows.length);
        for (Object rowId : (String)selectRows) {
            String taxNo = (String)this.getModel().getValue("taxno", (int)rowId);
            if (existTaxNoSet.contains(taxNo)) {
                ++failCount;
                continue;
            }
            saveList.add(this.createHisSyncLog((int)rowId));
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            ImcSaveServiceHelper.save(saveList);
            this.syncAwsInvoice(saveList.stream().map(DataEntityBase::getPkValue).toArray());
        }
        String msg = failCount > 0 ? String.format(ResManager.loadKDString((String)"\u6210\u529f\u589e\u52a0%s\u4e2a\u540c\u6b65\u4efb\u52a1", (String)"AwsSyncInvoicePlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), saveList.size()) : String.format(ResManager.loadKDString((String)"\u6210\u529f\u589e\u52a0%1$s\u4e2a\u540c\u6b65\u4efb\u52a1,%2$s\u4e2a\u5728\u5904\u7406\u4e2d\u4e0d\u80fd\u91cd\u590d\u589e\u52a0", (String)"AwsSyncInvoicePlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), saveList.size(), failCount);
        this.getView().returnDataToParent((Object)msg);
        this.getView().close();
    }

    private DynamicObject createHisSyncLog(int rowId) {
        DynamicObject syncLog = BusinessDataServiceHelper.newDynamicObject((String)"bdm_his_sync_log");
        String taxNo = (String)this.getModel().getValue("taxno", rowId);
        String taxName = (String)this.getModel().getValue("name", rowId);
        Object orgId = this.getModel().getValue("orgid", rowId);
        syncLog.set("deal_times", (Object)0);
        syncLog.set("start_time", (Object)new Date());
        syncLog.set("org", orgId);
        syncLog.set("success", (Object)0);
        syncLog.set("page_no", (Object)0);
        syncLog.set("tax_no", (Object)taxNo);
        syncLog.set("company_name", (Object)taxName);
        syncLog.set("appid", (Object)"sim");
        syncLog.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
        syncLog.set("data_date", (Object)"");
        syncLog.set("data_date_start", this.getModel().getValue("daterangefield_startdate"));
        syncLog.set("data_date_end", this.getModel().getValue("daterangefield_enddate"));
        syncLog.set("sync_type", (Object)"0");
        syncLog.set("status", (Object)"2");
        syncLog.set("clientid", this.getModel().getValue("clientid", rowId));
        return syncLog;
    }

    public void checkSyncDate() {
        Object startDate = this.getModel().getValue("daterangefield_startdate");
        Object endDate = this.getModel().getValue("daterangefield_enddate");
        if (startDate == null || endDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u6b65\u65f6\u95f4", (String)"AwsSyncInvoicePlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u540c\u6b65\u53d1\u7968\u7684\u4f01\u4e1a", (String)"AwsSyncInvoicePlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public void syncAwsInvoice(Object[] pkValue) {
        RequestContext requestContext = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"imc_issue_syncawsinvoice_asyncBackTask", () -> {
            RequestContext.copyAndSet((RequestContext)requestContext);
            AwsSyncInvoiceService.awsBatchSyncInvoice((Object[])pkValue);
        });
    }
}

