/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.sim.common.utils.MathUtils;

public class DiscountDialogPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams != null) {
            double result1 = Double.parseDouble(String.valueOf(customParams.get("taxrate")));
            DecimalFormat df = new DecimalFormat("0%");
            String r = df.format(result1);
            this.getModel().setValue("taxrate", (Object)r);
            this.getModel().setValue("amount", customParams.get("amount"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal amount;
        String change = this.getPageCache().get("change");
        this.getPageCache().remove("change");
        if (!"discountrate".equals(change) && "discountrate".equals(e.getProperty().getName())) {
            BigDecimal rate = (BigDecimal)e.getChangeSet()[0].getNewValue();
            amount = new BigDecimal((String)this.getModel().getValue("amount"));
            this.getPageCache().put("change", "discount");
            this.getModel().setValue("discount", (Object)amount.multiply(rate).divide(new BigDecimal(100), 2, 4));
        }
        if (!"discount".equals(change) && "discount".equals(e.getProperty().getName())) {
            BigDecimal discount = (BigDecimal)e.getChangeSet()[0].getNewValue();
            amount = new BigDecimal((String)this.getModel().getValue("amount"));
            this.getPageCache().put("change", "discountrate");
            this.getModel().setValue("discountrate", (Object)discount.multiply(new BigDecimal(100)).divide(amount, 2, 4));
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("confirm".equals(source.getKey())) {
            BigDecimal amount;
            BigDecimal discount = (BigDecimal)this.getModel().getValue("discount");
            if (discount.compareTo(amount = new BigDecimal((String)this.getModel().getValue("amount"))) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u660e\u7ec6\u91d1\u989d", (String)"DiscountDialogPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (MathUtils.isZero((BigDecimal)discount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"DiscountDialogPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)discount);
            this.getView().close();
        }
    }
}

