/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.CommonConstant;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.plugin.AbstractImportPlugin;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.service.InvoiceAddServiceImpl;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.invoicebatch.InvoiceBatchFileImportUtil;
import kd.imc.sim.formplugin.issuing.util.InvoiceImportDialogUtil;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class InvoiceImportDialogPlugin
extends AbstractImportPlugin
implements SimFormPluginConstellationUntrans {
    private static final String TEMPLATE_DIR = "excel_templates";
    private static final String TEMPLATE_JSON_NAME = "InvoiceImport.json";

    public void afterCreateNewData(EventObject evt) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"special_template"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("special_template".equals(control.getKey())) {
            ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)"\u589e\u503c\u7a0e\u53d1\u7968\uff08\u901a\u884c\u8d39\uff09\u5bfc\u5165\u6a21\u677f.xlsx");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void uploadFile(String filepath, InputStream inputStream, Workbook workbook) throws Exception {
        String suffix = filepath.substring(filepath.lastIndexOf(46));
        String str = ExcelHelper.getErrorExcelFileName((String)filepath, (String)suffix);
        if (ExcelHelper.isExcelFile((String)suffix)) {
            void var18_21;
            int failRowNum;
            DynamicObject[] savedObjs;
            int startRow = 2;
            int dataNum = workbook.getSheetAt(0).getLastRowNum() - startRow + 1;
            if (dataNum < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5145\u6570\u636e\u518d\u5f15\u5165", (String)"InvoiceImportDialogPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                return;
            }
            if (dataNum > 5000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u5f15\u51655000\u53d1\u7968\u4fe1\u606f", (String)"InvoiceImportDialogPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                return;
            }
            List templateFileFields = ExcelHelper.readTemplate((String)TEMPLATE_DIR, (String)TEMPLATE_JSON_NAME);
            Row titleRow = workbook.getSheetAt(0).getRow(startRow - 1);
            List titleCellList = ExcelHelper.replaceAsterisk((Row)titleRow);
            HashSet<String> removeField = new HashSet<String>(16);
            if (titleCellList.contains("\u8f66\u724c\u53f7")) {
                removeField.add("\u5546\u54c1\u540d\u79f0");
                removeField.add("\u89c4\u683c\u578b\u53f7");
                removeField.add("\u5355\u4f4d");
                removeField.add("\u6570\u91cf");
            } else {
                removeField.add("\u9879\u76ee\u540d\u79f0");
                removeField.add("\u8f66\u724c\u53f7");
            }
            templateFileFields.removeIf(field -> removeField.contains(field.getFieldName()));
            List fileFields = ExcelHelper.getFileFields((Row)titleRow, (List)templateFileFields);
            Map<String, FileField> fieldMap = fileFields.stream().collect(Collectors.toMap(FileField::getFieldCode, t -> t, (v1, v2) -> v1));
            HashMap<String, String> errMap = new HashMap<String, String>();
            Map mapList = InvoiceBatchFileImportUtil.doParse((Workbook)workbook, (List)fileFields, (int)2, errMap, (String)"invoice");
            if (mapList.isEmpty()) {
                InvoiceBatchFileImportUtil.showBatchFileImportResult((Workbook)workbook, (String)str, (IFormView)this.getView(), (int)0, (int)dataNum, errMap);
                return;
            }
            List<DynamicObject> objs = this.checkAndFillData(mapList, fieldMap, errMap);
            InvoiceUtils.dealInvoicesListMark(new HashMap(), objs);
            for (DynamicObject dynamicObject : objs) {
                IssueInvoiceService.updateDiscountInfo((DynamicObject)dynamicObject);
            }
            for (DynamicObject obj : savedObjs = (DynamicObject[])ImcSaveServiceHelper.save(objs)) {
                WideInvoiceSevice.addInvoiceToWide((DynamicObject)obj);
            }
            boolean bl = false;
            if (!objs.isEmpty()) {
                for (DynamicObject numObject : objs) {
                    DynamicObjectCollection numCollection = numObject.getDynamicObjectCollection("items");
                    var18_21 += numCollection.size();
                }
            }
            if ((failRowNum = workbook.getSheetAt(0).getLastRowNum() - 1 - var18_21) > 0) {
                InvoiceBatchFileImportUtil.showBatchFileImportResult((Workbook)workbook, (String)str, (IFormView)this.getView(), (int)var18_21, (int)failRowNum, errMap);
            } else {
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u6a21\u677f\u7684Excel\u6587\u4ef6", (String)"InvoiceImportDialogPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private List<DynamicObject> checkAndFillData(Map<String, LinkedList<Map<String, Object>>> mapList, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(mapList.size());
        Map TAX_NUMBER_MAP = InvoiceBatchFileImportUtil.queryTaxNumber();
        mapList.forEach((key, value) -> InvoiceImportDialogUtil.formatExcelData((LinkedList)value));
        String batchNumber = DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        DynamicObject epBaseInfo = TaxUtils.getEnterpriseDynamicObjectByOrg((Long)RequestContext.get().getOrgId());
        HashSet<String> invoicecodes = new HashSet<String>(mapList.size());
        for (String invoiceKey : mapList.keySet()) {
            invoicecodes.add(invoiceKey.substring(0, invoiceKey.length() - 8));
        }
        QFilter filter = new QFilter("invoicecode", "in", (Object)invoicecodes.toArray());
        DynamicObject[] invoiceArr = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoicecode,invoiceno", (QFilter[])filter.toArray());
        ArrayList codeNoList = Lists.newArrayListWithCapacity((int)invoiceArr.length);
        for (DynamicObject dy : invoiceArr) {
            codeNoList.add(dy.getString("invoicecode") + dy.getString("invoiceno"));
        }
        Set<Map.Entry<String, LinkedList<Map<String, Object>>>> entries = mapList.entrySet();
        for (Map.Entry<String, LinkedList<Map<String, Object>>> stringLinkedListEntry : entries) {
            Row row;
            DynamicObject dynamicObject;
            Boolean deatilCheck;
            LinkedList<Map<String, Object>> dyMap = stringLinkedListEntry.getValue();
            Boolean baseCheck = InvoiceImportDialogUtil.invoiceBaseCheck(dyMap, fieldMap, (ArrayList)codeNoList, (Map)TAX_NUMBER_MAP, (String)epBaseInfo.getString("number"), errMap);
            if (!baseCheck.booleanValue() || !(deatilCheck = InvoiceImportDialogUtil.checkDetailAndCount((DynamicObject)(dynamicObject = this.mapToDynamicObject(dyMap, batchNumber, BillStatusEnum.TEMP_SAVE.getCode())), fieldMap, (Row)(row = (Row)dyMap.get(0).get("row")), errMap)).booleanValue()) continue;
            dynamicObjectList.add(dynamicObject);
        }
        return dynamicObjectList;
    }

    private DynamicObject mapToDynamicObject(LinkedList<Map<String, Object>> linkedMap, String batchNumber, String billStatus) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.map2DynamicObject(linkedMap.get(0), (DynamicObject)dynamicObject);
        DynamicObjectCollection dc = dynamicObject.getDynamicObjectCollection("items");
        String invoiceType = DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)dynamicObject, (String)"invoicetype") ? dynamicObject.getString("invoicetype") : "";
        String iselepaper = DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)dynamicObject, (String)"iselepaper") ? dynamicObject.getString("iselepaper") : "";
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(iselepaper);
        for (Map map : linkedMap) {
            BigDecimal unitPrice;
            BigDecimal amount = new BigDecimal(map.get("amount").toString());
            BigDecimal taxAmount = new BigDecimal(map.get("tax").toString());
            map.put("taxamount", amount.add(taxAmount));
            if (StringUtils.isNotBlank(map.get("unitprice")) && !MathUtils.isZero((BigDecimal)(unitPrice = new BigDecimal(map.get("unitprice").toString())))) {
                BigDecimal num = new BigDecimal(map.get("num").toString());
                BigDecimal hsdj = PriceHelper.calcPriceOrNum((BigDecimal)amount.add(taxAmount), (BigDecimal)num, (boolean)isAllEle);
                map.put("taxunitprice", hsdj);
            }
            DynamicObjectUtil.map2DynamicObject((Map)map, (DynamicObject)dc.addNew());
        }
        dynamicObject.set("orderno", (Object)UUID.randomUUID());
        dynamicObject.set("batchbelong", (Object)batchNumber);
        dynamicObject.set("billdate", (Object)new Date());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("orgid", (Object)RequestContext.get().getOrgId());
        dynamicObject.set("buyertype", (Object)"8");
        dynamicObject.set("hsbz", (Object)"0");
        dynamicObject.set("issuestatus", (Object)"0");
        dynamicObject.set("pushstatus", (Object)"4");
        dynamicObject.set("downloadflag", (Object)"0");
        dynamicObject.set("printflag", (Object)"0");
        dynamicObject.set("inventorymark", (Object)"0");
        dynamicObject.set("specialtype", (Object)"00");
        dynamicObject.set("billstatus", (Object)billStatus);
        dynamicObject.set("ofdstatus", (Object)"0");
        dynamicObject.set("reissuestatus", (Object)"0");
        if (StringUtils.isNotBlank((Object)dynamicObject.get("buyertaxno"))) {
            dynamicObject.set("buyerproperty", (Object)"0");
        } else {
            dynamicObject.set("buyerproperty", (Object)"1");
        }
        if (StringUtils.isNotBlank((CharSequence)((DynamicObject)dc.get(0)).getString("vehplate"))) {
            if (((DynamicObject)dc.get(0)).getBigDecimal("tax").compareTo(BigDecimal.ZERO) == 0) {
                dynamicObject.set("specialtype", (Object)"07");
            } else {
                dynamicObject.set("specialtype", (Object)"06");
            }
            new InvoiceAddServiceImpl().updateBaseInvoiceInvoiceType("15", dynamicObject);
        } else {
            IssueInvoiceService.updateBaseInvoiceType((DynamicObject)dynamicObject);
        }
        InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)dynamicObject);
        IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)dynamicObject);
        return dynamicObject;
    }

    protected void downloadTemplate() {
        ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)"\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u5bfc\u5165\u6a21\u677f.xlsx");
    }

    public void pageRelease(EventObject e) {
        CacheHelper.remove((String)this.getView().getPageId());
    }
}

