/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.ImcLicenseServiceHelper;
import kd.imc.bdm.common.helper.MsgSendAuthHelper;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.SendMsgEmailService;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;

public class InvoiceMessageResendLabelPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvoiceMessageResendLabelPlugin.class);
    private static final String ONE_INVOICE_SEND = "1";
    private static final String ALL_INVOICE_SEND = "2";

    public void afterCreateNewData(EventObject e) {
        this.loadOldPhoneAndEmailView();
        this.loadSameEmailView();
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("oldinfotab");
    }

    public void registerListener(EventObject o) {
        this.addClickListeners(new String[]{"emailbutresend", "phonebutresend"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        switch (control.getKey()) {
            case "emailbutresend": {
                Object email = this.getModel().getValue("buyeremail");
                if (email == null || "".equals(email)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u63a8\u9001\u7684\u90ae\u7bb1\u53f7\uff01", (String)"InvoiceMessageResendLabelPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                String[] mails = email.toString().split(";");
                if (mails.length > 10) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u586b\u516510\u4e2a\u90ae\u7bb1", (String)"InvoiceMessageResendLabelPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                for (String string : mails) {
                    if (RegexUtil.isEmail((String)string)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceMessageResendLabelPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                JSONArray pkArray = JSONArray.parseArray((String)customParams.get("pks").toString());
                DynamicObject[] selectedInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "fileurl", "xmlfileurl", "pdffileurl", "invoicetype", "invoiceno", "orgid"), (QFilter[])new QFilter("id", "in", (Object)pkArray.toArray()).toArray());
                CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BTN_RE_SEND, (String)"sim_vatinvoice", (DynamicObject[])selectedInvoices);
                if (ONE_INVOICE_SEND.equals(this.getModel().getValue("sendway"))) {
                    boolean needQueryUrl = false;
                    for (DynamicObject invoice : selectedInvoices) {
                        if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || !StringUtils.isBlank((CharSequence)invoice.getString("fileurl")) && !StringUtils.isBlank((CharSequence)invoice.getString("xmlfileurl")) && !StringUtils.isBlank((CharSequence)invoice.getString("pdffileurl"))) continue;
                        needQueryUrl = true;
                        break;
                    }
                    if (needQueryUrl) {
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("continueSendArray", (Object)pkArray);
                        jSONObject.put("oneInvoiceSend", (Object)"oneInvoiceSend");
                        jSONObject.put("email", (Object)email.toString());
                        this.getView().returnDataToParent((Object)jSONObject);
                        this.getView().close();
                        break;
                    }
                    this.doEmailsResend(email.toString());
                    break;
                }
                JSONObject sendResult = new JSONObject();
                pkArray = JSONArray.parseArray((String)customParams.get("pks").toString());
                sendResult.put("continueSendArray", (Object)pkArray);
                sendResult.put("email", (Object)email.toString());
                this.getView().returnDataToParent((Object)sendResult);
                this.getView().close();
                break;
            }
            case "phonebutresend": {
                JSONArray jsonArray = (JSONArray)customParams.get("pks");
                JSONArray jSONArray = JSONArray.parseArray((String)"[]");
                if (customParams.size() > 0) {
                    DynamicObject[] dObject = BusinessDataServiceHelper.load((Object[])jsonArray.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
                    CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BTN_RE_SEND, (String)"sim_vatinvoice", (DynamicObject[])dObject);
                    StringBuilder invoiceNoBuilder = new StringBuilder();
                    for (DynamicObject dynamicObject : dObject) {
                        if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("fileurl"))) continue;
                        invoiceNoBuilder.append(dynamicObject.getString("invoiceno")).append('\u3001');
                    }
                    String invoiceNosStr = invoiceNoBuilder.toString();
                    if (StringUtils.isNotBlank((CharSequence)invoiceNosStr)) {
                        invoiceNosStr = invoiceNosStr.substring(0, invoiceNosStr.length() - 1);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s\u7684\u53d1\u7968\u6587\u4ef6\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u4e0d\u652f\u6301\u91cd\u53d1,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceMessageResendLabelPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceNosStr), Integer.valueOf(6000));
                        return;
                    }
                    ArrayList<String> phoneList = new ArrayList<String>(dObject.length);
                    for (DynamicObject dynamicObject : dObject) {
                        String buyerPhone = dynamicObject.getString("buyerphone");
                        if (StringUtils.isBlank((CharSequence)buyerPhone)) continue;
                        if (!MsgSendAuthHelper.authEpInfoByTaxNo((String)dynamicObject.getString("salertaxno"))) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8fd8\u672a\u5f00\u901a\u53d1\u7968\u4e91\u77ed\u4fe1\u670d\u52a1\uff0c\u65e0\u6cd5\u63a8\u9001\u53d1\u7968\u77ed\u4fe1\u3002\u8bf7\u5148\u5728\u5f00\u7968\u53c2\u6570\u8bbe\u7f6e/\u5f00\u7968\u5176\u4ed6\u4fe1\u606f\u8bbe\u7f6e/\u77ed\u4fe1\u63a8\u9001\u6743\u9650\u63a7\u5236\u4e2d\u5f00\u542f\u77ed\u4fe1\u670d\u52a1\u53c2\u6570", (String)"InvoiceMessageResendLabelPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        phoneList.add(buyerPhone);
                    }
                    if (!CollectionUtils.isEmpty(phoneList) && ImcLicenseServiceHelper.getInvoiceMsgAuth() == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u77ed\u4fe1\u4f59\u91cf\u4e3a0\uff0c\u65e0\u6cd5\u63a8\u9001\u77ed\u4fe1\uff0c\u8bf7\u8d2d\u4e70\u77ed\u4fe1\u8bb8\u53ef\u670d\u52a1\u540e\u518d\u8fdb\u884c\u77ed\u4fe1\u63a8\u9001", (String)"InvoiceMessageResendLabelPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    List msgNumBiggerThanFive = Arrays.stream(dObject).filter(o -> o.getInt("msgresendnum") > 4).collect(Collectors.toList());
                    if (msgNumBiggerThanFive.size() > 0) {
                        List invoiceNos = msgNumBiggerThanFive.stream().map(o -> o.getString("invoiceno")).collect(Collectors.toList());
                        ViewUtil.openConfirm((String)"confirmResendMsg", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u77ed\u4fe1\u91cd\u53d1\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u70b9\u51fb'\u7ee7\u7eed\u53d1\u9001'\u5c06\u5ffd\u7565\u4ee5\u4e0b\u53d1\u7968", (String)"InvoiceMessageResendLabelPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceMessageResendLabelPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7ee7\u7eed\u53d1\u9001", (String)"InvoiceMessageResendLabelPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)String.join((CharSequence)"\u3001", invoiceNos));
                        return;
                    }
                    this.doMsgAndEmailResends(jSONArray, dObject);
                }
                JSONObject sendResult = new JSONObject();
                sendResult.put("sendResult", (Object)jSONArray);
                this.getView().returnDataToParent((Object)sendResult);
                this.getView().close();
            }
        }
    }

    private void doMsgAndEmailResends(JSONArray strList, DynamicObject[] dObject) {
        for (DynamicObject dynamicObject : dObject) {
            LOGGER.info("\u77ed\u4fe1\u548c\u90ae\u4ef6\u6279\u91cf\u91cd\u53d1emailandmsgresendtogether___\u53d1\u7968\u53f7\u7801\uff1a" + dynamicObject.getString("invoiceno"));
            JSONObject pushJson = SendMsgEmailService.sendMultiMsgJson((DynamicObject)dynamicObject, (String)dynamicObject.getString("buyerphone"), (String)dynamicObject.getString("buyeremail"));
            String pushStatus = pushJson.getString("pushStatus");
            String emailErrorMsg = pushJson.getString("emailErrorMsg");
            if (StringUtils.isNotBlank((CharSequence)emailErrorMsg)) {
                throw new KDBizException(emailErrorMsg);
            }
            String phoneErrorMsg = pushJson.getString("phoneErrorMsg");
            if (StringUtils.isNotBlank((CharSequence)phoneErrorMsg)) {
                throw new KDBizException(phoneErrorMsg);
            }
            if ("0".equals(pushStatus)) continue;
            strList.add((Object)dynamicObject.getString("invoiceno"));
        }
    }

    private void loadOldPhoneAndEmailView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object[] pks = JSONArray.parseArray((String)customParams.get("pks").toString()).toArray();
        Label label = (Label)this.getControl("uplable");
        label.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5171\u8ba1\u9009\u62e9%s\u5f20\u7535\u5b50\u53d1\u7968\uff0c\u5c06\u6309\u7167\u6536\u7968\u624b\u673a", (String)"InvoiceMessageResendLabelPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), pks.length));
    }

    private void loadSameEmailView() {
    }

    private void doEmailsResend(String email) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray strList = JSONArray.parseArray((String)"[]");
        if (customParams.size() > 0) {
            JSONArray pk = JSONArray.parseArray((String)customParams.get("pks").toString());
            LOGGER.info("\u540c\u4e00\u90ae\u7bb1\u90ae\u4ef6\u6279\u91cf\u91cd\u53d1emailresendtogether\uff1a" + pk.toJSONString());
            for (Object strPk : pk) {
                DynamicObject dObject = BusinessDataServiceHelper.loadSingle((Object)strPk.toString(), (String)"sim_vatinvoice");
                LOGGER.info("\u540c\u4e00\u90ae\u7bb1\u90ae\u4ef6\u6279\u91cf\u91cd\u53d1emailresendtogether__\u53d1\u7968\u53f7\u7801:" + dObject.getString("invoiceno"));
                MsgResponse reponse = SendMsgEmailService.emailMultiDefaultOrBySelf((DynamicObject)dObject, (String)email);
                boolean emailUpdate = "0000".equals(reponse.getErrorCode());
                if (emailUpdate) {
                    dObject.set("buyerphone", (Object)"");
                    dObject.set("buyeremail", (Object)email);
                    dObject.set("pushstatus", (Object)"0");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                    continue;
                }
                strList.add((Object)dObject.getString("invoiceno"));
            }
        }
        JSONObject returnMap = new JSONObject();
        returnMap.put("sendResult", (Object)strList);
        this.getView().returnDataToParent((Object)returnMap);
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes != event.getResult()) {
            return;
        }
        if ("confirmResendMsg".equals(event.getCallBackId())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONArray strList = JSONArray.parseArray((String)"[]");
            Object[] pks = JSONArray.parseArray((String)customParams.get("pks").toString()).toArray();
            DynamicObject[] dObject = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            List<DynamicObject> resendDy = Arrays.stream(dObject).filter(o -> o.getInt("msgresendnum") < 5).collect(Collectors.toList());
            if (resendDy.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u77ed\u4fe1\u91cd\u53d1\u6b21\u6570\u5747\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceMessageResendLabelPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.doMsgAndEmailResends(strList, resendDy.toArray(new DynamicObject[0]));
            JSONObject sendResult = new JSONObject();
            sendResult.put("sendResult", (Object)strList);
            this.getView().returnDataToParent((Object)sendResult);
            this.getView().close();
        }
    }
}

