/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.ShowTipsConstant;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.dto.syncinvoice.SyncQueryInvoiceDTO;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceBaseControl;
import kd.imc.sim.formplugin.issuing.control.InvoiceSyncControl;
import kd.imc.sim.schedule.syncinvoice.SyncDevInvoiceTask;

public class InvoiceSyncPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvoiceSyncPlugin.class);
    private static final String SYNC_WAY_LEQI = "2";

    public void afterCreateNewData(EventObject e) {
        try {
            this.initLoadPage("1");
            DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObject((Long)RequestContext.get().getOrgId());
            if (orgDynamicObject != null) {
                this.getView().getModel().setValue("orgid", (Object)orgDynamicObject);
            }
        }
        catch (Exception e1) {
            LOGGER.error("\u540c\u6b65\u53d1\u7968\u521d\u59cb\u5316\u9519\u8bef", (Object)e);
        }
    }

    private void initInvoiceTypeMode(boolean mathInvoice) {
        ArrayList<ComboItem> items2 = new ArrayList<ComboItem>(5);
        items2.add(new ComboItem(new LocaleString("\u4e0d\u9650"), "-1"));
        if (mathInvoice) {
            items2.add(new ComboItem(new LocaleString(InvoiceType.ALL_E_NORMAL.getDescription()), InvoiceType.ALL_E_NORMAL.getTypeCode()));
            items2.add(new ComboItem(new LocaleString(InvoiceType.ALL_E_SPECIAL.getDescription()), InvoiceType.ALL_E_SPECIAL.getTypeCode()));
        }
        items2.add(new ComboItem(new LocaleString(InvoiceType.PAPER_SPECIAL_INVOICE.getDescription()), InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCodeHx()));
        items2.add(new ComboItem(new LocaleString(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getDescription()), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCodeHx()));
        items2.add(new ComboItem(new LocaleString(InvoiceType.PAPER_NOMAL_INVOICE.getDescription()), InvoiceType.PAPER_NOMAL_INVOICE.getTypeCodeHx()));
        items2.add(new ComboItem(new LocaleString(InvoiceType.ELECTRICAL_NORMAL_INVOICE.getDescription()), InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCodeHx()));
        items2.add(new ComboItem(new LocaleString(InvoiceType.PAPER_VOLUME_INVOICE.getDescription()), InvoiceType.PAPER_VOLUME_INVOICE.getTypeCodeHx()));
        ComboEdit comboEdit = (ComboEdit)this.getControl("invoicetype");
        comboEdit.setComboItems(items2);
        this.getModel().setValue("invoicetype", (Object)"-1");
    }

    private void initLoadPage(String syncType) {
        this.getModel().setValue("equipmentno", (Object)"");
        this.getModel().setValue("issueaccount", (Object)"");
        this.getModel().setValue("terminalno", (Object)"");
        this.getModel().setValue("synctype", (Object)syncType);
        Date startDate = DateUtils.getFirstDateOfMonth((Date)new Date());
        Date endDate = new Date();
        this.getModel().setValue("issuedate_startdate", (Object)startDate);
        this.getModel().setValue("issuedate_enddate", (Object)endDate);
        if (StringUtils.equals((CharSequence)syncType, (CharSequence)SYNC_WAY_LEQI)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"equipmentno"});
            this.initInvoiceTypeMode(false);
        } else {
            this.initInvoiceTypeMode(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"equipmentno", "issueaccount", "terminalno"});
            ComboEdit equipEdits = (ComboEdit)this.getView().getControl("equipmentno");
            equipEdits.setMustInput(false);
        }
    }

    private void initEquipment(DynamicObject orgDynamicObject, String syncType) {
        try {
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgDynamicObject.getLong("id"));
            if (StringUtils.equals((CharSequence)syncType, (CharSequence)SYNC_WAY_LEQI)) {
                this.syncDevData(saleInfo, orgDynamicObject);
            } else {
                this.syncMathData(saleInfo);
            }
        }
        catch (KDBizException e) {
            LOGGER.error("\u521d\u59cb\u5316\u9875\u9762\u6570\u636e\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)syncType);
            LOGGER.error("\u521d\u59cb\u5316\u9875\u9762\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    private void syncMathData(SaleInfo saleInfo) {
        QFilter qFilter;
        DynamicObject[] accounts;
        boolean isLqpt = EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo());
        if (isLqpt) {
            LOGGER.info("\u5207\u6362\u4e3a\u4e50\u4f01\u5e73\u53f0\u6388\u6743...");
        }
        if ((accounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)"alleinvoiceaccount", (QFilter[])(qFilter = new QFilter("taxno", "=", (Object)saleInfo.getSaleTaxNo())).toArray())).length > 0) {
            ArrayList comboItems = new ArrayList(8);
            Set<String> accountSet = Arrays.stream(accounts).map(o -> o.getString("alleinvoiceaccount")).collect(Collectors.toSet());
            accountSet.forEach(account -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(account));
                comboItem.setValue(account);
                comboItems.add(comboItem);
            });
            ComboEdit comboEdit = (ComboEdit)this.getControl("issueaccount");
            comboEdit.setComboItems(comboItems);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"equipmentno", "terminalno"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"issueaccount"});
        ComboEdit equipEdits = (ComboEdit)this.getView().getControl("equipmentno");
        equipEdits.setMustInput(false);
    }

    private void syncDevData(SaleInfo saleInfo, DynamicObject orgDynamicObject) {
        if (saleInfo.getDevNoList() == null) {
            throw new KDBizException(ShowTipsConstant.getORG_UNBIND_ENTERPRISE());
        }
        EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)this, (long)orgDynamicObject.getLong("id"), (String)saleInfo.getSaleTaxNo(), (String)"equipmentno", (String)"terminalno", (boolean)true);
        this.getModel().setValue("equipmentno", (Object)saleInfo.getDefaultDev());
        ComboEdit equipEdits = (ComboEdit)this.getView().getControl("equipmentno");
        equipEdits.setMustInput(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        String name = prop.getName();
        if ("issuedate_enddate".equals(name)) {
            Date startDate = (Date)this.getModel().getValue("issuedate_startdate");
            Date endDate = (Date)this.getModel().getValue("issuedate_enddate");
            if (null == endDate) {
                return;
            }
            Date lastDate = DateUtils.getLastDateOfMonth((Date)startDate);
            if (lastDate.compareTo(endDate) < 0) {
                this.getModel().setValue("issuedate_enddate", (Object)lastDate);
            }
        } else if ("equipmentno".equals(name)) {
            String equipmentNo = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)equipmentNo)) {
                return;
            }
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)CreateInvoiceBaseControl.getOrgIdByView((AbstractFormPlugin)this));
            EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)equipmentNo, (String)saleInfo.getSaleTaxNo(), (String)"terminalno", (boolean)false);
        } else if ("orgid".equals(name)) {
            DynamicObject orgDynamicObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            String synctype = (String)this.getModel().getValue("synctype");
            if (orgDynamicObject == null) {
                return;
            }
            DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgDynamicObject.getPkValue(), (DynamicObjectType)orgDynamicObject.getDynamicObjectType());
            this.initLoadPage(synctype);
            this.initEquipment(orgObject, synctype);
        } else if ("synctype".equals(name)) {
            String newyncType = (String)e.getChangeSet()[0].getNewValue();
            this.initLoadPage(newyncType);
            DynamicObject orgDynamicObject = (DynamicObject)this.getModel().getValue("orgid");
            if (orgDynamicObject == null) {
                return;
            }
            DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgDynamicObject.getPkValue(), (DynamicObjectType)orgDynamicObject.getDynamicObjectType());
            this.initEquipment(orgObject, newyncType);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm_sync"});
        this.addClickListeners(new String[]{"cancel"});
    }

    public void click(EventObject evt) {
        boolean isLqpt;
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (!"confirm_sync".equals(key)) {
            this.getView().close();
            return;
        }
        DynamicObject orgObject = (DynamicObject)this.getView().getModel().getValue("orgid");
        if (orgObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u4fe1\u606f", (String)"InvoiceSyncPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        PermissionHelper.checkPermission((String)"sim", (String)"sim_vatinvoice", (long)CreateInvoiceBaseControl.getOrgIdByView((AbstractFormPlugin)this), (ImcPermItemEnum)ImcPermItemEnum.INVOICE_SYNC);
        String syncType = (String)this.getModel().getValue("synctype");
        String syncWay = (String)this.getModel().getValue("syncway");
        if (!StringUtils.equals((CharSequence)syncType, (CharSequence)"1")) {
            try {
                this.downloadDevInvoices("");
            }
            catch (MsgException e) {
                this.getView().showTipNotification(e.getErrorMsg(), Integer.valueOf(5000));
            }
            return;
        }
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)CreateInvoiceBaseControl.getOrgIdByView((AbstractFormPlugin)this));
        String saleTaxNo = saleInfo.getSaleTaxNo();
        boolean isUseLqpt = isLqpt = EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo());
        if (StringUtils.isNotBlank((CharSequence)syncWay)) {
            isUseLqpt = SYNC_WAY_LEQI.equals(syncWay);
        }
        if (!isLqpt && isUseLqpt) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u4e50\u4f01\u901a\u9053\u914d\u7f6e\u4fe1\u606f\uff0c\u5982\u5f53\u524d\u7a0e\u53f7\u5df2\u5f00\u901a\u4e50\u4f01\uff0c\u8bf7\u5728\u57fa\u7840\u8d44\u6599\u2192\u4f01\u4e1a\u4fe1\u606f\u4e2d\u914d\u7f6e\u4e50\u4f01\u5e73\u53f0\u4fe1\u606f\u3002", (String)"InvoiceSyncPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (isLqpt && isUseLqpt) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65f6\u4e0d\u652f\u6301\u4e50\u4f01\u5e73\u53f0\u83b7\u53d6\u540c\u6b65\u53d1\u7968\u4fe1\u606f", (String)"InvoiceSyncPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        LOGGER.info("RPA\u53d1\u7968\u4fe1\u606f\u83b7\u53d6...");
        QFilter qFilter = new QFilter("taxno", "=", (Object)saleInfo.getSaleTaxNo());
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bdm_einvoice_account", (String)"alleinvoiceaccount", (QFilter[])qFilter.toArray());
        if (accounts == null || accounts.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6eRPA\u8d26\u53f7\u4fe1\u606f", (String)"InvoiceSyncPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        HashMap param = Maps.newHashMap();
        param.put("salertaxno", saleTaxNo);
        param.put("checkAuth", Boolean.FALSE);
        if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)param, (boolean)isLqpt)) {
            return;
        }
        try {
            this.downloadDevInvoices("199");
        }
        catch (MsgException e) {
            this.getView().showTipNotification(e.getErrorMsg(), Integer.valueOf(5000));
        }
    }

    private void downloadDevInvoices(String equipmentType) {
        if (this.getModel().getValue("orgid") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"InvoiceSyncPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String equipmentNo = (String)this.getModel().getValue("equipmentno");
        String terminalNo = (String)this.getModel().getValue("terminalno");
        Date startDate = (Date)this.getModel().getValue("issuedate_startdate");
        Date endDate = (Date)this.getModel().getValue("issuedate_enddate");
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        String invoiceCode = (String)this.getModel().getValue("invoicecode");
        String invoiceNo = (String)this.getModel().getValue("invoiceno");
        Long orgId = CreateInvoiceBaseControl.getOrgIdByView((AbstractFormPlugin)this);
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        SyncQueryInvoiceDTO dto = new SyncQueryInvoiceDTO();
        dto.setEquipmentNo(equipmentNo);
        dto.setTerminalNo(terminalNo);
        dto.setStartDate(startDate == null ? null : DateUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
        dto.setEndDate(endDate == null ? null : DateUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
        dto.setInvoiceType(invoiceType);
        dto.setInvoiceCode(invoiceCode);
        dto.setInvoiceNo(invoiceNo);
        dto.setTaxNo(saleInfo.getSaleTaxNo());
        dto.setOrgId(orgId);
        if (!Strings.isNullOrEmpty((String)invoiceCode) && !Strings.isNullOrEmpty((String)invoiceNo)) {
            if (StringUtils.equals((CharSequence)equipmentType, (CharSequence)"199")) {
                SyncDevInvoiceTask.rpaBatchCodeSync(dto, saleInfo.getSaleTaxNo(), false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u6210\u529f", (String)"InvoiceSyncPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            } else {
                this.singleSync(equipmentNo, terminalNo, invoiceType, invoiceCode, invoiceNo);
            }
            return;
        }
        if (startDate == null || endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d1\u7968\u4ee3\u7801\u548c\u53f7\u7801\u8fdb\u884c\u5355\u5f20\u53d1\u7968\u540c\u6b65\u6216\u586b\u5199\u65e5\u671f\u8fdb\u884c\u6279\u91cf\u53d1\u7968\u540c\u6b65\u3002", (String)"InvoiceSyncPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (!StringUtils.equals((CharSequence)equipmentType, (CharSequence)"199")) {
            EquipmentHelper.checkTerminalNo((String)equipmentNo, (String)saleInfo.getSaleTaxNo(), (String)terminalNo);
        }
        String string = equipmentType = StringUtils.isEmpty((CharSequence)equipmentType) ? EquipmentHelper.getEquipmentTypeByNo((String)equipmentNo) : equipmentType;
        if ("8".equals(equipmentType) && DateUtils.compare((Date)startDate, (Date)endDate) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u767e\u671b\u670d\u52a1\u5668\u4ec5\u652f\u6301\u540c\u6b65\u4e00\u5929\u5185\u7684\u53d1\u7968\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5f00\u7968\u65e5\u671f\u8de8\u5ea6\u3002", (String)"InvoiceSyncPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        ImmutableSet keySet = ImmutableSet.of((Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7");
        if (keySet.contains((Object)equipmentType)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7c7b\u578b[%1$s],\u8bbe\u5907\u7f16\u53f7[%2$s]\u6682\u4e0d\u652f\u6301\u53d1\u7968\u540c\u6b65", (String)"InvoiceSyncPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), EquipmentType.EQUIPMENT_MAP.get(equipmentType), equipmentNo), Integer.valueOf(2000));
            return;
        }
        dto.setEquipmentType(equipmentType);
        SyncDevInvoiceTask.dispatchDevTask(this, dto);
    }

    private void singleSync(String equipmentNo, String terminalNo, String invoiceType, String invoiceCode, String invoiceNo) {
        String result;
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)CreateInvoiceBaseControl.getOrgIdByView((AbstractFormPlugin)this));
        EquipmentHelper.checkTerminalNo((String)equipmentNo, (String)saleInfo.getSaleTaxNo(), (String)terminalNo);
        if (Strings.isNullOrEmpty((String)invoiceType) || "-1".equals(invoiceType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u636e\u53d1\u7968\u4ee3\u7801\u548c\u53f7\u7801\u540c\u6b65\u5fc5\u987b\u9009\u62e9\u53d1\u7968\u79cd\u7c7b\uff01", (String)"InvoiceSyncPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!invoiceCode.matches("[0-9]+")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u53ea\u80fd\u7531\u6570\u5b57\u7ec4\u6210[0-9]", (String)"InvoiceSyncPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            this.getModel().setValue("invoicecode", (Object)"");
            return;
        }
        if (invoiceCode.length() != 10 && invoiceCode.length() != 12) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u957f\u5ea6\u5fc5\u987b\u4e3a10\u4f4d\u621612\u4f4d!", (String)"InvoiceSyncPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (!invoiceNo.matches("[0-9]+")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u53ea\u80fd\u7531\u6570\u5b57\u7ec4\u6210[0-9]", (String)"InvoiceSyncPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            this.getModel().setValue("invoiceno", (Object)"");
            return;
        }
        if (invoiceNo.length() != 8) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u957f\u5ea6\u5fc5\u987b\u4e3a8\u4f4d!", (String)"InvoiceSyncPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u540c\u6b65\u53d1\u7968\uff1a%s - %s", invoiceCode, invoiceNo));
        }
        if ("\u53d1\u7968\u540c\u6b65\u6210\u529f".equals(result = InvoiceSyncControl.codeSync((String)equipmentNo, (String)terminalNo, (String)invoiceCode, (String)invoiceNo, (String)invoiceType, (long)CreateInvoiceBaseControl.getOrgIdByView((AbstractFormPlugin)this)))) {
            this.getView().showSuccessNotification(result);
        } else {
            this.getView().showTipNotification(result);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        if ("sim_sync_invoice_progress_call".equals(key)) {
            if (closedCallBackEvent.getReturnData() == null) {
                LOGGER.info("\u53d1\u7968\u540c\u6b65 \u5173\u95ed\u8fdb\u5ea6\u6761 " + this.getPageCache().get("syncDev"));
                CacheHelper.put((String)("syncEnd" + this.getPageCache().get("syncDev")), (String)"1");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u8fdb\u5165\u540e\u53f0\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u540c\u6b65\u7ed3\u679c!", (String)"InvoiceSyncPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            } else {
                HashMap hashMap = (HashMap)closedCallBackEvent.getReturnData();
                if ("-1".equals(hashMap.get("sign"))) {
                    this.getView().showTipNotification((String)hashMap.get("msg"));
                } else if ("100".equals(hashMap.get("sign"))) {
                    this.getView().showConfirm((String)hashMap.get("msg"), MessageBoxOptions.OK);
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"dispatchDevTaskCall", (CharSequence)key)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        if (!result.containsKey("taskinfo")) {
            return;
        }
        String taskInfoStr = (String)result.get("taskinfo");
        if (StringUtils.isEmpty((CharSequence)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (taskInfo.isTaskEnd() && !StringUtils.isEmpty((CharSequence)taskInfo.getData())) {
            JSONObject dataJson = JSONObject.parseObject((String)taskInfo.getData());
            if (dataJson.getBoolean("success").booleanValue()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f%s\u6761\u53d1\u7968", (String)"InvoiceSyncPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), dataJson.getString("invoiceCount")));
                this.getView().close();
            } else {
                this.getView().showMessage(dataJson.getString("errMsg"));
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        LOGGER.info("\u53d1\u7968\u540c\u6b65 \u56de\u8c03clientCallBack" + e.getName());
        if ("showSuccess".equals(e.getName())) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u6210\u529f\uff0c\u65b0\u589e\u53d1\u7968\u6570\u91cf\uff1a%1$s\uff0c\u66f4\u65b0\u53d1\u7968\u6570\u91cf\uff1a%2$s", (String)"InvoiceSyncPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]), this.getPageCache().get("addSize"), this.getPageCache().get("updateSize")));
        } else if ("startDownload".equals(e.getName())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u53d1\u7968\u540c\u6b65\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85...", (String)"InvoiceSyncPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }
}

