/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.dto.PaperInvoiceRollInfoDTO;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;

public class InvoiceVolumnInfoPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String PAGE_KEY_BTNOK = "btnok";
    public static final String PAGE_KEY_VOLUMNLIST = "volumnlist";
    public static final String KEY_INVOICECODE = "invoice_code";
    public static final String KEY_INVOICENUM = "invoice_num";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PAGE_KEY_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        JSONObject jsonObject = (JSONObject)customParams.get("info");
        JSONArray jsonArray = (JSONArray)customParams.get("volumn");
        List volumnList = jsonArray.toJavaList(PaperInvoiceRollInfoDTO.RollInfo.class);
        PaperInvoiceRollInfoDTO.InvoiceInfo invoiceInfo = (PaperInvoiceRollInfoDTO.InvoiceInfo)jsonObject.toJavaObject(PaperInvoiceRollInfoDTO.InvoiceInfo.class);
        this.getPageCache().put(KEY_INVOICECODE, invoiceInfo.getInvoice_code());
        this.getPageCache().put(KEY_INVOICENUM, invoiceInfo.getInvoice_num());
        for (int i = 0; i < volumnList.size(); ++i) {
            this.getModel().createNewEntryRow(PAGE_KEY_VOLUMNLIST);
            this.getModel().setValue(KEY_INVOICECODE, (Object)((PaperInvoiceRollInfoDTO.RollInfo)volumnList.get(i)).getInvoice_code(), i);
            String remainder = ((PaperInvoiceRollInfoDTO.RollInfo)volumnList.get(i)).getRemainder();
            this.getModel().setValue("remainder", (Object)remainder, i);
            String lc = InvoiceUtils.getInvoiceFormsType((String)((PaperInvoiceRollInfoDTO.RollInfo)volumnList.get(i)).getInvoice_code()).getDesc();
            this.getModel().setValue("lc", (Object)lc, i);
            this.getModel().setValue("select", (Object)((PaperInvoiceRollInfoDTO.RollInfo)volumnList.get(i)).getSelect(), i);
            String amount = ((PaperInvoiceRollInfoDTO.RollInfo)volumnList.get(i)).getAmount();
            this.getModel().setValue("amount", (Object)amount, i);
            String invoice_num = ((PaperInvoiceRollInfoDTO.RollInfo)volumnList.get(i)).getInvoice_num();
            this.getModel().setValue(KEY_INVOICENUM, (Object)invoice_num, i);
            if ("0".equals(remainder)) {
                this.getModel().setValue("current_invoiceno", (Object)"", i);
                continue;
            }
            this.getModel().setValue("current_invoiceno", (Object)String.valueOf(this.calculateCurrentInvoiceNo(invoice_num, remainder, amount)), i);
        }
        this.getModel().clearNoDataRow();
        this.getView().setEnable(Boolean.FALSE, new String[]{PAGE_KEY_VOLUMNLIST});
    }

    private int calculateCurrentInvoiceNo(String invoiceNo, String remainder, String amount) {
        int startInvoiceNo = Integer.parseInt(invoiceNo);
        int remainderIntVlaue = Integer.parseInt(remainder);
        int amountIntValue = Integer.parseInt(amount);
        return startInvoiceNo + (amountIntValue - remainderIntVlaue);
    }

    public void afterBindData(EventObject e) {
        DynamicObject dynamicObject;
        EntryGrid grid = (EntryGrid)this.getView().getControl(PAGE_KEY_VOLUMNLIST);
        DynamicObject[] dataEntitys = grid.getEntryData().getDataEntitys();
        int selectInex = 0;
        String currentInvoiceCode = this.getPageCache().get(KEY_INVOICECODE);
        String currentInvoiceNum = this.getPageCache().get(KEY_INVOICENUM);
        DynamicObject[] dynamicObjectArray = dataEntitys;
        int n = dynamicObjectArray.length;
        for (int i = 0; !(i >= n || currentInvoiceCode.equals((dynamicObject = dynamicObjectArray[i]).get(KEY_INVOICECODE)) && Long.parseLong(currentInvoiceNum) >= Long.parseLong(dynamicObject.getString(KEY_INVOICENUM)) && Long.parseLong(currentInvoiceNum) <= Long.parseLong(dynamicObject.getString(KEY_INVOICENUM)) + Long.parseLong(dynamicObject.getString("amount"))); ++i) {
            ++selectInex;
        }
        grid.selectRows(selectInex >= dataEntitys.length ? 0 : selectInex);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (PAGE_KEY_BTNOK.equals(source.getKey())) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(PAGE_KEY_VOLUMNLIST);
            int[] rows = grid.getSelectRows();
            if (rows.length < 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"InvoiceVolumnInfoPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, String> rMap = new HashMap<String, String>();
            DynamicObject[] dataEntitys = grid.getEntryData().getDataEntitys();
            if (dataEntitys.length > 0) {
                PaperInvoiceRollInfoDTO.RollInfo rollInfo = (PaperInvoiceRollInfoDTO.RollInfo)DynamicObjectUtil.dynamicObject2Bean(PaperInvoiceRollInfoDTO.RollInfo.class, (DynamicObject)dataEntitys[rows[0]]);
                int used = Integer.parseInt(rollInfo.getAmount()) - Integer.parseInt(rollInfo.getRemainder());
                rMap.put(KEY_INVOICECODE, rollInfo.getInvoice_code());
                rMap.put(KEY_INVOICENUM, this.getNextInvoiceNum(rollInfo.getInvoice_num(), used));
            }
            this.getView().returnDataToParent(rMap);
            this.getView().close();
        }
    }

    public String getNextInvoiceNum(String startInvoiceNum, Integer used) {
        String tnum = String.valueOf(Long.parseLong(startInvoiceNum) + (long)used.intValue());
        return String.join((CharSequence)"", Collections.nCopies(startInvoiceNum.length() - tnum.length(), "0")) + tnum;
    }
}

