/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.InvoiceDTO;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.plugin.AbstractCheckInvoicePlugin;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;

public class RedInvoiceDialogPlugin
extends AbstractCheckInvoicePlugin {
    public void afterCreateNewData(EventObject e) {
        Object invoiceType = this.getView().getFormShowParameter().getCustomParams().get("invoicetype");
        String orgId = (String)this.getView().getFormShowParameter().getCustomParams().get("orgId");
        this.getPageCache().put("orgId", orgId);
        if (InvoiceUtils.isSpecialInvoice((String)String.valueOf(invoiceType))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"originalissuetime", "originalinvoicetype", "redreason"});
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        TextEdit oriInvoiceNo = (TextEdit)this.getView().getControl("originalinvoiceno");
        oriInvoiceNo.addClickListener((ClickListener)this);
        TextEdit oriInvoiceCode = (TextEdit)this.getView().getControl("originalinvoicecode");
        oriInvoiceCode.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            QFilter qFilter;
            DynamicObject object;
            this.checkRedInvoice();
            String originalInvoiceCode = (String)this.getModel().getValue("originalinvoicecode");
            String originalInvoiceNo = (String)this.getModel().getValue("originalinvoiceno");
            Object originalIssueTime = this.getModel().getValue("originalissuetime");
            Object inputInvoiceType = this.getView().getFormShowParameter().getCustomParams().get("invoicetype");
            if (InvoiceUtils.isNormalInvoice((String)String.valueOf(inputInvoiceType))) {
                if (null == originalIssueTime) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInvoiceDialogPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                Object originalInvoiceType = this.getModel().getValue("originalinvoicetype");
                if (null == originalInvoiceType) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInvoiceDialogPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                Object redReason = this.getModel().getValue("redreason");
                if (null == redReason) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51b2\u7ea2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInvoiceDialogPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
            if ((object = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])(qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)originalInvoiceCode, (String)originalInvoiceNo)).toArray())) == null) {
                String content = String.format(ResManager.loadKDString((String)"\u84dd\u7968\u4ee3\u7801\uff1a%1$s\u84dd\u7968\u53f7\u7801\uff1a%2$s\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u7ea2\u51b2", (String)"RedInvoiceDialogPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), originalInvoiceCode, originalInvoiceNo);
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)content, (String)"issuetype");
                this.getPageCache().put("blank_invoiceCode", originalInvoiceCode);
                this.getPageCache().put("blank_invoiceNo", originalInvoiceNo);
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"sim_vatinvoice");
            String invoiceType = dynamicObject.getString("invoicetype");
            if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u662f\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u8bf7\u5230\u7ea2\u5b57\u4fe1\u606f\u8868\u9875\u9762\u8fdb\u884c\u7ea2\u51b2", (String)"RedInvoiceDialogPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            dynamicObject.set("redreason", this.getModel().getValue("redreason"));
            this.getView().returnDataToParent((Object)dynamicObject);
            this.getView().close();
        } else if ("originalinvoiceno".equals(key) || "originalinvoicecode".equals(key)) {
            this.openVatInvoiceListView();
        }
    }

    private void openVatInvoiceListView() {
        QFilter qFilter = new QFilter("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray).and("orgid", "=", (Object)Long.parseLong(this.getPageCache().get("orgId")));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object invoiceType = params.get("invoicetype");
        if (StringUtils.isNotBlank(invoiceType)) {
            if (InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceType)) {
                qFilter.and("invoicetype", "=", invoiceType);
            } else if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType)) {
                qFilter.and("invoicetype", "in", (Object)InvoiceUtils.getNormalInvoiceCanRedInvoiceType());
            } else {
                qFilter.and("invoicetype", "in", (Object)InvoiceUtils.getSpecialInvoiceType().toArray());
            }
        }
        qFilter.and("issuetype", "=", (Object)String.valueOf(IssueTypeEnum.blue.getValue()));
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_choose_vatinvoice", (String)"invoicecode", (String)ResManager.loadKDString((String)"\u9500\u9879\u53d1\u7968\u5217\u8868", (String)"RedInvoiceDialogPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("issuetype".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            InvoiceDTO invoiceDTO = new InvoiceDTO(this.getPageCache().get("blank_invoiceCode"), this.getPageCache().get("blank_invoiceNo"));
            invoiceDTO.setInvoiceType(String.valueOf(this.getModel().getValue("originalinvoicetype")));
            invoiceDTO.setRedReason(String.valueOf(this.getModel().getValue("redreason")));
            invoiceDTO.setIssueTime((Date)this.getModel().getValue("originalissuetime"));
            this.getView().returnDataToParent((Object)invoiceDTO);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "originalinvoicecode": 
            case "originalinvoiceno": {
                if (!StringUtils.isBlank((CharSequence)CacheHelper.get((String)(this.getView().getPageId() + "originalinvoicecode")))) break;
                this.getView().setEnable(Boolean.TRUE, new String[]{"originalissuetime", "originalinvoicetype"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection collection;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (("invoicecode".equals(actionId) || "invoiceno".equals(actionId)) && null != returnData && (collection = (ListSelectedRowCollection)returnData).size() > 0) {
            ListSelectedRow listSelectedRow = collection.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])new QFilter("id", "=", primaryKeyValue).toArray());
            if (array.length > 0) {
                CacheHelper.put((String)(this.getView().getPageId() + "originalinvoicecode"), (String)"id", (int)2);
                this.getModel().setValue("originalinvoicecode", array[0].get("invoicecode"));
                this.getModel().setValue("originalinvoiceno", array[0].get("invoiceno"));
                this.getModel().setValue("originalissuetime", array[0].get("issuetime"));
                this.getModel().setValue("originalinvoicetype", array[0].get("invoicetype"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"originalissuetime", "originalinvoicetype"});
            }
        }
    }
}

