/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.dataimport;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.enums.EnableStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.file.util.ErrorType;
import kd.imc.sim.common.utils.CollectionsUtils;
import kd.imc.sim.formplugin.issuing.dataimport.HistoryInvoiceDataImportService;

public class HistoryInvoiceDataImportListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(HistoryInvoiceDataImportListPlugin.class);
    private static final String UPDATE_STATUS_SQL = "update t_sim_his_inv_data_imp_st set fexecutionstatus = '%s',ffailreason='%s' where fimportentryid= %s and fexecutionstatus!='4'";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("btn_terminate".equals(operateKey)) {
            int successNum = 0;
            Map billNos = args.getOperationResult().getBillNos();
            for (Object primaryKeyValue : billNos.keySet()) {
                successNum += this.terminateData(primaryKeyValue);
            }
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u63d0\u4ea4\u7ec8\u6b62\u64cd\u4f5c\u8bb0\u5f55\u6570\u636e\uff1a%s\u6761", (String)"HistoryInvoiceDataImportListPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), successNum));
        } else if ("btn_restart".equals(operateKey)) {
            int successNum = 0;
            Map billNos = args.getOperationResult().getBillNos();
            for (Object primaryKeyValue : billNos.keySet()) {
                successNum += this.restartData(primaryKeyValue);
            }
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u63d0\u4ea4\u91cd\u8bd5\u64cd\u4f5c\u6570\u636e\uff1a%s\u6761", (String)"HistoryInvoiceDataImportListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), successNum));
        } else if ("btn_add".equals(operateKey)) {
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5386\u53f2\u53d1\u7968\u5bfc\u5165", (String)"HistoryInvoiceDataImportListPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), null, (String)"sim_his_inv_data_imp_pop", (String)"sim_his_inv_data_imp_pop");
        } else if ("btn_autoconfig".equals(operateKey)) {
            Map<String, Object> autoTaskMap = this.queryAutoTask();
            ViewUtil.openDialog((AbstractFormPlugin)this, autoTaskMap, (String)"sim_his_inv_data_imp_conf", (String)"sim_his_inv_data_imp_conf");
            this.getView().updateView();
        }
    }

    private int restartData(Object primaryKeyValue) {
        int successNum = 0;
        try (DLock lock = DLock.create((String)(HistoryInvoiceDataImportListPlugin.class.getName() + "_restartData_" + primaryKeyValue));){
            if (!lock.tryLock(60000L)) {
                int n = 0;
                return n;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_his_inv_data_import");
            String executionStatus = dynamicObject.getString("executionstatus");
            String dataType = dynamicObject.getString("datatype");
            boolean isSt = "2".equals(dataType);
            if (this.checkDataStatusFail(executionStatus)) {
                dynamicObject.set("executionstatus", (Object)"0");
                DynamicObjectCollection items2 = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject item : items2) {
                    String detailStatus = item.getString("detailexecutionstatus");
                    if (!this.checkDataStatusFail(detailStatus)) continue;
                    String status = "0";
                    String reason = "";
                    item.set("detailexecutionstatus", (Object)status);
                    item.set("detailfailreason", null);
                    if (!isSt) continue;
                    this.updateSyncInvoiceSt(status, reason, item.getPkValue());
                }
                ++successNum;
                ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        }
        return successNum;
    }

    private int terminateData(Object primaryKeyValue) {
        int operSuccessNum = 0;
        try (DLock lock = DLock.create((String)(HistoryInvoiceDataImportListPlugin.class.getName() + "_terminateData_" + primaryKeyValue));){
            if (!lock.tryLock(60000L)) {
                int n = 0;
                return n;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_his_inv_data_import");
            String executionStatus = dynamicObject.getString("executionstatus");
            String dataType = dynamicObject.getString("datatype");
            boolean isSt = "2".equals(dataType);
            if (this.checkDataStatusNotFinish(executionStatus)) {
                String downloadChannel = dynamicObject.getString("downloadchannel");
                if (!isSt && "1".equals(downloadChannel) && !"0".equals(executionStatus)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u540c\u6b65\uff0c\u4e50\u4f01\u901a\u9053\u6682\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\uff01", (String)"HistoryInvoiceDataImportListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                int successNum = dynamicObject.getInt("successnum");
                String execStatus = "5";
                if (successNum > 0) {
                    execStatus = "3";
                }
                dynamicObject.set("executionstatus", (Object)execStatus);
                DynamicObjectCollection items2 = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject item : items2) {
                    String detailStatus = item.getString("detailexecutionstatus");
                    if (!this.checkDataStatusNotFinish(detailStatus)) continue;
                    int itemSuccessNum = item.getInt("detailsuccessnum");
                    String failStatus = itemSuccessNum > 0 ? "3" : "5";
                    String failReason = ErrorType.USER_ERROR_A0507.getDescription();
                    item.set("detailexecutionstatus", (Object)failStatus);
                    item.set("detailfailreason", (Object)failReason);
                    if (!isSt) continue;
                    this.updateSyncInvoiceSt(failStatus, failReason, item.getPkValue());
                }
                ++operSuccessNum;
                ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        }
        return operSuccessNum;
    }

    private void updateSyncInvoiceSt(String executionStatus, String failReason, Object entryKey) {
        String sql = String.format(UPDATE_STATUS_SQL, executionStatus, failReason, entryKey);
        DB.update((DBRoute)DBRoute.of((String)"taxc"), (String)sql);
    }

    private boolean checkDataStatusNotFinish(String executionStatus) {
        if ("0".equals(executionStatus) || "1".equals(executionStatus) || "2".equals(executionStatus)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean checkDataStatusFail(String executionStatus) {
        if ("5".equals(executionStatus) || "3".equals(executionStatus)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Map returnMap = (Map)event.getReturnData();
        if (returnMap == null) {
            return;
        }
        if ("sim_his_inv_data_imp_pop".equals(actionId)) {
            DynamicObject returnData = (DynamicObject)returnMap.get("paramData");
            if (returnData == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"HistoryInvoiceDataImportListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            String dataType = returnData.getString("datatype");
            String importMethod = returnData.getString("importmethod");
            if ("3".equals(dataType)) {
                this.saveDownRimInvoiceFileData(returnMap);
            } else if ("2".equals(importMethod)) {
                this.saveInvoiceFileData(returnMap);
            } else {
                this.saveInvoiceInterFaceData(returnMap);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"HistoryInvoiceDataImportListPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else if ("sim_his_inv_data_imp_conf".equals(actionId)) {
            this.saveAutoTask(returnMap);
        }
        this.getView().invokeOperation("refresh");
    }

    private void saveDownRimInvoiceFileData(Map<String, Object> returnMap) {
        DynamicObject paramData = (DynamicObject)returnMap.get("paramData");
        String downloadChannel = paramData.getString("downloadchannel");
        String invoiceDate = paramData.getString("invoicedate");
        List<String> dateRangeList = this.checkInvoiceDate(invoiceDate);
        String invoiceType = paramData.getString("invoicetype");
        DynamicObjectCollection epInfos = paramData.getDynamicObjectCollection("epinfo");
        String issueAccount = paramData.getString("issueaccount");
        if ("1".equals(downloadChannel)) {
            issueAccount = null;
        }
        String dataType = paramData.getString("datatype");
        HistoryInvoiceDataImportService.saveInvoiceFileDownloadTaskData((DynamicObjectCollection)epInfos, (String)dataType, (String)invoiceType, (String)downloadChannel, (String)issueAccount, dateRangeList);
    }

    private void saveInvoiceInterFaceData(Map<String, Object> returnMap) {
        DynamicObject paramData = (DynamicObject)returnMap.get("paramData");
        String downloadChannel = paramData.getString("downloadchannel");
        String invoiceDate = paramData.getString("invoicedate");
        List<String> dateRangeList = this.checkInvoiceDate(invoiceDate);
        String invoiceType = paramData.getString("invoicetype");
        DynamicObjectCollection epInfos = paramData.getDynamicObjectCollection("epinfo");
        String issueAccount = paramData.getString("issueaccount");
        if ("1".equals(downloadChannel)) {
            issueAccount = null;
        }
        String dataType = paramData.getString("datatype");
        HistoryInvoiceDataImportService.saveHistoryImportTaskData((DynamicObjectCollection)epInfos, (String)dataType, (String)invoiceType, (String)downloadChannel, (String)issueAccount, dateRangeList);
    }

    private List<String> checkInvoiceDate(String invoiceDate) {
        if (StringUtils.isEmpty((CharSequence)invoiceDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u7968\u65e5\u671f", (String)"HistoryInvoiceDataImportListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        List<String> dateRangeList = this.getMonthsByYears(invoiceDate);
        if (dateRangeList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u7968\u65e5\u671f", (String)"HistoryInvoiceDataImportListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        return dateRangeList;
    }

    private void saveInvoiceFileData(Map<String, Object> returnMap) {
        List attachmentDataList = (List)returnMap.get("attachmentpanel");
        if (attachmentDataList == null || attachmentDataList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u518d\u64cd\u4f5c", (String)"HistoryInvoiceDataImportListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Map attachmentDataMap = (Map)attachmentDataList.get(0);
        String fileHash = this.getFileHashByUrl((String)attachmentDataMap.get("url"));
        DynamicObject paramData = (DynamicObject)returnMap.get("paramData");
        this.checkFileRecordIsExist(paramData, fileHash);
        DynamicObjectCollection epInfos = paramData.getDynamicObjectCollection("epinfo");
        DynamicObject epInfo = ((DynamicObject)epInfos.get(0)).getDynamicObject("fbasedataId");
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_his_inv_data_import");
        String dataType = paramData.getString("datatype");
        String invoiceType = paramData.getString("invoicetype");
        String importMethod = paramData.getString("importmethod");
        HistoryInvoiceDataImportService.setBaseData((DynamicObject)dynamicObject, (String)dataType, (String)invoiceType, (String)importMethod, (DynamicObject)epInfo);
        dynamicObject.set("filehash", (Object)fileHash);
        this.saveData(dynamicObject, attachmentDataList);
    }

    private void saveData(DynamicObject dynamicObject, List<Map<String, Object>> attachmentDataList) {
        try {
            ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
            if (attachmentDataList != null && !attachmentDataList.isEmpty()) {
                for (Map<String, Object> data : attachmentDataList) {
                    String filePath = AttachmentServiceHelper.saveTempToFileService((String)data.get("url").toString(), (String)"sim", (String)"sim_his_inv_data_import", (Object)dynamicObject.getPkValue(), (String)data.get("name").toString());
                    data.put("url", filePath);
                }
                AttachmentServiceHelper.upload((String)"sim_his_inv_data_import", (Object)dynamicObject.getPkValue(), (String)"attachmentpanel", attachmentDataList);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"HistoryInvoiceDataImportListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            LOGGER.error("\u5386\u53f2\u6570\u636e\u5bfc\u5165\u4fdd\u5b58\u51fa\u9519\uff1a", e);
            dynamicObject.set("executionstatus", (Object)"5");
            ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void checkFileRecordIsExist(DynamicObject popData, String fileHash) {
        DynamicObjectCollection epInfos = popData.getDynamicObjectCollection("epinfo");
        if (epInfos == null || epInfos.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9500\u65b9\u4fe1\u606f\u7528\u4e8e\u505a\u6570\u636e\u5173\u8054", (String)"HistoryInvoiceDataImportListPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String queryField = "id,billno";
        DynamicObject epInfo = ((DynamicObject)epInfos.get(0)).getDynamicObject("fbasedataId");
        QFilter filter = new QFilter("epinfo", "=", epInfo.getPkValue()).and(new QFilter("importmethod", "=", (Object)"2")).and(new QFilter("filehash", "=", (Object)fileHash)).and(new QFilter("executionstatus", "=", (Object)"0").or(new QFilter("executionstatus", "=", (Object)"2")));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_his_inv_data_import", (String)queryField, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            String taxNo = epInfo.getString("number");
            String billNo = dynamicObject.getString("billno");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u53f7%1$s\u5df2\u7ecf\u4e0a\u4f20\u4e86\u76f8\u540c\u7684\u6587\u4ef6\uff0c\u4e0b\u8f7d\u6279\u6b21\u53f7%2$s\uff0c\u8bf7\u68c0\u67e5", (String)"HistoryInvoiceDataImportListPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), taxNo, billNo));
        }
    }

    /*
     * Exception decompiling
     */
    private String getFileHashByUrl(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getMonthsByYears(String years) {
        List yearArrList = CollectionsUtils.getListFromStr((String)years);
        ArrayList<String> invoiceDateList = new ArrayList<String>(8);
        for (String invoiceDataStr : yearArrList) {
            if (!StringUtils.isNotEmpty((CharSequence)invoiceDataStr)) continue;
            invoiceDateList.addAll(this.getMonthsByYear(invoiceDataStr));
        }
        return invoiceDateList;
    }

    private List<String> getMonthsByYear(String year) {
        if (year.length() == 7) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(year);
            return list;
        }
        LocalDate now = LocalDate.now().withDayOfMonth(1);
        return IntStream.rangeClosed(1, 12).mapToObj(month -> LocalDate.of(Integer.parseInt(year), month, 1)).filter(date -> !date.isAfter(now)).map(date -> date.format(DateTimeFormatter.ofPattern("yyyy-MM"))).collect(Collectors.toList());
    }

    private Map<String, Object> queryAutoTask() {
        boolean invoiceData = Boolean.FALSE;
        boolean invoiceStatus = Boolean.FALSE;
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObject[] dynamicObjects = this.queryAutoTaskData(Boolean.TRUE);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String type = dynamicObject.getString("type");
                if ("3".equals(type)) {
                    invoiceData = Boolean.TRUE;
                    continue;
                }
                if (!"4".equals(type)) continue;
                invoiceStatus = Boolean.TRUE;
            }
        }
        map.put("invoicedata", invoiceData);
        map.put("invoicestatus", invoiceStatus);
        return map;
    }

    private DynamicObject[] queryAutoTaskData(boolean queryEnable) {
        QFilter qFilter = new QFilter("datatype", "=", (Object)"2");
        if (queryEnable) {
            qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getStatus()));
        }
        qFilter.and(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
        return BusinessDataServiceHelper.load((String)"bdm_auto_task", (String)"id,type,enable", (QFilter[])qFilter.toArray());
    }

    public void saveAutoTask(Map<String, Object> returnMap) {
        Boolean invoiceDataFlag = (Boolean)returnMap.get("invoicedata");
        Boolean invoiceStatusFlag = (Boolean)returnMap.get("invoicestatus");
        String invoiceDataStr = invoiceDataFlag != false ? "1" : "0";
        String invoiceStatusStr = invoiceStatusFlag != false ? "1" : "0";
        DynamicObject[] dynamicObjects = this.queryAutoTaskData(Boolean.FALSE);
        boolean invoiceDataExist = Boolean.FALSE;
        boolean invoiceStatusExist = Boolean.FALSE;
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                String type = dynamicObject.getString("type");
                String enable = dynamicObject.getString("enable");
                if ("3".equals(type)) {
                    invoiceDataExist = Boolean.TRUE;
                    if (invoiceDataStr.equals(enable)) continue;
                    dynamicObject.set("enable", (Object)invoiceDataStr);
                    updateList.add(dynamicObject);
                    continue;
                }
                if (!"4".equals(type)) continue;
                invoiceStatusExist = Boolean.TRUE;
                if (invoiceStatusStr.equals(enable)) continue;
                dynamicObject.set("enable", (Object)invoiceStatusStr);
                updateList.add(dynamicObject);
            }
            if (!updateList.isEmpty()) {
                ImcSaveServiceHelper.update(updateList);
            }
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(2);
        if (invoiceDataFlag.booleanValue() && !invoiceDataExist) {
            saveList.add(this.getAutoTaskDynamicObject(Boolean.TRUE));
        }
        if (invoiceStatusFlag.booleanValue() && !invoiceStatusExist) {
            saveList.add(this.getAutoTaskDynamicObject(Boolean.FALSE));
        }
        if (!saveList.isEmpty()) {
            DynamicObject[] saveArray = saveList.toArray(new DynamicObject[0]);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bdm_auto_task", (DynamicObject[])saveArray, (OperateOption)OperateOption.create());
            List validateErrors = operationResult.getValidateResult().getValidateErrors();
            if (!operationResult.isSuccess()) {
                this.getView().showErrorNotification(((OperateErrorInfo)((ValidateResult)validateErrors.get(0)).getAllErrorInfo().get(0)).getMessage());
                return;
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"HistoryInvoiceDataImportListPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject getAutoTaskDynamicObject(boolean isInvoiceData) {
        String number = "imcTask" + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + "_" + RandomString.nextString((int)5, (boolean)true, (boolean)false);
        String name = isInvoiceData ? ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u8f7d\u53d1\u7968\u4efb\u52a1", (String)"HistoryInvoiceDataImportListPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u81ea\u52a8\u66f4\u65b0\u53d1\u7968\u7528\u9014\u72b6\u6001\u4efb\u52a1", (String)"HistoryInvoiceDataImportListPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String type = isInvoiceData ? "3" : "4";
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_auto_task");
        dynamicObject.set("name", (Object)name);
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("datatype", (Object)"2");
        dynamicObject.set("type", (Object)type);
        dynamicObject.set("timeperiod", (Object)"0");
        dynamicObject.set("invoicetype", (Object)",026,028,007,004,10xdp,08xdp,");
        dynamicObject.set("enable", (Object)EnableStatusEnum.ENABLE.getStatus());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        String desc = isInvoiceData ? ResManager.loadKDString((String)"\u652f\u6301\u81ea\u52a8\u4e0b\u8f7d\u53d1\u7968\u6570\u636e\uff0c\u5982\u9700\u4f7f\u7528\u4e50\u4f01\u66f4\u65b0\uff0c\u8bf7\u786e\u8ba4\u5df2\u5f00\u901a\u4e50\u4f01\u7684\u5f52\u96c6\u80fd\u529b\u3002\u9ed8\u8ba4\u6bcf\u6708\u4e94\u53f7\u4e0b\u8f7d", (String)"HistoryInvoiceDataImportListPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u652f\u6301\u81ea\u52a8\u66f4\u65b0\u53d1\u7968\u7528\u9014\u72b6\u6001\uff0c\u5982\u9700\u4f7f\u7528\u4e50\u4f01\u66f4\u65b0\uff0c\u8bf7\u786e\u8ba4\u5df2\u5f00\u901a\u4e50\u4f01\u7684\u5f52\u96c6\u80fd\u529b\u3002\u9ed8\u8ba4\u6bcf\u6708\u4e94\u53f7\u4e0b\u8f7d", (String)"HistoryInvoiceDataImportListPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        dynamicObject.set("description", (Object)desc);
        dynamicObject.set("ctrlstrategy", (Object)"7");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getOrgId(), (String)"bdm_org");
        dynamicObject.set("createorg", (Object)org);
        dynamicObject.set("useorg", (Object)org);
        if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)dynamicObject, (String)"srccreateorg")) {
            dynamicObject.set("srccreateorg", (Object)org);
        }
        dynamicObject.set("org", (Object)org);
        dynamicObject.set("status", (Object)"C");
        return dynamicObject;
    }
}

