/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.invalid;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.PaperInvoiceRollInfoDTO;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.utils.BeanUtil;
import kd.imc.sim.formplugin.issuing.control.BatchInvoiceControl;
import kd.imc.sim.formplugin.issuing.invalid.InvalidInvoiceControl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class InvalidReIssueDialogListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(InvalidReIssueDialogListPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"issueinvoice", "imgvolumninfo"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("issueinvoice")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONArray jsonArray = (JSONArray)customParams.get("ids");
            this.confirmBatch(jsonArray);
        } else if ("imgvolumninfo".equals(source.getKey())) {
            this.popPaperInvoiceRollInfoDialog();
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        JSONArray jsonArray = (JSONArray)customParams.get("ids");
        QFilter pkFilter = new QFilter("id", "in", (Object)jsonArray.toArray());
        DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])pkFilter.toArray());
        if (invoiceArray.length > 0) {
            this.getPageCache().put("orgid", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceArray[0].get("orgid"))));
            String sellerTaxNo = invoiceArray[0].getString("salertaxno");
            String jqbh = invoiceArray[0].getString("jqbh");
            if (EquipmentHelper.isEnable((Object)sellerTaxNo, (Object)jqbh)) {
                this.getModel().setValue("jqbh", (Object)invoiceArray[0].getString("jqbh"));
            }
            this.setEquipmentAndTerminaNo(invoiceArray[0].getDynamicObject("orgid").getLong("id"));
            if (StringUtils.isNotBlank((Object)this.getModel().getValue("jqbh"))) {
                this.getModel().setValue("terminalno", (Object)invoiceArray[0].getString("terminalno"));
            }
        } else {
            this.setEquipmentAndTerminaNo(0L);
        }
        this.setTotalCount();
        try {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexvolumninfo"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"textvolumninfo"});
            DynamicObject equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)invoiceArray[0].getString("jqbh"), (String)invoiceArray[0].getString("salertaxno"));
            if (StringUtils.isNotBlank((Object)this.getModel().getValue("jqbh")) && !"8".equals(equipment.getString("equipmenttype"))) {
                this.changeDevice(ObjectUtils.defaultIfNull((Object)this.getModel().getValue("jqbh"), (Object)"").toString());
            }
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
        this.setListFilter();
    }

    public void setEquipmentAndTerminaNo(long orgId) {
        orgId = orgId == 0L ? RequestContext.get().getOrgId() : orgId;
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)this, (long)orgId, (String)saleInfo.getSaleTaxNo(), (String)"jqbh", (String)"terminalno", (boolean)true);
    }

    private void setTotalCount() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object tips = customParams.get("tips");
        if (!kd.bos.orm.util.StringUtils.isEmpty(tips)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e2d\u5305\u542b\u4e86'\u7a7a\u767d\u4f5c\u5e9f'\u53d1\u7968\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5ffd\u7565\u3002", (String)"InvalidReIssueDialogListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        JSONArray jsonArray = (JSONArray)customParams.get("ids");
        this.getPageCache().put("ids", jsonArray.toJSONString());
        String invoiceType = (String)customParams.get("invoiceType");
        this.getPageCache().put("invoicetype", invoiceType);
        Map<String, Object> amtMap = this.getAmt(jsonArray.toArray());
        String str = ResManager.loadKDString((String)"\u603b\u8ba1\uff1a\u5f00\u7968\u4efd\u6570 %1$s \u4efd\uff0c\u4ef7\u7a0e\u5408\u8ba1 %2$s \u5143\uff0c\u7a0e\u989d %3$s \u5143\u3002", (String)"InvalidReIssueDialogListPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String format = String.format(str, amtMap.get("count"), amtMap.get("totalAmount"), amtMap.get("taxAmount"));
        this.getModel().setValue("labelap", (Object)format);
    }

    private void setListFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        JSONArray jsonArray = (JSONArray)customParams.get("ids");
        this.getPageCache().put("ids", jsonArray.toJSONString());
        BillList billList = (BillList)this.getView().getControl("billlistap");
        FilterParameter fp = new FilterParameter();
        fp.setFilter(new QFilter("id", "in", (Object)jsonArray.toArray()));
        billList.setFilterParameter(fp);
        billList.refreshData();
    }

    private Map<String, Object> getAmt(Object[] ids) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT count(1) as count,SUM(t.FTOTALTAX) as taxTotal,SUM(t.FTOTALAMOUNT) as totalAmount ");
        sql.append(" FROM t_sim_vatinvoice t ");
        sql.append(" WHERE t.fid in (");
        for (int i = 0; i < ids.length; ++i) {
            sql.append('?');
            if (i == ids.length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (DataSet ds = DB.queryDataSet((String)"getInvoiceAmt", (DBRoute)new DBRoute("taxc"), (String)sql.toString(), (Object[])ids);){
            if (ds != null) {
                for (Row data : ds) {
                    BigDecimal taxAmount = data.getBigDecimal("taxTotal") != null ? data.getBigDecimal("taxTotal") : BigDecimal.ZERO;
                    BigDecimal totalAmount = data.getBigDecimal("totalAmount") != null ? data.getBigDecimal("totalAmount") : BigDecimal.ZERO;
                    map.put("count", data.get("count"));
                    map.put("taxAmount", taxAmount.setScale(2, 4).toString());
                    map.put("totalAmount", totalAmount.setScale(2, 4).toString());
                }
            }
        }
        return map;
    }

    public void confirmBatch(JSONArray jsonArray) {
        try {
            SaleInfo saleInfo;
            Object devNo = this.getModel().getValue("jqbh");
            Object terminalNo = this.getModel().getValue("terminalno");
            if (StringUtils.isBlank((Object)devNo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u8bbe\u5907", (String)"InvalidReIssueDialogListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] invoiceList = BusinessDataServiceHelper.load((Object[])jsonArray.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            int invoiceListLength = 0;
            if (invoiceList.length == 0) {
                saleInfo = TaxUtils.getSaleInfoByOrg();
            } else {
                PermissionHelper.checkPermission((String)"sim", (String)"sim_invoice_invalid", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceList[0].get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.IMC_RE_ISSUE);
                saleInfo = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceList[0].get("orgid")));
                invoiceListLength = invoiceList.length;
            }
            EquipmentHelper.checkTerminalNo((String)((String)devNo), (String)saleInfo.getSaleTaxNo(), (String)((String)terminalNo));
            DynamicObject[] reIssueInvoiceArray = new DynamicObject[invoiceListLength];
            String belongNo = String.format("ZFPC_%d_%s", RequestContext.get().getOrgId(), UUID.getBatchNumber());
            for (int i = 0; i < invoiceList.length; ++i) {
                DynamicObject reIssueInvoice;
                DynamicObject invoiceDynamicObject = invoiceList[i];
                reIssueInvoiceArray[i] = reIssueInvoice = InvalidInvoiceControl.getReIssueInvoice((DynamicObject)invoiceDynamicObject, (String)belongNo);
            }
            for (DynamicObject invoice : reIssueInvoiceArray) {
                invoice.set("jqbh", devNo);
                DrawerStrategyHelper.setOtherObjDrawers((DynamicObject)invoice);
            }
            ArrayList reInvoiceList = new ArrayList();
            Collections.addAll(reInvoiceList, reIssueInvoiceArray);
            InvoiceUtils.dealInvoicesListMark(new HashMap(), reInvoiceList);
            BatchInvoiceControl.doBatchInvoice((Object)devNo, (Object)terminalNo, (DynamicObject[])reIssueInvoiceArray);
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
        catch (KDBizException exception) {
            logger.error("reissueException", (Throwable)exception);
            this.getView().showErrorNotification(exception.getMessage());
        }
        catch (MsgException exception) {
            logger.error("reissueException", (Throwable)exception);
            this.getView().showErrorNotification(exception.getErrorMsg());
        }
        catch (Exception exception) {
            logger.error("reissueException", (Throwable)exception);
            this.getView().showErrorNotification(exception.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("jqbh".equals(e.getProperty().getName())) {
            String equipmentNo = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((CharSequence)equipmentNo)) {
                return;
            }
            String orgStr = this.getPageCache().get("orgid");
            SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrg((Long)(StringUtils.isBlank((CharSequence)orgStr) ? RequestContext.get().getOrgId() : Long.parseLong(orgStr)));
            EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)equipmentNo, (String)saleInfoByOrg.getSaleTaxNo(), (String)"terminalno", (boolean)false);
            DynamicObject equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)equipmentNo, (String)saleInfoByOrg.getSaleTaxNo());
            if (!"8".equals(equipment.getString("equipmenttype"))) {
                try {
                    this.changeDevice(String.valueOf(e.getChangeSet()[0].getNewValue()));
                }
                catch (KDBizException ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (actionId == null) {
            return;
        }
        if ("callback_sim_invoice_volumn_info_dialog".equals(actionId)) {
            this.handleSelectInvoiceVolumn(event);
        }
    }

    public void handleSelectInvoiceVolumn(ClosedCallBackEvent event) {
        Map map = (Map)event.getReturnData();
        if (MapUtils.isNotEmpty((Map)map)) {
            String invoiceCode = ObjectUtils.defaultIfNull(map.get("invoice_code"), (Object)"").toString();
            String invoiceNum = ObjectUtils.defaultIfNull(map.get("invoice_num"), (Object)"").toString();
            HashMap<String, String> sjdMap = new HashMap<String, String>();
            sjdMap.put("fpdm", invoiceCode);
            sjdMap.put("fphm", ObjectUtils.defaultIfNull(map.get("invoice_num"), (Object)"").toString());
            sjdMap.put("kpzl", "2");
            String deviceId = ObjectUtils.defaultIfNull((Object)this.getModel().getValue("jqbh"), (Object)"").toString();
            if (StringUtils.isEmpty((CharSequence)deviceId)) {
                return;
            }
            String orgStr = this.getPageCache().get("orgid");
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)(StringUtils.isBlank((CharSequence)orgStr) ? RequestContext.get().getOrgId() : Long.parseLong(orgStr)));
            ComponentResponse componentResponse = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)deviceId), (String)JSON.toJSONString((Object)new ComponentRequest(ComponentInterfaceTypeEnum.SETINVOICEVOLUME.getCzlx(), sjdMap, null, saleInfo.getDefaultTerminal())), Map.class);
            if (!"0".equals(componentResponse.getErrcode())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u53d1\u7968\u5377\u5f02\u5e38(%s)", (String)"InvalidReIssueDialogListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), componentResponse.getDescription()));
            }
            String lc = InvoiceUtils.getInvoiceFormsType((String)invoiceCode).getDesc();
            String volumnInfoStr = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801: %1$s \u8d77\u59cb\u53f7\u7801: %2$s %3$s", (String)"InvalidReIssueDialogListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceCode, invoiceNum, lc);
            this.getModel().setValue("textvolumninfo", (Object)volumnInfoStr);
        }
    }

    private void changeDevice(String equipmentNo) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexvolumninfo"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"textvolumninfo"});
        this.getPageCache().put("textvolumninfo", null);
        String equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)equipmentNo);
        String invoiceType = this.getPageCache().get("invoicetype");
        if (!EquipmentHelper.checkIsSupportSelectInvoiceRoll((String)invoiceType, (String)equipmentType)) {
            return;
        }
        PaperInvoiceRollInfoDTO paperInvoiceRollInfoDTO = EquipmentHelper.queryPaperInvoiceRollInfo((String)invoiceType, (String)equipmentNo);
        if (paperInvoiceRollInfoDTO == null || CollectionUtils.isEmpty((Collection)paperInvoiceRollInfoDTO.getVolumn())) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexvolumninfo"});
        for (PaperInvoiceRollInfoDTO.RollInfo volumn : paperInvoiceRollInfoDTO.getVolumn()) {
            if (!paperInvoiceRollInfoDTO.getInfo().getInvoice_code().equals(volumn.getInvoice_code()) || Long.parseLong(paperInvoiceRollInfoDTO.getInfo().getInvoice_num()) < Long.parseLong(volumn.getInvoice_num()) || Long.parseLong(paperInvoiceRollInfoDTO.getInfo().getInvoice_num()) > Long.parseLong(volumn.getInvoice_num()) + Long.parseLong(volumn.getAmount())) continue;
            String lc = InvoiceUtils.getInvoiceFormsType((String)volumn.getInvoice_code()).getDesc();
            String volumnInfoStr = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801: %1$s \u8d77\u59cb\u53f7\u7801: %2$s %3$s", (String)"InvalidReIssueDialogListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), volumn.getInvoice_code(), volumn.getInvoice_num(), lc);
            this.getModel().setValue("textvolumninfo", (Object)volumnInfoStr);
            break;
        }
    }

    private void popPaperInvoiceRollInfoDialog() {
        String equipmentNo = ObjectUtils.defaultIfNull((Object)this.getModel().getValue("jqbh"), (Object)"").toString();
        PaperInvoiceRollInfoDTO paperInvoiceRollInfoDTO = EquipmentHelper.queryPaperInvoiceRollInfo((String)this.getPageCache().get("invoicetype"), (String)equipmentNo);
        if (paperInvoiceRollInfoDTO == null) {
            return;
        }
        ViewUtil.openDialog((AbstractFormPlugin)this, (Map)BeanUtil.objectToMap((Object)paperInvoiceRollInfoDTO), (String)"sim_invoice_volumn_info", (String)"callback_sim_invoice_volumn_info_dialog");
    }
}

