/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.invalid;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.formplugin.issuing.AbstractVatInvoiceListPlugin;
import kd.imc.sim.formplugin.issuing.control.BatchInvoiceControl;
import kd.imc.sim.formplugin.issuing.invalid.InvalidInvoiceControl;
import org.apache.commons.lang.StringUtils;

public class InvoiceInvalidReopenListPlugin
extends AbstractVatInvoiceListPlugin {
    private static final String SIM_INVALID_PREVIEW_LIST = "sim_invalid_preview_list";
    private static final String BTN_REISSUE = "reissue";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_REISSUE});
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = new QFilter("invoicestatus", "=", (Object)"6");
        e.getCustomQFilters().add(qFilter);
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"exit"});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTN_REISSUE.equalsIgnoreCase(evt.getItemKey())) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u6570\u636e!", (String)"InvoiceInvalidReopenListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_RE_ISSUE, (DynamicObject[])load);
            TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)load[0].get("orgid")));
            String invoiceType = BatchInvoiceControl.checkSelectData((DynamicObject[])load, (boolean)false);
            for (DynamicObject object : load) {
                if (!"1".equals(object.getString("abolishtype"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a7a\u767d\u4f5c\u5e9f\u7684\u53d1\u7968\u4e0d\u80fd\u91cd\u5f00", (String)"InvoiceInvalidReopenListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("ids", primaryKeyValues);
            customParams.put("invoiceType", invoiceType);
            ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)SIM_INVALID_PREVIEW_LIST, (String)SIM_INVALID_PREVIEW_LIST);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if ("success".equals(returnData) && (SIM_INVALID_PREVIEW_LIST.equals(actionId) || "sim_create_invoice".equals(actionId))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u91cd\u5f00\u6210\u529f\uff0c\u8bf7\u5237\u65b0\u67e5\u770b\u91cd\u5f00\u72b6\u6001", (String)"InvoiceInvalidReopenListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else if ("singleReIssueSuccess".equals(returnData)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u5f00\u53d1\u7968\u6210\u529f", (String)"InvoiceInvalidReopenListPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refreshData();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("reorderno".equals(fieldName)) {
            HashMap<String, Object> params = this.invalidHyperLinkClick(args, fieldName);
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u91cd\u5f00\u53d1\u7968", (String)"InvoiceInvalidReopenListPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), params, (String)params.get("formId").toString(), null);
        } else if ("invoiceno".equals(fieldName)) {
            HashMap<String, Object> params = this.invalidHyperLinkClick(args, fieldName);
            if (params.get("invoiceBatchShowFid") != null) {
                ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, (String)(this.getView().getPageId() + params.get("invoiceBatchShowFid")), params, (String)"sim_create_invoice_inh", null, (String)ResManager.loadKDString((String)"\u5f85\u5f00\u4f5c\u5e9f\u91cd\u5f00", (String)"InvoiceInvalidReopenListPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            } else {
                ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, null, params, (String)"sim_create_invoice_valid", (String)"sim_create_invoice", (String)ResManager.loadKDString((String)"\u4f5c\u5e9f\u53d1\u7968\u8be6\u60c5", (String)"InvoiceInvalidReopenListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private HashMap<String, Object> invalidHyperLinkClick(HyperLinkClickArgs args, String fieldName) {
        args.setCancel(true);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValue = row.getPrimaryKeyValue();
        DynamicObject clickDynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"sim_vatinvoice");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if ("reorderno".equals(fieldName)) {
            QFilter qFilter = new QFilter("orderno", "=", (Object)clickDynamicObject.getString("reorderno"));
            qFilter.and("issuestatus", "=", (Object)"0");
            DynamicObject reIssueInvoiceDynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,issuestatus", (QFilter[])qFilter.toArray());
            if (reIssueInvoiceDynamicObject == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f5c\u5e9f\u53d1\u7968\u8fd8\u672a\u91cd\u5f00\u6210\u529f", (String)"InvoiceInvalidReopenListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            params.put("id", reIssueInvoiceDynamicObject.getPkValue());
        } else if ("invoiceno".equals(fieldName)) {
            DynamicObject dynamicObject;
            InvalidInvoiceControl.checkInvalidData((DynamicObject)clickDynamicObject);
            DynamicObject waitInvoiceDynamicObject = null;
            if (StringUtils.isNotEmpty((String)clickDynamicObject.getString("reorderno")) && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter("orderno", "=", (Object)clickDynamicObject.getString("reorderno")).toArray())) != null) {
                waitInvoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"sim_vatinvoice");
            }
            if (waitInvoiceDynamicObject == null) {
                params.put("invalidPrimaryKey", primaryKeyValue);
            } else {
                params.put("invoiceBatchShowFid", waitInvoiceDynamicObject.getPkValue());
            }
        }
        String invoiceType = clickDynamicObject.getString("invoicetype");
        String formId = InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceType) ? "sim_vatinvoice_show_roll" : "sim_vatinvoice_show";
        formId = InvoiceUtils.isAllEInvoice((Object)invoiceType) ? "sim_vatinvoice_show_all" : formId;
        params.put("formId", formId);
        return params;
    }
}

