/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.DataRepairHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.service.InvoiceIsmcSyncToImcService;

public class InvoiceSyncScheduleTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InvoiceSyncScheduleTask.class);
    private static final String REPAIR_CACHE = "REPAIR_INVOICE_DATA";
    private static final int REPAIR_CACHE_TIME = 1800;

    public void execute(RequestContext arg0, Map<String, Object> paramMap) throws KDException {
        DynamicObject[] dynamicObjects = InvoiceIsmcSyncToImcService.getNeedSyncPDFStatusInvoice();
        ArrayList<Object> repairInvoicePks = this.queryRepairPks();
        if (repairInvoicePks.size() > 0) {
            this.repairInvoices(repairInvoicePks);
        }
        if (dynamicObjects.length == 0) {
            LOGGER.info("InvoiceSyncScheduleTask \u672c\u6b21\u4efb\u52a1\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u53d1\u7968");
            return;
        }
        LOGGER.info(String.format("InvoiceSyncScheduleTask \u672c\u6b21\u4efb\u52a1\u66f4\u65b0%d\u5f20\u53d1\u7968", dynamicObjects.length));
        dynamicObjects = this.checkSyncData(dynamicObjects);
        LOGGER.info(String.format("InvoiceSyncScheduleTask \u5305\u542b\u53d1\u7968\u4fee\u590d\u6570\u636e\u5e76\u8fc7\u6ee4\u7684\u603b\u6570\u636e\u91cf:%d", dynamicObjects.length));
        try {
            List<JSONArray> jsonArrayList = this.get20Invoice(dynamicObjects, 200);
            int i = 0;
            boolean syncSussccess = false;
            Map param = ImcConfigUtil.getValue((String)"issue_speed_config");
            String syncTimes = (String)param.get("sync_invoice_status_items");
            int times = 2;
            if (StringUtils.isNotBlank((CharSequence)syncTimes)) {
                try {
                    times = Integer.parseInt(syncTimes);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            LOGGER.info(String.format("\u540c\u6b65\u6b21\u6570\uff1a%s", times));
            for (JSONArray jsonArray : jsonArrayList) {
                if (i >= times) break;
                String syncOrderNo = UUID.next();
                boolean executeSync = InvoiceIsmcSyncToImcService.executeSyncIsmcInvoice((Object)jsonArray, (String)syncOrderNo);
                if (executeSync) {
                    syncSussccess = true;
                }
                ++i;
            }
            if (syncSussccess) {
                LOGGER.info("InvoiceSyncScheduleTask \u66f4\u65b0OFD\u72b6\u6001\u6210\u529f");
            } else {
                LOGGER.info("InvoiceSyncScheduleTask \u66f4\u65b0OFD\u72b6\u6001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOGGER.info("InvoiceSyncScheduleTask Exception ", (Object)e);
        }
    }

    private void repairInvoices(ArrayList<Object> repairInvoicePks) {
        final DynamicObject[] repairArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"orderno,skm,checkcode,invoicetype,invoiceno,invoicecode,jqbh", (QFilter[])new QFilter("id", "in", (Object)repairInvoicePks.toArray(new Object[0])).toArray());
        if (repairInvoicePks.size() > 0 && StringUtils.isBlank((CharSequence)CacheHelper.get((String)REPAIR_CACHE))) {
            CacheHelper.put((String)REPAIR_CACHE, (String)"id", (int)1800);
            ThreadPools.executeOnceIncludeRequestContext((String)"repairInvoiceThread", (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LOGGER.info(String.format("syncRepairInvoiceSize:%s", repairArray.length));
                        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
                        int repairTime = 1;
                        if (repairArray.length <= 20) {
                            List invoices = InvoiceSyncScheduleTask.this.get20Invoice(repairArray, 20);
                            boolean executeSync = InvoiceIsmcSyncToImcService.executeSyncIsmcInvoice(invoices.get(0), null);
                            LOGGER.info(String.format("syncRepairInvoice:%s,time:%s", executeSync, repairTime++));
                        } else {
                            for (DynamicObject invoice : repairArray) {
                                JSONObject json = new JSONObject();
                                json.put("orderno", (Object)invoice.getString("orderno"));
                                jsonObjects.add(json);
                                if (jsonObjects.size() < 20) continue;
                                boolean executeSync = InvoiceIsmcSyncToImcService.executeSyncIsmcInvoice(jsonObjects, null);
                                LOGGER.info(String.format("syncRepairInvoice:%s,time:%s", executeSync, repairTime++));
                                jsonObjects.clear();
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (jsonObjects.size() > 0) {
                                boolean executeSync = InvoiceIsmcSyncToImcService.executeSyncIsmcInvoice(jsonObjects, null);
                                LOGGER.info(String.format("syncRepairInvoice:%s,time:%s", executeSync, repairTime++));
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("repairInvoiceError:" + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        CacheHelper.remove((String)InvoiceSyncScheduleTask.REPAIR_CACHE);
                    }
                }
            });
        }
    }

    private List<JSONArray> get20Invoice(DynamicObject[] dynamicObjects, int needSyncCount) {
        ArrayList<JSONArray> result = new ArrayList<JSONArray>();
        JSONArray jsonArray = new JSONArray();
        result.add(jsonArray);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (jsonArray.size() > needSyncCount) {
                jsonArray = new JSONArray();
                result.add(jsonArray);
            }
            jsonArray.add((Object)dynamicObject);
        }
        return result;
    }

    private DynamicObject[] checkSyncData(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> syncList = new ArrayList<DynamicObject>();
        for (DynamicObject invoice : dynamicObjects) {
            String invoiceType = invoice.getString("invoicetype");
            if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
                String skm = invoice.getString("skm");
                String checkCode = invoice.getString("checkcode");
                if ("4".equals(invoice.getString("issuesource"))) {
                    syncList.add(invoice);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)skm) || StringUtils.isBlank((CharSequence)checkCode)) {
                    DataRepairHelper.asyncRepairImcAndIsmcData((DynamicObject)invoice);
                    continue;
                }
                syncList.add(invoice);
                continue;
            }
            syncList.add(invoice);
        }
        dynamicObjects = syncList.toArray(new DynamicObject[0]);
        return dynamicObjects;
    }

    private ArrayList<Object> queryRepairPks() {
        DynamicObject[] invoicePks = BusinessDataServiceHelper.load((String)"sim_repair_invoice", (String)"invoicepk", null, (String)"invoicepk", (int)0, (int)500);
        ArrayList<Object> repairInvoicePks = new ArrayList<Object>();
        for (DynamicObject invoicePk : invoicePks) {
            repairInvoicePks.add(invoicePk.get("invoicepk"));
        }
        if (invoicePks.length == 0) {
            CacheHelper.remove((String)"sim_repair_invoice");
        }
        LOGGER.info("queryRepairPks\uff1a" + JSONObject.toJSONString(repairInvoicePks));
        return repairInvoicePks;
    }
}

