/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.constant.VatInvoicePushRecord;
import kd.imc.bdm.common.constant.table.MailSettingConstant;
import kd.imc.bdm.common.dto.InvoicePushTaskDTO;
import kd.imc.bdm.common.dto.PushProcessDTO;
import kd.imc.bdm.common.enums.PushStatusEnum;
import kd.imc.bdm.common.helper.DeviceHelper;
import kd.imc.bdm.common.helper.DownLoadCenterHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.MailSettingHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.SendMsgEmailService;
import kd.imc.bdm.common.util.ZipUtils;
import kd.imc.sim.formplugin.issuing.InvoiceQueryListPlugin;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.commons.io.FileUtils;

public class PushInvoiceTask
extends AbstractTask
implements SimFormPluginConstellationUntrans {
    private static Log LOGGER = LogFactory.getLog(PushInvoiceTask.class);
    private static String OFD = "ofd";
    private static String PDF = "pdf";
    private static String XML = "xml";
    private static String BASE_TEMP_DIRECTORY = "imcsimpushinvoice";
    private static String UPLOAD_ZIP_URL = "/doc/api/file/upload";

    public static void dispatchTask(InvoiceQueryListPlugin plugin, List<InvoicePushTaskDTO> totalTask) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u53d1\u7968\u6587\u4ef6\u63a8\u9001", (String)"PushInvoiceTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(PushInvoiceTask.class.getName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("request", JSONObject.toJSONString(totalTask));
        jobInfo.setParams(params);
        JobFormInfo formInfo = new JobFormInfo(jobInfo);
        formInfo.setCanBackground(true);
        formInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "dispatchTask"));
        formInfo.setTimeout(600);
        jobInfo.setAppId(plugin.getView().getFormShowParameter().getAppId());
        JobForm.dispatch((JobFormInfo)formInfo, (IFormView)plugin.getView());
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<Object, DynamicObject> needUpdateInvoicesMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> invoicePkMap = new HashMap();
        List task = null;
        PushProcessDTO pushProcess = new PushProcessDTO();
        try {
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u53d1\u7968\u63a8\u9001", (String)"PushInvoiceTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
            LOGGER.info("PushInvoiceTaskStart");
            task = JSONObject.parseArray((String)((String)map.get("request")), InvoicePushTaskDTO.class);
            int totalTask = task.size();
            invoicePkMap = this.getAllInvoices(task);
            this.getZipFileLimit(invoicePkMap, pushProcess);
            LOGGER.info("isSendAttachement:" + pushProcess.isSendAttachement());
            for (int i = 0; i < task.size(); ++i) {
                InvoicePushTaskDTO o = (InvoicePushTaskDTO)task.get(i);
                String orderNo = kd.imc.bdm.common.util.UUID.randomUUID();
                pushProcess.setTempBatchNo(orderNo);
                if (StringUtils.isBlank((CharSequence)pushProcess.getLastUsedBatchNo())) {
                    pushProcess.setLastUsedBatchNo(orderNo);
                }
                this.excutePushTask(needUpdateInvoicesMap, o, invoicePkMap, pushProcess);
                int progress = (i + 1) * 100 / totalTask;
                String desc = ResManager.loadKDString((String)"\u63a8\u9001\u4e2d", (String)"PushInvoiceTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                this.feedbackProgress(progress, desc, new HashMap());
            }
            result.put("success", Boolean.TRUE);
            result.put("errMsg", ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f", (String)"PushInvoiceTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        catch (MsgException e) {
            LOGGER.error("dealPushInvoiceTask" + e.getMessage(), (Throwable)e);
            result.put("success", Boolean.FALSE);
            result.put("errMsg", e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("dealPushInvoiceTask" + e.getMessage(), (Throwable)e);
            result.put("success", Boolean.FALSE);
            result.put("errMsg", e.getMessage());
        }
        if (pushProcess.getErrorCount() > 0) {
            String errorMsg = this.getErrorMsg(pushProcess);
            result.put("success", Boolean.FALSE);
            result.put("errMsg", errorMsg);
        }
        if (needUpdateInvoicesMap.size() > 0) {
            ArrayList list = new ArrayList(needUpdateInvoicesMap.values());
            ImcSaveServiceHelper.update(list);
        }
        this.deleteFileAndDirectory(pushProcess);
        this.feedbackCustomdata(result);
    }

    public void getZipFileLimit(Map<Object, DynamicObject> invoicePkMap, PushProcessDTO pushProcess) {
        DynamicObject emailObject = null;
        long org = 0L;
        int i = 0;
        for (Map.Entry<Object, DynamicObject> entry : invoicePkMap.entrySet()) {
            ++i;
            DynamicObject invoice = entry.getValue();
            org = invoice.getDynamicObject("orgid").getLong("id");
            try {
                String mailSettingPk = SendMsgEmailService.matchMailSettingByInvoice((DynamicObject)invoice);
                if (null == mailSettingPk) break;
                emailObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(mailSettingPk), (String)"bdm_mail");
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage(), (Object)e);
            }
            if (i != 1) continue;
            break;
        }
        if (null == emailObject) {
            LOGGER.info("noEmailConfig");
            pushProcess.setZipFileLimit(0x1E00000);
            return;
        }
        if (emailObject.getBoolean("attachementsend")) {
            int size = (Integer)SystemParameterHelper.getInvsmParameterValue((long)org, (String)"mail_attachement_size");
            if (size > 10 || size <= 0) {
                pushProcess.setZipFileLimit(0xA00000);
            } else {
                pushProcess.setZipFileLimit(size * 1024 * 1024);
            }
            LOGGER.info("attachementsend");
            pushProcess.setSendAttachement(true);
        } else {
            LOGGER.info("noEmailConfigattachementsend");
            pushProcess.setZipFileLimit(0x1E00000);
        }
    }

    public String getErrorMsg(PushProcessDTO pushProcess) {
        StringBuilder tipBuilder = new StringBuilder();
        this.appendErrorDescription(tipBuilder, pushProcess.getNoOfdPathPks(), FileType.OFD.getFileExtension(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230", (String)"PushInvoiceTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), "1", true);
        this.appendErrorDescription(tipBuilder, pushProcess.getNoPdfPathPks(), FileType.PDF.getFileExtension(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230", (String)"PushInvoiceTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), "1", true);
        this.appendErrorDescription(tipBuilder, pushProcess.getNoXmlPathPks(), FileType.XML.getFileExtension(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230", (String)"PushInvoiceTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), "1", true);
        this.appendErrorDescription(tipBuilder, pushProcess.getOfdDownloadErrorPks(), FileType.OFD.getFileExtension(), ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"PushInvoiceTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), "2", true);
        this.appendErrorDescription(tipBuilder, pushProcess.getPdfDownloadErrorPks(), FileType.PDF.getFileExtension(), ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"PushInvoiceTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), "2", true);
        this.appendErrorDescription(tipBuilder, pushProcess.getXmlDownloadErrorPks(), FileType.XML.getFileExtension(), ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"PushInvoiceTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), "2", false);
        return tipBuilder.toString();
    }

    private void appendErrorDescription(StringBuilder tipBuilder, List<Object> noOfdPathPks, String fileType, String baseDescription, String type, boolean appendLineSeparator) {
        if (noOfdPathPks.size() > 0) {
            if ("1".equalsIgnoreCase(type)) {
                tipBuilder.append(baseDescription).append(fileType).append(ResManager.loadKDString((String)"\u5730\u5740\u7684\u53d1\u7968\u53f7\u7801\uff1a", (String)"PushInvoiceTask_6", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(this.getInvoiceNos(noOfdPathPks));
            } else {
                tipBuilder.append(baseDescription).append(fileType).append(ResManager.loadKDString((String)"\u6587\u4ef6\u5931\u8d25\u7684\u53d1\u7968\u53f7\u7801\uff1a", (String)"PushInvoiceTask_7", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(this.getInvoiceNos(noOfdPathPks));
            }
            if (appendLineSeparator) {
                tipBuilder.append(System.lineSeparator());
            }
        }
    }

    public String getInvoiceNos(List<Object> invoiceNos) {
        StringBuilder invoiceNoBuilder = new StringBuilder();
        for (Object invoiceNo : invoiceNos) {
            invoiceNoBuilder.append(invoiceNo).append('\u3001');
        }
        String str = invoiceNoBuilder.toString();
        return str.substring(0, str.length() - 1);
    }

    public void deleteFileAndDirectory(PushProcessDTO pushProcess) {
        String[] orderNoArray;
        Set usedBatchNo = pushProcess.getUsedBatchNo();
        for (String orderNo : orderNoArray = usedBatchNo.toArray(new String[0])) {
            try {
                File zipFile;
                File file = new File(BASE_TEMP_DIRECTORY + File.separator + orderNo);
                if (file.exists() && file.isDirectory()) {
                    FileUtils.cleanDirectory((File)file);
                    if (file.exists()) {
                        boolean delete = file.delete();
                        LOGGER.info(String.format("\u76ee\u5f55:%s\u5220\u9664%s", orderNo, delete));
                    }
                }
                if (!(zipFile = new File(BASE_TEMP_DIRECTORY + File.separator + orderNo + ".zip")).exists()) continue;
                boolean delete = zipFile.delete();
                LOGGER.info(String.format("\u538b\u7f29\u5305:%s\u5220\u9664\u6210\u529f,%s", orderNo, delete));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map<Object, DynamicObject> getAllInvoices(List<InvoicePushTaskDTO> task) {
        Set<Object> invoicePkSet = task.stream().map(InvoicePushTaskDTO::getInvoicePk).filter(Objects::nonNull).collect(Collectors.toSet());
        String fields = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice");
        DynamicObject[] allInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)fields, (QFilter[])new QFilter("id", "in", (Object)invoicePkSet.toArray(new Object[0])).toArray());
        HashMap<Object, DynamicObject> invoicePkMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject invoice : allInvoices) {
            invoice.set("pushstatus", (Object)PushStatusEnum.failed.getCode());
            invoicePkMap.put(invoice.getPkValue(), invoice);
        }
        return invoicePkMap;
    }

    public void excutePushTask(Map<Object, DynamicObject> needUpdateInvoicesMap, InvoicePushTaskDTO task, Map<Object, DynamicObject> invoicePkMap, PushProcessDTO pushProcess) {
        String taskType;
        switch (taskType = task.getTaskType()) {
            case "1": {
                this.queryUrl(needUpdateInvoicesMap, task, invoicePkMap, pushProcess);
                break;
            }
            case "2": {
                this.downloadFile(task, invoicePkMap, pushProcess);
                break;
            }
            case "3": {
                if (pushProcess.getErrorCount() > 0) {
                    return;
                }
                PushInvoiceTask.zipFileAndSend(task, pushProcess, invoicePkMap);
                break;
            }
            case "4": {
                if (pushProcess.getErrorCount() > 0) {
                    return;
                }
                if (needUpdateInvoicesMap.size() > 0) {
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(needUpdateInvoicesMap.values());
                    ImcSaveServiceHelper.update(list);
                }
                this.oriSendEmail(task, invoicePkMap);
            }
        }
    }

    private void oriSendEmail(InvoicePushTaskDTO task, Map<Object, DynamicObject> invoicePkMap) {
        String email = task.getEmail();
        Object invoicePk = task.getInvoicePk();
        DynamicObject invoice = invoicePkMap.get(invoicePk);
        try {
            MsgResponse response = SendMsgEmailService.emailMultiDefaultOrBySelf((DynamicObject)invoice, (String)email);
            if (!ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%s\u63a8\u9001\u5931\u8d25", (String)"PushInvoiceTask_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("invoiceno")));
            }
            invoice.set("pushstatus", (Object)PushStatusEnum.success.getCode());
        }
        catch (MsgException e) {
            LOGGER.error(e.getErrorMsg(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s,\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"PushInvoiceTask_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("invoiceno"), e.getErrorMsg()));
        }
        catch (KDBizException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\u63a8\u9001\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"PushInvoiceTask_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("invoiceno"), e.getMessage()));
        }
    }

    public static void zipFileAndSend(InvoicePushTaskDTO task, PushProcessDTO pushProcess, Map<Object, DynamicObject> invoicePkMap) {
        String[] orderNos;
        for (String orderNo : orderNos = pushProcess.getUsedBatchNo().toArray(new String[0])) {
            try {
                ZipUtils.fileToZip((File)new File(BASE_TEMP_DIRECTORY + File.separator + orderNo), (String)(BASE_TEMP_DIRECTORY + File.separator + orderNo + ".zip"));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u538b\u7f29\u53d1\u7968\u6587\u4ef6\u5931\u8d25", (String)"PushInvoiceTask_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            File zipFile = new File(BASE_TEMP_DIRECTORY + File.separator + orderNo + ".zip");
            if (!zipFile.exists()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e0b\u8f7d\u7684zip\u6587\u4ef6", (String)"PushInvoiceTask_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            String uploadZipFileUrl = PushInvoiceTask.uploadFile(zipFile);
            String emails = task.getEmail();
            LOGGER.info("email:" + emails);
            Map orderMap = pushProcess.getOrderNoInovicePkListMap();
            Set invoicePks = (Set)orderMap.get(orderNo);
            ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>();
            for (Object invoicePk : invoicePks) {
                DynamicObject invoice = invoicePkMap.get(invoicePk);
                invoiceList.add(invoice);
            }
            PushInvoiceTask.sendEmail(uploadZipFileUrl, emails, invoiceList, pushProcess.isSendAttachement());
            PushInvoiceTask.markInvoicesSendSuccess(invoiceList);
        }
    }

    private static void markInvoicesSendSuccess(ArrayList<DynamicObject> invoiceList) {
        for (DynamicObject invoice : invoiceList) {
            invoice.set("pushstatus", (Object)PushStatusEnum.success.getCode());
        }
        ImcSaveServiceHelper.update(invoiceList);
    }

    public static void sendEmail(String uploadZipFileUrl, String emails, ArrayList<DynamicObject> dynamicObjects, boolean isSendAttachement) {
        String[] emailArray = emails.split(";");
        DynamicObject invoice = dynamicObjects.get(0);
        String emailPk = SendMsgEmailService.matchMailSettingByInvoice((DynamicObject)invoice);
        if (StringUtils.isBlank((CharSequence)emailPk)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u90ae\u7bb1\u8bbe\u7f6e", (String)"PushInvoiceTask_21", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        DynamicObject emailObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(emailPk), (String)"bdm_mail");
        String sendOption = emailObject.getString("sendinvoiceoption");
        boolean isSelfEmail = sendOption.equals(MailSettingConstant.SendInvoiceOption.CUSTOM_MAIL.getValue());
        String template = emailObject.getString("mailtempoption");
        boolean isCustomStyle = template.equals(MailSettingConstant.MailTempOption.CUSTOM_STYLE.getValue());
        String emailBody = emailObject.getString("multimailbody_tag");
        String multiTitle = emailObject.getString("multimailtitle");
        String multiFields = emailObject.getString("multifields");
        if (StringUtils.isBlank((CharSequence)multiFields)) {
            multiFields = String.join((CharSequence)",", "buyername", "totalamount", "invoicecode", "invoiceno", "issuetime");
        }
        DynamicObject[] pushRecords = new DynamicObject[dynamicObjects.size()];
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject pushRecord;
            pushRecords[i] = pushRecord = VatInvoicePushRecord.getPushRecord((DynamicObject)dynamicObjects.get(i));
        }
        for (String s : emailArray) {
            try {
                for (DynamicObject pushRecord : pushRecords) {
                    DynamicObjectCollection emailEntryEntity = pushRecord.getDynamicObjectCollection("entryentity");
                    DynamicObject emailEntry = emailEntryEntity.addNew();
                    emailEntry.set("epushtime", (Object)new Date());
                    emailEntry.set("email", (Object)VatInvoicePushRecord.getCutString((int)50, (String)s));
                    if (isSelfEmail) {
                        emailEntry.set("epushtemplate", (Object)template);
                        continue;
                    }
                    emailEntry.set("epushtemplate", (Object)"2");
                }
                if (isSelfEmail && StringUtils.isNotBlank((CharSequence)emailBody) && StringUtils.isNotBlank((CharSequence)multiTitle) && isCustomStyle) {
                    String invoiceListTemp = MailSettingHelper.generateContentTable((String)multiFields, dynamicObjects, (Map)MailSettingHelper.getSelectMap());
                    emailBody = MailSettingHelper.replacceKey2Value((String)emailBody, (String)"[\u53d1\u7968\u5217\u8868]", (String)invoiceListTemp);
                    LOGGER.info("emailBody:" + emailBody);
                    emailBody = MailSettingHelper.replacceKey2Value((String)emailBody, (String)"[&amp;zip\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740&amp;]", (String)uploadZipFileUrl);
                    String emailContent = MailSettingHelper.replacePlaceholder((String)emailBody, (DynamicObject)invoice, (Boolean)Boolean.FALSE);
                    LOGGER.info("emailBody:" + emailContent);
                    String emailTitle = MailSettingHelper.replacePlaceholder((String)multiTitle, (DynamicObject)invoice, (Boolean)Boolean.TRUE);
                    if (StringUtils.isBlank((CharSequence)emailTitle)) {
                        emailTitle = "\u3010\u91d1\u8776\u53d1\u7968\u4e91\u3011\u60a8\u7533\u8bf7\u7684\u53d1\u7968\u6570\u636e\u5df2\u9001\u8fbe";
                    }
                    PushInvoiceTask.sendCustomEmail(uploadZipFileUrl, isSendAttachement, emailObject, emailContent, s, emailTitle, pushRecords);
                    continue;
                }
                if (isSelfEmail && !isCustomStyle) {
                    emailBody = MailSettingHelper.generateDefaultContent(dynamicObjects);
                    emailBody = MailSettingHelper.replacceKey2Value((String)emailBody, (String)"[&amp;zip\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740&amp;]", (String)uploadZipFileUrl);
                    PushInvoiceTask.sendCustomEmail(uploadZipFileUrl, isSendAttachement, emailObject, emailBody, s, "\u3010\u91d1\u8776\u53d1\u7968\u4e91\u3011\u60a8\u7533\u8bf7\u7684\u53d1\u7968\u6570\u636e\u5df2\u9001\u8fbe", pushRecords);
                    continue;
                }
                SendMsgEmailService.sendEmailZip((String)s, (String)uploadZipFileUrl, dynamicObjects, (boolean)isSendAttachement, (DynamicObject[])pushRecords);
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void sendCustomEmail(String uploadZipFileUrl, boolean isSendAttachement, DynamicObject emailObject, String emailBody, String s, String emailTitle) {
        PushInvoiceTask.sendCustomEmail(uploadZipFileUrl, isSendAttachement, emailObject, emailBody, s, emailTitle, null);
    }

    private static void sendCustomEmail(String uploadZipFileUrl, boolean isSendAttachement, DynamicObject emailObject, String emailBody, String s, String emailTitle, DynamicObject[] pushRecords) {
        MsgResponse msgResponse;
        if (isSendAttachement) {
            HashMap<String, String> attachedMap = new HashMap<String, String>();
            attachedMap.put(uploadZipFileUrl, "\u53d1\u7968\u538b\u7f29\u5305.zip");
            msgResponse = SendMsgEmailService.sendAttachementEmailBySelf((String)s, (String)emailTitle, (String)emailBody, attachedMap, (DynamicObject)emailObject);
        } else {
            msgResponse = SendMsgEmailService.sendEmailBySelf((String)emailBody, (String)s, (DynamicObject)emailObject, (String)emailTitle);
        }
        boolean isSuccess = ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode());
        SendMsgEmailService.savePushRecords((DynamicObject[])pushRecords, (boolean)isSuccess, (String)msgResponse.getErrorMsg());
        if (!isSuccess) {
            throw new KDBizException(msgResponse.getErrorMsg());
        }
    }

    public static String uploadFile(File zipFile) {
        Map awsConfigMap = ImcConfigUtil.getValue((String)"dim_imc_config_fpy");
        LOGGER.info("\u83b7\u53d6aws\u914d\u7f6e\u4fe1\u606f" + SerializationUtils.toJsonString((Object)awsConfigMap));
        String clientId = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"clientid", "dim_imc_config_fpy_clientid"});
        String clientSecret = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"clientsecret", "dim_imc_config_fpy_clientsecret"});
        BufferedInputStream is = null;
        try {
            AwsFpyService awsFpyService = AwsFpyService.newInstance();
            String accessToken = awsFpyService.getAccessToken(clientId, clientSecret);
            String url = awsFpyService.getBaseUrl() + UPLOAD_ZIP_URL + "?access_token=" + accessToken + "&encry_type=GCM";
            String proxy = awsFpyService.getProxy();
            is = new BufferedInputStream(new FileInputStream(zipFile));
            String dateStr = DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("client-platform", "common");
            JSONObject uploadResult = HttpUtil.uploadZipFile((String)url, (String)proxy, (InputStream)is, (String)("invoice_" + dateStr + ".zip"), headers, (String)clientId, (boolean)true);
            JSONObject json = uploadResult.getJSONObject("data");
            String string = json.getString("originalUrl");
            return string;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u53d1\u7968\u6587\u4ef6\u538b\u7f29\u5305\u5931\u8d25:%s", (String)"PushInvoiceTask_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void downloadFile(InvoicePushTaskDTO task, Map<Object, DynamicObject> invoicePkMap, PushProcessDTO pushProcess) {
        String fileFullName;
        int fileSize;
        byte[] bytes;
        Object invoicePk = task.getInvoicePk();
        DynamicObject invoice = invoicePkMap.get(invoicePk);
        String invoiceOrderNo = invoice.getString("orderno");
        String invoiceType = invoice.getString("invoicetype");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            this.downloadFile(invoice, invoice.getString("pdffileurl"), FileType.PDF.getFileExtension(), pushProcess);
            this.downloadFile(invoice, invoice.getString("fileurl"), FileType.OFD.getFileExtension(), pushProcess);
            this.downloadFile(invoice, invoice.getString("xmlfileurl"), FileType.XML.getFileExtension(), pushProcess);
            return;
        }
        String issueSource = invoice.getString("issuesource");
        JSONArray orderNoJson = DownLoadCenterHelper.getOrderNoJson((String)invoiceOrderNo);
        String ismcFileType = DeviceHelper.isOfdDevice((String)issueSource) ? OFD : PDF;
        try {
            bytes = this.reGetFileBytesFromIsmc(orderNoJson, 2);
            fileSize = bytes.length;
            if (fileSize < 1000) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s\u4e0b\u8f7d\u7684\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38", (String)"PushInvoiceTask_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("invoiceno")));
            }
        }
        catch (Exception e) {
            pushProcess.addDownloadErrorInvoiceNo(ismcFileType, invoice.getString("invoiceno"));
            LOGGER.error(e.getMessage(), (Throwable)e);
            return;
        }
        this.resetBatchNoAndSize(pushProcess, fileSize);
        this.addOrderNoMap(invoice, pushProcess);
        pushProcess.getUsedBatchNo().add(pushProcess.getCurrentBatchNo());
        pushProcess.setCurrentTotalSize(pushProcess.getCurrentTotalSize() + fileSize);
        if (DeviceHelper.isOfdDevice((String)issueSource)) {
            this.createDirectory(pushProcess.getCurrentBatchNo(), OFD);
            fileFullName = this.getFileFullName(invoice, pushProcess.getCurrentBatchNo(), FileType.OFD.getFileExtension());
        } else {
            this.createDirectory(pushProcess.getCurrentBatchNo(), PDF);
            fileFullName = this.getFileFullName(invoice, pushProcess.getCurrentBatchNo(), FileType.PDF.getFileExtension());
        }
        this.write2File(new ByteArrayInputStream(bytes), fileFullName);
    }

    private void resetBatchNoAndSize(PushProcessDTO pushProcess, int fileSize) {
        if (pushProcess.getCurrentTotalSize() + fileSize > pushProcess.getZipFileLimit()) {
            pushProcess.setCurrentBatchNo(pushProcess.getTempBatchNo());
            pushProcess.setLastUsedBatchNo(pushProcess.getCurrentBatchNo());
            pushProcess.setCurrentTotalSize(fileSize);
        } else {
            pushProcess.setCurrentBatchNo(pushProcess.getLastUsedBatchNo());
            pushProcess.setCurrentTotalSize(fileSize + pushProcess.getCurrentTotalSize());
        }
    }

    private byte[] reGetFileBytesFromIsmc(JSONArray orderNoJson, int retryTime) throws Exception {
        for (int i = 0; i < retryTime; ++i) {
            String uuid = UUID.randomUUID().toString();
            InputStream is = DownLoadCenterHelper.getFileFromIsmc((String)uuid, (JSONArray)orderNoJson);
            byte[] bytes = PushInvoiceTask.streamToByteArray(is);
            if (null != bytes && bytes.length > 1000) {
                return bytes;
            }
            this.sleep();
        }
        return new byte[0];
    }

    private void downloadFile(DynamicObject invoice, String ofdUrl, String fileType, PushProcessDTO pushProcess) {
        if (StringUtils.isBlank((CharSequence)ofdUrl)) {
            pushProcess.setCurrentBatchNo(pushProcess.getLastUsedBatchNo());
            this.createDirectory(pushProcess.getCurrentBatchNo(), OFD, PDF, XML);
            pushProcess.getUsedBatchNo().add(pushProcess.getCurrentBatchNo());
            return;
        }
        byte[] fileByteArray = this.reGetFileInputStream(ofdUrl, 2);
        int fileLength = null == fileByteArray ? 0 : fileByteArray.length;
        if (StringUtils.isBlank((CharSequence)ImcConfigUtil.getValue((String)"downloadSizeCheck", (String)"downloadSizeCheck"))) {
            LOGGER.info(String.format("%s\u7684\u6587\u4ef6\u5927\u5c0f\uff1a%s", fileType, fileLength));
            if (!FileType.XML.getFileExtension().equals(fileType) && fileLength < 1800) {
                pushProcess.addDownloadErrorInvoiceNo(fileType, invoice.getString("invoiceno"));
                return;
            }
            if (fileLength < 700) {
                pushProcess.addDownloadErrorInvoiceNo(fileType, invoice.getString("invoiceno"));
                return;
            }
        }
        this.recordSizeAndBatchNo(fileType, pushProcess, fileLength);
        this.addOrderNoMap(invoice, pushProcess);
        this.createDirectory(pushProcess.getCurrentBatchNo(), OFD, PDF, XML);
        String fullName = this.getFileFullName(invoice, pushProcess.getCurrentBatchNo(), fileType);
        if ("xml".equals(fileType)) {
            fullName = fullName.substring(0, fullName.length() - 3) + "zip";
        }
        if (null != fileByteArray) {
            this.write2File(new ByteArrayInputStream(fileByteArray), fullName);
        }
    }

    private void recordSizeAndBatchNo(String fileType, PushProcessDTO pushProcess, int fileLength) {
        if (FileType.PDF.getFileExtension().equals(fileType)) {
            this.resetBatchNoAndSize(pushProcess, fileLength);
        } else {
            pushProcess.setCurrentTotalSize(fileLength + pushProcess.getCurrentTotalSize());
        }
    }

    private byte[] reGetFileInputStream(String ofdUrl, int retryTime) {
        byte[] bytes = null;
        for (int i = 0; i < retryTime; ++i) {
            bytes = this.getBytesFromUrl(ofdUrl);
            if (null != bytes && bytes.length > 1000) {
                return bytes;
            }
            this.sleep();
        }
        return bytes;
    }

    private void sleep() {
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private byte[] getBytesFromUrl(String ofdUrl) {
        try {
            InputStream is1 = DownLoadCenterHelper.getInputStream((String)ofdUrl);
            return PushInvoiceTask.streamToByteArray(is1);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void addOrderNoMap(DynamicObject invoice, PushProcessDTO pushProcess) {
        Map orderNoMap = pushProcess.getOrderNoInovicePkListMap();
        Set invoicePks = orderNoMap.computeIfAbsent(pushProcess.getCurrentBatchNo(), k -> new HashSet());
        invoicePks.add(invoice.getPkValue());
        pushProcess.getUsedBatchNo().add(pushProcess.getCurrentBatchNo());
    }

    /*
     * Loose catch block
     */
    private static byte[] streamToByteArray(InputStream is) throws Exception {
        try {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int len;
                byte[] b = new byte[1024];
                while ((len = is.read(b)) != -1) {
                    bos.write(b, 0, len);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
    }

    private String getFileFullName(DynamicObject invoice, String batchNo, String fileType) {
        String baseDirectory = BASE_TEMP_DIRECTORY + File.separator + batchNo + File.separator + fileType;
        File file = new File(baseDirectory);
        if (!file.exists()) {
            boolean isSuccess = file.mkdirs();
            LOGGER.info("" + isSuccess);
        }
        String fileName = SendMsgEmailService.getFileName((DynamicObject)invoice, (String)("." + fileType));
        return baseDirectory + File.separator + fileName;
    }

    private void write2File(InputStream input, String fileFullName) {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            File file = new File(fileFullName);
            if (!file.exists()) {
                boolean isSuccess = file.createNewFile();
                LOGGER.info("" + isSuccess);
            }
            in = new BufferedInputStream(input);
            out = new BufferedOutputStream(new FileOutputStream(fileFullName));
            int len = -1;
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                ((BufferedOutputStream)out).write(b, 0, len);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void createDirectory(String orderNo, String ... types) {
        File file = new File(BASE_TEMP_DIRECTORY + File.separator + orderNo);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (String type : types) {
            File ofdDirectory = new File(BASE_TEMP_DIRECTORY + File.separator + orderNo + File.separator + type);
            if (ofdDirectory.exists()) continue;
            ofdDirectory.mkdir();
        }
    }

    private void queryUrl(Map<Object, DynamicObject> needUpdateInvoicesMap, InvoicePushTaskDTO task, Map<Object, DynamicObject> invoicePkMap, PushProcessDTO pushProcess) {
        String[] array;
        Object invoicePk = task.getInvoicePk();
        DynamicObject invoice = invoicePkMap.get(invoicePk);
        String fileTypeStr = task.getTaskParam();
        for (String s : array = fileTypeStr.split(",")) {
            int fileType;
            if ("file".equals(s)) {
                s = "ofd";
            }
            if (0 == (fileType = this.getFileType(s))) continue;
            String fieldKey = this.getFieldKey(s);
            String url = null;
            try {
                url = InvoiceQueryControl.queryUrl((DynamicObject)invoice, (int)fileType);
            }
            catch (KDBizException e) {
                if (String.valueOf(e.getMessage()).contains("\u672a\u67e5\u8be2\u5230")) {
                    pushProcess.addNoUrlInvoiceNo(s, invoice.getString("invoiceno"));
                }
                throw e;
            }
            invoice.set(fieldKey, (Object)url);
        }
        invoice.set("ofdstatus", (Object)"1");
        needUpdateInvoicesMap.put(invoice.getPkValue(), invoice);
    }

    private int getFileType(String s) {
        if ("xml".equalsIgnoreCase(s)) {
            return 3;
        }
        if ("pdf".equalsIgnoreCase(s)) {
            return 2;
        }
        if ("ofd".equalsIgnoreCase(s)) {
            return 1;
        }
        return 0;
    }

    private String getFieldKey(String s) {
        if ("xml".equalsIgnoreCase(s)) {
            return "xmlfileurl";
        }
        if ("pdf".equalsIgnoreCase(s)) {
            return "pdffileurl";
        }
        return "fileurl";
    }
}

