/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.formplugin.issuing.task.MatchBillAsyncTask;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillMailHelper;

public class RedConfirmMailPushTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RedConfirmMailPushTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)MatchBillAsyncTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                return;
            }
            try {
                Date date = DateUtils.getAWholeHour(null);
                LOGGER.info(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u63a8\u9001\u90ae\u4ef6\u672c\u6b21\u65f6\u95f4\u70b9[%s]", date));
                RedConfirmBillMailHelper.getRedConfirmBill();
                this.sendRedConfirmBillMail(date);
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u90ae\u4ef6\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[%s]", e.getMessage()));
            }
        }
    }

    private void sendRedConfirmBillMail(Date pushDate) {
        try {
            DynamicObject[] pushRecords = BusinessDataServiceHelper.load((String)"sim_confirm_mail_record", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_confirm_mail_record"), (QFilter[])new QFilter("1", "=", (Object)1).toArray());
            HashMap sendMap = Maps.newHashMapWithExpectedSize((int)0);
            for (DynamicObject pushRecord : pushRecords) {
                try {
                    String customTime;
                    boolean needSend = false;
                    Date uploadDate = pushRecord.getDate("uploaddate");
                    boolean pushOneOrTwo = DateUtils.getHourTimeDiff((Date)pushDate, (Date)uploadDate, (int)60);
                    String pushTimes = pushRecord.getString("pushtimes");
                    if (pushOneOrTwo && pushTimes.contains(",0,") && pushRecord.getInt("onedaypush") == 0 && DateUtils.compare((Date)DateUtils.addDay((Date)pushDate, (int)-2), (Date)uploadDate) == 0) {
                        pushRecord.set("onedaypush", (Object)(pushRecord.getInt("onedaypush") + 1));
                        needSend = true;
                    }
                    if (pushOneOrTwo && pushTimes.contains(",1,") && pushRecord.getInt("onedaypush") == 0 && DateUtils.compare((Date)DateUtils.addDay((Date)pushDate, (int)-1), (Date)uploadDate) == 0) {
                        pushRecord.set("twodaypush", (Object)(pushRecord.getInt("twodaypush") + 1));
                        needSend = true;
                    }
                    if (pushTimes.contains(",2,") && pushRecord.getInt("pushimm") == 0) {
                        pushRecord.set("pushimm", (Object)(pushRecord.getInt("pushimm") + 1));
                        needSend = true;
                    }
                    if (pushTimes.contains(",3,") && StringUtils.isNotEmpty((CharSequence)(customTime = pushRecord.getString("pushtimecustom")))) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(pushDate);
                        if (Integer.parseInt(customTime) == calendar.get(11)) {
                            pushRecord.set("pushcustom", (Object)(pushRecord.getInt("pushcustom") + 1));
                            needSend = true;
                        }
                    }
                    if (!needSend) continue;
                    RedConfirmBillMailHelper.buildSendMap((DynamicObject)pushRecord, (Map)sendMap);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u63a8\u9001\u62a5\u9519[%s], \u63a8\u9001\u8bb0\u5f55[%s]", e.getMessage(), SerializationUtils.toJsonString((Object)pushRecord)));
                }
            }
            RedConfirmBillMailHelper.sendMailMethod((Map)sendMap);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u63a8\u9001\u62a5\u9519[%s]", e.getMessage()));
        }
    }
}

