/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.UserParam;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imc.sim.billcenter.sys.OperaCommonLogicService;
import org.apache.commons.collections.CollectionUtils;

public class SimBillCenterUserManageTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SimBillCenterUserManageTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramsMap) throws KDException {
        logger.info("SimBillCenterUserManageTask\uff0c\u82cd\u7a79\u5e73\u53f0\u7528\u6237\u8d26\u53f7\u7981\u7528\u4efb\u52a1\u7684\u529f\u80fd\uff01");
        try (DLock lock = DLock.create((String)SimBillCenterUserManageTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                logger.error("SimBillCenterUserManageTask-\u5f53\u524d\u5b9a\u65f6\u4efb\u52a1\u7684\u7ebf\u7a0b\u672a\u83b7\u53d6\u5230\u76f8\u5173\u7684\u9501\u673a\u5236\uff01");
                return;
            }
            String systemSource = (String)paramsMap.get("systemSource");
            String userName = (String)paramsMap.get("userName");
            String userPhone = (String)paramsMap.get("userPhone");
            String userEmail = (String)paramsMap.get("userEmail");
            String startDate = (String)paramsMap.get("startDate");
            String endDate = (String)paramsMap.get("endDate");
            logger.info("SimBillCenterUserManageTask, systemSource:{}, userName:{}, userPhone:{}, userEmail:{}, startDate:{}, endDate:{}", new Object[]{systemSource, userName, userPhone, userEmail, startDate, endDate});
            ArrayList<String> userIdList = new ArrayList<String>(10);
            if ("chimelong".equals(systemSource)) {
                OperaCommonLogicService operaCommonLogicService = new OperaCommonLogicService();
                operaCommonLogicService.dealLoadDepartEmployeesMethod(userIdList, startDate, endDate);
            }
            logger.info("SimBillCenterUserManageTask, userIdList\u5927\u5c0f:{}", (Object)userIdList.size());
            this.dealSetEmployeeDisableMethod(userIdList, userName, userPhone, userEmail);
        }
    }

    private void dealSetEmployeeDisableMethod(List<String> userIdList, String userName, String userPhone, String userEmail) {
        QFilter personFilter = CollectionUtils.isNotEmpty(userIdList) ? new QFilter("number", "in", userIdList) : new QFilter("number", "=", (Object)userName).or("phone", "=", (Object)userPhone).or("email", "=", (Object)userEmail);
        DynamicObject[] personObjectArray = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])personFilter.toArray());
        if (personObjectArray == null || personObjectArray.length == 0) {
            return;
        }
        logger.info("dealSetEmployeeDisableMethod, personObjectArray\u7684\u5927\u5c0f:{}", (Object)personObjectArray.length);
        block0: for (DynamicObject personObject : personObjectArray) {
            Long personId = personObject.getLong("id");
            UserParam userParam = new UserParam();
            userParam.setId(personId.longValue());
            List<UserParam> userParamList = Collections.singletonList(userParam);
            UserServiceHelper.disableUser(userParamList);
            UserServiceHelper.disable(userParamList);
            for (UserParam result : userParamList) {
                boolean flag = result.isSuccess();
                String message = result.getMsg();
                logger.info("SimBillCenterUserManageTask, flag:{}, message:{}", (Object)flag, (Object)message);
                if (!result.isSuccess()) continue;
                continue block0;
            }
        }
    }
}

