/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleInvoiceApplyAsyncRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleInvoiceQueryAsyncRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.service.ApiLogService;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceResponseDTO;
import kd.imc.sim.common.dto.allele.AllVehicleBillResponseDTO;
import kd.imc.sim.common.dto.allele.UsedCarFullInvoiceResponseDTO;
import kd.imc.sim.common.dto.allele.VehicleInvoiceResponseDTO;
import kd.imc.sim.common.dto.syncinvoice.SyncQueryInvoiceDTO;
import kd.imc.sim.common.service.InvoiceAddServiceImpl;
import kd.imc.sim.common.utils.CollectionsUtils;
import kd.imc.sim.formplugin.invoicebatch.TaxInvoiceImportUtil;
import kd.imc.sim.formplugin.issuing.helper.DataSyncHelper;
import kd.imc.sim.schedule.syncinvoice.SyncDevInvoiceTask;
import org.apache.commons.lang3.StringUtils;

public class SimHisInvDataImportTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SimHisInvDataImportTask.class);
    private static final String TASK_NAME_PRE = "SimHisInvDataImportTask_";
    private static final String TASK_NAME_FILE = "SimHisInvDataImportTask_FILE";
    private static final String INVOICE_FIELDS = "invoicecode,invoiceno,alletaxinvoiceno,invoicetype,salertaxno,buyertaxno,specialtype,issuetime";
    private static final String QUERY_STATUS_SUCCESS_SQL = "select count(1) as count from t_sim_his_inv_data_imp_st where fexecutionstatus = '%s' and fimportentryid = %s";
    private static final String INVOICE_FILE_FIELDS = "invoiceno,issuetime,buyertaxno,buyername,salertaxno,salername,totalamount";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)"SimHisInvDataImportTask_lock");){
            if (lock.tryLock(1000L)) {
                DynamicObject[] dataArr;
                long currentId = 0L;
                while ((dataArr = this.getData(currentId)) != null && dataArr.length != 0) {
                    logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u68c0\u6d4b\u5230\u5b58\u5728,\u5f00\u59cb\u5904\u7406\u3002");
                    for (DynamicObject data : dataArr) {
                        long id = data.getLong("id");
                        if (id > currentId) {
                            currentId = id;
                        }
                        this.execData(data);
                    }
                }
                this.deleteTemp();
                logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165\uff0c\u5904\u7406\u7ed3\u675f\u3002");
            } else {
                logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165\uff0c\u5904\u7406\u7ed3\u675f\u3002\u672a\u83b7\u53d6\u5230\u9501");
            }
        }
    }

    private void deleteTemp() {
        try {
            if (CacheHelper.get((String)"deletetempflag") == null) {
                Date latDate = DateUtils.addHour((Date)new Date(), (int)-12);
                String sql = "delete from t_sim_import_temp where fcreatetime< ? ";
                DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)sql, (Object[])new Object[]{latDate});
                CacheHelper.put((String)"deletetempflag", (String)"1", (int)43200);
                logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165\uff0c\u5220\u9664\u4e34\u65f6\u6570\u636e");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execData(DynamicObject data) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)"sim_his_inv_data_import");
        String billNo = dynamicObject.getString("billno");
        try (DLock lock = DLock.create((String)(TASK_NAME_PRE + billNo));){
            if (!lock.tryLock(600000L)) {
                return;
            }
            dynamicObject.set("executionstatus", (Object)"2");
            ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
            logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u5f00\u59cb\u4efb\u52a1:{}", (Object)billNo);
            String importMethod = dynamicObject.getString("importmethod");
            String dataType = dynamicObject.getString("datatype");
            if ("3".equals(dataType)) {
                this.downRimInvoiceFile(dynamicObject);
            } else if ("2".equals(importMethod)) {
                this.execInvoiceFileData(dynamicObject);
            } else {
                this.saveInvoiceInterFaceData(dynamicObject);
            }
            logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u7ed3\u675f\u4efb\u52a1:{}", (Object)billNo);
        }
    }

    private Date getPeriodDate(DynamicObject item, SimpleDateFormat format, boolean isStartDate) {
        LocalDate yesterday;
        String invoiceDate = item.getString("detailinvoicedate");
        YearMonth yearMonth = YearMonth.parse(invoiceDate);
        String startDateStr = yearMonth.atDay(1).format(kd.imc.sim.common.utils.DateUtils.FORMATTER_DATE);
        LocalDate endLocalDate = yearMonth.atEndOfMonth();
        if (endLocalDate.isAfter(yesterday = LocalDate.now().minus(1L, ChronoUnit.DAYS))) {
            endLocalDate = yesterday;
        }
        String endDateStr = endLocalDate.format(kd.imc.sim.common.utils.DateUtils.FORMATTER_DATE);
        Date startDate = new Date();
        Date endDate = new Date();
        try {
            if (isStartDate) {
                return format.parse(startDateStr);
            }
            Date endReulst = format.parse(endDateStr);
            Calendar instance = Calendar.getInstance();
            instance.setTime(endReulst);
            instance.add(5, 1);
            return instance.getTime();
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (isStartDate) {
                return startDate;
            }
            Calendar instance = Calendar.getInstance();
            instance.setTime(endDate);
            instance.add(5, 1);
            return instance.getTime();
        }
    }

    public void downRimInvoiceFile(DynamicObject dynamicObject) {
        String issueAccount = dynamicObject.getString("issueaccount");
        logger.info("billno:" + dynamicObject.getString("billno"));
        String taxNo = dynamicObject.getDynamicObject("epinfo").getString("number");
        issueAccount = this.getIssueAccount(issueAccount, taxNo);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> invokeLogList = new ArrayList<DynamicObject>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        int batchSize = this.getQueryFileBatchSize();
        JSONObject billProcess = new JSONObject();
        if (entryEntity != null && !entryEntity.isEmpty()) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                try {
                    int count;
                    DynamicObject item = (DynamicObject)entryEntity.get(i);
                    String executeStatus = item.getString("detailexecutionstatus");
                    boolean isFinishStatus = "5".equals(executeStatus) || "4".equals(executeStatus) || "3".equals(executeStatus);
                    QFilter detailTaskFilter = new QFilter("detailtaskno", "=", (Object)item.getString("detailtaskno"));
                    DynamicObject[] invokeLogs = BusinessDataServiceHelper.load((String)"sim_imp_rim_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_imp_rim_file", (boolean)true), (QFilter[])detailTaskFilter.toArray());
                    if (isFinishStatus || this.checkFinished(invokeLogs)) {
                        logger.info("billnoItemFinish:" + dynamicObject.getString("billno"));
                        continue;
                    }
                    DynamicObject maxSeqLog = this.getInvokeMinInvoicePk(invokeLogs);
                    Date startDate = this.getPeriodDate(item, format, true);
                    Date endDate = this.getPeriodDate(item, format, false);
                    String invoiceType = item.getString("detailinvoicetype");
                    QFilter baseFilter = new QFilter("issuetime", ">", (Object)startDate).and("issuetime", "<", (Object)endDate).and("salertaxno", "=", (Object)taxNo).and("invoicetype", "=", (Object)invoiceType);
                    QFilter baseShouGouFilter = new QFilter("issuetime", ">", (Object)startDate).and("issuetime", "<", (Object)endDate).and("buyertaxno", "=", (Object)taxNo).and("invoicetype", "=", (Object)invoiceType).and("specialtype", "=", (Object)"02");
                    long minPk = 0L;
                    long minShouGouPk = 0L;
                    DynamicObject lastLogObj = null;
                    boolean isPurchase = false;
                    boolean isOneRowAllSuccess = true;
                    int querySeq = 0;
                    if (null != maxSeqLog) {
                        querySeq = maxSeqLog.getInt("queryseq") + 1;
                        if ("1".equals(maxSeqLog.getString("ispurchase"))) {
                            isPurchase = true;
                            minShouGouPk = maxSeqLog.getLong("mininvoicepk");
                        } else {
                            minPk = maxSeqLog.getLong("mininvoicepk");
                        }
                        lastLogObj = maxSeqLog;
                    }
                    JSONArray loopArray = new JSONArray();
                    JSONObject oneRowJson = new JSONObject();
                    oneRowJson.put("loopProcess", (Object)loopArray);
                    billProcess.put(item.getString("detailtaskno"), (Object)oneRowJson);
                    int loopQueryIndex = 0;
                    do {
                        JSONObject oneQuery = new JSONObject();
                        loopArray.add((Object)oneQuery);
                        QFilter filter = baseFilter.copy();
                        QFilter shouGouFilter = baseShouGouFilter.copy();
                        if (minPk != 0L) {
                            filter.and("id", "<", (Object)minPk);
                        }
                        if (minShouGouPk != 0L) {
                            shouGouFilter.and("id", "<", (Object)minShouGouPk);
                        }
                        DynamicObject[] invoices = null;
                        if (!isPurchase && (invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)INVOICE_FILE_FIELDS, (QFilter[])filter.toArray(), (String)"id desc", (int)batchSize)).length > 0) {
                            minPk = invoices[invoices.length - 1].getLong("id");
                        }
                        if (invoices == null || invoices.length == 0) {
                            invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)INVOICE_FILE_FIELDS, (QFilter[])shouGouFilter.toArray(), (String)"id desc", (int)batchSize);
                            if (invoices.length > 0) {
                                minShouGouPk = invoices[invoices.length - 1].getLong("id");
                            }
                            isPurchase = true;
                        }
                        count = invoices.length;
                        if ("1".equals(ImcConfigUtil.getValue((String)"logHistoryFileDetail", (String)"logHistoryFileDetail"))) {
                            oneQuery.put("invoices.length", (Object)count);
                            oneQuery.put("loopQueryIndex", (Object)loopQueryIndex++);
                            oneQuery.put("isPurchase", (Object)isPurchase);
                            oneQuery.put("filterStr", (Object)filter.toString());
                            oneQuery.put("shouGouFilterStr", (Object)shouGouFilter.toString());
                        }
                        if (invoices.length > 0) {
                            DynamicObject logObj = this.excuteInvoiceFileDownload(dynamicObject, item, invoices, issueAccount, querySeq, isPurchase, oneQuery);
                            if (null != logObj) {
                                oneQuery.put("logObj", (Object)logObj.getString("rpabatchno"));
                                invokeLogList.add(logObj);
                                ++querySeq;
                            } else {
                                oneQuery.put("logObj", (Object)"empty");
                                oneQuery.put("oneLoopStatus", (Object)"breakLoop");
                                isOneRowAllSuccess = false;
                                lastLogObj = this.generateEmptyLog(dynamicObject, item);
                                lastLogObj.set("finish", (Object)"2");
                                invokeLogList.add(lastLogObj);
                                break;
                            }
                            lastLogObj = logObj;
                        }
                        if (!isPurchase || invoices.length != 0 || null != lastLogObj || querySeq != 0) continue;
                        oneQuery.put("oneLoopStatus", (Object)"queryNoData");
                        lastLogObj = this.generateEmptyLog(dynamicObject, item);
                        invokeLogList.add(lastLogObj);
                    } while (count > 0);
                    oneRowJson.put("rowComplete", (Object)false);
                    if (null == lastLogObj || !isOneRowAllSuccess) continue;
                    oneRowJson.put("rowComplete", (Object)true);
                    lastLogObj.set("finish", (Object)"1");
                    continue;
                }
                catch (Exception e) {
                    logger.info("billnoError:" + dynamicObject.getString("billno"));
                    logger.error("repeatInvokeError:" + e.getMessage(), (Throwable)e);
                }
            }
            if (invokeLogList.size() > 0) {
                ImcSaveServiceHelper.save(invokeLogList);
            }
            new ApiLogService("logHistoryFileDetail", dynamicObject.getString("billno"), billProcess.toJSONString()).saveLog("");
            logger.info("billnoFinishCount:" + dynamicObject.getString("billno"));
            this.countRowTotalNum(dynamicObject);
            ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }

    private String getIssueAccount(String issueAccount, String taxNo) {
        if (StringUtils.isNotBlank((CharSequence)issueAccount)) {
            if (issueAccount.startsWith(",")) {
                issueAccount = issueAccount.substring(1);
            }
            if (issueAccount.endsWith(",")) {
                issueAccount = issueAccount.substring(0, issueAccount.length() - 1);
            }
        }
        logger.info("baseIssueAccount:" + issueAccount);
        if (StringUtils.isBlank((CharSequence)issueAccount)) {
            issueAccount = AllEleAuthHelper.getEleAccount((String)taxNo, (boolean)true);
        }
        logger.info("issueAccount:" + issueAccount);
        return issueAccount;
    }

    private DynamicObject[] filterInvoices(DynamicObject[] invoices) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (DynamicObject invoice : invoices) {
            if (StringUtils.isBlank((CharSequence)invoice.getString("invoiceno")) || null == invoice.getDate("issuetime") || StringUtils.isBlank((CharSequence)invoice.getString("buyername")) || StringUtils.isBlank((CharSequence)invoice.getString("salername")) || BigDecimalUtil.compareZero((BigDecimal)invoice.getBigDecimal("totalamount"))) continue;
            result.add(invoice);
        }
        return result.toArray(new DynamicObject[0]);
    }

    private int getQueryFileBatchSize() {
        String value = ImcConfigUtil.getValue((String)"rim_deduction", (String)"rpa_max_size_down_ele_file");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                int querySize = Integer.parseInt(value);
                if (querySize < 1 || querySize > 1000) {
                    return 1000;
                }
                return querySize;
            }
            catch (Exception e) {
                logger.error("getQueryFileBatchSizeError:" + e.getMessage(), (Throwable)e);
            }
        }
        return 1000;
    }

    private void countRowTotalNum(DynamicObject dynamicObject) {
        String billNo = dynamicObject.getString("billno");
        QFilter detailTaskFilter = new QFilter("impbatchno", "=", (Object)billNo);
        DynamicObject[] invokeLogs = BusinessDataServiceHelper.load((String)"sim_imp_rim_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_imp_rim_file", (boolean)true), (QFilter[])detailTaskFilter.toArray());
        new InvoiceAddServiceImpl().updateHistoryExcuteStatus(dynamicObject, invokeLogs);
    }

    private DynamicObject generateEmptyLog(DynamicObject dynamicObject, DynamicObject item) {
        DynamicObject lastLogObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_imp_rim_file");
        lastLogObj.set("impbatchno", (Object)dynamicObject.getString("billno"));
        lastLogObj.set("detailtaskno", (Object)item.getString("detailtaskno"));
        lastLogObj.set("rpabatchsize", (Object)0);
        lastLogObj.set("beforerpasize", (Object)0);
        lastLogObj.set("rowcomplete", (Object)"1");
        lastLogObj.set("queryseq", (Object)0);
        lastLogObj.set("finish", (Object)"1");
        lastLogObj.set("createtime", (Object)new Date());
        lastLogObj.set("modifytime", (Object)new Date());
        return lastLogObj;
    }

    private DynamicObject getInvokeMinInvoicePk(DynamicObject[] invokeLogs) {
        if (invokeLogs.length == 0) {
            return null;
        }
        int maxSeq = 0;
        DynamicObject maxSeqLog = null;
        for (DynamicObject invokeLog : invokeLogs) {
            int seq = invokeLog.getInt("queryseq");
            if (seq <= maxSeq) continue;
            maxSeq = seq;
            maxSeqLog = invokeLog;
        }
        return maxSeqLog;
    }

    private boolean checkFinished(DynamicObject[] invokeLogs) {
        if (invokeLogs.length == 0) {
            return false;
        }
        for (DynamicObject invokeLog : invokeLogs) {
            if (!"1".equals(invokeLog.getString("finish"))) continue;
            return true;
        }
        return false;
    }

    private DynamicObject excuteInvoiceFileDownload(DynamicObject dynamicObject, DynamicObject item, DynamicObject[] invoices, String rimAccount, int querySeq, boolean isPurchase, JSONObject oneQuery) {
        DynamicObject[] filterInvoices;
        ArrayList<Map<String, Object>> invoiceList = new ArrayList<Map<String, Object>>();
        DynamicObject epInfo = dynamicObject.getDynamicObject("epinfo");
        String taxNo = epInfo.getString("number");
        Map<String, Object> param = this.generateParam(item, rimAccount, invoiceList, taxNo);
        String cityCode = this.getCityCode(taxNo);
        for (DynamicObject invoice : filterInvoices = this.filterInvoices(invoices)) {
            this.addOneInvoice2List(invoiceList, cityCode, invoice);
        }
        logger.info("rpaRequest:" + JSONObject.toJSONString(param));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"downOutFile", (Object[])new Object[]{param});
        Object errCode = result.get("errcode");
        JSONObject resultJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)result));
        logger.info("rpaResponse:" + resultJson);
        if (ErrorType.SUCCESS.getErrcode().equals(errCode)) {
            item.set("detailexecutionstatus", (Object)"2");
            return this.generateOneBatchQueryLog(dynamicObject, item, invoices, filterInvoices, querySeq, isPurchase, resultJson);
        }
        JSONArray failArray = resultJson.getJSONArray("failInvoices");
        String description = resultJson.getString("description");
        if (null == failArray) {
            JSONObject json = new JSONObject();
            json.put("description", (Object)description);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)json);
            resultJson.put("failInvoices", (Object)jsonArray);
        }
        Set cuurentFailDescriptions = new InvoiceAddServiceImpl().addItemFailReasons(failArray, item);
        oneQuery.put("invokeFailReason", (Object)cuurentFailDescriptions);
        return null;
    }

    private Map<String, Object> generateParam(DynamicObject item, String rimAccount, List<Map<String, Object>> invoiceList, String taxNo) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String invoiceType = item.getString("detailinvoicetype");
        String rimInvoiceType = InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType) ? "26" : "27";
        param.put("taxNo", taxNo);
        param.put("account", rimAccount);
        param.put("snapshotMark", true);
        param.put("invoiceTypes", rimInvoiceType);
        param.put("invoices", invoiceList);
        return param;
    }

    private DynamicObject generateOneBatchQueryLog(DynamicObject dynamicObject, DynamicObject item, DynamicObject[] invoices, DynamicObject[] filterInvoices, int querySeq, boolean isPurchase, JSONObject resultJson) {
        JSONArray successInvoices = resultJson.getJSONArray("successInvoices");
        int totalSize = filterInvoices.length;
        if (null != successInvoices) {
            totalSize = successInvoices.size();
        }
        String rpaBatchNo = resultJson.getString("batchNo");
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_imp_rim_file");
        logObj.set("rpabatchno", (Object)rpaBatchNo);
        logObj.set("impbatchno", (Object)dynamicObject.getString("billno"));
        logObj.set("detailtaskno", (Object)item.getString("detailtaskno"));
        logObj.set("rpabatchsize", (Object)totalSize);
        logObj.set("beforerpasize", (Object)invoices.length);
        logObj.set("rowcomplete", (Object)"0");
        logObj.set("queryseq", (Object)querySeq);
        logObj.set("mininvoicepk", invoices[invoices.length - 1].getPkValue());
        logObj.set("createtime", (Object)new Date());
        logObj.set("modifytime", (Object)new Date());
        logObj.set("finish", (Object)"0");
        logObj.set("ispurchase", (Object)(isPurchase ? "1" : "0"));
        return logObj;
    }

    private void addOneInvoice2List(List<Map<String, Object>> invoiceList, String cityCode, DynamicObject invoice) {
        int[] array = new int[]{-1};
        HashMap<String, Object> oneInvoice = new HashMap<String, Object>();
        oneInvoice.put("invoiceNo", invoice.getString("invoiceno"));
        oneInvoice.put("invoiceDate", kd.imc.sim.common.utils.DateUtils.formatDate((Date)invoice.getDate("issuetime"), (DateTimeFormatter)kd.imc.sim.common.utils.DateUtils.FORMATTER_TIME));
        oneInvoice.put("buyerTaxNo", invoice.getString("buyertaxno"));
        oneInvoice.put("buyerName", invoice.getString("buyername"));
        oneInvoice.put("salerTaxNo", invoice.getString("salertaxno"));
        oneInvoice.put("salerName", invoice.getString("salername"));
        oneInvoice.put("totalAmount", invoice.getString("totalamount"));
        oneInvoice.put("cityCode", cityCode);
        oneInvoice.put("fileTypes", array);
        logger.info("oneInvoiceLog:" + JSONObject.toJSONString(oneInvoice));
        invoiceList.add(oneInvoice);
    }

    private String getCityCode(String taxNo) {
        DynamicObject taxCity;
        DynamicObject[] epINfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"tax_city", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
        if (epINfos.length > 0 && null != (taxCity = epINfos[0].getDynamicObject("tax_city"))) {
            return taxCity.getString("number");
        }
        return "";
    }

    public void saveInvoiceInterFaceData(DynamicObject dynamicObject) {
        String issueAccount = dynamicObject.getString("issueaccount");
        if (StringUtils.isNotBlank((CharSequence)issueAccount)) {
            if (issueAccount.startsWith(",")) {
                issueAccount = issueAccount.substring(1);
            }
            if (issueAccount.endsWith(",")) {
                issueAccount = issueAccount.substring(0, issueAccount.length() - 1);
            }
        }
        DynamicObject epInfo = dynamicObject.getDynamicObject("epinfo");
        long orgId = epInfo.getLong("org.id");
        String taxNo = epInfo.getString("number");
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        if (entryEntity != null && !entryEntity.isEmpty()) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject item = (DynamicObject)entryEntity.get(i);
                String executionStatus = item.getString("detailexecutionstatus");
                String dataType = dynamicObject.getString("datatype");
                boolean isInvoiceData = "1".equals(dataType);
                if ("0".equals(executionStatus)) {
                    String status = isInvoiceData ? "2" : "1";
                    item.set("detailexecutionstatus", (Object)status);
                    entryEntity.set(i, (Object)item);
                    dynamicObject.set("entryentity", (Object)entryEntity);
                    ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
                } else if ("4".equals(executionStatus) || "5".equals(executionStatus)) continue;
                boolean syncSuccess = isInvoiceData ? this.syncInvoiceData(dynamicObject, entryEntity, taxNo, orgId, issueAccount, i) : this.syncInvoiceStatus(dynamicObject, entryEntity, taxNo, orgId, issueAccount, i);
                if (!syncSuccess) break;
            }
        }
        if ((entryEntity = dynamicObject.getDynamicObjectCollection("entryentity")) != null && !entryEntity.isEmpty()) {
            String executionStatusOriginal = dynamicObject.getString("executionstatus");
            String executionStatusNew = null;
            int totalNum = entryEntity.size();
            int successNum = 0;
            int failNum = 0;
            int partSuccessNum = 0;
            for (DynamicObject item : entryEntity) {
                String executionStatus = item.getString("detailexecutionstatus");
                if ("2".equals(executionStatus)) {
                    executionStatusNew = "2";
                    break;
                }
                if ("4".equals(executionStatus)) {
                    ++successNum;
                    continue;
                }
                if ("5".equals(executionStatus)) {
                    ++failNum;
                    continue;
                }
                if (!"3".equals(executionStatus)) continue;
                ++partSuccessNum;
            }
            if (executionStatusNew == null) {
                executionStatusNew = totalNum == successNum ? "4" : (totalNum == failNum ? "5" : (partSuccessNum == 0 && failNum == 0 && successNum == 0 ? "0" : "3"));
            }
            if (!executionStatusNew.equals(executionStatusOriginal)) {
                dynamicObject.set("executionstatus", (Object)executionStatusNew);
                ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        }
    }

    private boolean syncInvoiceStatus(DynamicObject dynamicObject, DynamicObjectCollection entryEntity, String taxNo, long orgId, String account, int index) {
        DynamicObject item = (DynamicObject)entryEntity.get(index);
        String invoiceDateMonth = item.getString("detailinvoicedate");
        String invoiceTypeStr = item.getString("detailinvoicetype");
        List invoiceTypeList = CollectionsUtils.getListFromStr((String)invoiceTypeStr);
        YearMonth yearMonth = YearMonth.parse(invoiceDateMonth);
        LocalDateTime startDateTime = yearMonth.atDay(1).atStartOfDay();
        LocalDateTime endDateTime = yearMonth.atEndOfMonth().atTime(23, 59, 59);
        if (yearMonth.equals(YearMonth.now())) {
            endDateTime = LocalDate.now().minusDays(1L).atTime(23, 59, 59);
        }
        int totalNum = 0;
        while (!startDateTime.isAfter(endDateTime)) {
            QFilter qFilter = this.getInvoiceDataQFilter(invoiceTypeList, taxNo, startDateTime);
            totalNum = this.syncInvoiceDataToSt(dynamicObject, item, index, qFilter, totalNum, orgId, account);
            startDateTime = startDateTime.plusDays(1L);
        }
        boolean updateFlag = this.updateEntry(dynamicObject, index, "detailexecutionstatus", "2");
        if (!updateFlag) {
            return false;
        }
        String downloadChannel = dynamicObject.getString("downloadchannel");
        boolean isRpa = "2".equals(downloadChannel);
        int successNum = 0;
        successNum = isRpa ? this.asyncInvoiceDataFromSt(dynamicObject, taxNo, item, index) : this.syncInvoiceDataFromSt(dynamicObject, item, index);
        String execStatus = "3";
        if (totalNum != 0 && successNum == 0) {
            execStatus = "5";
        } else if (totalNum == successNum) {
            execStatus = "4";
        } else if (successNum == -1) {
            execStatus = "2";
        }
        return this.updateEntry(dynamicObject, index, "detailexecutionstatus", execStatus);
    }

    private int syncInvoiceDataFromSt(DynamicObject importData, DynamicObject item, int index) {
        int totalSuccessNum;
        DynamicObject[] dataArr;
        String batchNo = importData.getString("billno");
        Object entryKey = item.getPkValue();
        QFilter awaitQFilter = this.getInvoiceStQFilter(batchNo, entryKey, true);
        int successNum = 0;
        String downloadChannel = importData.getString("downloadchannel");
        boolean isRpa = "2".equals(downloadChannel);
        while ((dataArr = BusinessDataServiceHelper.load((String)"sim_his_inv_data_imp_st", (String)"id", (QFilter[])awaitQFilter.toArray(), (String)"id", (int)200)) != null && dataArr.length != 0) {
            for (DynamicObject dataPri : dataArr) {
                DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)dataPri.getPkValue(), (String)"sim_his_inv_data_imp_st");
                successNum += this.queryRedInfoPre(data, isRpa);
            }
            boolean updateFlag = this.updateEntry(importData, index, "detailsuccessnum", successNum);
            if (updateFlag) continue;
            break;
        }
        if ((totalSuccessNum = this.getSyncInvoiceStSuccessNum(entryKey)) != successNum) {
            this.updateEntry(importData, index, "detailsuccessnum", totalSuccessNum);
        }
        return totalSuccessNum;
    }

    private int asyncInvoiceDataFromSt(DynamicObject importData, String taxNo, DynamicObject item, int index) {
        String batchNo = importData.getString("billno");
        Object entryKey = item.getPkValue();
        QFilter awaitQFilter = this.getInvoiceStQFilter(batchNo, entryKey, true);
        String optionAccountList = importData.getString("issueaccount");
        if (optionAccountList != null && optionAccountList.startsWith(",")) {
            optionAccountList = optionAccountList.substring(1);
        }
        DataSyncHelper.asyncQueryInvoicePurposeStatusReqToRpa((String)optionAccountList, (String)taxNo, (QFilter)awaitQFilter);
        this.updateEntry(importData, index, "detailexecutionstatus", "2");
        QFilter inProgressQFilter = this.getInvoiceStQFilter(batchNo, entryKey, false);
        boolean isUpdating = DataSyncHelper.asyncQueryInvoicePurposeStatusRespFromRpa((String)optionAccountList, (String)taxNo, (QFilter)inProgressQFilter);
        int totalSuccessNum = this.getSyncInvoiceStSuccessNum(entryKey);
        this.updateEntry(importData, index, "detailsuccessnum", totalSuccessNum);
        if (isUpdating) {
            return -1;
        }
        return totalSuccessNum;
    }

    private int getSyncInvoiceStSuccessNum(Object entryKey) {
        String executionStatus = "4";
        String sql = String.format(QUERY_STATUS_SUCCESS_SQL, executionStatus, entryKey);
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)"getSyncInvoiceStSuccessNum", (DBRoute)new DBRoute("taxc"), (String)sql);){
            if (ds != null) {
                count = ds.next().getLong("count").intValue();
            }
        }
        return count;
    }

    private int queryRedInfoPre(DynamicObject data, boolean isRpa) {
        String applicant = data.getString("keylabel");
        String sellerTaxNo = data.getString("salertaxno");
        String buyerTaxNo = data.getString("buyertaxno");
        String account = data.getString("issueaccount");
        String invoiceCode = data.getString("invoicecode");
        String invoiceNo = data.getString("invoiceno");
        String invoiceType = data.getString("invoicetype");
        String invoiceDate = data.getString("invoicedate");
        Object invoiceId = data.get("invoiceid");
        JSONObject resultJson = isRpa ? DataSyncHelper.queryRedInfoPreRpa((String)applicant, (String)sellerTaxNo, (String)buyerTaxNo, (String)account, (String)invoiceCode, (String)invoiceNo, (String)invoiceType, (String)invoiceDate, (Object)invoiceId) : DataSyncHelper.queryRedInfoPreLeqi((String)applicant, (String)sellerTaxNo, (String)buyerTaxNo, (String)invoiceCode, (String)invoiceNo, (String)invoiceType, (String)invoiceDate, (Object)invoiceId);
        int success = resultJson.getIntValue("success");
        String failMsg = resultJson.getString("failMsg");
        String executionStatus = success == 1 ? "4" : "5";
        data.set("executionstatus", (Object)executionStatus);
        data.set("failreason", (Object)failMsg);
        ImcSaveServiceHelper.update((DynamicObject)data);
        return success;
    }

    private QFilter getInvoiceStQFilter(String batchNo, Object entryKey, boolean isAwait) {
        QFilter qFilter = new QFilter("billno", "=", (Object)batchNo);
        qFilter.and("importentryid", "=", entryKey);
        if (isAwait) {
            QFilter statusFilter = new QFilter("executionstatus", "=", (Object)"0");
            statusFilter.or("executionstatus", "=", (Object)"1");
            qFilter.and(statusFilter);
        } else {
            qFilter.and("executionstatus", "=", (Object)"2");
        }
        return qFilter;
    }

    private int syncInvoiceDataToSt(DynamicObject importData, DynamicObject item, int entryIndex, QFilter qFilter, int totalNum, long orgId, String account) {
        DynamicObject[] dataArr;
        String batchNo = importData.getString("billno");
        String downloadChannel = importData.getString("downloadchannel");
        Object entryKey = item.getPkValue();
        int pageIndex = 0;
        while ((dataArr = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)INVOICE_FIELDS, (QFilter[])qFilter.toArray(), (String)"issuetime", (int)pageIndex, (int)200)) != null && dataArr.length != 0) {
            totalNum += dataArr.length;
            ArrayList<DynamicObject> invoiceStatusDataList = new ArrayList<DynamicObject>(dataArr.length);
            for (DynamicObject invoiceData : dataArr) {
                Object invoiceId = invoiceData.getPkValue();
                DynamicObject dynamicObject = this.queryInvoiceSdByInvoiceId(invoiceId, entryKey);
                if (dynamicObject != null) continue;
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_his_inv_data_imp_st");
                dynamicObject.set("billno", (Object)batchNo);
                dynamicObject.set("org", (Object)orgId);
                dynamicObject.set("downloadchannel", (Object)downloadChannel);
                dynamicObject.set("invoicecode", (Object)invoiceData.getString("invoicecode"));
                dynamicObject.set("invoiceno", (Object)invoiceData.getString("invoiceno"));
                String allETaxInvoiceNo = invoiceData.getString("alletaxinvoiceno");
                if ("--".equals(allETaxInvoiceNo)) {
                    allETaxInvoiceNo = "";
                }
                dynamicObject.set("alletaxinvoiceno", (Object)allETaxInvoiceNo);
                String invoiceType = invoiceData.getString("invoicetype");
                dynamicObject.set("invoicetype", (Object)invoiceType);
                Date issueTime = invoiceData.getDate("issuetime");
                if (issueTime != null) {
                    String issueTimeStr = kd.imc.sim.common.utils.DateUtils.formatDate((Date)issueTime, (DateTimeFormatter)kd.imc.sim.common.utils.DateUtils.FORMATTER_TIME);
                    dynamicObject.set("invoicedate", (Object)issueTimeStr);
                }
                String specialTypeStr = invoiceData.getString("specialtype");
                SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue((String)specialTypeStr);
                String keyLabel = "1";
                String buyerTaxNo = invoiceData.getString("buyertaxno");
                String sellerTaxNo = invoiceData.getString("salertaxno");
                if (SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS == specialType || SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS_02 == specialType) {
                    keyLabel = "2";
                    buyerTaxNo = invoiceData.getString("salertaxno");
                    sellerTaxNo = invoiceData.getString("buyertaxno");
                }
                dynamicObject.set("specialtype", (Object)specialTypeStr);
                dynamicObject.set("issueaccount", (Object)account);
                dynamicObject.set("salertaxno", (Object)sellerTaxNo);
                dynamicObject.set("buyertaxno", (Object)buyerTaxNo);
                dynamicObject.set("keylabel", (Object)keyLabel);
                dynamicObject.set("importentryid", entryKey);
                dynamicObject.set("invoiceid", invoiceId);
                dynamicObject.set("executionstatus", (Object)"0");
                invoiceStatusDataList.add(dynamicObject);
            }
            boolean updateFlag = this.updateEntry(importData, entryIndex, "detailtotalnum", totalNum);
            if (!updateFlag) break;
            ImcSaveServiceHelper.save(invoiceStatusDataList);
            ++pageIndex;
        }
        return totalNum;
    }

    private DynamicObject queryInvoiceSdByInvoiceId(Object invoiceId, Object entryKey) {
        QFilter qFilterC = new QFilter("importentryid", "=", entryKey);
        qFilterC.and(new QFilter("invoiceid", "=", invoiceId));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_his_inv_data_imp_st", (String)"id", (QFilter[])qFilterC.toArray());
        if (dynamicObject != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"sim_his_inv_data_imp_st");
        }
        return dynamicObject;
    }

    private boolean updateEntry(DynamicObject dynamicObject, int index, String key, Object value) {
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObject item = (DynamicObject)entryEntity.get(index);
        item.set(key, value);
        entryEntity.set(index, (Object)item);
        dynamicObject.set("entryentity", (Object)entryEntity);
        return this.updateData(dynamicObject);
    }

    private boolean specialInvoiceType(String invoiceType) {
        return InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType);
    }

    private QFilter getInvoiceDataQFilter(List<String> invoiceTypeList, String taxNo, LocalDateTime start) {
        QFilter qFilter = new QFilter("invoicetype", "in", invoiceTypeList);
        qFilter.and("salertaxno", "=", (Object)taxNo);
        qFilter.and("issuetype", "=", (Object)"0");
        qFilter.and("invoicestatus", "=", (Object)"0");
        LocalDateTime end = start.withHour(23).withMinute(59).withSecond(59);
        qFilter.and("issuetime", ">=", (Object)start);
        qFilter.and("issuetime", "<=", (Object)end);
        return qFilter;
    }

    private boolean syncInvoiceData(DynamicObject dynamicObject, DynamicObjectCollection entryEntity, String taxNo, long orgId, String account, int index) {
        LocalDate yesterday;
        DynamicObject item = (DynamicObject)entryEntity.get(index);
        String invoiceDate = item.getString("detailinvoicedate");
        YearMonth yearMonth = YearMonth.parse(invoiceDate);
        String startDate = yearMonth.atDay(1).format(kd.imc.sim.common.utils.DateUtils.FORMATTER_DATE);
        LocalDate endLocalDate = yearMonth.atEndOfMonth();
        if (endLocalDate.isAfter(yesterday = LocalDate.now().minus(1L, ChronoUnit.DAYS))) {
            endLocalDate = yesterday;
        }
        String endDate = endLocalDate.format(kd.imc.sim.common.utils.DateUtils.FORMATTER_DATE);
        String invoiceType = item.getString("detailinvoicetype");
        SyncQueryInvoiceDTO dto = new SyncQueryInvoiceDTO();
        dto.setStartDate(startDate);
        dto.setEndDate(endDate);
        dto.setTaxNo(taxNo);
        dto.setOrgId(Long.valueOf(orgId));
        dto.setAccount(account);
        dto.setFromHistorySync(true);
        dto.setOldInvoiceType(invoiceType);
        boolean successFlag = Boolean.FALSE;
        try {
            boolean updateFlag;
            String downloadChannel = dynamicObject.getString("downloadchannel");
            String detailTaskNo = item.getString("detailtaskno");
            boolean isRpa = "2".equals(downloadChannel);
            invoiceType = InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceType);
            if (isRpa && StringUtils.isBlank((CharSequence)invoiceType)) {
                invoiceType = "-1";
            }
            dto.setInvoiceType(invoiceType);
            if (StringUtils.isEmpty((CharSequence)detailTaskNo) && StringUtils.isNotEmpty((CharSequence)(detailTaskNo = isRpa ? this.asyncQueryInvoiceDataReq(dto) : this.syncInvoiceDataFromLeqiApply(dto))) && !(updateFlag = this.updateEntry(dynamicObject, index, "detailtaskno", detailTaskNo))) {
                return Boolean.FALSE;
            }
            Map<String, Integer> resultMap = isRpa ? this.asyncQueryInvoiceDataRsp(detailTaskNo, dto) : this.syncInvoiceDataFromLeqiQuery(detailTaskNo);
            if (resultMap == null) {
                return Boolean.TRUE;
            }
            Integer totalNum = resultMap.get("TOTAL_NUM");
            Integer successNum = resultMap.get("SUCCESS_NUM");
            item.set("detailtotalnum", (Object)totalNum);
            item.set("detailsuccessnum", (Object)successNum);
            item.set("detailexecutionstatus", (Object)"4");
            item.set("detailfailreason", (Object)ErrorType.SUCCESS.getDescription());
            successFlag = Boolean.TRUE;
        }
        catch (MsgException msgException) {
            logger.error("SimHisInvDataImportTask msgException", (Throwable)msgException);
            if (ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u540c\u6b65\u7684\u53d1\u7968\u6570\u636e", (String)"SimHisInvDataImportTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]).equals(msgException.getErrorMsg())) {
                item.set("detailtotalnum", (Object)0);
                item.set("detailsuccessnum", (Object)0);
                item.set("detailexecutionstatus", (Object)"4");
                successFlag = Boolean.TRUE;
            }
            item.set("detailfailreason", (Object)msgException.getErrorMsg());
        }
        catch (Exception e) {
            logger.error("SimHisInvDataImportTask exception", (Throwable)e);
            item.set("detailfailreason", (Object)String.format(ResManager.loadKDString((String)"\u5185\u90e8\u5904\u7406\u5f02\u5e38\uff0ctraceid\u4e3a[%s]", (String)"SimHisInvDataImportTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
        if (!successFlag) {
            item.set("detailexecutionstatus", (Object)"5");
        }
        entryEntity.set(index, (Object)item);
        dynamicObject.set("entryentity", (Object)entryEntity);
        return this.updateData(dynamicObject);
    }

    private String syncInvoiceDataFromLeqiApply(SyncQueryInvoiceDTO body) {
        HashMap<String, Object> param = new HashMap<String, Object>(5);
        param.put("invoiceType", body.getInvoiceType());
        param.put("taxNo", body.getTaxNo());
        param.put("orgId", body.getOrgId());
        param.put("dataType", 2);
        param.put("firstDate", body.getStartDate());
        param.put("endDate", body.getEndDate());
        Map applyResponse = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"outInvoiceApply", (Object[])new Object[]{param});
        logger.info("\u7533\u8bf7\u4e50\u4f01\u53d1\u7968\u6570\u636e\u540c\u6b65\u4efb\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u8fd4\u56de\u53c2\u6570\uff1a{}", param, (Object)applyResponse);
        if (applyResponse == null || applyResponse.get("data") == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u7533\u8bf7\u540c\u6b65\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"SimHisInvDataImportTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String errCode = (String)applyResponse.get("errcode");
        if (!ErrorType.SUCCESS.getErrcode().equals(errCode)) {
            throw new MsgException((String)applyResponse.get("description"));
        }
        Map data = (Map)applyResponse.get("data");
        return (String)data.get("batchNo");
    }

    private Map<String, Integer> syncInvoiceDataFromLeqiQuery(String taskNo) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("batchNo", taskNo);
        Map queryResponse = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"outInvoiceDownloadResult", (Object[])new Object[]{param});
        logger.info("\u83b7\u53d6\u4e50\u4f01\u53d1\u7968\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u679c\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u8fd4\u56de\u53c2\u6570\uff1a{}", param, (Object)queryResponse);
        if (queryResponse == null || queryResponse.get("data") == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u7533\u8bf7\u540c\u6b65\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"SimHisInvDataImportTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String errCode = (String)queryResponse.get("errcode");
        if (!ErrorType.SUCCESS.getErrcode().equals(errCode)) {
            throw new MsgException((String)queryResponse.get("description"));
        }
        Map data = (Map)queryResponse.get("data");
        String status = String.valueOf(data.get("status"));
        if ("success".equals(status)) {
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>(2);
            resultMap.put("TOTAL_NUM", Integer.parseInt((String)data.get("totalNum")));
            resultMap.put("SUCCESS_NUM", Integer.parseInt((String)data.get("successNum")));
            return resultMap;
        }
        if ("fail".equals(status)) {
            throw new MsgException((String)data.get("description"));
        }
        return null;
    }

    private String asyncQueryInvoiceDataReq(SyncQueryInvoiceDTO body) {
        String failMsg = "";
        String batchNo = null;
        try {
            AllEleInvoiceApplyAsyncRequestDTO dto = new AllEleInvoiceApplyAsyncRequestDTO();
            dto.setDataType(Integer.valueOf(2));
            dto.setAccount(body.getAccount());
            ArrayList<Integer> invoiceTypes = new ArrayList<Integer>(1);
            invoiceTypes.add(Integer.parseInt(body.getInvoiceType()));
            dto.setInvoiceTypes(invoiceTypes);
            dto.setStartDate(body.getStartDate());
            dto.setEndDate(body.getEndDate());
            dto.setRequest_path(AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_DATA_STATUS_REQ.getRequestPath());
            dto.setCombinePatch(AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_DATA_STATUS_REQ.getCombinePath());
            dto.setChannelType("2");
            logger.info("asyncQueryInvoiceDataReq start:{}", (Object)JSON.toJSONString((Object)dto));
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)body.getTaxNo(), (AllEleRequestDTO)dto, JSONObject.class);
            logger.info("asyncQueryInvoiceDataReq end:{}", (Object)JSON.toJSONString((Object)response));
            if (response.getSuccess().booleanValue()) {
                JSONObject responseData = (JSONObject)response.getData();
                if (responseData != null) {
                    batchNo = responseData.getString("batchNo");
                } else {
                    failMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u540c\u6b65\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"SimHisInvDataImportTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                }
            } else {
                failMsg = response.getDescription();
            }
        }
        catch (Exception e) {
            failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"SimHisInvDataImportTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)failMsg)) {
            throw new MsgException(failMsg);
        }
        return batchNo;
    }

    private Map<String, Integer> asyncQueryInvoiceDataRsp(String taskNo, SyncQueryInvoiceDTO dto) {
        AllEleInvoiceQueryAsyncRequestDTO requestDTO = new AllEleInvoiceQueryAsyncRequestDTO();
        requestDTO.setAccount(dto.getAccount());
        requestDTO.setBatchNo(taskNo);
        requestDTO.setPageSize(200);
        requestDTO.setCurrentPage(1);
        requestDTO.setRequest_path(AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_DATA_STATUS_RSP.getRequestPath());
        requestDTO.setCombinePatch(AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_DATA_STATUS_RSP.getCombinePath());
        requestDTO.setChannelType("2");
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>(2);
        int totalNum = 0;
        int successNum = 0;
        try {
            Map<String, Integer> firstMap = this.asyncQueryInvoiceDataRsp(requestDTO, dto);
            if (firstMap == null) {
                return null;
            }
            totalNum = firstMap.get("TOTAL_NUM");
            successNum += firstMap.get("SUCCESS_NUM").intValue();
            int times = totalNum / 200;
            if (totalNum % 200 > 0) {
                ++times;
            }
            for (int i = 1; i < times; ++i) {
                requestDTO.setCurrentPage(i + 1);
                Map<String, Integer> currentMap = this.asyncQueryInvoiceDataRsp(requestDTO, dto);
                if (currentMap == null) {
                    return null;
                }
                successNum += currentMap.get("SUCCESS_NUM").intValue();
            }
        }
        catch (MsgException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("asyncQueryInvoiceDataRsp exception", (Throwable)e);
            return null;
        }
        resultMap.put("TOTAL_NUM", totalNum);
        resultMap.put("SUCCESS_NUM", successNum);
        return resultMap;
    }

    private Map<String, Integer> asyncQueryInvoiceDataRsp(AllEleInvoiceQueryAsyncRequestDTO requestDTO, SyncQueryInvoiceDTO dto) {
        int totalNum = 0;
        int successNum = 0;
        boolean isException = true;
        for (int i = 0; i < 3; ++i) {
            try {
                AllEleResponseListDTO responseUsedCarListDTO = null;
                AllEleResponseListDTO responseVehicleListDTO = null;
                AllEleResponseListDTO responseListDTO = null;
                logger.info("asyncQueryInvoiceDataRsp start:{}", (Object)JSON.toJSONString((Object)requestDTO));
                String oldInvoiceType = dto.getOldInvoiceType();
                boolean isUsedCarInvoice = InvoiceUtils.isUsedCarInvoice((Object)oldInvoiceType);
                boolean isVehicleInvoice = InvoiceUtils.isVehicleInvoice((String)oldInvoiceType);
                ArrayList<AllVehicleBillResponseDTO> vehicleBillResponseData = new ArrayList<AllVehicleBillResponseDTO>();
                String errorCode = null;
                boolean isResponseNull = false;
                boolean isSuccess = false;
                String description = null;
                List vehicleData = null;
                List usedCarData = null;
                if (isUsedCarInvoice) {
                    responseUsedCarListDTO = AllEleServiceHelper.doPostList((String)dto.getTaxNo(), (AllEleRequestDTO)requestDTO, UsedCarFullInvoiceResponseDTO.class);
                    boolean bl = isResponseNull = null == responseUsedCarListDTO;
                    if (!isResponseNull) {
                        errorCode = responseUsedCarListDTO.getErrcode();
                        description = responseUsedCarListDTO.getDescription();
                        isSuccess = responseUsedCarListDTO.getSuccess();
                        totalNum = responseUsedCarListDTO.getTotalElement();
                        usedCarData = responseUsedCarListDTO.getData();
                    }
                } else if (isVehicleInvoice) {
                    responseVehicleListDTO = AllEleServiceHelper.doPostList((String)dto.getTaxNo(), (AllEleRequestDTO)requestDTO, VehicleInvoiceResponseDTO.class);
                    boolean bl = isResponseNull = null == responseVehicleListDTO;
                    if (!isResponseNull) {
                        errorCode = responseVehicleListDTO.getErrcode();
                        description = responseVehicleListDTO.getDescription();
                        isSuccess = responseVehicleListDTO.getSuccess();
                        totalNum = responseVehicleListDTO.getTotalElement();
                        vehicleData = responseVehicleListDTO.getData();
                    }
                } else {
                    responseListDTO = AllEleServiceHelper.doPostList((String)dto.getTaxNo(), (AllEleRequestDTO)requestDTO, AllEleFullInvoiceResponseDTO.class);
                    boolean bl = isResponseNull = null == responseListDTO;
                    if (!isResponseNull) {
                        errorCode = responseListDTO.getErrcode();
                        description = responseListDTO.getDescription();
                        isSuccess = responseListDTO.getSuccess();
                        totalNum = responseListDTO.getTotalElement();
                    }
                }
                logger.info("asyncQueryInvoiceDataRsp end:{}", (Object)JSON.toJSONString((Object)responseListDTO));
                if (isResponseNull || StringUtils.isBlank((CharSequence)errorCode) || "1307".equals(errorCode)) {
                    return null;
                }
                if (!isSuccess) {
                    throw new MsgException(description);
                }
                isException = false;
                HashSet<String> invoiceReplaySet = new HashSet<String>();
                if (isVehicleInvoice || isUsedCarInvoice) {
                    if (isVehicleInvoice && null != responseVehicleListDTO) {
                        Collections.addAll(vehicleBillResponseData, responseVehicleListDTO.getData().toArray(new AllVehicleBillResponseDTO[0]));
                    }
                    if (isUsedCarInvoice && null != responseUsedCarListDTO) {
                        Collections.addAll(vehicleBillResponseData, responseUsedCarListDTO.getData().toArray(new AllVehicleBillResponseDTO[0]));
                    }
                    successNum += SyncDevInvoiceTask.saveEleVehicleInvoiceData(invoiceReplaySet, vehicleBillResponseData, dto);
                    break;
                }
                List data = responseListDTO.getData();
                successNum += SyncDevInvoiceTask.saveEleFullInvoiceData(invoiceReplaySet, data, dto);
                break;
            }
            catch (MsgException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("asyncQueryInvoiceDataRsp exception", (Throwable)e);
                continue;
            }
        }
        if (isException) {
            return null;
        }
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>(2);
        resultMap.put("TOTAL_NUM", totalNum);
        resultMap.put("SUCCESS_NUM", successNum);
        return resultMap;
    }

    private boolean updateData(DynamicObject dynamicObject) {
        DynamicObject dynamicObjectDB = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (DynamicObjectType)dynamicObject.getDynamicObjectType());
        String executionStatus = dynamicObjectDB.getString("executionstatus");
        if ("5".equals(executionStatus)) {
            return false;
        }
        int totalNum = 0;
        int successNum = 0;
        boolean allSuccess = Boolean.TRUE;
        boolean allFinish = Boolean.TRUE;
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject item : entryEntity) {
            String currentStatus = item.getString("detailexecutionstatus");
            if (StringUtils.isBlank((CharSequence)currentStatus) || "0".equals(currentStatus) || "2".equals(currentStatus) || "1".equals(currentStatus)) {
                allFinish = Boolean.FALSE;
            }
            if (allSuccess && !"4".equals(currentStatus)) {
                allSuccess = Boolean.FALSE;
            }
            totalNum += item.getInt("detailtotalnum");
            successNum += item.getInt("detailsuccessnum");
        }
        dynamicObject.set("totalnum", (Object)totalNum);
        dynamicObject.set("successnum", (Object)successNum);
        if (allFinish) {
            if (allSuccess) {
                dynamicObject.set("executionstatus", (Object)"4");
            } else if (successNum == 0) {
                dynamicObject.set("executionstatus", (Object)"5");
            } else {
                dynamicObject.set("executionstatus", (Object)"3");
            }
        } else {
            dynamicObject.set("executionstatus", (Object)"2");
        }
        ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
        return true;
    }

    private void execInvoiceFileData(DynamicObject obj) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"sim_his_inv_data_import");
        try (DLock lock = DLock.create((String)TASK_NAME_FILE);){
            if (!lock.tryLock(6000L)) {
                return;
            }
            List attachments = AttachmentServiceHelper.getAttachments((String)"sim_his_inv_data_import", (Object)dynamicObject.getPkValue(), (String)"attachmentpanel");
            int status = 1;
            long start = System.currentTimeMillis();
            if (attachments != null && !attachments.isEmpty()) {
                try {
                    dynamicObject.set("modifytime", (Object)new Date());
                    String url = (String)((Map)attachments.get(0)).get("relativeUrl");
                    String name = (String)((Map)attachments.get(0)).get("name");
                    logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u5904\u7406\u6587\u4ef6\u4efb\u52a1\uff0cURL:{}", (Object)url);
                    TaxInvoiceImportUtil invoiceImportUtil = new TaxInvoiceImportUtil();
                    JSONObject result = invoiceImportUtil.parseTaxFile(null, url, name);
                    int totalNum = BigDecimalUtil.transDecimal((Object)result.get((Object)"total")).intValue();
                    int successNum = BigDecimalUtil.transDecimal((Object)result.get((Object)"success")).intValue();
                    dynamicObject.set("totalnum", (Object)result.getIntValue("total"));
                    dynamicObject.set("successnum", (Object)result.getIntValue("success"));
                    Map errMap = (Map)result.get((Object)"errMap");
                    if (errMap != null && !errMap.isEmpty()) {
                        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                        entryentity.clear();
                        int i = 0;
                        for (Map.Entry entry : errMap.entrySet()) {
                            ++i;
                            DynamicObject item = entryentity.addNew();
                            String msg = (String)entry.getKey() + ":" + (String)entry.getValue();
                            item.set("detailfailreason", (Object)StringUtils.substring((String)msg, (int)0, (int)100));
                            if (msg.length() > 100) {
                                item.set("detailfailreason_tag", (Object)StringUtils.substring((String)msg, (int)0, (int)500));
                            }
                            item.set("detailexecutionstatus", (Object)"5");
                            if (i <= 100) continue;
                            break;
                        }
                        if (successNum == 0) {
                            dynamicObject.set("executionstatus", (Object)"5");
                        }
                    }
                    if (totalNum != 0 && successNum == totalNum) {
                        dynamicObject.set("executionstatus", (Object)"4");
                    } else if (totalNum > successNum && successNum > 0) {
                        dynamicObject.set("executionstatus", (Object)"3");
                    } else if (successNum == 0) {
                        dynamicObject.set("executionstatus", (Object)"5");
                    }
                }
                catch (Exception e) {
                    logger.error("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u6587\u4ef6\u5904\u7406\u5931\u8d25", (Throwable)e);
                    dynamicObject.set("executionstatus", (Object)"5");
                }
            }
            logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u5904\u7406\u6587\u4ef6\u4efb\u52a1\uff0c\u5904\u7406\u7ed3\u679c:{}\uff0c\u603b\u8017\u65f6:{}", (Object)status, (Object)(System.currentTimeMillis() - start));
            ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
        }
    }

    private void execResult(DynamicObject dynamicObject, int status) {
        String execStatus = "4";
        if (status == 1) {
            execStatus = "5";
        } else if (status == 2) {
            execStatus = "3";
        }
        dynamicObject.set("executionstatus", (Object)execStatus);
        ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private DynamicObject[] getData(long pkValue) {
        QFilter filter = new QFilter("executionstatus", "=", (Object)"0").or(new QFilter("executionstatus", "=", (Object)"2"));
        QFilter qFilter = new QFilter("id", ">", (Object)pkValue);
        qFilter.and(filter);
        return BusinessDataServiceHelper.load((String)"sim_his_inv_data_import", (String)"id", (QFilter[])qFilter.toArray(), (String)"createtime", (int)10);
    }
}

