/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.async.AbstractAsyncIssueHandler;
import kd.imc.sim.async.IAsyncIssueHandler;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleIssueInvoiceImpl;

public class SyncTGInvoiceTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(SyncTGInvoiceTask.class);
    private static final String[] issueChannels = new String[]{"lqpt", "hbhx", "ly", "rpa", "lq_combine", "leqi_redconfirm_query"};

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)SyncTGInvoiceTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                return;
            }
            this.addTaskLog();
            QFilter dateFilter = new QFilter("createdate", ">=", (Object)DateUtils.addDay((Date)new Date(), (int)-2));
            RequestContext context = RequestContext.get();
            ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService();
            CountDownLatch countdownlatch = new CountDownLatch(issueChannels.length);
            for (String issueChannel : issueChannels) {
                executorService.execute(() -> {
                    try {
                        RequestContext.copyAndSet((RequestContext)context);
                        QFilter qFilter = new QFilter("issuechannel", "=", (Object)issueChannel);
                        DynamicObject[] asyncInvoices = BusinessDataServiceHelper.load((String)"sim_async_issue_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_async_issue_invoice"), (QFilter[])new QFilter[]{qFilter, dateFilter}, (String)String.format("%s asc, %s asc", "querycount", "createdate"), (int)SyncTGInvoiceTask.getQueryCount());
                        if (asyncInvoices.length != 0) {
                            try {
                                IAsyncIssueHandler hanler = AbstractAsyncIssueHandler.getAsyncIssueHandler((String)issueChannel);
                                hanler.handlerInvoice(Arrays.stream(asyncInvoices).collect(Collectors.toList()));
                            }
                            catch (Exception e) {
                                LOGGER.error("SyncTGInvoiceTask error ", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        countdownlatch.countDown();
                    }
                });
            }
            try {
                countdownlatch.await();
                executorService.shutdown();
            }
            catch (Exception e) {
                LOGGER.error("SyncTGInvoiceTask error ", (Throwable)e);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u5f02\u6b65\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
            }
            this.deleteAsyncLog();
        }
    }

    private void deleteAsyncLog() {
        if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)"sim_async_issue_invoice_delte"))) {
            return;
        }
        DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("createdate", "<", (Object)DateUtils.addDay((Date)new Date(), (int)-2)).toArray());
        long time = DateUtils.trunc((Date)DateUtils.addDay((Date)new Date(), (int)1)).getTime();
        long remain = (time - System.currentTimeMillis()) / 1000L;
        if (remain > 0L) {
            CacheHelper.put((String)"sim_async_issue_invoice_delte", (String)"sim_async_issue_invoice_delte", (int)Integer.parseInt(String.valueOf(remain)));
        }
    }

    public void addTaskLog() {
        try {
            DynamicObject[] asyncInvoices = BusinessDataServiceHelper.load((String)"sim_async_issue_invoice", (String)String.join((CharSequence)",", "orderno", "querycount", "issuechannel", "govorderno", "salertaxno"), null, (String)String.format("%s asc, %s asc", "querycount", "createdate"), (int)SyncTGInvoiceTask.getQueryCount());
            String value = ImcConfigUtil.getValue((String)"addLogMinInv", (String)"addLogMinInv");
            int minNum = 20;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                minNum = Integer.parseInt(value);
            }
            if (asyncInvoices.length > minNum) {
                return;
            }
            Date now = new Date();
            String timeStr = DateUtils.format((Date)now, (String)"yyyyMMddHHmmss");
            String subStr = timeStr.substring(10, 12);
            ArrayList list = new ArrayList();
            Collections.addAll(list, "12", "9", "10");
            if ("30".equals(subStr)) {
                LOGGER.info("enterAddTaskLog");
                Set asyncOrderNos = Arrays.stream(asyncInvoices).map(o -> o.getString("orderno")).collect(Collectors.toSet());
                QFilter dateFilter = new QFilter("createtime", ">=", (Object)DateUtils.addDay((Date)new Date(), (int)-2));
                QFilter sourceFilter = new QFilter("issuesource", "in", (Object)list.toArray());
                QFilter issueStatusFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.underway.getCode());
                DynamicObject[] invs = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter[]{dateFilter, sourceFilter, issueStatusFilter}, (String)"id desc", (int)20);
                ArrayList<DynamicObject> needAddTasks = new ArrayList<DynamicObject>();
                AllEleIssueInvoiceImpl issueService = new AllEleIssueInvoiceImpl();
                HashMap<String, Boolean> isLeqiMap = new HashMap<String, Boolean>();
                for (DynamicObject inv : invs) {
                    String sellerTaxNo = inv.getString("salertaxno");
                    if (!isLeqiMap.containsKey(sellerTaxNo)) {
                        boolean isLeqiChannel = EnterpriseHelper.isLqptChannel((String)sellerTaxNo);
                        isLeqiMap.put(sellerTaxNo, isLeqiChannel);
                    }
                    if (((Boolean)isLeqiMap.get(sellerTaxNo)).booleanValue() || asyncOrderNos.contains(inv.getString("orderno"))) continue;
                    String issueChannel = "12".equalsIgnoreCase(inv.getString("issuesource")) ? "rpa" : "ly";
                    needAddTasks.add(issueService.addAsyncInvoice(inv, issueChannel));
                }
                if (needAddTasks.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])needAddTasks.toArray(new DynamicObject[0]));
                }
                LOGGER.info("enterAddTaskLogSize");
            }
        }
        catch (Exception e) {
            LOGGER.error("addTaskLog" + e.getMessage(), (Throwable)e);
        }
    }

    public static int getQueryCount() {
        int queryCount = 500;
        try {
            String queryCountStr = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.ASYNC_ISSUE_INVOICE_QUERY_COUNT);
            queryCount = Integer.parseInt(queryCountStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryCount;
    }
}

