/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.lqpt.op;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.summary.SummaryConfirmOrCancelRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.formplugin.lqpt.op.SimLqptSummaryValidator;

public class SimLqptSummaryConfirmOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
                    DynamicObject summary = dataEntity.getDataEntity();
                    String summaryStatus = summary.getString("summarystatus");
                    if (!"1".equals(summaryStatus)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u7684\u65e0\u9700\u518d\u6b21\u6c47\u603b\u786e\u8ba4", (String)"SimLqptSummaryConfirmOp_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
        });
        e.getValidators().add(new SimLqptSummaryValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] summaryObjs = e.getDataEntities();
        LqptService lqptService = new LqptService();
        for (DynamicObject summaryObj : summaryObjs) {
            DynamicObject epInfo = summaryObj.getDynamicObject("epinfo");
            if (epInfo == null) continue;
            SummaryConfirmOrCancelRequest request = (SummaryConfirmOrCancelRequest)DynamicObjectUtil.dynamicObject2Bean(SummaryConfirmOrCancelRequest.class, (DynamicObject)summaryObj);
            SimLqptSummaryConfirmOp.setBaseInfo(lqptService, summaryObj, request);
            request.setYwlx("0");
            LqptResponse send = lqptService.send((LqptRequest)request);
            if (send.success()) {
                summaryObj.set("summarystatus", (Object)"1");
                summaryObj.set("summaryresult", (Object)"");
                continue;
            }
            summaryObj.set("summarystatus", (Object)"-1");
            summaryObj.set("summaryresult", (Object)(send.getDescription().length() > 200 ? send.getDescription().substring(0, 200) : send.getDescription()));
        }
        ImcSaveServiceHelper.save((DynamicObject[])summaryObjs);
    }

    public static void setBaseInfo(LqptService lqptService, DynamicObject summaryObj, SummaryConfirmOrCancelRequest request) {
        DynamicObject epInfo = BusinessDataServiceHelper.loadSingle((Object)summaryObj.getDynamicObject("epinfo").getPkValue(), (String)"bdm_enterprise_baseinfo");
        String taxNo = epInfo.getString("number");
        request.setNsrsbh(taxNo);
        request.setXsfnsrsbh(taxNo);
        LqEpConfig lqEpConfig = lqptService.getLqEpConfig(taxNo);
        request.setPtbh(lqEpConfig.getJrdwptbh());
        DynamicObject ep = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_info", (String)"zgswskfjdm", (QFilter[])new QFilter("epinfo", "=", epInfo.getPkValue()).toArray());
        if (ep == null) {
            return;
        }
        request.setXsfsjswjgdm(ep.getString("zgswskfjdm"));
        request.setYf(DateUtils.format((Date)summaryObj.getDate("summarymonth"), (String)"yyyy-MM"));
    }
}

