/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.callback;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.table.InvsmQrCallbackLogConstant;
import kd.imc.bdm.common.util.CallbackMcloudUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.formplugin.issuing.task.SyncTGInvoiceTask;

public class CallbackMcloudTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(CallbackMcloudTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter filter = new QFilter("retry_times", "<=", (Object)10);
        filter.and("callback_code", "!=", (Object)"0000");
        DynamicObject[] callbackMcloudLogs = BusinessDataServiceHelper.load((String)"invsm_qr_callback_log", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"invsm_qr_callback_log"), (QFilter[])filter.toArray(), (String)String.format("%s asc, %s asc", "retry_times", "createdate"), (int)SyncTGInvoiceTask.getQueryCount());
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u5b9a\u65f6\u540c\u6b65\u53d1\u7968\u5230\u79fb\u52a8\u4e91\u67e5\u8be2\u5230%s\u6761\u8bb0\u5f55", callbackMcloudLogs.length));
        }
        if (callbackMcloudLogs.length == 0) {
            return;
        }
        for (DynamicObject log : callbackMcloudLogs) {
            try {
                DynamicObject vatInvObj;
                long invId = log.getLong("vat_invoice_ids");
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("\u5f53\u524d\u53d1\u7968ID\u662f\uff1a%s", invId));
                }
                if (null == (vatInvObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])new QFilter("id", "=", (Object)invId).toArray()))) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"invsm_qr_callback_log"), (Object[])new Object[]{log.getPkValue()});
                    continue;
                }
                if (!InvsmQrCallbackLogConstant.BusTypeEnum.M_CLOUDE.getValue().equals(log.getString("bus_type"))) continue;
                vatInvObj = BusinessDataServiceHelper.loadSingle((Object)vatInvObj.getPkValue(), (String)"sim_vatinvoice");
                CallbackMcloudUtil.dealInvoice2Mcloud((DynamicObject)vatInvObj);
            }
            catch (Exception e) {
                logger.error("\u53d1\u7968\u540c\u6b65\u79fb\u52a8\u4e91\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

