/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.enums.CancelRedEum;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.util.ConvertUpMoneyUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.formplugin.bill.originalbill.util.SelectDeviceUtil;
import org.apache.commons.lang3.StringUtils;

public class RedConfirmBillIssuePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Object redConfirmBillId = this.getView().getFormShowParameter().getCustomParam("id");
        if (redConfirmBillId == null) {
            return;
        }
        DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)redConfirmBillId, (String)"sim_red_confirm_bill");
        this.getPageCache().put("createorg", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)redConfirmBill.get("createorg"))));
        ModelUtil.setModelAndEntryValueFromDynamicObject((DynamicObject)redConfirmBill, (AbstractFormPlugin)this);
        Label invoiceTypeLabel = (Label)this.getControl("label_head");
        invoiceTypeLabel.setText(InvoiceType.getInvoiceDescription((String)redConfirmBill.getString("invoicetype")));
        BigDecimal totalAmount = redConfirmBill.getBigDecimal("totalamount").setScale(2, 4);
        this.getModel().setValue("text_total_amount", (Object)String.format(ResManager.loadKDString((String)"\uff08\u5927\u5199\uff09 %1$s \uff08\u5c0f\u5199\uff09 %2$s", (String)"RedConfirmBillIssuePlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), ConvertUpMoneyUtils.toChinese((String)totalAmount.toString()), totalAmount));
        String remark = redConfirmBill.getString("remark");
        String autoRemark = RemarkTemplateHelper.generateRedAllEleRemark((String)redConfirmBill.getString("number"), (String)redConfirmBill.getString("originalinvoiceno"));
        this.getModel().setValue("remark", (Object)(remark + autoRemark));
        SelectDeviceUtil.setAccount((AbstractFormPlugin)this, (String)redConfirmBill.getString("salertaxno"), (String)"");
        this.getModel().setValue("account", this.getView().getFormShowParameter().getCustomParam("account"));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbar_opt"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("btn_openinvoice".equals(evt.getItemKey())) {
            String orgStr = this.getPageCache().get("createorg");
            if (StringUtils.isBlank((CharSequence)orgStr)) {
                return;
            }
            PermissionHelper.checkPermission((String)"sim", (String)"sim_red_confirm_bill", (long)Long.parseLong(orgStr), (ImcPermItemEnum)ImcPermItemEnum.SIM_RED);
            Object redConfirmBillId = this.getView().getFormShowParameter().getCustomParam("id");
            if (redConfirmBillId == null) {
                return;
            }
            DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)redConfirmBillId, (String)"sim_red_confirm_bill");
            JSONObject param = BotpHelper.cancelOrRedArInvoice((DynamicObject[])new DynamicObject[]{redConfirmBill}, (CancelRedEum)CancelRedEum.ISSUE_RED_CONFIRM);
            Integer billPksSize = param.getInteger("billPksSize");
            if (billPksSize > 0) {
                this.getPageCache().put("cancelOrRedArInvoiceBillPks", param.toJSONString());
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u7ea2\u51b2\u53d1\u7968\u5c06\u51b2\u9500\u5f00\u7968\u7533\u8bf7\u5355\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RedConfirmBillIssuePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"cancelOrRedArInvoice");
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btn_openinvoice".equals(evt.getItemKey())) {
            String orgStr = this.getPageCache().get("createorg");
            if (StringUtils.isBlank((CharSequence)orgStr)) {
                return;
            }
            Object pk = this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"));
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            if ("02".equals(redConfirm.getString("specialtype")) || InvoiceUtils.isUsedCarInvoice((Object)redConfirm.getString("invoicetype")) && redConfirm.getString("applicant").equals("1")) {
                params.put("salertaxno", redConfirm.getString("buyertaxno"));
            } else {
                params.put("salertaxno", redConfirm.getString("salertaxno"));
            }
            params.put("account", this.getModel().getValue("account"));
            if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, params)) {
                return;
            }
            this.doissueRedConfirmBill();
        }
    }

    private void doissueRedConfirmBill() {
        Object pk = this.getView().getFormShowParameter().getCustomParam("id");
        OperateOption operateOption = OperateOption.create();
        Object sellerOrgPk = this.getView().getFormShowParameter().getCustomParam("sellerOrgPk");
        operateOption.setVariableValue("sellerOrgPk", String.valueOf(sellerOrgPk));
        operateOption.setVariableValue("account", (String)this.getModel().getValue("account"));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"issue", (String)"sim_red_confirm_bill", (Object[])new Object[]{pk}, (OperateOption)operateOption);
        if (!operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            if (!CollectionUtils.isEmpty((Collection)successPkIds) && successPkIds.contains(pk)) {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)OperationConstant.getErrorMsg((OperationResult)operationResult), (String)"lqpt");
            } else {
                this.getView().showErrorNotification(OperationConstant.getErrorMsg((OperationResult)operationResult));
            }
            return;
        }
        DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle(operationResult.getSuccessPkIds().get(0), (String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"));
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("invoiceno", redConfirm.get("invoiceno"));
        if (BotpHelper.isRedConfirmOrInfoNeedShowArTip((DynamicObject)redConfirm)) {
            customParams.put(BotpHelper.getArFiTip(), BotpHelper.getRedFiTip());
        }
        ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"sim_show_invoice_dialog", (String)"sim_show_invoice_dialog");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("lqpt".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
        if ("cancelOrRedArInvoice".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            String paramStr = this.getPageCache().get("cancelOrRedArInvoiceBillPks");
            this.getPageCache().remove("cancelOrRedArInvoiceBillPks");
            if (StringUtils.isNotBlank((CharSequence)paramStr)) {
                BotpHelper.writeOffArBillAndAddMark((String)paramStr, (String)"sim_red_confirm_bill");
            }
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("salertaxno", this.getModel().getValue("salertaxno"));
            params.put("account", this.getModel().getValue("account"));
            if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, params)) {
                return;
            }
            this.doissueRedConfirmBill();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("sim_show_invoice_dialog".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
            return;
        }
        if ("bdm_tax_login".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            this.doissueRedConfirmBill();
        }
    }
}

