/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.dto.allele.AllEleTaxPlatformResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.dto.RedConfirmBillHandleRequest;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import kd.imc.sim.formplugin.redconfirm.control.RedConfirmBillIssueControl;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import kd.imc.sim.schedule.AbstractJobTask;
import kd.imc.sim.schedule.redconfirm.RedConfirmBillDownloadTask;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;
import org.apache.commons.lang3.StringUtils;

public class RedConfirmBillListPlugin
extends AbstractListPlugin
implements SimFormPluginConstellationUntrans {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillListPlugin.class);

    public void beforeItemClick(BeforeItemClickEvent evt) {
        RiskControlRecordConstant.ExecuteActionEnum executeAction;
        Object[] idArr;
        boolean antiReplayControlFlag;
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.size() == 0) {
            return;
        }
        String itemKey = evt.getItemKey();
        if (("btn_submit".equals(itemKey) || "btn_confirm".equals(itemKey) || "btn_red".equals(itemKey)) && (antiReplayControlFlag = BillRiskControlService.riskControl((Object[])(idArr = selectedRows.getPrimaryKeyValues()), (String)"sim_red_confirm_bill", (RiskControlRecordConstant.ExecuteActionEnum)(executeAction = RiskControlRecordConstant.ExecuteActionEnum.getExecuteActionEnumByButtonKey((String)itemKey)), (AbstractFormPlugin)this, (String)("risk_control_check_" + itemKey)))) {
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        HashMap<String, Constable> map = new HashMap<String, Constable>(4);
        Long orgId = CollectionUtils.isEmpty((Collection)selectedMainOrgIds) ? Long.valueOf(RequestContext.get().getOrgId()) : (Long)selectedMainOrgIds.get(0);
        map.put("org", orgId);
        if ("btn_add".equals(evt.getItemKey())) {
            ViewUtil.openDialog((AbstractFormPlugin)this, map, (String)"sim_red_confirm_bill_add", (String)"sim_red_confirm_bill_add");
        } else if ("btn_download".equals(evt.getItemKey()) || "btn_update_head".equals(evt.getItemKey())) {
            map.put("updateHead", Boolean.valueOf("btn_update_head".equals(evt.getItemKey())));
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)("btn_update_head".equals(evt.getItemKey()) ? ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001\u66f4\u65b0", (String)"RedConfirmBillListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ""), map, (String)"sim_red_confirm_bill_down", (String)"sim_red_confirm_bill_down");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate oprate = (FormOperate)args.getSource();
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        Long orgId = CollectionUtils.isEmpty((Collection)selectedMainOrgIds) ? Long.valueOf(RequestContext.get().getOrgId()) : (Long)selectedMainOrgIds.get(0);
        oprate.getOption().setVariableValue("org", String.valueOf(orgId));
        String operateKey = oprate.getOperateKey();
        String statusDescription = this.getStatusDescription(operateKey);
        oprate.getOption().setVariableValue("statusDescription", statusDescription);
        if (StringUtils.isNotBlank((CharSequence)statusDescription) || "btn_red".equals(operateKey)) {
            oprate.getOption().setVariableValue("batchop_batchsize", "0");
        }
        Object[] pks = this.getSelectedRows().getPrimaryKeyValues();
        if ("btn_revoke".equals(oprate.getOperateKey()) || "batch_revoke".equals(oprate.getOperateKey())) {
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
            String fields = String.join((CharSequence)",", "confirmstatus", "enteridentity", "buyertaxno", "salertaxno", "specialtype");
            DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
            StringBuilder builder = new StringBuilder("revokeTaxNoLog:");
            for (DynamicObject redConfirm : redConfirms) {
                String revokeTaxNo = RedConfirmHelper.getRedConfirmRevokeTaxNo((DynamicObject)redConfirm);
                builder.append("[number:").append(redConfirm.getString("number")).append(",revokeTaxNo:").append(revokeTaxNo).append("]");
                if (!StringUtils.isNotBlank((CharSequence)revokeTaxNo) || Objects.equals(saleInfo.getSaleTaxNo(), revokeTaxNo)) continue;
                LOGGER.info(builder.toString());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0d\u80fd\u4f7f\u7528\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u7a0e\u53f7\u64a4\u9500\uff0c\u4ec5\u53ef\u901a\u8fc7\u7a0e\u53f7\uff1a%s\u8fdb\u884c\u64a4\u9500", (String)"RedConfirmBillListPlugin_68", (String)"imc-sim-formplugin", (Object[])new Object[0]), revokeTaxNo));
            }
            LOGGER.info(builder.toString());
        }
    }

    private String getStatusDescription(String operateKey) {
        String statusDescription = "";
        switch (operateKey) {
            case "batch_confirm": {
                statusDescription = "\u786e\u8ba4\u4e2d";
                break;
            }
            case "batch_refuse": {
                statusDescription = "\u62d2\u7edd\u4e2d";
                break;
            }
            case "batch_revoke": {
                statusDescription = "\u64a4\u9500\u4e2d";
                break;
            }
            case "batch_submit": {
                statusDescription = "\u5f55\u5165\u4e2d";
            }
        }
        return statusDescription;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "batch_submit": 
            case "batch_revoke": 
            case "batch_confirm": 
            case "batch_refuse": 
            case "btn_red": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                operationResult.setShowMessage(false);
                if (!operationResult.isSuccess()) {
                    this.getView().showTipNotification(OperationConstant.getErrorMsg((OperationResult)operationResult, (String)""));
                    return;
                }
                String message = operationResult.getMessage();
                JSONObject json = JSONObject.parseObject((String)message);
                json.put("operateKey", (Object)afterDoOperationEventArgs.getOperateKey());
                json.put("pkIds", (Object)operationResult.getSuccessPkIds());
                if ("btn_red".equals(afterDoOperationEventArgs.getOperateKey())) {
                    if (json.containsKey((Object)"cancelOrRedArInvoiceBillPks")) {
                        this.getPageCache().put("cancelOrRedArInvoiceBillPks", json.toJSONString());
                        ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u7ea2\u51b2\u53d1\u7968\u5c06\u51b2\u9500\u5f00\u7968\u7533\u8bf7\u5355\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RedConfirmBillListPlugin_55", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"cancelOrRedArInvoice");
                        return;
                    }
                    new RedConfirmBillIssueControl().handlerRedConfirmIssue((AbstractFormPlugin)this, json);
                    return;
                }
                if (!EnterpriseHelper.isLqptChannel((String)json.getString("taxNo"))) {
                    ViewUtil.openDialog((AbstractFormPlugin)this, (Map)json, (String)"sim_red_coinfirm_account", (String)"sim_red_coinfirm_account");
                    return;
                }
                this.executeBatchOperate(json);
                break;
            }
            case "rollback": {
                OperationResult rollbackResult = afterDoOperationEventArgs.getOperationResult();
                if (rollbackResult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u9000\u6210\u529f%s\u6761", (String)"RedConfirmBillListPlugin_57", (String)"imc-sim-formplugin", (Object[])new Object[]{rollbackResult.getSuccessPkIds().size()}), Integer.valueOf(3000));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "trackup": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                BillHelper.trackup((AbstractListPlugin)this, (String)"sim_red_confirm_bill", (Object[])((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues());
            }
        }
    }

    private void startExecuteBatchOperate(JSONObject json) {
        if ("btn_red".equals(json.getString("operateKey"))) {
            new RedConfirmBillIssueControl().executeBatchRed((AbstractFormPlugin)this, json);
            return;
        }
        this.executeBatchOperate(json);
    }

    private void executeBatchOperate(JSONObject json) {
        String taxNo = json.getString("taxNo");
        String operateKey = "btn_" + json.getString("operateKey").replace("batch_", "");
        try (DLock dLock = DLock.create((String)(taxNo + "_redconfirm_" + operateKey));){
            if (!dLock.tryLock()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s]\u6b63\u5728[%2$s]", (String)"RedConfirmBillListPlugin_60", (String)"imc-sim-formplugin", (Object[])new Object[0]), taxNo, operateKey));
                return;
            }
            String statusDescription = json.getString("statusDescription");
            JSONArray pkIds = json.getJSONArray("pkIds");
            RedConfirmBillHandleRequest request = new RedConfirmBillHandleRequest(operateKey, pkIds.toArray(), statusDescription, json.getString("account"));
            IssueInvoiceMqHelper.submitRedConfirm2MQ((RedConfirmBillHandleRequest)request);
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u63d0\u4ea4%1$s%2$s\u6761\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u67e5\u770b\u5904\u7406\u7ed3\u679c", (String)"RedConfirmBillListPlugin_61", (String)"imc-sim-formplugin", (Object[])new Object[0]), statusDescription.replace("\u4e2d", ""), pkIds.size()));
        }
        this.getView().invokeOperation("refresh");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("invoiceno".equals(args.getFieldName())) {
            args.setCancel(true);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"sim_red_confirm_bill", (String)"invoiceno");
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)"").and("invoiceno", "=", (Object)redConfirmBill.getString("invoiceno"));
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])qFilter.toArray());
            if (invoice != null) {
                invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice");
                InvoiceQueryControl.showInvoiceView((AbstractFormPlugin)this, (DynamicObject)invoice);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        MessageBoxResult result = e.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        String callBackId = e.getCallBackId();
        if ("cancelOrRedArInvoice".equals(callBackId)) {
            JSONObject json = JSONObject.parseObject((String)this.getPageCache().get("cancelOrRedArInvoiceBillPks"));
            String confirmParamStr = json.getString("cancelOrRedArInvoiceBillPks");
            BotpHelper.writeOffArBillAndAddMark((String)confirmParamStr, (String)"sim_red_confirm_bill");
            new RedConfirmBillIssueControl().handlerRedConfirmIssue((AbstractFormPlugin)this, JSONObject.parseObject((String)this.getPageCache().get("cancelOrRedArInvoiceBillPks")));
        } else if (callBackId.startsWith("risk_control_check_")) {
            String key = callBackId.substring(callBackId.indexOf("risk_control_check_") + "risk_control_check_".length());
            BillRiskControlService.unlockRiskRecord((AbstractFormPlugin)this);
            BeforeItemClickEvent evt = new BeforeItemClickEvent(new Object(), key, key);
            this.beforeItemClick(evt);
            if (!evt.isCancel()) {
                this.getView().invokeOperation(key);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("sim_red_confirm_bill".equals(closedCallBackEvent.getActionId()) || "sim_red_confirmbill_issue".equals(closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
            return;
        }
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "sim_red_confirm_bill_add": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                RedConfirmBillListPlugin.openRedConfirmAddPage((AbstractFormPlugin)this, returnData);
                break;
            }
            case "bdm_tax_login": {
                AllEleTaxPlatformResponseDTO response = (AllEleTaxPlatformResponseDTO)closedCallBackEvent.getReturnData();
                if (null == response) break;
                this.startExecuteBatchOperate(new JSONObject(response.getCustomParams()));
                break;
            }
            case "sim_red_confirm_bill_down": {
                AllEleRedConfirmDownLoadRequestDTO request = (AllEleRedConfirmDownLoadRequestDTO)closedCallBackEvent.getReturnData();
                new RedConfirmBillDownloadTask().dispatchTask(this, request, request.getUpdateHead() != false ? ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001\u66f4\u65b0", (String)"RedConfirmBillListPlugin_58", (String)"imc-sim-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0b\u8f7d", (String)"RedConfirmBillListPlugin_59", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "dispatchTask": {
                AbstractJobTask.dispatchTaskCloseCallback(this, closedCallBackEvent.getReturnData());
                break;
            }
            case "sim_red_coinfirm_account": {
                JSONObject json = (JSONObject)closedCallBackEvent.getReturnData();
                json.put("salertaxno", (Object)json.getString("taxNo"));
                if (AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)json)) {
                    return;
                }
                this.startExecuteBatchOperate(json);
            }
        }
    }

    public static void openRedConfirmAddPage(AbstractFormPlugin that, Map<String, Object> returnData) {
        BillShowParameter listParam = new BillShowParameter();
        listParam.setStatus(OperationStatus.ADDNEW);
        listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listParam.setFormId("sim_red_confirm_bill");
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)that, "sim_red_confirm_bill"));
        listParam.setCustomParams(returnData);
        that.getView().showForm((FormShowParameter)listParam);
    }

    public static void openRedConfirmPage(AbstractFormPlugin that, Object pkId) {
        BillShowParameter listParam = new BillShowParameter();
        listParam.setStatus(OperationStatus.EDIT);
        listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listParam.setFormId("sim_red_confirm_bill");
        listParam.setPkId(pkId);
        that.getView().showForm((FormShowParameter)listParam);
    }
}

