/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmapply.RedConfirmBillConfirmRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmRefuseResponseDTO;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public class RedConfirmBillRefuseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_red_confirm_bill", (boolean)true));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successObj = new ArrayList<DynamicObject>(dataEntities.length);
        String account = this.getOption().containsVariable("account") ? this.getOption().getVariableValue("account") : "";
        for (DynamicObject redConfirmBill : dataEntities) {
            String confirmStatus = redConfirmBill.getString("confirmstatus");
            RedConfirmBillRefuseOp.redConfirmBillRefuseMethod(redConfirmBill, account);
            if (!StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)confirmStatus) && (StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)"05") || StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)"06"))) {
                successObj.add(redConfirmBill);
                continue;
            }
            this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u62d2\u7edd\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillRefuseOp_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), redConfirmBill.getString("failreason"))));
        }
        e.setDataEntities(successObj.toArray(new DynamicObject[0]));
        ImcSaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public static void redConfirmBillRefuseMethod(DynamicObject redConfirmBill, String account) {
        String taxNo = RedConfirmBillHelper.getConfirmTaxNo((DynamicObject)redConfirmBill);
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            RedConfirmBillConfirmRequest request = (RedConfirmBillConfirmRequest)DynamicObjectUtil.dynamicObject2Bean(RedConfirmBillConfirmRequest.class, (DynamicObject)redConfirmBill);
            request.setNsrsbh(taxNo);
            request.setUuid(redConfirmBill.getString("govuuid"));
            request.setQrlx("N");
            LqptResponse response = new LqptService().send((LqptRequest)request);
            String status = redConfirmBill.getString("confirmstatus");
            if (StringUtils.equals((CharSequence)taxNo, (CharSequence)redConfirmBill.getString("buyertaxno"))) {
                status = "05";
            } else if (StringUtils.equals((CharSequence)taxNo, (CharSequence)redConfirmBill.getString("salertaxno"))) {
                status = "06";
            }
            if (response.success()) {
                redConfirmBill.set("confirmstatus", (Object)status);
                redConfirmBill.set("failreason", (Object)"");
                return;
            }
            String desc = response.getDescription();
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = ResManager.loadKDString((String)"\u62d2\u7edd\u5931\u8d25", (String)"RedConfirmBillRefuseOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
            RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)desc);
            return;
        }
        AllEleResponseDTO response = RedConfirmBillHelper.requestConfirm((String)taxNo, (String)"N", (DynamicObject)redConfirmBill, (String)account);
        if (response.getSuccess().booleanValue()) {
            AllEleRedConfirmRefuseResponseDTO confirmResponse = (AllEleRedConfirmRefuseResponseDTO)response.getData();
            redConfirmBill.set("confirmstatus", (Object)confirmResponse.getRedConfirmBillStatus());
            redConfirmBill.set("failreason", (Object)"");
            return;
        }
        String desc = response.getDescription();
        if (StringUtils.isEmpty((CharSequence)desc)) {
            desc = ResManager.loadKDString((String)"\u62d2\u7edd\u5931\u8d25", (String)"RedConfirmBillRefuseOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        }
        RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)desc);
    }
}

