/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmapply.RedConfirmBillConfirmRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmRevokeRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmRevokeResponseDTO;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillMailHelper;

public class RedConfirmBillRevokeOp
extends AbstractOperationServicePlugIn {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillRevokeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_red_confirm_bill", (boolean)true));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successObj = new ArrayList<DynamicObject>(dataEntities.length);
        String account = this.getOption().containsVariable("account") ? this.getOption().getVariableValue("account") : "";
        for (DynamicObject redConfirmBill : dataEntities) {
            String confirmStatus = redConfirmBill.getString("confirmstatus");
            RedConfirmBillRevokeOp.redConfirmBillRevokeMethod(redConfirmBill, account);
            if (StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)confirmStatus)) {
                this.operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo((DynamicObject)redConfirmBill, (String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u64a4\u9500\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillRevokeOp_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirmBill.getString("orderno"), redConfirmBill.getString("failreason"))));
                continue;
            }
            successObj.add(redConfirmBill);
        }
        e.setDataEntities(successObj.toArray(new DynamicObject[0]));
        ImcSaveServiceHelper.save((DynamicObject[])dataEntities);
        RedConfirmBillMailHelper.deletePushRecord(successObj.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
    }

    public static void redConfirmBillRevokeMethod(DynamicObject redConfirmBill, String account) {
        String taxNo = RedConfirmHelper.getRedConfirmRevokeTaxNo((DynamicObject)redConfirmBill);
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            RedConfirmBillConfirmRequest request = (RedConfirmBillConfirmRequest)DynamicObjectUtil.dynamicObject2Bean(RedConfirmBillConfirmRequest.class, (DynamicObject)redConfirmBill);
            request.setNsrsbh(taxNo);
            request.setXsfnsrsbh(redConfirmBill.getString("salertaxno"));
            request.setUuid(redConfirmBill.getString("govuuid"));
            request.setHzqrdbh(redConfirmBill.getString("number"));
            request.setQrlx("C");
            LOGGER.info("\u4e50\u4f01\u64a4\u9500\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request));
            LqptResponse response = new LqptService().send((LqptRequest)request);
            LOGGER.info("\u4e50\u4f01\u64a4\u9500\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (response.success()) {
                if (redConfirmBill.getString("confirmstatus").equals("04")) {
                    redConfirmBill.set("confirmstatus", (Object)"09");
                } else {
                    redConfirmBill.set("confirmstatus", (Object)"08");
                }
                redConfirmBill.set("failreason", (Object)"");
                return;
            }
            String desc = response.getDescription();
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25", (String)"RedConfirmBillRevokeOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
            RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)desc);
            return;
        }
        AllEleRedConfirmRevokeRequestDTO requestDTO = new AllEleRedConfirmRevokeRequestDTO();
        requestDTO.setAccount(account);
        requestDTO.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_REVOKE.getRequestPath());
        requestDTO.setSalerTaxNo(redConfirmBill.getString("salertaxno"));
        requestDTO.setGovRedConfirmBillUuid(redConfirmBill.getString("govuuid"));
        requestDTO.setConfirmType("C");
        LOGGER.info("RPA\u8bf7\u6c42\u7a0e\u5c40\u64a4\u9500\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)requestDTO));
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)requestDTO, AllEleRedConfirmRevokeResponseDTO.class);
        LOGGER.info("RPA\u8bf7\u6c42\u7a0e\u5c40\u64a4\u9500\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (response.getSuccess().booleanValue()) {
            AllEleRedConfirmRevokeResponseDTO revokeResponse = (AllEleRedConfirmRevokeResponseDTO)response.getData();
            if (StringUtils.isNotBlank((CharSequence)revokeResponse.getRedConfirmBillStatus())) {
                redConfirmBill.set("confirmstatus", (Object)revokeResponse.getRedConfirmBillStatus());
            }
            redConfirmBill.set("failreason", (Object)"");
            return;
        }
        String desc = response.getDescription();
        if (StringUtils.isEmpty((CharSequence)desc)) {
            desc = ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25", (String)"RedConfirmBillRevokeOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        }
        RedConfirmBillHelper.setFailReason((DynamicObject)redConfirmBill, (String)desc);
    }
}

