/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.op;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.helper.BillRollbackHelper;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import kd.imc.sim.formplugin.match.BillComprehensiveStatusHelper;
import kd.imc.sim.formplugin.match.RedConfirmMatchHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.collections.CollectionUtils;

public class RedConfirmBillRollbackOp
extends AbstractOperationServicePlugIn {
    private static final Set<String> canRollbackStatus = new ImmutableSet.Builder().add((Object)RedConfirmStatusEnum.SALES_DISCOUNTS.getBillCode()).add((Object)RedConfirmStatusEnum.SELLER_CANCEL.getBillCode()).add((Object)RedConfirmStatusEnum.TIME_CANCEL.getBillCode()).add((Object)RedConfirmStatusEnum.CREATOR_REVOKE.getBillCode()).add((Object)RedConfirmStatusEnum.CONFIRM_REVOKE.getBillCode()).add((Object)RedConfirmStatusEnum.EXCEPTION_CONFIRM.getBillCode()).build();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("uploadstatus");
        e.getFieldKeys().add("confirmstatus");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("originalinvoicecode");
        e.getFieldKeys().add("originalinvoiceno");
        e.getFieldKeys().add("source");
        e.getFieldKeys().add("occupystatus");
        e.getFieldKeys().add("applicant");
        e.getFieldKeys().add("uploadbatchno");
        e.getFieldKeys().add("orderno");
        e.getFieldKeys().add("items.originseq");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] redConfirms = e.getDataEntities();
        this.rollBackRedConfirms(redConfirms);
    }

    public void rollBackRedConfirms(DynamicObject[] redConfirms) {
        int macthIndex = 0;
        DynamicObject[] macthRedConfirms = new DynamicObject[redConfirms.length];
        int billIndex = 0;
        DynamicObject[] billRedConfirms = new DynamicObject[redConfirms.length];
        for (DynamicObject redConfirm : redConfirms) {
            if (StringUtils.isNotBlank((CharSequence)redConfirm.getString("uploadbatchno"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%s\u5f55\u5165\u6279\u6b21\u53f7\u4e0d\u4e3a\u7a7a\u4e0d\u5141\u8bb8\u56de\u9000", (String)"RedConfirmBillRollbackOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("number")));
            }
            if ("10".equals(redConfirm.getString("source"))) {
                macthRedConfirms[macthIndex] = redConfirm;
                ++macthIndex;
            }
            if (!"5".equals(redConfirm.getString("source"))) continue;
            billRedConfirms[billIndex] = redConfirm;
            ++billIndex;
        }
        if (macthIndex > 0) {
            this.matchRedconfirmRollback(macthRedConfirms);
        }
        if (billIndex > 0) {
            this.billRedconfirmRollback(billRedConfirms);
        }
    }

    private void matchRedconfirmRollback(DynamicObject[] redConfirms) {
        ArrayList<Object> deleteIds = new ArrayList<Object>(redConfirms.length);
        ArrayList<Object> deleteRelationIds = new ArrayList<Object>(redConfirms.length);
        ArrayList<Object> deleteRelationNumbers = new ArrayList<Object>(redConfirms.length);
        HashSet<Object> matchBillPkSet = new HashSet<Object>(redConfirms.length);
        HashSet<String> invoiceCodeNoSet = new HashSet<String>(redConfirms.length);
        Set redConfirmPkSet = Arrays.stream(redConfirms).map(o -> o.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection matchBill2RedConfirmRelations = QueryServiceHelper.query((String)"sim_match_inv_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid", "matchtarget"), (QFilter[])new QFilter("tbillid", "in", redConfirmPkSet).toArray());
        Map<Object, String> redConfirmTargetMap = matchBill2RedConfirmRelations.stream().collect(Collectors.toMap(relation -> relation.get("tbillid"), relation -> relation.getString("matchtarget"), (v1, v2) -> v1));
        ArrayList<DynamicObject> matchBillMatchRedConfirms = new ArrayList<DynamicObject>(16);
        for (DynamicObject redConfirm : redConfirms) {
            String matchTarget = redConfirmTargetMap.get(redConfirm.getPkValue());
            if ("1".equals(matchTarget) || "2".equals(matchTarget)) {
                matchBillMatchRedConfirms.add(redConfirm);
            } else {
                if ("1".equals(redConfirm.getString("uploadstatus")) && !canRollbackStatus.contains(redConfirm.getString("confirmstatus"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%s\u4e3a\u5339\u914d\u84dd\u7968\u751f\u6210\u4e14\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001\u4e3a\u5df2\u5f55\u5165\u4e0d\u5141\u8bb8\u56de\u9000", (String)"RedConfirmBillRollbackOp_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("number")));
                }
                this.revokeRedConfirmFromMatchInv(deleteIds, deleteRelationIds, deleteRelationNumbers, invoiceCodeNoSet, redConfirm);
            }
            matchBillPkSet.addAll(this.matchBillMatchInvoiceRollback(deleteRelationIds, deleteRelationNumbers, deleteIds, invoiceCodeNoSet));
            matchBillPkSet.addAll(this.matchBillMatchRedConfirmRollback(matchBillMatchRedConfirms, matchBill2RedConfirmRelations));
            if (!CollectionUtils.isNotEmpty(matchBillPkSet)) continue;
            this.getOption().setVariableValue("matchBillIds", matchBillPkSet.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
    }

    private List<Object> matchBillMatchInvoiceRollback(List<Object> deleteRelationIds, List<Object> deleteRelationNumbers, List<Object> deleteIds, Set<String> invoiceCodeNoSet) {
        DynamicObject[] matchBills;
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"rollbackdelete", (String)"sim_red_confirm_bill", (Object[])deleteIds.toArray(), null);
        if (CollectionUtils.isNotEmpty((Collection)operationResult.getSuccessPkIds())) {
            deleteRelationIds.addAll(operationResult.getSuccessPkIds());
        }
        if (CollectionUtils.isEmpty(deleteRelationIds)) {
            return new ArrayList<Object>(1);
        }
        DynamicObject[] matchBillInvRelation = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)String.join((CharSequence)",", "ssubdetailid", "sbillid"), (QFilter[])OrgHelper.getIdFilter(deleteRelationIds, (String)"tbillid").toArray());
        if (matchBillInvRelation.length == 0) {
            return new ArrayList<Object>(1);
        }
        HashSet<Object> redConfirm2MatchBillOriItemSet = new HashSet<Object>(16);
        for (DynamicObject relation2 : matchBillInvRelation) {
            redConfirm2MatchBillOriItemSet.add(relation2.get("ssubdetailid"));
        }
        for (DynamicObject matchBill : matchBills = BusinessDataServiceHelper.load((Object[])Arrays.stream(matchBillInvRelation).map(relation -> relation.get("sbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"))) {
            DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items2) {
                DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
                for (DynamicObject oriItem : oriItems) {
                    if (deleteRelationNumbers.contains(oriItem.getString("infocode"))) {
                        oriItem.set("infocode", (Object)"");
                    }
                    if ("3".equals(matchBill.getString("matchtarget"))) {
                        String invoiceCodeNo = oriItem.getString("oriinvoicecode") + "\u25cf\u25c6\u25a0" + oriItem.getString("oriinvoiceno");
                        if (!invoiceCodeNoSet.contains(invoiceCodeNo)) continue;
                        oriItem.set("pushstatus", (Object)"-1");
                        continue;
                    }
                    if (!redConfirm2MatchBillOriItemSet.contains(oriItem.getPkValue())) continue;
                    oriItem.set("pushstatus", (Object)"-1");
                }
            }
            NegativeBillMatchHelper.changePushStatus((DynamicObject)matchBill);
        }
        ImcSaveServiceHelper.save((DynamicObject[])matchBills);
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])OrgHelper.getIdFilter(deleteRelationIds, (String)"tbillid").toArray());
        DeleteServiceHelper.delete((String)"sim_bill_inv_relation", (QFilter[])OrgHelper.getIdFilter(deleteRelationIds, (String)"tbillid").toArray());
        return Arrays.stream(matchBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    private List<Object> matchBillMatchRedConfirmRollback(List<DynamicObject> matchBillMatchRedConfirms, DynamicObjectCollection matchBill2RedConfirmRelations) {
        DynamicObject[] bills;
        if (CollectionUtils.isEmpty(matchBillMatchRedConfirms)) {
            return new ArrayList<Object>(1);
        }
        Set sBillIds = matchBill2RedConfirmRelations.stream().map(o -> o.getLong("sbillid")).collect(Collectors.toSet());
        Set tBillIds = matchBill2RedConfirmRelations.stream().map(o -> o.getLong("tbillid")).collect(Collectors.toSet());
        DynamicObject[] matchBills = BusinessDataServiceHelper.load((Object[])sBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        RedConfirmMatchHelper redConfirmMatchHelper = new RedConfirmMatchHelper();
        for (DynamicObject matchBill : matchBills) {
            DynamicObjectCollection confirmItems;
            DynamicObjectCollection items2;
            if ("3".equals(matchBill.getString("matchtarget"))) {
                items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items2) {
                    confirmItems = item.getDynamicObjectCollection("confirmsubentryentity");
                    confirmItems.clear();
                }
            } else {
                items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items2) {
                    confirmItems = item.getDynamicObjectCollection("confirmsubentryentity");
                    confirmItems.removeIf(nextConfirmItem -> tBillIds.contains(nextConfirmItem.getLong("redconfirmpk")));
                }
            }
            redConfirmMatchHelper.countMatchBillAmountAndStatus(matchBill);
        }
        Map<Long, DynamicObject> matchBillIdMatchBillMap = Arrays.stream(matchBills).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        ImcSaveServiceHelper.save((DynamicObject[])matchBills);
        DynamicObject[] billMatchRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)"sbillid,tbillid", (QFilter[])new QFilter("tbillid", "in", sBillIds).toArray());
        Map<Long, Long> billIdMatchBillIdMap = Arrays.stream(billMatchRelations).collect(Collectors.toMap(o -> o.getLong("sbillid"), o -> o.getLong("tbillid"), (v1, v2) -> v1));
        Set sOriginalBillPks = Arrays.stream(billMatchRelations).map(o -> o.getLong("sbillid")).collect(Collectors.toSet());
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"matchstatus", (QFilter[])new QFilter("id", "in", sOriginalBillPks).toArray())) {
            DynamicObject matchBill;
            Long matchBillId = billIdMatchBillIdMap.get(bill.getLong("id"));
            if (null == matchBillId || null == (matchBill = matchBillIdMatchBillMap.get(matchBillId))) continue;
            bill.set("matchstatus", (Object)matchBill.getString("matchstatus"));
        }
        if (bills.length > 0) {
            ImcSaveServiceHelper.save((DynamicObject[])bills);
        }
        this.updateRedConfirmAndDeleteRelation(matchBillMatchRedConfirms, matchBillMatchRedConfirms.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        return Arrays.stream(matchBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    public void updateRedConfirmAndDeleteRelation(List<DynamicObject> matchBillMatchRedConfirms, List<Object> deleteRelationIds) {
        for (DynamicObject redConfirm : matchBillMatchRedConfirms) {
            redConfirm.set("occupystatus", (Object)"0");
            if ("1".equals(redConfirm.getString("applicant"))) {
                redConfirm.set("source", (Object)"2");
                continue;
            }
            redConfirm.set("source", (Object)"1");
        }
        ImcSaveServiceHelper.save(matchBillMatchRedConfirms);
        DeleteServiceHelper.delete((String)"sim_vatinvoice", (QFilter[])new QFilter("orderno", "in", (Object)matchBillMatchRedConfirms.stream().map(confirm -> confirm.getString("orderno")).toArray()).toArray());
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])OrgHelper.getIdFilter(deleteRelationIds, (String)"tbillid").toArray());
        DeleteServiceHelper.delete((String)"sim_bill_inv_relation", (QFilter[])OrgHelper.getIdFilter(deleteRelationIds, (String)"tbillid").toArray());
    }

    private void revokeRedConfirmFromMatchInv(List<Object> deleteIds, List<Object> deleteRelationIds, List<Object> deleteRelationNumbers, Set<String> invoiceCodeNoSet, DynamicObject redConfirm) {
        invoiceCodeNoSet.add(redConfirm.getString("originalinvoicecode") + "\u25cf\u25c6\u25a0" + redConfirm.getString("originalinvoiceno"));
        this.unSubmitRedconfirms(redConfirm, deleteIds);
        if (canRollbackStatus.contains(redConfirm.getString("confirmstatus"))) {
            deleteRelationIds.add(redConfirm.getPkValue());
            deleteRelationNumbers.add(redConfirm.getString("number"));
        }
    }

    private void unSubmitRedconfirms(DynamicObject redConfirm, List<Object> deleteIds) {
        String uploadStatus = redConfirm.getString("uploadstatus");
        if ("0".equals(uploadStatus)) {
            deleteIds.add(redConfirm.getPkValue());
        }
        if ("2".equals(uploadStatus)) {
            if (RedConfirmBillHelper.isAllowDelFailRedComfrimBill((Object)redConfirm.getPkValue())) {
                deleteIds.add(redConfirm.getPkValue());
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u9000\u5931\u8d25\uff1a\u7a0e\u5c40\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001\u4e3a\u5df2\u5f55\u5165\uff0c\u8bf7\u5148\u66f4\u65b0\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001", (String)"RedConfirmBillRollbackOp_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String matchBillIds;
        OperateOption option = this.getOption();
        if (option.containsVariable("matchBillIds") && StringUtils.isNotBlank((CharSequence)(matchBillIds = option.getVariableValue("matchBillIds")))) {
            DynamicObject[] matchBills;
            BillComprehensiveStatusHelper billComprehensiveStatusHelper = new BillComprehensiveStatusHelper();
            String[] matchBillIdArr = matchBillIds.split(",");
            for (DynamicObject matchBill : matchBills = BusinessDataServiceHelper.load((String)"sim_match_bill", (String)BillComprehensiveStatusHelper.SELECT_FIELD, (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(matchBillIdArr).map(Long::parseLong).collect(Collectors.toSet())).toArray())) {
                billComprehensiveStatusHelper.setBillComprehensiveStatusByMatchBill(matchBill);
            }
        }
    }

    private void billRedconfirmRollback(DynamicObject[] redConfirms) {
        ArrayList<Object> deleteIds = new ArrayList<Object>(1);
        ArrayList<DynamicObject> updateRedconfirms = new ArrayList<DynamicObject>(1);
        for (DynamicObject redConfirm : redConfirms) {
            if ("1".equals(redConfirm.getString("uploadstatus")) && !canRollbackStatus.contains(redConfirm.getString("confirmstatus"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%s\u4e3a\u5339\u914d\u84dd\u7968\u751f\u6210\u4e14\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001\u4e3a\u5df2\u5f55\u5165\u4e0d\u5141\u8bb8\u56de\u9000", (String)"RedConfirmBillRollbackOp_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), redConfirm.getString("number")));
            }
            this.unSubmitRedconfirms(redConfirm, deleteIds);
            if (!RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirm.getString("confirmstatus"))) continue;
            redConfirm.set("source", (Object)"1");
            updateRedconfirms.add(redConfirm);
        }
        OperationServiceHelper.executeOperate((String)"rollbackdelete", (String)"sim_red_confirm_bill", (Object[])deleteIds.toArray(), null);
        if (CollectionUtils.isNotEmpty(updateRedconfirms)) {
            ImcSaveServiceHelper.save(updateRedconfirms);
        }
        new BillRollbackHelper().deleteRelateAndRollbackOriginalbill(redConfirms, "sim_red_confirm_bill");
        new BillRollbackHelper().deleteRelationAndMatchBill(redConfirms);
    }
}

