/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.DrawerStrategyDTO;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceViewCloseCallBackControl;
import kd.imc.sim.formplugin.redinfo.RedInfoListPlugin;
import kd.imc.sim.formplugin.redinfo.service.AddInitRedInfoService;
import kd.imc.sim.formplugin.redinfo.service.EditInitRedInfoService;

public class RedInfoEditPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(RedInfoEditPlugin.class);

    public void afterCreateNewData(EventObject e) {
        EditInitRedInfoService initRedInfo;
        Object pkValue = this.getView().getFormShowParameter().getCustomParam("sim_red_info");
        if (null != pkValue) {
            initRedInfo = new EditInitRedInfoService();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)String.join((CharSequence)",", "jqbh", "terminalno", "org"), (QFilter[])new QFilter("id", "=", pkValue).toArray());
            this.getModel().setValue("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("org")));
            this.getModel().setValue("jqbh", (Object)obj.getString("jqbh"));
            this.getModel().setValue("terminalno", (Object)obj.getString("terminalno"));
        } else {
            this.getModel().setValue("org", this.getView().getFormShowParameter().getCustomParam("org"));
            initRedInfo = new AddInitRedInfoService();
            this.getModel().setValue("id", (Object)DBServiceHelper.genGlobalLongId());
        }
        initRedInfo.init((AbstractFormPlugin)this);
        this.setJqbh();
        if (null == pkValue) {
            this.initPayeeAndReviewer();
        }
    }

    private void setJqbh() {
        Object jqbh = this.getModel().getValue("jqbh");
        String applicant = (String)this.getModel().getValue("applicant");
        Object sellerTaxNo = this.getModel().getValue(RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant) ? "salertaxno" : "buyertaxno");
        if (EquipmentHelper.isDisableJQBH((Object)sellerTaxNo, (Object)jqbh)) {
            this.getModel().setValue("jqbh", null);
            this.getModel().setValue("terminalno", null);
        }
    }

    private void initPayeeAndReviewer() {
        DrawerInfo drawerInfo = DrawerStrategyHelper.getDrawerInfoNonOriginalBill(null, null, null, (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")), (Object)this.getModel().getValue("jqbh"));
        this.getModel().setValue("payee", (Object)drawerInfo.getPayee());
        this.getModel().setValue("reviewer", (Object)drawerInfo.getReviewer());
        this.getModel().setValue("drawer", (Object)drawerInfo.getDrawer());
        LOGGER.info(String.format("initPayeeAndReviewer %s", JSONObject.toJSONString((Object)drawerInfo)));
    }

    private void setDeviceOpUserMethod() {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
        String jqbh = (String)this.getModel().getValue("jqbh");
        LOGGER.info("setDeviceOpUserMethod, orgId:{}, jqbh:{}", (Object)orgId, (Object)jqbh);
        DrawerStrategyDTO drawerStrategyDTO = DrawerStrategyHelper.getDrawerStrategyFromCache((Long)orgId);
        if (drawerStrategyDTO == null) {
            return;
        }
        DynamicObject devDynamicObject = EquipmentUtil.getEquipmentDynamicObject((Long)orgId, (Object)jqbh);
        if (devDynamicObject == null) {
            return;
        }
        String drawerstrategy = drawerStrategyDTO.getDrawerStrategy();
        String payeeStrategy = drawerStrategyDTO.getPayeeStrategy();
        String reviewerStrategy = drawerStrategyDTO.getReviewerStrategy();
        LOGGER.info("setDeviceOpUserMethod, drawerstrategy:{}, payeeStrategy:{}, reviewerStrategy:{}", new Object[]{drawerstrategy, payeeStrategy, reviewerStrategy});
        if (StringUtils.isNotBlank((CharSequence)drawerstrategy) && "2".equals(drawerstrategy)) {
            this.getModel().setValue("drawer", (Object)devDynamicObject.getString("drawer"));
        }
        if (StringUtils.isNotBlank((CharSequence)payeeStrategy) && "2".equals(payeeStrategy)) {
            this.getModel().setValue("payee", (Object)devDynamicObject.getString("payee"));
        }
        if (StringUtils.isNotBlank((CharSequence)reviewerStrategy) && "2".equals(reviewerStrategy)) {
            this.getModel().setValue("reviewer", (Object)devDynamicObject.getString("reviewer"));
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        TextEdit saleEdit = (TextEdit)this.getView().getControl("saleraddr");
        saleEdit.addClickListener((ClickListener)this);
        TextEdit buyerEdit = (TextEdit)this.getView().getControl("buyeraddr");
        buyerEdit.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        QFilter qFilter;
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "saleraddr": {
                qFilter = new QFilter("taxno", "=", this.getModel().getValue("salertaxno"));
                break;
            }
            case "buyeraddr": {
                qFilter = new QFilter("taxno", "=", this.getModel().getValue("buyertaxno"));
                break;
            }
            default: {
                qFilter = new QFilter("taxno", "=", (Object)"-1");
            }
        }
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter, (String)"sim_invoice_setting", (String)source.getKey());
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btn_save": {
                DynamicObject obj;
                this.getModel().setValue("applyreason", (Object)String.format(" %s", this.getModel().getValue("applyreason").toString().trim()));
                Object pkValue = this.getView().getFormShowParameter().getCustomParam("sim_red_info");
                if (null != pkValue && (obj = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"org", (QFilter[])new QFilter("id", "=", pkValue).toArray())) != null) {
                    PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("org")), (ImcPermItemEnum)ImcPermItemEnum.ITEM_EDIT);
                }
                this.customSaveOrSubmit("btn_save");
                break;
            }
            case "btn_submit": {
                this.getModel().setValue("applyreason", (Object)String.format(" %s", this.getModel().getValue("applyreason").toString().trim()));
                PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (ImcPermItemEnum)ImcPermItemEnum.ITEM_SUBMIT);
                this.customSaveOrSubmit("btn_submit");
                break;
            }
        }
    }

    private void customSaveOrSubmit(String operation) {
        HashMap showDataMap = Maps.newHashMapWithExpectedSize((int)1);
        showDataMap.put("eventkey", operation);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, (Map)showDataMap, (String)"customcontrolap");
    }

    private void refreshParent() {
        this.getView().returnDataToParent((Object)"refresh");
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "hsbz": {
                HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
                this.getPageCache().put("hsbz", String.valueOf(e.getChangeSet()[0].getNewValue()));
                showDataMap.put("eventkey", "sethsbz");
                showDataMap.put("hsbz", e.getChangeSet()[0].getNewValue());
                ViewUtil.bindDataToHtml((AbstractFormPlugin)this, showDataMap, (String)"customcontrolap");
                break;
            }
            case "buyeraddrtext": {
                this.getModel().setValue("buyeraddr", e.getChangeSet()[0].getNewValue());
                break;
            }
            case "saleraddrtext": {
                this.getModel().setValue("saleraddr", e.getChangeSet()[0].getNewValue());
                break;
            }
            case "jqbh": {
                String equipmentNo = (String)e.getChangeSet()[0].getNewValue();
                if (StringUtils.isBlank((CharSequence)equipmentNo)) {
                    return;
                }
                this.setDeviceOpUserMethod();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u5907\u5207\u6362\u4e3a%s", (String)"RedInfoEditPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), EquipmentType.getNameByCode((String)EquipmentHelper.getEquipmentTypeByNo((String)equipmentNo))));
                EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)equipmentNo, (String)"salertaxno", (String)"terminalno", (boolean)false);
            }
        }
    }

    private DynamicObject saveRedInfo(String ars) {
        DynamicObject obj;
        try {
            obj = RedInfoHelper.buildInvoiceDynamicObject((AbstractFormPlugin)this, (String)ars, (Object)this.getModel().getValue("org"));
            String specialType = (String)this.getModel().getValue("checkboxtobacco");
            obj.set("specialtype", (Object)specialType);
        }
        catch (MsgException e) {
            throw new KDBizException(e.getErrorMsg());
        }
        String errorMsg = InvoiceCheckService.checkRedInfo((DynamicObject)obj);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            throw new KDBizException(errorMsg);
        }
        this.checkRedLimitAmount(obj.getString("originalinvoicecode"), obj.getString("originalinvoiceno"), obj.getBigDecimal("invoiceamount"), obj.getBigDecimal("totaltax"));
        if (GBKUtils.getGBKLength((String)obj.getString("applyreason")) > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u7406\u7531\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100\uff08\u4e00\u4e2a\u6c49\u5b572\u4e2a\u5b57\u7b26\u957f\u5ea6\uff09", (String)"RedInfoEditPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"id", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(String.valueOf(this.getModel().getValue("id")))).toArray());
            if (dynamicObject == null) {
                DynamicObject dynamicObject2 = this.save(obj);
                return dynamicObject2;
            }
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"sim_red_info");
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("items");
            DeleteServiceHelper.delete((IDataEntityType)collection.getDynamicObjectType(), (Object[])collection.stream().map(DataEntityBase::getPkValue).toArray());
            this.buildRedInfo(dynamicObject, obj);
            ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
            DynamicObject dynamicObject3 = dynamicObject;
            return dynamicObject3;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                LOGGER.error("\u4fe1\u606f\u8868\u4fdd\u5b58\u5931\u8d25:{" + e.getMessage() + "}", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4fe1\u606f\u8868\u4fdd\u5b58\u5931\u8d25", (String)"RedInfoEditPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private DynamicObject save(DynamicObject obj) {
        obj.set("createtime", (Object)new Date());
        obj.set("creater", (Object)RequestContext.get().getUserId());
        obj.set("infosource", (Object)"1");
        obj.set("infoserialno", (Object)RedInfoHelper.generateRedInfoSerialNo((String)obj.getString("jqbh")));
        obj.set("orderno", (Object)UUID.next());
        this.buildRedInfoSale(obj, obj);
        Long taxOrgId = RedInfoHelper.getTaxOrgId((String)obj.getString("applytaxno"));
        obj.set("taxorg", (Object)taxOrgId);
        obj.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_red_info", (String)"1"));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_info", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            throw new KDBizException(operationResult.getMessage());
        }
        return obj;
    }

    private void buildDrawerPayeeReview(DynamicObject obj) {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
        String jqbh = (String)this.getModel().getValue("jqbh");
        LOGGER.info("setDeviceOpUserMethod, orgId:{}, jqbh:{}", (Object)orgId, (Object)jqbh);
        DrawerStrategyDTO drawerStrategyDTO = DrawerStrategyHelper.getDrawerStrategyFromCache((Long)orgId);
        if (drawerStrategyDTO == null) {
            return;
        }
        DynamicObject devDynamicObject = EquipmentUtil.getEquipmentDynamicObject((Long)orgId, (Object)jqbh);
        if (devDynamicObject == null) {
            return;
        }
        String drawerstrategy = drawerStrategyDTO.getDrawerStrategy();
        String payeeStrategy = drawerStrategyDTO.getPayeeStrategy();
        String reviewerStrategy = drawerStrategyDTO.getReviewerStrategy();
        LOGGER.info("setDeviceOpUserMethod, drawerstrategy:{}, payeeStrategy:{}, reviewerStrategy:{}", new Object[]{drawerstrategy, payeeStrategy, reviewerStrategy});
        if ("3".equals(drawerstrategy)) {
            obj.set("drawer", (Object)drawerStrategyDTO.getDrawerName());
        } else if ("0".equals(drawerstrategy)) {
            obj.set("drawer", (Object)RequestContext.get().getUserName());
        } else if ("1".equals(drawerstrategy)) {
            obj.set("drawer", (Object)drawerStrategyDTO.getDrawerName());
        } else if ("4".equals(drawerstrategy)) {
            obj.set("drawer", (Object)drawerStrategyDTO.getDrawerName());
        }
    }

    private void buildRedInfo(DynamicObject dynamicObject, DynamicObject obj) {
        dynamicObject.set("applyreason", obj.get("applyreason"));
        dynamicObject.set("hsbz", obj.get("hsbz"));
        dynamicObject.set("invoicetype", obj.get("invoicetype"));
        dynamicObject.set("specialtype", obj.get("specialtype"));
        dynamicObject.set("invoiceamount", obj.get("invoiceamount"));
        dynamicObject.set("totaltax", obj.get("totaltax"));
        dynamicObject.set("totalamount", obj.get("totalamount"));
        dynamicObject.set("jqbh", obj.get("jqbh"));
        dynamicObject.set("terminalno", obj.get("terminalno"));
        this.buildRedInfoSale(obj, dynamicObject);
        dynamicObject.set("reviewer", obj.get("reviewer"));
        dynamicObject.set("payee", obj.get("payee"));
        dynamicObject.set("drawer", obj.get("drawer"));
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
        dynamicObject.set("items", obj.get("items"));
        dynamicObject.set("reason", obj.get("reason"));
        String jqbh = dynamicObject.getString("jqbh");
        String infoSerialNo = dynamicObject.getString("infoserialno");
        if (StringUtils.isNotBlank((CharSequence)jqbh) && jqbh.length() >= 12 && !infoSerialNo.startsWith(jqbh = jqbh.substring(jqbh.length() - 12))) {
            dynamicObject.set("infoserialno", (Object)RedInfoHelper.generateRedInfoSerialNo((String)jqbh));
        }
    }

    private void buildRedInfoSale(DynamicObject sourceObj, DynamicObject targetObj) {
        targetObj.set("salername", (Object)this.trimStr(sourceObj.getString("salername")));
        targetObj.set("salertaxno", (Object)this.trimStr(sourceObj.getString("salertaxno")));
        targetObj.set("saleraddr", (Object)this.trimStr(sourceObj.getString("saleraddr")));
        targetObj.set("salerbank", (Object)this.trimStr(sourceObj.getString("salerbank")));
        targetObj.set("buyername", (Object)this.trimStr(sourceObj.getString("buyername")));
        targetObj.set("buyertaxno", (Object)this.trimStr(sourceObj.getString("buyertaxno")));
        targetObj.set("buyeraddr", (Object)this.trimStr(sourceObj.getString("buyeraddr")));
        targetObj.set("buyerbank", (Object)this.trimStr(sourceObj.getString("buyerbank")));
    }

    private String trimStr(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    private void checkRedLimitAmount(String originalInvoiceCode, String originalInvoiceNo, BigDecimal invoiceAmount, BigDecimal totalTax) {
        DynamicObject obj;
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode) && StringUtils.isNotBlank((CharSequence)originalInvoiceNo) && (obj = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "remainredamount", "canredtaxamount", "buyertype"), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)originalInvoiceCode, (String)originalInvoiceNo).toArray())) != null && !"9".equals(obj.getString("buyertype"))) {
            BigDecimal remainAmount = obj.getBigDecimal("remainredamount");
            BigDecimal remainTax = obj.getBigDecimal("canredtaxamount");
            if (remainAmount.compareTo(invoiceAmount.abs()) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u5269\u4f59\u53ef\u7533\u8bf7\u7ea2\u5b57\u4fe1\u606f\u8868\u91d1\u989d\u4e3a%s", (String)"RedInfoEditPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), remainAmount.setScale(2, 4)));
            }
            if (remainTax.compareTo(totalTax.abs()) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u5269\u4f59\u53ef\u7533\u8bf7\u7ea2\u5b57\u4fe1\u606f\u8868\u7a0e\u989d\u4e3a%s", (String)"RedInfoEditPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), remainTax.setScale(2, 4)));
            }
        }
    }

    private void submit(String items2) {
        DynamicObject obj = this.saveRedInfo(items2);
        if (RedInfoListPlugin.operationRedInfo(obj.getString("billstatus"), "btn_submit")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5185\u90e8\u5ba1\u6838\u72b6\u6001\u4e0d\u5141\u8bb8\u4e0a\u4f20", (String)"RedInfoEditPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)String.valueOf(obj.getPkValue()), (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u9501\u5b9a", (String)"RedInfoEditPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));){
            if (lock.tryLock()) {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"btn_submit", (String)"sim_red_info", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
                if (!operationResult.isSuccess()) {
                    throw new KDBizException(OperationConstant.getErrorMsg((OperationResult)operationResult));
                }
                return;
            }
            try {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ea2\u5b57\u4fe1\u606f\u8868\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"RedInfoEditPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
            switch (closedCallBackEvent.getActionId()) {
                case "saleraddr": {
                    CreateInvoiceViewCloseCallBackControl.updateSaleAddressView((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_invoice_setting"), (IFormView)this.getView());
                    break;
                }
                case "buyeraddr": {
                    this.updateBuyerAddressView(BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_invoice_setting"));
                    break;
                }
                case "salername": 
                case "buyername": {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdm_invice_title_strate", (String)"taxno,name,telephone,addr,openingbank,bankaccount,mobilephone,email,buyertype,idcode");
                    this.updateRedInfoTitleView(dynamicObject, closedCallBackEvent.getActionId());
                }
            }
            return;
        }
        if (closedCallBackEvent.getActionId().equals("queryGoods")) {
            ViewUtil.bindDataToHtml((AbstractFormPlugin)this, (Map)CreateInvoiceControl.handleGoodsCodeCloseCallBack((ClosedCallBackEvent)closedCallBackEvent, (AbstractFormPlugin)this), (String)"customcontrolap");
        }
    }

    private void updateRedInfoTitleView(DynamicObject dynamicObject, String actionId) {
        HashMap showDataMap = Maps.newHashMapWithExpectedSize((int)5);
        showDataMap.put("eventkey", "updateTitle");
        if (actionId.equals("buyername")) {
            if ("2".equals(dynamicObject.getString("buyertype"))) {
                this.getModel().setValue("buyertaxno", dynamicObject.get("idcode"));
            } else {
                this.getModel().setValue("buyertaxno", dynamicObject.get("taxno"));
            }
            this.getModel().setValue("buyername", (Object)dynamicObject.getString("name"));
            this.getModel().setValue("buyeraddrtext", dynamicObject.get("addr"));
            this.getModel().setValue("buyerbank", dynamicObject.get("openingbank"));
            showDataMap.put("buyername", dynamicObject.getString("name"));
        } else {
            this.getModel().setValue("salertaxno", dynamicObject.get("taxno"));
            this.getModel().setValue("salername", (Object)dynamicObject.getString("name"));
            this.getModel().setValue("saleraddrtext", dynamicObject.get("addr"));
            this.getModel().setValue("salerbank", dynamicObject.get("openingbank"));
            showDataMap.put("salername", dynamicObject.getString("name"));
        }
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, (Map)showDataMap, (String)(actionId.equals("buyername") ? "querytitlediy" : "saletitlediy"));
    }

    private void updateBuyerAddressView(DynamicObject object) {
        this.getView().getModel().setValue("buyeraddr", object.get("invoiceaddr"));
        this.getView().getModel().setValue("buyerbank", object.get("openuserbank"));
    }

    public void customEvent(CustomEventArgs e) {
        String event = e.getEventName();
        String ars = e.getEventArgs();
        switch (event) {
            case "chooseTitle": {
                String closedCallBack = ars.equals("sale") ? "salername" : "buyername";
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)ImcBaseDataHelper.getInvTitleFilter((Object)this.getModel().getValue("org")), (String)"bdm_invice_title_strate", (String)closedCallBack);
                break;
            }
            case "queryTitle": {
                if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(this.getModel().getValue("applicant"))) {
                    this.getModel().setValue("buyername", (Object)ars);
                    this.getView().addClientCallBack("querytitlediy");
                    break;
                }
                this.getModel().setValue("salername", (Object)ars);
                this.getView().addClientCallBack("saletitlediy");
                break;
            }
            case "updateBuyerTaxNo": {
                if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(this.getModel().getValue("applicant"))) {
                    CreateInvoiceControl.updateBuyerTaxNo((String)ars, (AbstractFormPlugin)this, (String)"buyertaxno", (String)"buyername");
                    break;
                }
                JSONObject jsonObject = JSONObject.parseObject((String)ars);
                if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("tax"))) {
                    this.getView().getModel().setValue("salertaxno", jsonObject.get((Object)"tax"));
                }
                this.getView().getModel().setValue("salername", jsonObject.get((Object)"name"));
                break;
            }
            case "queryGoods": {
                CreateInvoiceControl.queryGoods((String)ars, (AbstractFormPlugin)this);
                break;
            }
            case "btn_save": {
                try {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4fdd\u5b58", (String)"RedInfoEditPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                    this.saveRedInfo(ars);
                    this.refreshParent();
                    break;
                }
                catch (Exception ex) {
                    this.getView().hideLoading();
                    throw ex;
                }
            }
            case "btn_submit": {
                try {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4e0a\u4f20", (String)"RedInfoEditPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0])));
                    this.submit(ars);
                    this.refreshParent();
                    break;
                }
                catch (Exception ex) {
                    this.getView().hideLoading();
                    throw ex;
                }
            }
            case "tipNotify": {
                this.getView().showTipNotification(ars, Integer.valueOf(2000));
                break;
            }
            case "queryName": {
                CreateInvoiceControl.queryLikeGoodsByName((AbstractFormPlugin)this, (String)ars);
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        switch (e.getName()) {
            case "querytitlediy": {
                CreateInvoiceControl.queryBuyerTitle((String)((String)this.getModel().getValue("buyername")), (String)"querytitlediy", (AbstractFormPlugin)this, (String)this.getView().getPageId());
                break;
            }
            case "saletitlediy": {
                CreateInvoiceControl.queryBuyerTitle((String)((String)this.getModel().getValue("salername")), (String)"saletitlediy", (AbstractFormPlugin)this, (String)this.getView().getPageId());
            }
        }
    }
}

