/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.CommonConstant;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.SaleAddrAndPayeeDTO;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.plugin.AbstractImportPlugin;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.cache.GoodsInfoCacheHelper;
import kd.imc.sim.common.helper.cache.InvoiceTitleCacheHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class RedInfoImportPlugin
extends AbstractImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(RedInfoImportPlugin.class);
    private static final String TEMPLATE_DIR = "excel_templates";
    private static final String TEMPLATE_JSON_NAME = "redInfo.json";
    public static final int GOODSNAME_LENGTH = 92;
    public static final int UNIT_LENGTH = 22;
    public static final int SPECIFICATION_LENGTH = 40;

    public void afterCreateNewData(EventObject evt) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getModel().setValue("batchbelong", (Object)DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        ViewUtil.setLabelViewData((IFormView)this.getView(), (String)"helplabel", (String)ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u672c\u6a21\u677f\u9002\u7528\u4e8e\uff0c\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u84dd\u7968\u4fe1\u606f\u7684\u60c5\u51b5\u4e0b\uff0c\u901a\u8fc7\u6a21\u677f\u586b\u5199\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\u6765\u751f\u6210\u7ea2\u5b57\u4fe1\u606f\u7533\u8bf7\u8868\u3002", (String)"RedInfoImportPlugin_43", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    protected void downloadTemplate() {
        ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u5bfc\u5165\u6a21\u677f.xlsx");
    }

    protected void uploadFile(String filepath, InputStream inputStream, Workbook workbook) {
        PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (ImcPermItemEnum)ImcPermItemEnum.IMC_IMPORT);
        String suffix = filepath.substring(filepath.lastIndexOf(46));
        String errFileName = ExcelHelper.getErrorExcelFileName((String)filepath, (String)suffix);
        if (ExcelHelper.isExcelFile((String)suffix)) {
            try {
                int startRow = 2;
                int dataNum = workbook.getSheetAt(0).getLastRowNum() - startRow + 1;
                if (dataNum < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5145\u6570\u636e\u518d\u5f15\u5165", (String)"RedInfoImportPlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                if (dataNum > 5000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u5f15\u51655000\u884c\u660e\u7ec6\u4fe1\u606f", (String)"RedInfoImportPlugin_45", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                List fileFields = ExcelHelper.getFileFields((Row)workbook.getSheetAt(0).getRow(startRow - 1), (List)ExcelHelper.readTemplate((String)TEMPLATE_DIR, (String)TEMPLATE_JSON_NAME));
                Map<String, FileField> fieldMap = fileFields.stream().collect(Collectors.toMap(FileField::getFieldCode, t -> t, (v1, v2) -> v1));
                HashMap errMap = Maps.newHashMapWithExpectedSize((int)(dataNum >> 1));
                List list = ExcelHelper.doParse((Workbook)workbook, (List)fileFields, (int)startRow, (boolean)true, (Map)errMap);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5145\u6570\u636e\u518d\u5f15\u5165", (String)"RedInfoImportPlugin_44", (String)"imc-sim-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                this.fillInData(list);
                Map<String, Object> returnMap = this.checkRedInfo(list, fieldMap, errMap);
                List objs = (List)returnMap.get("objs");
                ImcSaveServiceHelper.save((List)objs);
                int successSize = Integer.parseInt(returnMap.get("successSize").toString());
                if (successSize != list.size()) {
                    ExcelHelper.showErrorResult((Workbook)workbook, (int)list.size(), (int)successSize, (Map)errMap, (String)errFileName, (AbstractFormPlugin)this, (String)"sim_red_info_import", (String)"sim_inv_import_result");
                } else {
                    super.resetFile();
                    this.getView().returnDataToParent((Object)"refresh");
                    this.getView().close();
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)e.getMessage()) ? e.toString() : e.getMessage());
                LOGGER.error("\u7ea2\u5b57\u4fe1\u606f\u8868\u5bfc\u5165\u51fa\u9519", (Throwable)e);
            }
        }
    }

    private void fillInData(List<Map<String, Object>> list) {
        DynamicObject[] devs;
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"defaultdev", (QFilter[])new QFilter("id", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f15\u5165\u7ec4\u7ec7;", (String)"RedInfoImportPlugin_47", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String jqbh = org.getString("defaultdev");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jqbh) && (devs = EquipmentUtil.getEquipmentByOrgId((Long)RequestContext.get().getOrgId())).length != 0) {
            jqbh = devs[0].getString("equipmentno");
        }
        Map bueryAddrMap = InvoiceTitleCacheHelper.getInvoiceTitleNMap();
        HashSet<String> goodsNameSet = new HashSet<String>(list.size());
        for (Map<String, Object> redInfo : list) {
            goodsNameSet.add((String)redInfo.get("goodsname"));
        }
        Map goodsMap = GoodsInfoCacheHelper.getGoodsInfo((String)"name", (Long)RequestContext.get().getOrgId(), goodsNameSet);
        SaleAddrAndPayeeDTO info = TaxUtils.getDefaultAddrAndPayee(null);
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            String billNo = (String)map.get("billno");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)billNo)) {
                map.put("billno", "billno" + i);
            }
            this.convertExcelDataToDbData(map);
            this.fillInSaleAndBuyerData(map, info, bueryAddrMap);
            map.put("jqbh", jqbh);
            this.fillInGoodsInfo(map, goodsMap);
        }
    }

    private void fillInGoodsInfo(Map<String, Object> map, Map<String, DynamicObject> goodsMap) {
        String goodsName = (String)map.get("goodsname");
        DynamicObject obj = goodsMap.get(goodsName);
        if (obj != null) {
            String hsbz = (String)map.get("hsbz");
            BigDecimal price = hsbz.equals(obj.getString("isinclusive")) ? obj.getBigDecimal("price") : obj.getBigDecimal("prices");
            String defaultPrice = MathUtils.isNullOrZero((BigDecimal)price) ? "" : price.negate().setScale(8, 4).toPlainString();
            this.fillInMapValue(map, "specification", obj.getString("specifications"));
            this.fillInMapValue(map, "unit", obj.getString("unit"));
            this.fillInMapValue(map, "goodscode", obj.getString("taxcode.mergecode"));
            this.fillInMapValue(map, "taxpremark", obj.getString("privilegeflag"));
            this.fillInMapValue(map, "zzstsgl", obj.getString("privilegetype"));
            this.fillInMapValue(map, "taxrate", obj.getString("taxrate"));
            if (this.checkMapValueNull(map, "amount")) {
                this.fillInMapValue(map, "unitprice", defaultPrice);
            } else if (!this.checkMapValueNull(map, "num")) {
                this.fillInMapValue(map, "unitprice", defaultPrice);
            }
        }
    }

    private void fillInSaleAndBuyerData(Map<String, Object> map, SaleAddrAndPayeeDTO info, Map<String, DynamicObject> bueryAddrMap) {
        String buyername;
        String salername;
        String salertaxno = "";
        String salerbank = "";
        String saleraddr = "";
        String buyertaxno = "";
        String buyerbank = "";
        String buyeraddr = "";
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(map.get("applicant"))) {
            salername = info.getSaleName();
            salertaxno = info.getSaleTaxNo();
            salerbank = info.getOpenUserBank();
            saleraddr = info.getInvoiceAddr();
            buyername = (String)map.get("buyername");
            DynamicObject obj = bueryAddrMap.get(buyername);
            if (obj != null) {
                buyertaxno = obj.getString("taxno");
                buyerbank = obj.getString("openingbank");
                buyeraddr = obj.getString("addr");
            }
        } else {
            buyername = info.getSaleName();
            buyertaxno = info.getSaleTaxNo();
            buyerbank = info.getOpenUserBank();
            buyeraddr = info.getInvoiceAddr();
            salername = (String)map.get("salername");
            DynamicObject obj = bueryAddrMap.get(salername);
            if (obj != null) {
                salertaxno = obj.getString("taxno");
                salerbank = obj.getString("openingbank");
                saleraddr = obj.getString("addr");
            }
        }
        this.fillInMapValue(map, "buyername", buyername);
        this.fillInMapValue(map, "buyertaxno", buyertaxno);
        this.fillInMapValue(map, "buyeraddr", buyeraddr);
        this.fillInMapValue(map, "buyerbank", buyerbank);
        this.fillInMapValue(map, "salername", salername);
        this.fillInMapValue(map, "salertaxno", salertaxno);
        this.fillInMapValue(map, "saleraddr", saleraddr);
        this.fillInMapValue(map, "salerbank", salerbank);
    }

    private void convertExcelDataToDbData(Map<String, Object> map) {
        String applicant = (String)map.get("applicant");
        map.put("applicant", org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(applicant = RedInfoConstant.ApplicantEnum.getCodeByDescribe((String)applicant))) ? applicant : RedInfoConstant.ApplicantEnum.SALER.getCode());
        String hsbz = (String)map.get("hsbz");
        hsbz = (String)InvoiceConstant.HSBZ_MAP.get(hsbz);
        map.put("hsbz", org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)hsbz) ? hsbz : "0");
        String taxpremark = (String)map.get("taxpremark");
        taxpremark = (String)InvoiceConstant.TAXPREMARK_MAP.get(taxpremark);
        map.put("taxpremark", org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)taxpremark) ? taxpremark : "0");
        String invoiceType = (String)map.get("invoicetype");
        invoiceType = InvoiceType.getCodeByDesc((String)invoiceType);
        map.put("invoicetype", org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invoiceType) ? invoiceType : InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode());
        String taxRate = (String)map.get("taxrate");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)taxRate)) {
            map.put("taxrate", TaxRateUtil.convertTaxRate((String)taxRate));
        }
    }

    private Map<String, Object> checkRedInfo(List<Map<String, Object>> list, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        SaleAddrAndPayeeDTO info = TaxUtils.getDefaultAddrAndPayee(null);
        String batchbelong = (String)this.getModel().getValue("batchbelong");
        int successSize = 0;
        Date today = new Date();
        DynamicObjectCollection dc = QueryServiceHelper.query((String)"sim_red_info", (String)"billno", (QFilter[])new QFilter("org", "=", (Object)RequestContext.get().getOrgId()).toArray());
        Set billNumberSets = dc.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        Map invoiceListMap = list.stream().collect(Collectors.groupingBy(map -> map.get("billno").toString(), Collectors.toList()));
        boolean tobaccoEnterprise = TaxUtils.isTobaccoEnterprise((Long)RequestContext.get().getOrgId());
        ArrayList objList = Lists.newArrayListWithCapacity((int)invoiceListMap.size());
        DynamicObject issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)RequestContext.get().getOrgId());
        boolean isSplit = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"));
        boolean isHint = BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"));
        Long taxOrgId = RedInfoHelper.getTaxOrgId((String)info.getSaleTaxNo());
        String billStatus = BillHelper.getBillStatusByTableName((String)"sim_red_info", (String)"3");
        for (Map.Entry entry : invoiceListMap.entrySet()) {
            BigDecimal totalTax;
            Map redInfo = (Map)entry.getValue().get(0);
            Row invoiceRow = (Row)redInfo.get("row");
            boolean checkFlag = true;
            if (billNumberSets.contains(entry.getKey())) {
                checkFlag = false;
                ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("billno"), (String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728", (String)"RedInfoImportPlugin_48", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            int errMsgSize = errMap.size();
            this.checkRedInfoMain(errMap, redInfo, fieldMap, today, info);
            if (errMsgSize != errMap.size()) {
                checkFlag = false;
            }
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_info");
            BigDecimal invoiceAmount = totalTax = BigDecimal.ZERO;
            BigDecimal totalAmount = totalTax;
            String mainTaxRate = (String)redInfo.get("taxrate");
            DynamicObjectUtil.map2DynamicObject((Map)redInfo, (DynamicObject)obj);
            obj.set("taxorg", (Object)taxOrgId);
            DynamicObjectCollection items2 = obj.getDynamicObjectCollection("items");
            try {
                BigDecimal sumSewc = BigDecimal.ZERO;
                List itemList = entry.getValue();
                int tobaccoDetailSize = 0;
                for (int i = 0; i < itemList.size(); ++i) {
                    String goodsCode;
                    DynamicObject taxRateCode;
                    String specification;
                    String unit;
                    Map redInfoDetail = (Map)itemList.get(i);
                    if (!((Boolean)redInfoDetail.get("flag")).booleanValue()) {
                        checkFlag = false;
                    }
                    Row row = (Row)redInfoDetail.get("row");
                    String goodsName = (String)redInfoDetail.get("goodsname");
                    if (StringUtils.isBlank((CharSequence)goodsName)) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodsname"), (String)ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoImportPlugin_50", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                    if (StringUtils.isBlank((CharSequence)(unit = (String)redInfoDetail.get("unit")))) {
                        if (GBKUtils.getGBKLength((String)unit) > 22 && isSplit) {
                            redInfoDetail.put("unit", GBKUtils.cutGBKString((String)unit, (int)22));
                        } else if (GBKUtils.getGBKLength((String)unit) > 22 && isHint) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unit"), (String)ApiErrCodeEnum.INVOICE_OPEN_GOODUNIT.getMsg(), errMap);
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)(specification = (String)redInfoDetail.get("specification")))) {
                        if (GBKUtils.getGBKLength((String)specification) > 40 && isSplit) {
                            redInfoDetail.put("specification", GBKUtils.cutGBKString((String)specification, (int)40));
                        } else if (GBKUtils.getGBKLength((String)specification) > 40 && isHint) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("specification"), (String)ApiErrCodeEnum.INVOICE_OPEN_SPECIFICATION.getMsg(), errMap);
                        }
                    }
                    if ((taxRateCode = TaxClassCodeCheckHelper.geTaxCode((String)(goodsCode = (String)redInfoDetail.get("goodscode")))) == null) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodscode"), (String)ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u6c47\u603b\u9879\u6216\u4e0d\u5b58\u5728", (String)"RedInfoImportPlugin_51", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    } else {
                        if (goodsCode.startsWith("1030402")) {
                            String applicant = (String)redInfoDetail.get("applicant");
                            if (!tobaccoEnterprise && applicant.equals(RedInfoConstant.ApplicantEnum.SALER.getCode())) {
                                checkFlag = false;
                                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodscode"), (String)ResManager.loadKDString((String)"\u975e\u5377\u70df\u4f01\u4e1a\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u5377\u70df\u660e\u7ec6\u53d1\u7968", (String)"RedInfoImportPlugin_52", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                            } else {
                                ++tobaccoDetailSize;
                            }
                        }
                        String simpleName = TaxClassCodeCheckHelper.geTaxCode((String)goodsCode).getString("simplename");
                        redInfoDetail.put("simplegoodsname", simpleName);
                        goodsName = '*' + simpleName + '*' + goodsName;
                    }
                    if (GBKUtils.getGBKLength((String)goodsName) > 92 && isSplit) {
                        redInfoDetail.put("goodsname", GBKUtils.cutGBKString((String)goodsName, (int)92));
                    } else if (GBKUtils.getGBKLength((String)goodsName) > 92 && isHint) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodsname"), (String)ApiErrCodeEnum.INVOICE_OPEN_GOODNAMEISGBK.getMsg(), errMap);
                    }
                    if (!this.checkTaxpremarkAndTaxRate(redInfoDetail, fieldMap, errMap)) {
                        checkFlag = false;
                    }
                    if (!this.checkPriceNum(redInfoDetail, fieldMap, errMap)) {
                        checkFlag = false;
                    }
                    sumSewc = sumSewc.add(new BigDecimal(redInfoDetail.get("sewc").toString()));
                    DynamicObject item = items2.addNew();
                    DynamicObjectUtil.map2DynamicObject((Map)redInfoDetail, (DynamicObject)item);
                    item.set("taxamount", (Object)item.getBigDecimal("taxamount").setScale(2, 4));
                    item.set("amount", (Object)item.getBigDecimal("amount").setScale(2, 4));
                    item.set("tax", (Object)item.getBigDecimal("tax").setScale(2, 4));
                    item.set("seq", (Object)i);
                    totalAmount = totalAmount.add(item.getBigDecimal("taxamount"));
                    invoiceAmount = invoiceAmount.add(item.getBigDecimal("amount"));
                    totalTax = totalTax.add(item.getBigDecimal("tax"));
                    String taxRate = (String)((Map)itemList.get(i)).get("taxrate");
                    if (mainTaxRate == null || mainTaxRate.equals(taxRate)) continue;
                    mainTaxRate = null;
                }
                obj.set("specialtype", (Object)"00");
                if (tobaccoDetailSize != itemList.size()) {
                    if (tobaccoDetailSize != 0) {
                        checkFlag = false;
                        Row row = (Row)((Map)itemList.get(0)).get("row");
                        ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodscode"), (String)ResManager.loadKDString((String)"\u5377\u70df\u53d1\u7968\u4e0d\u80fd\u5305\u542b\u975e\u5377\u70df\u660e\u7ec6", (String)"RedInfoImportPlugin_53", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                    if (tobaccoDetailSize > 8) {
                        Row row = (Row)((Map)itemList.get(0)).get("row");
                        ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("goodscode"), (String)ResManager.loadKDString((String)"\u5377\u70df\u53d1\u7968\u4e0d\u80fd\u8d85\u8fc78\u884c\u660e\u7ec6", (String)"RedInfoImportPlugin_54", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                    }
                } else {
                    obj.set("specialtype", (Object)"11");
                }
                if (sumSewc.compareTo(InvoiceConstant.DIFF_127) > 0) {
                    checkFlag = false;
                    ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("tax"), (String)ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u884c\u7a0e\u989d\u8bef\u5dee\u4e4b\u548c\u8d85\u8fc71.27\uff0c\u8bf7\u8c03\u6574\u7a0e\u989d\u6570\u503c", (String)"RedInfoImportPlugin_55", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                }
                if (!this.checkOriginalInvoice(invoiceRow, redInfo, invoiceAmount, totalTax, errMap, fieldMap)) {
                    checkFlag = false;
                }
            }
            catch (Exception e) {
                LOGGER.error("\u660e\u7ec6\u6821\u9a8c\u51fa\u9519" + e.getMessage(), (Throwable)e);
                checkFlag = false;
            }
            if (!checkFlag) continue;
            successSize += entry.getValue().size();
            obj.set("totalamount", (Object)totalAmount.setScale(2, 4));
            obj.set("invoiceamount", (Object)invoiceAmount.setScale(2, 4));
            obj.set("totaltax", (Object)totalTax.setScale(2, 4));
            obj.set("createtime", (Object)today);
            obj.set("infodate", (Object)today);
            obj.set("maintaxrate", (Object)mainTaxRate);
            obj.set("originaldeduction", (Object)BigDecimal.ZERO);
            obj.set("salertaxno", (Object)obj.getString("salertaxno").toUpperCase());
            obj.set("buyertaxno", (Object)obj.getString("buyertaxno").toUpperCase());
            obj.set("status", (Object)"1");
            obj.set("infoserialno", (Object)RedInfoHelper.generateRedInfoSerialNo((String)obj.getString("jqbh")));
            obj.set("orderno", (Object)UUID.next());
            obj.set("creater", (Object)RequestContext.get().getUserId());
            obj.set("infosource", (Object)"3");
            obj.set("org", (Object)RequestContext.get().getOrgId());
            obj.set("batchbelong", (Object)batchbelong);
            obj.set("billstatus", (Object)billStatus);
            if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(obj.getString("applicant"))) {
                obj.set("applytaxno", (Object)obj.getString("salertaxno"));
            } else {
                obj.set("applytaxno", (Object)obj.getString("buyertaxno"));
            }
            objList.add(obj);
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
        returnMap.put("successSize", successSize);
        returnMap.put("objs", objList);
        return returnMap;
    }

    private boolean checkOriginalInvoice(Row invoiceRow, Map<String, Object> redInfo, BigDecimal invoiceAmount, BigDecimal totalTax, Map<String, String> errMap, Map<String, FileField> fieldMap) {
        String issueTime;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)redInfo.get("originalinvoicecode").toString()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)redInfo.get("originalinvoiceno").toString())) {
            return true;
        }
        QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)redInfo.get("originalinvoicecode").toString(), (String)redInfo.get("originalinvoiceno").toString()).and("invoicetype", "in", (Object)new String[]{InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode()}).and("orgid", "=", (Object)RequestContext.get().getOrgId());
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"invoicestatus,remainredamount,canredtaxamount,invoicetype,issuetime", (QFilter[])qFilter.toArray());
        if (invoice == null) {
            return true;
        }
        boolean checkFlag = true;
        String invoiceType = (String)redInfo.get("invoicetype");
        if (!invoiceType.equals(invoice.getString("invoicetype"))) {
            checkFlag = false;
            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("invoicetype"), (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u7c7b\u578b\u4e0e\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4", (String)"RedInfoImportPlugin_57", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (!InvoiceStatus.isNormalInvIncludePartRed((String)invoice.getString("invoicestatus"))) {
            checkFlag = false;
            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("originalinvoicecode"), (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u72b6\u6001\u4e0d\u6b63\u5e38", (String)"RedInfoImportPlugin_58", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if ((issueTime = (String)redInfo.get("originalissuetime")) != null && !issueTime.equals(DateUtils.format((Date)invoice.getDate("issuetime")))) {
            checkFlag = false;
            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("originalissuetime"), (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u6b63\u5e38", (String)"RedInfoImportPlugin_59", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (invoiceAmount.abs().compareTo(invoice.getBigDecimal("remainredamount")) > 0) {
            checkFlag = false;
            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("amount"), (String)String.format(ResManager.loadKDString((String)"\u5df2\u8fbe\u5230\u6700\u5927\u53ef\u7ea2\u51b2\u91d1\u989d,\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u4e3a%s", (String)"RedInfoImportPlugin_85", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getBigDecimal("remainredamount").setScale(2, 4)), errMap);
        }
        if (totalTax.abs().compareTo(invoice.getBigDecimal("canredtaxamount")) > 0) {
            checkFlag = false;
            ExcelHelper.setErrorMessage((Row)invoiceRow, (FileField)fieldMap.get("amount"), (String)String.format(ResManager.loadKDString((String)"\u5df2\u8fbe\u5230\u6700\u5927\u53ef\u7ea2\u51b2\u7a0e\u989d,\u5269\u4f59\u53ef\u7ea2\u51b2\u7a0e\u989d\u4e3a%s", (String)"RedInfoImportPlugin_86", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getBigDecimal("canredtaxamount").setScale(2, 4)), errMap);
        }
        return checkFlag;
    }

    private void checkRedInfoMain(Map<String, String> errMap, Map<String, Object> redInfo, Map<String, FileField> fieldMap, Date today, SaleAddrAndPayeeDTO info) {
        this.checkNull(errMap, redInfo, fieldMap.get("buyername"));
        this.checkTaxNo(errMap, redInfo, fieldMap.get("buyertaxno"), true);
        this.checkNull(errMap, redInfo, fieldMap.get("buyeraddr"));
        this.checkNull(errMap, redInfo, fieldMap.get("buyerbank"));
        this.checkNull(errMap, redInfo, fieldMap.get("salername"));
        this.checkTaxNo(errMap, redInfo, fieldMap.get("salertaxno"));
        this.checkNull(errMap, redInfo, fieldMap.get("saleraddr"));
        this.checkNull(errMap, redInfo, fieldMap.get("salerbank"));
        String applicant = redInfo.get("applicant").toString();
        if (!RedInfoConstant.ApplicantEnum.BUYERDEDUCTED.getCode().equals(applicant)) {
            this.checkInvoiceCode(errMap, fieldMap.get("originalinvoicecode"), redInfo);
            this.checkInvoiceNo(errMap, fieldMap.get("originalinvoiceno"), redInfo);
            this.checkIssueTime(errMap, fieldMap.get("originalissuetime"), redInfo, today);
        }
        String buyerTaxNo = (String)redInfo.get("buyertaxno");
        String buyerName = (String)redInfo.get("buyername");
        String salerTaxNo = (String)redInfo.get("salertaxno");
        String salerName = (String)redInfo.get("salername");
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)salerTaxNo) && !salerTaxNo.equals(info.getSaleTaxNo())) {
                ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)fieldMap.get("salertaxno"), (String)ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0e\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"RedInfoImportPlugin_62", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)salerName) && !salerName.equals(info.getSaleName())) {
                ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)fieldMap.get("salername"), (String)ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0\u4e0e\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4", (String)"RedInfoImportPlugin_63", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        } else {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)buyerTaxNo) && !buyerTaxNo.equals(info.getSaleTaxNo())) {
                ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)fieldMap.get("buyertaxno"), (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7\u4e0e\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"RedInfoImportPlugin_64", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)buyerName) && !buyerName.equals(info.getSaleName())) {
                ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)fieldMap.get("buyername"), (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0\u4e0e\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4", (String)"RedInfoImportPlugin_65", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)salerTaxNo) && salerTaxNo.equals(buyerTaxNo)) {
            ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)fieldMap.get("salertaxno"), (String)ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0e\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e00\u6837", (String)"RedInfoImportPlugin_66", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)salerName) && salerName.equals(buyerName)) {
            ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)fieldMap.get("salername"), (String)ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0\u4e0e\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e00\u6837", (String)"RedInfoImportPlugin_67", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
    }

    private boolean checkPriceNum(Map<String, Object> redInfoDetail, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        boolean flag = true;
        Row row = (Row)redInfoDetail.get("row");
        String hsbz = (String)redInfoDetail.get("hsbz");
        String unitPrice = (String)redInfoDetail.get("unitprice");
        String num = (String)redInfoDetail.get("num");
        String amount = (String)redInfoDetail.get("amount");
        String taxRate = (String)redInfoDetail.get("taxrate");
        String tax = (String)redInfoDetail.get("tax");
        String sewc = "0";
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)taxRate)) {
            flag = false;
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)amount)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tax)) {
                tax = this.calcTax(taxRate, hsbz, amount).toPlainString();
                redInfoDetail.put("tax", tax);
            } else {
                BigDecimal calcTax = this.calcTax(taxRate, hsbz, amount);
                BigDecimal wc = calcTax.subtract(new BigDecimal(tax)).abs();
                if (wc.compareTo(InvoiceConstant.DIFFF_06) > 0) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u91d1\u989d\u4e58\u4ee5\u7a0e\u7387\u4e0e\u7a0e\u989d\u7684\u8bef\u5dee\u8d85\u8fc7\u9650\u52360.06", (String)"RedInfoImportPlugin_68", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                } else {
                    sewc = wc.toPlainString();
                }
            }
        }
        if (flag && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)amount)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)unitPrice) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)num)) {
                BigDecimal calcAmount = new BigDecimal(unitPrice).multiply(new BigDecimal(num));
                if (calcAmount.subtract(new BigDecimal(amount)).abs().compareTo(InvoiceConstant.DIFF_01) > 0) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("amount"), (String)ResManager.loadKDString((String)"\u5355\u4ef7\u6570\u91cf\u91d1\u989d\u8bef\u5dee\u5927\u4e8e0.01", (String)"RedInfoImportPlugin_69", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
                } else {
                    this.fillInPrice(amount, tax, hsbz, num, unitPrice, redInfoDetail);
                }
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)unitPrice) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)num)) {
                try {
                    num = UnitPriceHelper.calcNum((BigDecimal)new BigDecimal(amount), (BigDecimal)new BigDecimal(unitPrice)).toPlainString();
                }
                catch (KDBizException e) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("num"), (String)e.getMessage(), errMap);
                }
                redInfoDetail.put("num", num);
                this.fillInPrice(amount, tax, hsbz, num, unitPrice, redInfoDetail);
            } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)unitPrice) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)num)) {
                try {
                    unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)new BigDecimal(amount), (BigDecimal)new BigDecimal(num), (boolean)Boolean.FALSE).toPlainString();
                }
                catch (KDBizException e) {
                    flag = false;
                    ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("unitprice"), (String)e.getMessage(), errMap);
                }
                this.fillInPrice(amount, tax, hsbz, num, unitPrice, redInfoDetail);
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)amount) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tax)) {
                String taxAmount = "0".equals(hsbz) ? new BigDecimal(amount).add(new BigDecimal(tax)).setScale(2, 4).toPlainString() : amount;
                amount = "1".equals(hsbz) ? new BigDecimal(amount).subtract(new BigDecimal(tax)).setScale(2, 4).toPlainString() : amount;
                redInfoDetail.put("taxamount", taxAmount);
                redInfoDetail.put("amount", amount);
            }
        }
        redInfoDetail.put("sewc", sewc);
        return flag;
    }

    private void fillInPrice(String amountStr, String tax, String hsbz, String num, String unitPrice, Map<String, Object> redInfoDetail) {
        if ("0".equals(hsbz)) {
            BigDecimal taxAmount = new BigDecimal(amountStr).add(new BigDecimal(tax));
            redInfoDetail.put("taxamount", taxAmount);
            redInfoDetail.put("amount", amountStr);
            redInfoDetail.put("unitprice", unitPrice);
            redInfoDetail.put("taxunitprice", PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)new BigDecimal(num), (boolean)Boolean.FALSE));
        } else {
            BigDecimal amount = new BigDecimal(amountStr).subtract(new BigDecimal(tax));
            redInfoDetail.put("taxamount", amountStr);
            redInfoDetail.put("amount", amount);
            redInfoDetail.put("taxunitprice", unitPrice);
            redInfoDetail.put("unitprice", PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)new BigDecimal(num), (boolean)Boolean.FALSE));
        }
    }

    private BigDecimal calcTax(String taxRateStr, String hsbz, String amountStr) {
        BigDecimal taxRate = new BigDecimal(taxRateStr);
        BigDecimal amount = new BigDecimal(amountStr);
        BigDecimal tax = "0".equals(hsbz) ? amount.multiply(taxRate).divide("0.015".equals(taxRateStr) ? new BigDecimal("1.035") : BigDecimal.ONE, 2, 4) : amount.multiply(taxRate).divide(BigDecimal.ONE.add("0.015".equals(taxRateStr) ? new BigDecimal("0.05") : taxRate), 2, 4);
        return tax;
    }

    private boolean checkTaxpremarkAndTaxRate(Map<String, Object> redInfoDetail, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        boolean flag = true;
        Row row = (Row)redInfoDetail.get("row");
        String taxRate = (String)redInfoDetail.get("taxrate");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)taxRate)) {
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("taxrate"), (String)ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoImportPlugin_70", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else {
            String goodsCode;
            if (BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) == 0) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("zzstsgl"), (String)ResManager.loadKDString((String)"0\u7a0e\u7387\u4e0d\u5141\u8bb8\u5f00\u4e13\u7968", (String)"RedInfoImportPlugin_71", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodsCode = (String)redInfoDetail.get("goodscode"))) && goodsCode.startsWith("1030402") && TaxRate.ONE_POINT_FIVE_PERCENT.getNumValue().compareTo(new BigDecimal(taxRate)) == 0) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("zzstsgl"), (String)ResManager.loadKDString((String)"\u5377\u70df\u53d1\u7968\u4e0d\u80fd\u5f001.5%\u7a0e\u7387\u7684\u53d1\u7968", (String)"RedInfoImportPlugin_72", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
        String taxpremark = (String)redInfoDetail.get("taxpremark");
        if ("1".equals(taxpremark)) {
            String zzstsgl = (String)redInfoDetail.get("zzstsgl");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)zzstsgl)) {
                flag = false;
                ExcelHelper.setErrorMessage((Row)row, (FileField)fieldMap.get("zzstsgl"), (String)ResManager.loadKDString((String)"\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoImportPlugin_73", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            } else if (!this.checkTaxRate(redInfoDetail, fieldMap, zzstsgl, errMap)) {
                flag = false;
            }
        }
        return flag;
    }

    private boolean checkTaxRate(Map<String, Object> redInfoDetail, Map<String, FileField> fieldMap, String zzstsgl, Map<String, String> errMap) {
        String msg;
        String goodsCode;
        DynamicObject taxCodeObj;
        Row row = (Row)redInfoDetail.get("row");
        boolean flag = true;
        String taxRate = (String)redInfoDetail.get("taxrate");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)taxRate) && (taxCodeObj = TaxClassCodeCheckHelper.geTaxCode((String)(goodsCode = redInfoDetail.get("goodscode").toString()))) != null && (msg = TaxRateUtil.checkPrivilegeType((String)taxCodeObj.getString("vatspecialmanagement"), (String)zzstsgl, (String)taxRate)) != null) {
            FileField field = fieldMap.get("zzstsgl");
            if (msg.contains("\u7a0e\u7387")) {
                field = fieldMap.get("taxrate");
            }
            flag = false;
            ExcelHelper.setErrorMessage((Row)row, (FileField)field, (String)msg, errMap);
        }
        return flag;
    }

    private void checkIssueTime(Map<String, String> errMap, FileField field, Map<String, Object> redInfo, Date today) {
        String originalIssueTime = (String)redInfo.get("originalissuetime");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)originalIssueTime)) {
            ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoImportPlugin_75", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else if (DateUtils.stringToDate((String)originalIssueTime).compareTo(today) > 0) {
            ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u65e5\u671f", (String)"RedInfoImportPlugin_76", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
    }

    private void checkInvoiceNo(Map<String, String> errMap, FileField field, Map<String, Object> redInfo) {
        String invoiceNo = (String)redInfo.get("originalinvoiceno");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoiceNo)) {
            ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoImportPlugin_77", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
        if (!RegexUtil.isInvoiceNo((String)invoiceNo)) {
            ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801\u683c\u5f0f\u9519\u8bef", (String)"RedInfoImportPlugin_78", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        }
    }

    private void checkInvoiceCode(Map<String, String> errMap, FileField field, Map<String, Object> redInfo) {
        String invoiceCode = (String)redInfo.get("originalinvoicecode");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoiceCode)) {
            ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoImportPlugin_79", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            return;
        }
        if (!RegexUtil.isInvoiceCode((String)invoiceCode)) {
            ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u4ee3\u7801\u683c\u5f0f\u9519\u8bef", (String)"RedInfoImportPlugin_80", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
        } else {
            String invoiceType;
            char eight = invoiceCode.charAt(7);
            if (invoiceCode.length() == 10 && eight != '1' && eight != '5') {
                ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4ee3\u7801", (String)"RedInfoImportPlugin_81", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (invoiceCode.length() == 12 && !"13".equals(invoiceCode.substring(10))) {
                ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\u4ee3\u7801", (String)"RedInfoImportPlugin_82", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
            if (!(invoiceType = invoiceCode.length() == 12 ? InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode() : InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()).equals(redInfo.get("invoicetype"))) {
                ExcelHelper.setErrorMessage((Row)((Row)redInfo.get("row")), (FileField)field, (String)ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u5bf9\u5e94\u53d1\u7968\u79cd\u7c7b\u9519\u8bef", (String)"RedInfoImportPlugin_83", (String)"imc-sim-formplugin", (Object[])new Object[0]), errMap);
            }
        }
    }
}

