/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.formplugin.redinfo.op.validator.RedInfoRevokeValidator;
import kd.imc.sim.formplugin.redinfo.op.validator.RedInfoUploadValidator;

public class RedInfoOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("applicant");
        e.getFieldKeys().add("applytaxno");
        e.getFieldKeys().add("salertaxno");
        e.getFieldKeys().add("buyertaxno");
        e.getFieldKeys().add("originalinvoicecode");
        e.getFieldKeys().add("originalinvoiceno");
        e.getFieldKeys().add("terminalno");
        e.getFieldKeys().add("invoiceamount");
        e.getFieldKeys().add("totaltax");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("infoserialno");
        e.getFieldKeys().add("jqbh");
        e.getFieldKeys().add("invoicetype");
        e.getFieldKeys().add("infocode");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("infostatus");
        e.getFieldKeys().add("statusdescribe");
        e.getFieldKeys().add("submitter");
        e.getFieldKeys().add("submitdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        if (CollectionUtils.isEmpty((Collection)validators)) {
            return;
        }
        String operateKey = ((AbstractValidator)validators.get(0)).getOperateKey();
        if ("btn_submit".equals(operateKey)) {
            e.getValidators().add(new RedInfoUploadValidator());
        } else if ("btn_revoke".equals(operateKey)) {
            e.getValidators().add(new RedInfoRevokeValidator());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        switch (e.getOperationKey()) {
            case "unsubmit": 
            case "unaudit": {
                this.clearSubmit(e);
                break;
            }
            case "btn_submit": {
                this.submitRedInfo(e);
                break;
            }
            case "btn_revoke": {
                this.revokeRedInfo(e);
            }
        }
    }

    private void clearSubmit(BeginOperationTransactionArgs e) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = e.getDataEntities()) {
            obj.set("submitter", null);
            obj.set("submitdate", null);
        }
        ImcSaveServiceHelper.save((DynamicObject[])objs);
    }

    private void revokeRedInfo(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        HashMap<String, String> jqbhMap = new HashMap<String, String>();
        DynamicObject[] redInfos = e.getDataEntities();
        EquipmentHelper.checkJQBH((DynamicObject[])redInfos);
        block15: for (DynamicObject redInfo : redInfos) {
            String equipmentType;
            switch (equipmentType = RedInfoOp.getEquipmentType(jqbhMap, redInfo)) {
                case "0": 
                case "2": {
                    RedInfoHelper.componentRevoke(successObjs, (DynamicObject)redInfo, (OperationResult)this.operationResult);
                    continue block15;
                }
                case "3": {
                    RedInfoHelper.revokeRedInfo((DynamicObject)redInfo);
                    successObjs.add(redInfo);
                    continue block15;
                }
                case "4": {
                    HostModeInvoiceHelper.revokeRedInfo(successObjs, (DynamicObject)redInfo, (OperationResult)this.operationResult);
                    continue block15;
                }
                case "9": 
                case "10": 
                case "11": {
                    LyServerInvoiceHelper.revokeRedInfo(successObjs, (DynamicObject)redInfo, (OperationResult)this.operationResult);
                }
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        ImcSaveServiceHelper.save((DynamicObject[])redInfos);
    }

    public static String getEquipmentType(Map<String, String> jqbhMap, DynamicObject redInfo) {
        String jqbh = redInfo.getString("jqbh");
        String equipmentType = jqbhMap.get(jqbh);
        if (StringUtils.isBlank((CharSequence)equipmentType)) {
            equipmentType = DeviceUtil.getDevType((String)jqbh);
            jqbhMap.put(jqbh, equipmentType);
        }
        return equipmentType;
    }

    private void submitRedInfo(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        HashMap<String, String> jqbhMap = new HashMap<String, String>();
        DynamicObject[] redInfos = e.getDataEntities();
        redInfos = BusinessDataServiceHelper.load((Object[])Stream.of(redInfos).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"));
        EquipmentHelper.checkJQBH((DynamicObject[])redInfos);
        for (DynamicObject redInfo : redInfos) {
            String equipmentType = RedInfoOp.getEquipmentType(jqbhMap, redInfo);
            if ("3".equals(equipmentType)) {
                RedInfoHelper.submitVirtualRedInfo((DynamicObject)redInfo);
                successObjs.add(redInfo);
                continue;
            }
            if (EquipmentHelper.isBlockChainOrHostModeDevice((String)equipmentType)) {
                RedInfoHelper.submitHostModeRedInfo(successObjs, (DynamicObject)redInfo, (OperationResult)this.operationResult);
                continue;
            }
            if ("8".equals(equipmentType)) {
                RedInfoHelper.submitBwServerRedInfo(successObjs, (DynamicObject)redInfo, (OperationResult)this.operationResult);
                continue;
            }
            if (EquipmentType.isLyServer((String)equipmentType)) {
                RedInfoHelper.submitLyServerRedInfo(successObjs, (DynamicObject)redInfo, (OperationResult)this.operationResult);
                continue;
            }
            boolean isComponentBw = "1".equals(equipmentType);
            RedInfoHelper.submitRedInfoToComponent(successObjs, (DynamicObject)redInfo, (boolean)isComponentBw, (OperationResult)this.operationResult);
        }
        new NegativeBillMatchHelper().writeInfoCode2MatchBill(successObjs);
        e.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        ImcSaveServiceHelper.save((DynamicObject[])redInfos);
    }
}

