/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo.callback;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.annotation.CallBackAnnotation;
import kd.imc.bdm.common.constant.CallBackEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.DrawerStrategyDTO;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillRollbackHelper;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.service.IssueInvoiceService;
import org.apache.commons.lang3.StringUtils;

public class RedInfoListCallBack {
    private static final Log LOGGER = LogFactory.getLog(RedInfoListCallBack.class);

    @CallBackAnnotation(value={"sim_red_info_dialog"}, callback=CallBackEnum.CLOSED)
    public void redInfoAddCallBack(AbstractFormPlugin that, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            String pageId = (String)map.get("pageId");
            ViewUtil.openMainNewTabPage((AbstractFormPlugin)that, (String)((StringUtils.isBlank((CharSequence)pageId) ? RequestContext.get().getUserId() : pageId) + "sim_red_info_edit"), (Map)map, (String)"sim_red_info_edit", (String)"sim_red_info_edit");
        }
    }

    @CallBackAnnotation(value={"sim_red_info_edit"}, callback=CallBackEnum.CLOSED)
    public void redInfoEditCallBack(AbstractFormPlugin that, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"RedInfoListCallBack_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            IListView listView = (IListView)that.getView();
            listView.refresh();
        }
    }

    @CallBackAnnotation(value={"sim_red_info_download"}, callback=CallBackEnum.CLOSED)
    public void redInfoDownloadCallBack(AbstractFormPlugin that, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String message = (String)closedCallBackEvent.getReturnData();
            that.getView().showSuccessNotification(message);
            IListView listView = (IListView)that.getView();
            listView.refresh();
        }
    }

    @CallBackAnnotation(value={"sim_red_info_openinvoice"}, callback=CallBackEnum.CLOSED)
    public void redInfoOpenInvoiceCallBack(AbstractFormPlugin that, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            IListView listView = (IListView)that.getView();
            listView.refresh();
        }
    }

    @CallBackAnnotation(value={"sim_red_info_import"}, callback=CallBackEnum.CLOSED)
    public void redInfoImportCallBack(AbstractFormPlugin that, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff01", (String)"RedInfoListCallBack_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        IListView listView = (IListView)that.getView();
        listView.refresh();
    }

    @CallBackAnnotation(value={"rollbackori"}, callback=CallBackEnum.CONFIRM)
    public void rollBackCallBack(AbstractFormPlugin that, MessageBoxClosedEvent e) {
        if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
            ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"org", (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray());
            CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)that, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_ROLLBACK_1, (DynamicObject[])redInfos);
            new BillRollbackHelper().rollback(that, rows.getPrimaryKeyValues(), "sim_red_info");
        }
        this.refreshList(that);
    }

    private void refreshList(AbstractFormPlugin that) {
        BillList list = (BillList)that.getControl("billlistap");
        list.clearSelection();
        list.refresh();
    }

    @Deprecated
    public void redInfoInvoiceOpenCallBack(AbstractFormPlugin that, MessageBoxClosedEvent e) {
    }

    @CallBackAnnotation(value={"cancelOrRedArInvoice"}, callback=CallBackEnum.CONFIRM)
    public void cancelOrRedCallBack(AbstractFormPlugin that, MessageBoxClosedEvent e) {
        if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
            String paramStr = that.getPageCache().get("cancelOrRedArInvoiceBillPks");
            that.getPageCache().remove("cancelOrRedArInvoiceBillPks");
            BotpHelper.writeOffArBillAndAddMark((String)paramStr, (String)"sim_red_info");
            ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
            DynamicObject[] redInfoDynamicObjects = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"));
            boolean showTip = false;
            for (DynamicObject dynamicObject : redInfoDynamicObjects) {
                String errorMsg = InvoiceCheckService.checkParams((DynamicObject)dynamicObject, (boolean)false);
                if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                    throw new KDBizException(errorMsg);
                }
                if (showTip || !BotpHelper.isRedConfirmOrInfoNeedShowArTip((DynamicObject)dynamicObject)) continue;
                showTip = true;
            }
            HashSet<String> errMsg = new HashSet<String>(redInfoDynamicObjects.length);
            int successNum = 0;
            for (DynamicObject redInfoDynamicObject : redInfoDynamicObjects) {
                RedInfoHelper.queryWaitInvoiceByInfoCodeThenDelete((DynamicObject)redInfoDynamicObject);
                DynamicObject invoiceObj = RedInfoHelper.redInfoToInvoice((DynamicObject)redInfoDynamicObject);
                MsgResponse response = IssueInvoiceService.doIssueInvoice((DynamicObject)invoiceObj);
                if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
                    JSONObject json = JSONObject.parseObject((String)response.getRespData());
                    redInfoDynamicObject.set("invoicecode", json.get((Object)"invoicecode"));
                    redInfoDynamicObject.set("invoiceno", json.get((Object)"invoiceno"));
                    redInfoDynamicObject.set("status", (Object)"4");
                    Object issueTime = json.get((Object)"issuetime");
                    if (issueTime == null) {
                        redInfoDynamicObject.set("issuetime", (Object)new Date());
                    } else {
                        redInfoDynamicObject.set("issuetime", (Object)IssueInvoiceService.handleIssueTime((String)String.valueOf(json.get((Object)"issuetime"))));
                    }
                    SaveServiceHelper.update((DynamicObject)redInfoDynamicObject);
                    ++successNum;
                    continue;
                }
                errMsg.add(response.getErrorMsg());
            }
            this.refreshList(that);
            if (!CollectionUtils.isEmpty(errMsg)) {
                String errMsgs = String.join((CharSequence)",", errMsg);
                if (showTip && successNum > 0) {
                    String msg = ResManager.loadKDString((String)"\u90e8\u5206\u7ea2\u51b2\u5931\u8d25\u539f\u56e0:", (String)"RedInfoListCallBack_3", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                    errMsgs = BotpHelper.getRedFiTip() + System.lineSeparator() + msg + errMsgs;
                }
                that.getView().showErrorNotification(errMsgs);
            } else if (showTip && successNum > 0) {
                that.getView().showTipNotification(BotpHelper.getRedFiTip(), Integer.valueOf(8000));
            }
        }
    }

    @CallBackAnnotation(value={"EDIT_ORG_CALLBACK"}, callback=CallBackEnum.CLOSED)
    public void redInfoEditOrgCallBack(AbstractFormPlugin that, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            Object[] primaryKeyValues = ((IListView)that.getView()).getSelectedRows().getPrimaryKeyValues();
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"));
            PermissionHelper.checkPermission((String)"sim", (String)"sim_red_info", (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)redInfos[0].get("org")), (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_RED_INFO_EDIT_ORG);
            Object orgId = closedCallBackEvent.getReturnData();
            for (DynamicObject redInfo : redInfos) {
                redInfo.set("org", orgId);
                this.dealSetOpUserBySelectOrg(orgId, redInfo);
            }
            SaveServiceHelper.update((DynamicObject[])redInfos);
            that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fee\u6539\u6210\u529f", (String)"RedInfoListCallBack_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        this.refreshList(that);
    }

    private void dealSetOpUserBySelectOrg(Object object, DynamicObject redInfo) {
        if (object != null) {
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)object;
            if (listSelectedRowCollection == null || listSelectedRowCollection.isEmpty()) {
                return;
            }
            ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
            Object orgId = listSelectedRow.getPrimaryKeyValue();
            if (orgId == null) {
                return;
            }
            Long org_id = Long.parseLong(orgId.toString());
            LOGGER.info("dealSetOpUserBySelectOrg, org_id:{}", (Object)org_id);
            DynamicObject devDynamicObject = EquipmentUtil.getDefaultDev((Long)org_id);
            if (devDynamicObject == null) {
                return;
            }
            DrawerStrategyDTO drawerStrategyDTO = DrawerStrategyHelper.getDrawerStrategyFromCache((Long)org_id);
            if (drawerStrategyDTO == null) {
                return;
            }
            redInfo.set("jqbh", (Object)devDynamicObject.getString("equipmentno"));
            String drawerstrategy = drawerStrategyDTO.getDrawerStrategy();
            String payeeStrategy = drawerStrategyDTO.getPayeeStrategy();
            String reviewerStrategy = drawerStrategyDTO.getReviewerStrategy();
            LOGGER.info("dealSetOpUserBySelectOrg, drawerstrategy:{}, payeeStrategy:{}, reviewerStrategy", new Object[]{drawerstrategy, payeeStrategy, reviewerStrategy});
            if ("2".equals(drawerstrategy)) {
                redInfo.set("drawer", (Object)devDynamicObject.getString("drawer"));
            }
            if ("2".equals(payeeStrategy)) {
                redInfo.set("payee", (Object)devDynamicObject.getString("payee"));
            }
            if ("2".equals(reviewerStrategy)) {
                redInfo.set("reviewer", (Object)devDynamicObject.getString("reviewer"));
            }
        }
    }
}

