/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo.op.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.formplugin.redinfo.RedInfoListPlugin;

public class RedInfoUploadValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject[] dynamicObjects = (DynamicObject[])Stream.of(dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        DynamicObjectCollection remainRedAmountAndTax = RedInfoHelper.queryOriginalInvoiceRemainRedAmount((DynamicObject[])dynamicObjects);
        Map<String, BigDecimal> remainRedAmountMap = remainRedAmountAndTax.stream().collect(Collectors.toMap(k -> k.getString("invoicecode") + '_' + k.getString("invoiceno"), v -> v.getBigDecimal("remainredamount"), BigDecimal::add));
        Map<String, BigDecimal> remainRedTaxMap = remainRedAmountAndTax.stream().collect(Collectors.toMap(k -> k.getString("invoicecode") + '_' + k.getString("invoiceno"), v -> v.getBigDecimal("canredtaxamount"), BigDecimal::add));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject redInfo = dataEntity.getDataEntity();
            if (RedInfoListPlugin.operationRedInfo(redInfo.getString("billstatus"), this.getOperateKey())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("{0}\u5f53\u524d\u5185\u90e8\u5ba1\u6838\u72b6\u6001\u4e0d\u5141\u8bb8\u4e0a\u4f20", redInfo.getString("infoserialno")), (String)"RedInfoUploadValidator_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                continue;
            }
            String jqbh = redInfo.getString("jqbh");
            if (StringUtils.isBlank((CharSequence)jqbh)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%s\u5bf9\u5e94\u4fe1\u606f\u8868\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedInfoUploadValidator_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), redInfo.getString("infoserialno")));
                continue;
            }
            DynamicObject equipmentDynamicObject = EquipmentUtil.getCommonEquipment((String)jqbh, (String)redInfo.getString("applytaxno"), (String)redInfo.getString("terminalno"));
            if (equipmentDynamicObject == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65b9\u7a0e\u53f7%1$s\u4e0b\u4e0d\u5b58\u5728\u76d8\u53f7\u4e3a%2$s\u7684\u76d8", (String)"RedInfoUploadValidator_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), redInfo.getString("applytaxno"), jqbh));
                continue;
            }
            String key = redInfo.getString("originalinvoicecode") + '_' + redInfo.getString("originalinvoiceno");
            BigDecimal remainAmount = remainRedAmountMap.get(key);
            BigDecimal remainTax = remainRedTaxMap.get(key);
            if (remainAmount == null || remainTax == null) continue;
            if (remainAmount.compareTo(redInfo.getBigDecimal("invoiceamount").abs()) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("{0}\u5269\u4f59\u53ef\u7533\u8bf7\u7ea2\u5b57\u4fe1\u606f\u8868\u91d1\u989d\u4e3a{1}", key, remainAmount.setScale(2, 4)), (String)"RedInfoUploadValidator_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (remainTax.compareTo(redInfo.getBigDecimal("totaltax").abs()) >= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("{0}\u5269\u4f59\u53ef\u7533\u8bf7\u7ea2\u5b57\u4fe1\u606f\u8868\u7a0e\u989d\u4e3a{1}", key, remainTax.setScale(2, 4)), (String)"RedInfoUploadValidator_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }
}

