/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.sim.formplugin.report.AbstractReportDataPlugin;

public class SimBizTypeReportDataPlugin
extends AbstractReportDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(SimBizTypeReportDataPlugin.class);

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        try {
            QFilter filters = this.initFilters(param);
            String fields = DBUtils.getQueryFields((String[])new String[]{"bizcontroltype", "createtime", "usemonth", "useamount", "invoiceid", "orgid", "invoicecode", "invoiceno", "issuestatus", "epname", "taxno"});
            DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bdm_issue_policy_log", (String)fields, (QFilter[])filters.toArray(), (String)"createtime");
            String orgFields = "id,name";
            DataSet resultSet = null;
            if (this.orgIdsSet.isEmpty()) {
                QFilter filter = new QFilter("orgid", "=", (Object)-12344261L);
                return set.filter(filter.toString());
            }
            for (Object orgId : this.orgIdsSet) {
                DataSet copy;
                QFilter idFilter = new QFilter("orgid", "=", orgId);
                DataSet oneOrgResultSet = this.getOneOrgResultSet(orgFields, idFilter, copy = set.copy());
                if (null == oneOrgResultSet) continue;
                if (null == resultSet) {
                    resultSet = oneOrgResultSet;
                    continue;
                }
                resultSet = resultSet.union(oneOrgResultSet);
            }
            return resultSet;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private DataSet getOneOrgResultSet(String orgFields, QFilter idFilter, DataSet copy) {
        DataSet oneOrgSet = copy.filter(idFilter.toString());
        DataSet orgSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bdm_org", (String)orgFields, null, null);
        GroupbyDataSet gSet = oneOrgSet.groupBy(new String[]{"bizcontroltype", "orgid", "taxno", "epname", "usemonth"});
        GroupbyDataSet sumSet = gSet.sum("useamount");
        DataSet finish = sumSet.finish();
        JoinDataSet on = finish.join(orgSet.select("id, name as orgname"), JoinType.LEFT).on("orgid", "id");
        DataSet dataSet = on.select(new String[]{"orgname", "epname", "taxno", "useamount", "bizcontroltype", "usemonth"}).finish();
        DataSet bizTypeSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bdm_biz_control", (String)"id,name,monthlimit", null, null);
        JoinDataSet joinDataSet = dataSet.join(bizTypeSet.select("id, name as bizname, monthlimit"), JoinType.LEFT).on("bizcontroltype", "id");
        return joinDataSet.select(new String[]{"orgname", "epname", "bizname", "monthlimit", "taxno", "useamount", "usemonth", "bizcontroltype"}).finish();
    }

    public QFilter initFilters(ReportQueryParam param) {
        DynamicObjectCollection collection;
        QFilter orgNameFilter;
        FilterInfo info = param.getFilter();
        QFilter resultFilter = this.initTimePeriodFilter(info);
        QFilter orgFilter = this.initOrgFilter(info);
        if (null != orgFilter) {
            resultFilter = resultFilter.and(orgFilter);
        }
        if (null != (orgNameFilter = this.initOrgNameFilter(info))) {
            resultFilter = resultFilter.and(orgNameFilter);
        }
        if ((collection = info.getDynamicObjectCollection("biztype")) != null) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (DynamicObject dynamicObject : collection) {
                ids.add(dynamicObject.getLong("id"));
            }
            QFilter qFilter = new QFilter("bizcontroltype", "in", (Object)ids.toArray());
            resultFilter.and(qFilter);
        }
        return resultFilter;
    }
}

