/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.sim.formplugin.report.AbstractReportDataPlugin;

public class SimBuyerReportDataPlugin
extends AbstractReportDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(SimBuyerReportDataPlugin.class);

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        try {
            QFilter filters = this.initFilters(param);
            String fields = DBUtils.getQueryFields((String[])new String[]{"buyername", "buyertaxno", "invoicetype", "issuetime", "totalamount", "invoiceamount", "totaltax", "orgid"});
            DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sim_vatinvoice", (String)fields, (QFilter[])filters.toArray(), (String)"invoicetype");
            String orgFields = "id,name";
            DataSet resultSet = null;
            if (this.orgIdsSet.isEmpty()) {
                QFilter filter = new QFilter("orgid", "=", (Object)-12344261L);
                return set.filter(filter.toString());
            }
            for (Object orgId : this.orgIdsSet) {
                DataSet copy;
                QFilter idFilter = new QFilter("orgid", "=", orgId);
                DataSet oneOrgResultSet = this.getOneOrgResultSet(orgFields, idFilter, copy = set.copy());
                if (null == oneOrgResultSet) continue;
                if (null == resultSet) {
                    resultSet = oneOrgResultSet;
                    continue;
                }
                resultSet = resultSet.union(oneOrgResultSet);
            }
            return resultSet;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private DataSet getOneOrgResultSet(String orgFields, QFilter idFilter, DataSet copy) {
        DataSet oneOrgSet = copy.filter(idFilter.toString());
        DataSet orgSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bdm_org", (String)orgFields, null, null);
        GroupbyDataSet gSet = oneOrgSet.groupBy(new String[]{"orgid", "buyername", "buyertaxno", "invoicetype"});
        GroupbyDataSet sumSet = gSet.sum("invoiceamount").sum("totalamount").sum("totaltax").count();
        DataSet finish = sumSet.finish();
        JoinDataSet on = finish.join(orgSet.select("id,name"), JoinType.LEFT).on("orgid", "id");
        DataSet oneOrgDetailSet = on.select(new String[]{"name as orgname", "buyername", "buyertaxno", "invoicetype", "invoiceamount", "totalamount", "totaltax", "count as invoicenum"}).finish();
        oneOrgDetailSet = oneOrgDetailSet.orderBy(new String[]{"invoiceamount desc", "totalamount desc", "totaltax desc"});
        DataSet totalGroupSet = oneOrgDetailSet.copy().groupBy(new String[]{"orgname"}).sum("invoiceamount").sum("totalamount").sum("totaltax").sum("invoicenum").finish();
        DataSet oneCountLineSet = totalGroupSet.select(new String[]{"orgname", String.format("'' as %s", "buyername"), String.format("'' as %s", "buyertaxno"), String.format("%s as %s", "'\u603b\u8ba1'", "invoicetype"), "invoiceamount", "totalamount", "totaltax", "invoicenum"});
        return oneOrgDetailSet.union(oneCountLineSet);
    }

    public QFilter initFilters(ReportQueryParam param) {
        QFilter buyerTaxNoFilter;
        QFilter buyerNameFilter;
        QFilter orgNameFilter;
        QFilter invoiceKindFilter;
        FilterInfo info = param.getFilter();
        QFilter resultFilter = this.initTimePeriodFilter(info);
        QFilter orgFilter = this.initOrgFilter(info);
        if (null != orgFilter) {
            resultFilter = resultFilter.and(orgFilter);
        }
        if (null != (invoiceKindFilter = this.initInvoiceKindFilter(info))) {
            resultFilter = resultFilter.and(invoiceKindFilter);
        }
        if (null != (orgNameFilter = this.initOrgNameFilter(info))) {
            resultFilter = resultFilter.and(orgNameFilter);
        }
        if (null != (buyerNameFilter = this.initBuyerNameFilter(info))) {
            resultFilter = resultFilter.and(buyerNameFilter);
        }
        if (null != (buyerTaxNoFilter = this.initBuyerTaxNoFilter(info))) {
            resultFilter = resultFilter.and(buyerTaxNoFilter);
        }
        QFilter filter = this.initExcludeCancelInvoiceFilter();
        resultFilter = resultFilter.and(filter);
        QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        resultFilter = resultFilter.and(issuedFilter);
        return resultFilter;
    }
}

