/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.formplugin.report.AbstractReportDataPlugin;
import kd.imc.sim.untrans.SimFormPluginConstellationUntrans;

public class SimInvStatisticsReportDataPlugin
extends AbstractReportDataPlugin
implements SimFormPluginConstellationUntrans {
    private static final String ITEMS_TAXRATE = "items.taxrate";
    private static final String ITEMS_ZEROTAXMARK = "items.zerotaxmark";
    private static final String ITEMS_AMOUNT = "items.amount";
    private static final String ITEMS_TAX_AMOUNT = "items.tax";
    private static final String T_STATISTICS = "statistics_items";
    public static final List<String> GROUP_LIST = Arrays.asList("groupOne", "groupTwo", "groupThree");
    public static final List<String> ZEROTAXMARK_LIST = Arrays.asList("0", "1", "2", "3");
    public static final List<String> RATE_LIST = Arrays.asList("0.13", "0.09", "0.06", "0.05", "0.03", "0");
    private static final List<String> TITLE_RATE_KEY_LIST = Arrays.asList("thirteenpercent", "ninepercent", "sixpercent", "fivepercent", "threepercent", "zeropercent", "otherpercent");
    private static final String TOTAL_FIELD = "" + TITLE_RATE_KEY_LIST.get(0) + "+" + TITLE_RATE_KEY_LIST.get(1) + "+" + TITLE_RATE_KEY_LIST.get(2) + "+" + TITLE_RATE_KEY_LIST.get(3) + "+" + TITLE_RATE_KEY_LIST.get(4) + "+" + TITLE_RATE_KEY_LIST.get(5) + "+" + TITLE_RATE_KEY_LIST.get(6) + " as total";
    private static final List<QFilter> conditionGroup = new ArrayList<QFilter>(4);
    private static final String[] groupThreeField;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo fInfo = reportQueryParam.getFilter();
        DynamicObjectCollection orgs = reportQueryParam.getFilter().getDynamicObjectCollection("org");
        if (null == orgs) {
            QFilter currOgrFilter = new QFilter("id", "=", (Object)RequestContext.get().getOrgId());
            orgs = QueryServiceHelper.query((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org", (boolean)true), (QFilter[])currOgrFilter.toArray());
        }
        DataSet allDataSet = null;
        List<Long> orgIds = this.buildOrgIds(orgs);
        for (Long orgId : orgIds) {
            String selFieldsGroup3;
            DataSet overSet3;
            String selFieldsGroup2;
            DataSet overSet2;
            QFilter allFilter = this.initTimePeriodFilter(fInfo);
            QFilter orgFilter = new QFilter("orgid", "=", (Object)orgId);
            allFilter.and(orgFilter);
            Map<String, String> epMap = this.getEpInfoByOrgId(orgId);
            if (null == epMap) continue;
            String selFieldsGroup1 = DBUtils.getQueryFields((String[])new String[]{"salername", "salertaxno", ITEMS_AMOUNT, ITEMS_TAXRATE, ITEMS_ZEROTAXMARK});
            DataSet overSet1 = this.filterDataSetByGroup(allFilter, epMap, selFieldsGroup1, GROUP_LIST.get(0));
            QFilter ff = new QFilter("id", "=", (Object)-98989898999L);
            DataSet groupSetOne = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bdm_org", (String)"id", (QFilter[])new QFilter[]{ff}, null);
            DataSet groupSetTwo = null;
            DataSet groupSetThree = null;
            if (null != overSet1) {
                String field = "salername,salertaxno,statistics_items," + TOTAL_FIELD + "," + String.join((CharSequence)",", TITLE_RATE_KEY_LIST) + ",zeropercent0,zeropercent1,zeropercent2,zeropercent3";
                overSet1 = overSet1.select(field);
                DataSet totalSet = this.buildGroupDataSet(overSet1.copy(), GROUP_LIST.get(0));
                groupSetOne = overSet1.union(totalSet);
            }
            if (null != (overSet2 = this.filterDataSetByGroup(allFilter, epMap, selFieldsGroup2 = DBUtils.getQueryFields((String[])new String[]{"salername", "salertaxno", ITEMS_TAX_AMOUNT, ITEMS_TAXRATE, ITEMS_ZEROTAXMARK}), GROUP_LIST.get(1)))) {
                String field = "salername,salertaxno,statistics_items," + TOTAL_FIELD + "," + String.join((CharSequence)",", TITLE_RATE_KEY_LIST) + ",zeropercent0,zeropercent1,zeropercent2,zeropercent3";
                overSet2 = overSet2.select(field).copy();
                DataSet totalSet = this.buildGroupDataSet(overSet2, GROUP_LIST.get(1));
                groupSetTwo = overSet2.union(totalSet);
            }
            if (null != (overSet3 = this.filterDataSetByGroup(allFilter, epMap, selFieldsGroup3 = DBUtils.getQueryFields((String[])new String[]{"id", "salername", "salertaxno"})))) {
                overSet3 = overSet3.groupBy(groupThreeField).sum("total").finish();
                String rateFields = "0 as thirteenpercent,0 as ninepercent,0 as sixpercent,0 as fivepercent,0 as threepercent,0 as zeropercent,0 as otherpercent,0 as zeropercent0,0 as zeropercent1,0 as zeropercent2,0 as zeropercent3";
                String fields = "salername,salertaxno,statistics_items,total," + rateFields + "";
                overSet3 = overSet3.select(fields);
                DataSet totalSet = this.buildGroupDataSet(overSet3.copy(), GROUP_LIST.get(2));
                groupSetThree = overSet3.union(totalSet);
            }
            if (allDataSet == null) {
                allDataSet = groupSetOne.union(new DataSet[]{groupSetTwo, groupSetThree});
                continue;
            }
            allDataSet = allDataSet.union(groupSetOne.union(new DataSet[]{groupSetTwo, groupSetThree}));
        }
        if (null == allDataSet) {
            QFilter nullFilter = new QFilter("id", "=", (Object)-999999999999999L);
            allDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bdm_org", (String)"id", (QFilter[])nullFilter.toArray(), null);
        }
        return allDataSet;
    }

    private DataSet filterDataSetByGroup(QFilter paramFilter, Map<String, String> epMap, String selFields, String group) {
        DataSet unionDataSet = null;
        for (int i = 0; i < conditionGroup.size(); ++i) {
            DataSet selDataSet;
            String[] sel;
            QFilter[] filters = new QFilter[]{paramFilter, conditionGroup.get(i)};
            QFilter rmFilter = QFilter.isNotNull((String)ITEMS_TAXRATE);
            DataSet tmpDataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sim_vatinvoice", (String)selFields, (QFilter[])filters, null).filter(rmFilter.toString());
            if (tmpDataset.isEmpty()) {
                sel = this.buildSelStr(group, true, epMap, i);
                selDataSet = this.buildVirtualDataSet(sel);
                if (selDataSet.isEmpty()) continue;
                unionDataSet = null == unionDataSet ? selDataSet : unionDataSet.union(selDataSet);
                continue;
            }
            sel = this.buildSelStr(group, false, epMap, i);
            selDataSet = tmpDataset.select(sel);
            if (selDataSet.isEmpty()) continue;
            unionDataSet = null == unionDataSet ? selDataSet : unionDataSet.union(selDataSet);
        }
        if (null == unionDataSet) {
            return null;
        }
        return this.buildDataSetFillTaxRate(unionDataSet);
    }

    private DataSet filterDataSetByGroup(QFilter paramFilter, Map<String, String> epMap, String selFields) {
        DataSet unionDataset = null;
        for (int i = 0; i < conditionGroup.size(); ++i) {
            DataSet selDataSet;
            String[] sel;
            QFilter[] filters = new QFilter[]{paramFilter, conditionGroup.get(i)};
            DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sim_vatinvoice", (String)selFields, (QFilter[])filters, null);
            if (tmpDataSet.isEmpty()) {
                sel = this.buildSelStr(GROUP_LIST.get(2), true, epMap, i);
                selDataSet = this.buildVirtualDataSet(sel);
                if (selDataSet.isEmpty()) continue;
                unionDataset = null == unionDataset ? selDataSet : unionDataset.union(selDataSet);
                continue;
            }
            sel = this.buildSelStr(GROUP_LIST.get(2), false, epMap, i);
            selDataSet = tmpDataSet.select(sel);
            if (selDataSet.isEmpty()) continue;
            unionDataset = null == unionDataset ? selDataSet : unionDataset.union(selDataSet);
        }
        if (null == unionDataset) {
            return null;
        }
        return unionDataset;
    }

    private List<Long> buildOrgIds(DynamicObjectCollection orgCollection) {
        if (orgCollection.isEmpty()) {
            return Collections.singletonList(RequestContext.get().getOrgId());
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(orgCollection.size());
        for (DynamicObject org : orgCollection) {
            orgIds.add(org.getLong("id"));
        }
        return orgIds;
    }

    private Map<String, String> getEpInfoByOrgId(Long orgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (org == null) {
            return null;
        }
        DynamicObject epInfo = org.getDynamicObject("epinfo");
        if (epInfo == null) {
            return null;
        }
        HashMap<String, String> epMap = new HashMap<String, String>(2);
        epMap.put("epName", epInfo.getString("name"));
        epMap.put("taxNo", epInfo.getString("number"));
        return epMap;
    }

    public String[] buildSelStr(String group, boolean isEmpty, Map<String, String> epMap, int i) {
        switch (group) {
            case "groupOne": {
                if (isEmpty) {
                    return new String[]{"'" + epMap.get("epName") + "' as " + "salername" + "", "'" + epMap.get("taxNo") + "' as " + "salertaxno" + "", "'" + (String)SimInvStatisticsReportDataPlugin_0.get(i) + "' as " + T_STATISTICS + "", "0 as items.amount", "'999' as items.taxrate", "'998' as items.zerotaxmark"};
                }
                return new String[]{"salername", "salertaxno", "'" + (String)SimInvStatisticsReportDataPlugin_0.get(i) + "' as " + T_STATISTICS + "", ITEMS_AMOUNT, ITEMS_TAXRATE, ITEMS_ZEROTAXMARK};
            }
            case "groupTwo": {
                if (isEmpty) {
                    return new String[]{"'" + epMap.get("epName") + "' as " + "salername" + "", "'" + epMap.get("taxNo") + "' as " + "salertaxno" + "", "'" + (String)SimInvStatisticsReportDataPlugin_1.get(i) + "' as " + T_STATISTICS + "", "0 as items.tax", "'999' as items.taxrate", "'998' as items.zerotaxmark"};
                }
                return new String[]{"salername", "salertaxno", "'" + (String)SimInvStatisticsReportDataPlugin_1.get(i) + "' as " + T_STATISTICS + "", ITEMS_TAX_AMOUNT, ITEMS_TAXRATE, ITEMS_ZEROTAXMARK};
            }
            case "groupThree": {
                if (isEmpty) {
                    return new String[]{"'" + epMap.get("epName") + "' as " + "salername" + "", "'" + epMap.get("taxNo") + "' as " + "salertaxno" + "", "'" + (String)SimInvStatisticsReportDataPlugin_2.get(i) + "' as " + T_STATISTICS + "", "0 as total", "-9999999999 as id"};
                }
                return new String[]{"salername", "salertaxno", "'" + (String)SimInvStatisticsReportDataPlugin_2.get(i) + "' as " + T_STATISTICS + "", "1 as total", "id"};
            }
        }
        return new String[0];
    }

    private DataSet buildDataSetFillTaxRate(DataSet dataSet) {
        String[] fieldsNames = dataSet.getRowMeta().getFieldNames();
        String group = "";
        if (Arrays.asList(fieldsNames).contains(ITEMS_AMOUNT)) {
            group = GROUP_LIST.get(0);
        }
        if (Arrays.asList(fieldsNames).contains(ITEMS_TAX_AMOUNT)) {
            group = GROUP_LIST.get(1);
        }
        QFilter otherPercentFilter = new QFilter(ITEMS_TAXRATE, "not in", RATE_LIST);
        DataSet otherPercentSet = dataSet.copy().filter(otherPercentFilter.toString());
        DataSet buildSet = otherPercentSet = otherPercentSet.select(this.buildRateTitle("other", group, null));
        for (String rate : RATE_LIST) {
            String rateFilter = new QFilter(ITEMS_TAXRATE, "=", (Object)rate).toString();
            DataSet rateFilterSet = dataSet.copy().filter(rateFilter);
            DataSet fillSet = rateFilterSet.select(this.buildRateTitle(rate, group, null));
            buildSet = fillSet.union(buildSet);
            if (!"0".equals(rate)) continue;
            DataSet zeroRateFilterSet = dataSet.copy().filter(rateFilter);
            for (String zerotaxmark : ZEROTAXMARK_LIST) {
                String zerotaxmarkFilter = new QFilter(ITEMS_ZEROTAXMARK, "=", (Object)zerotaxmark).toString();
                DataSet resultFilterSet = zeroRateFilterSet.copy().filter(zerotaxmarkFilter);
                String[] rateTitle = this.buildRateTitle(rate, group, zerotaxmark);
                DataSet fillSet2 = resultFilterSet.select(rateTitle);
                buildSet = fillSet2.union(buildSet);
            }
        }
        buildSet = buildSet.union(otherPercentSet);
        buildSet = buildSet.groupBy(new String[]{"salername", "salertaxno", T_STATISTICS}).sum(TITLE_RATE_KEY_LIST.get(0)).sum(TITLE_RATE_KEY_LIST.get(1)).sum(TITLE_RATE_KEY_LIST.get(2)).sum(TITLE_RATE_KEY_LIST.get(3)).sum(TITLE_RATE_KEY_LIST.get(4)).sum(TITLE_RATE_KEY_LIST.get(5)).sum(TITLE_RATE_KEY_LIST.get(6)).sum("zeropercent0").sum("zeropercent1").sum("zeropercent2").sum("zeropercent3").finish();
        return buildSet;
    }

    public String[] buildRateTitle(String rate, String group, String zerotaxmark) {
        String title = "";
        if (GROUP_LIST.get(0).equals(group)) {
            title = ITEMS_AMOUNT;
        }
        if (GROUP_LIST.get(1).equals(group)) {
            title = ITEMS_TAX_AMOUNT;
        }
        if (GROUP_LIST.get(2).equals(group)) {
            title = "id";
        }
        ArrayList<String> list = new ArrayList<String>();
        if (rate.equals(RATE_LIST.get(0))) {
            list.add("" + title + " as thirteenpercent");
            list.add("0 as ninepercent");
            list.add("0 as sixpercent");
            list.add("0 as fivepercent");
            list.add("0 as threepercent");
            list.add("0 as zeropercent");
            list.add("0 as zeropercent0");
            list.add("0 as zeropercent1");
            list.add("0 as zeropercent2");
            list.add("0 as zeropercent3");
            list.add("0 as otherpercent");
        }
        if (rate.equals(RATE_LIST.get(1))) {
            list.add("0 as thirteenpercent");
            list.add("" + title + " as ninepercent");
            list.add("0 as sixpercent");
            list.add("0 as fivepercent");
            list.add("0 as threepercent");
            list.add("0 as zeropercent");
            list.add("0 as zeropercent0");
            list.add("0 as zeropercent1");
            list.add("0 as zeropercent2");
            list.add("0 as zeropercent3");
            list.add("0 as otherpercent");
        }
        if (rate.equals(RATE_LIST.get(2))) {
            list.add("0 as thirteenpercent");
            list.add("0 as ninepercent");
            list.add("" + title + " as sixpercent");
            list.add("0 as fivepercent");
            list.add("0 as threepercent");
            list.add("0 as zeropercent");
            list.add("0 as zeropercent0");
            list.add("0 as zeropercent1");
            list.add("0 as zeropercent2");
            list.add("0 as zeropercent3");
            list.add("0 as otherpercent");
        }
        if (rate.equals(RATE_LIST.get(3))) {
            list.add("0 as thirteenpercent");
            list.add("0 as ninepercent");
            list.add("0 as sixpercent");
            list.add("" + title + " as fivepercent");
            list.add("0 as threepercent");
            list.add("0 as zeropercent");
            list.add("0 as zeropercent0");
            list.add("0 as zeropercent1");
            list.add("0 as zeropercent2");
            list.add("0 as zeropercent3");
            list.add("0 as otherpercent");
        }
        if (rate.equals(RATE_LIST.get(4))) {
            list.add("0 as thirteenpercent");
            list.add("0 as ninepercent");
            list.add("0 as sixpercent");
            list.add("0 as fivepercent");
            list.add("" + title + " as threepercent");
            list.add("0 as zeropercent");
            list.add("0 as zeropercent0");
            list.add("0 as zeropercent1");
            list.add("0 as zeropercent2");
            list.add("0 as zeropercent3");
            list.add("0 as otherpercent");
        }
        if (rate.equals(RATE_LIST.get(5))) {
            list.add("0 as thirteenpercent");
            list.add("0 as ninepercent");
            list.add("0 as sixpercent");
            list.add("0 as fivepercent");
            list.add("0 as threepercent");
            if (zerotaxmark != null) {
                list.add("0 as zeropercent");
                for (String mark : ZEROTAXMARK_LIST) {
                    if (mark.equals(zerotaxmark)) {
                        list.add("" + title + " as zeropercent" + mark);
                        continue;
                    }
                    list.add("0 as zeropercent" + mark);
                }
            } else {
                list.add("" + title + " as zeropercent");
                list.add("0 as zeropercent0");
                list.add("0 as zeropercent1");
                list.add("0 as zeropercent2");
                list.add("0 as zeropercent3");
            }
            list.add("0 as otherpercent");
        }
        if (rate.equals("other")) {
            list.add("0 as thirteenpercent");
            list.add("0 as ninepercent");
            list.add("0 as sixpercent");
            list.add("0 as fivepercent");
            list.add("0 as threepercent");
            list.add("0 as zeropercent");
            list.add("0 as zeropercent0");
            list.add("0 as zeropercent1");
            list.add("0 as zeropercent2");
            list.add("0 as zeropercent3");
            list.add("" + title + " as otherpercent");
        }
        Collections.addAll(list, "salername", "salertaxno", T_STATISTICS);
        return list.toArray(new String[list.size()]);
    }

    private DataSet buildGroupDataSet(DataSet overSet, String group) {
        QFilter totalFilter;
        String field = "";
        if (GROUP_LIST.get(0).equals(group)) {
            totalFilter = new QFilter(T_STATISTICS, "in", (Object)new String[]{(String)SimInvStatisticsReportDataPlugin_0.get(1), (String)SimInvStatisticsReportDataPlugin_0.get(3)});
            overSet = overSet.filter(totalFilter.toString());
            field = "salername,'' as salertaxno,'\u5b9e\u9645\u9500\u552e\u91d1\u989d' as statistics_items," + TOTAL_FIELD + "," + String.join((CharSequence)",", TITLE_RATE_KEY_LIST) + ",zeropercent0,zeropercent1,zeropercent2,zeropercent3";
        }
        if (GROUP_LIST.get(1).equals(group)) {
            totalFilter = new QFilter(T_STATISTICS, "in", (Object)new String[]{(String)SimInvStatisticsReportDataPlugin_1.get(1), (String)SimInvStatisticsReportDataPlugin_1.get(3)});
            overSet = overSet.filter(totalFilter.toString());
            field = "salername,'' as salertaxno,'\u5b9e\u9645\u9500\u552e\u7a0e\u989d' as statistics_items," + TOTAL_FIELD + "," + String.join((CharSequence)",", TITLE_RATE_KEY_LIST) + ",zeropercent0,zeropercent1,zeropercent2,zeropercent3";
        }
        if (GROUP_LIST.get(2).equals(group)) {
            totalFilter = new QFilter(T_STATISTICS, "in", (Object)new String[]{(String)SimInvStatisticsReportDataPlugin_2.get(1), (String)SimInvStatisticsReportDataPlugin_2.get(3)});
            overSet = overSet.filter(totalFilter.toString());
            String rateFields = "0 as thirteenpercent,0 as ninepercent,0 as sixpercent,0 as fivepercent,0 as threepercent,0 as zeropercent,0 as zeropercent0,0 as zeropercent1,0 as zeropercent2,0 as zeropercent3,0 as otherpercent";
            field = "salername,'' as salertaxno,'\u5df2\u5f00\u53d1\u7968\u4efd\u6570' as statistics_items,total," + rateFields + "";
            DataSet groupSet = overSet.groupBy(new String[]{"salername", "salertaxno"}).sum("total").finish();
            return groupSet.select(field);
        }
        DataSet groupSet = overSet.groupBy(new String[]{"salername", "salertaxno"}).sum(TITLE_RATE_KEY_LIST.get(0)).sum(TITLE_RATE_KEY_LIST.get(1)).sum(TITLE_RATE_KEY_LIST.get(2)).sum(TITLE_RATE_KEY_LIST.get(3)).sum(TITLE_RATE_KEY_LIST.get(4)).sum(TITLE_RATE_KEY_LIST.get(5)).sum(TITLE_RATE_KEY_LIST.get(6)).sum("zeropercent0").sum("zeropercent1").sum("zeropercent2").sum("zeropercent3").finish();
        groupSet = groupSet.select(field);
        return groupSet;
    }

    private DataSet buildVirtualDataSet(String[] sel) {
        QFilter tmpFilter = new QFilter("id", "=", (Object)RequestContext.get().getOrgId());
        DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bdm_org", (String)"id", (QFilter[])tmpFilter.toArray(), null);
        return tmpDataSet.select(sel);
    }

    static {
        conditionGroup.add(new QFilter("invoicestatus", "=", (Object)"6").and("issuetype", "=", (Object)"0"));
        conditionGroup.add(new QFilter("invoicestatus", "in", (Object)new String[]{"0", "3"}).and("issuetype", "=", (Object)"0"));
        conditionGroup.add(new QFilter("invoicestatus", "=", (Object)"6").and("issuetype", "=", (Object)"1"));
        conditionGroup.add(new QFilter("invoicestatus", "=", (Object)"0").and("issuetype", "=", (Object)"1"));
        groupThreeField = new String[]{"salername", "salertaxno", T_STATISTICS};
    }
}

