/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.sim.formplugin.report.AbstractReportDataPlugin;

public class SimStatusReportDataPlugin
extends AbstractReportDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(SimStatusReportDataPlugin.class);
    private DataSet totallize = null;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        try {
            QFilter filters = this.initFilters(reportQueryParam);
            HashSet<String> enterpriseNames = this.queryEnterpriseName(reportQueryParam.getFilter());
            String fields = DBUtils.getQueryFields((String[])new String[]{"salername", "salertaxno", "invoicetype", "invoicestatus", "totaltax", "invoiceamount", "totalamount", "orgid"});
            DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sim_vatinvoice", (String)fields, (QFilter[])filters.toArray(), (String)"invoicetype");
            String orgFields = "id,name";
            DataSet resultSet = null;
            if (enterpriseNames.isEmpty()) {
                QFilter filter = new QFilter("orgid", "=", (Object)-12344261L);
                return set.filter(filter.toString());
            }
            for (String eName : enterpriseNames) {
                QFilter nameFilter = new QFilter("salername", "=", (Object)eName);
                DataSet copy = set.copy();
                DataSet oneOrgResultSet = this.getOneEResultSet(orgFields, nameFilter, copy);
                if (null == resultSet) {
                    resultSet = oneOrgResultSet;
                    continue;
                }
                resultSet = resultSet.union(oneOrgResultSet);
            }
            if (null != resultSet) {
                resultSet = resultSet.orderBy(new String[]{"salername", "invoicetype", "invoicestatus"});
                DataSet totallizeRow = this.totallize.groupBy(new String[]{"totallize"}).sum("totaltax").sum("invoiceamount").sum("totalamount").sum("orgid").finish();
                DataSet selectLastRow = totallizeRow.select(new String[]{"'\u603b\u8ba1' as invoicetype", "'' as invoicestatus", "'' as salername", "'' as salertaxno", "totaltax", "invoiceamount", "totalamount", "orgid", "totallize"});
                return resultSet.union(selectLastRow);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private DataSet getOneEResultSet(String orgFields, QFilter nameFilter, DataSet copy) {
        DataSet oneOrgSet = copy.filter(nameFilter.toString());
        DataSet orgSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bdm_org", (String)orgFields, null, null);
        GroupbyDataSet gSet = oneOrgSet.groupBy(new String[]{"salername", "invoicetype", "invoicestatus", "salertaxno", "orgid"});
        GroupbyDataSet sumSet = gSet.sum("totaltax").sum("invoiceamount").sum("totalamount").count();
        DataSet finish = sumSet.finish();
        JoinDataSet on = finish.join(orgSet.select("id,name"), JoinType.LEFT).on("orgid", "id");
        DataSet oneNameDetailSet = on.select(new String[]{"invoicetype", "invoicestatus", "salername", "salertaxno", "totaltax", "invoiceamount", "totalamount", "count as orgid", "'0' as totallize"}).finish();
        DataSet totalGroupSet = oneNameDetailSet.copy().groupBy(new String[]{"salername", "totallize"}).sum("totaltax").sum("invoiceamount").sum("totalamount").sum("orgid").finish();
        DataSet oneCountLineSet = totalGroupSet.select(new String[]{"'\u5c0f\u8ba1' as invoicetype", "'' as invoicestatus", "salername", "'' as salertaxno", "totaltax", "invoiceamount", "totalamount", "orgid", "totallize"});
        this.totallize = null == this.totallize ? oneCountLineSet.copy() : this.totallize.union(oneCountLineSet.copy());
        return oneNameDetailSet.union(oneCountLineSet);
    }

    private QFilter initFilters(ReportQueryParam param) {
        QFilter sellerTaxNoFilter;
        QFilter sellerNameFilter;
        QFilter orgNameFilter;
        QFilter invoiceKindFilter;
        FilterInfo info = param.getFilter();
        QFilter resultFilter = this.initTimePeriodFilter(info);
        QFilter orgFilter = this.initOrgFilter(info);
        if (null != orgFilter) {
            resultFilter = resultFilter.and(orgFilter);
        }
        if (null != (invoiceKindFilter = this.initInvoiceKindFilter(info))) {
            resultFilter = resultFilter.and(invoiceKindFilter);
        }
        if (null != (orgNameFilter = this.initOrgNameFilter(info))) {
            resultFilter = resultFilter.and(orgNameFilter);
        }
        if (null != (sellerNameFilter = this.initSellerNameFilter(info))) {
            resultFilter = resultFilter.and(sellerNameFilter);
        }
        if (null != (sellerTaxNoFilter = this.initSellerTaxNoFilter(info))) {
            resultFilter = resultFilter.and(sellerTaxNoFilter);
        }
        QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        resultFilter = resultFilter.and(issuedFilter);
        return resultFilter;
    }
}

