/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.sim.formplugin.report.AbstractReportDataPlugin;

public class SimVehicleReportDataPlugin
extends AbstractReportDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(SimVehicleReportDataPlugin.class);
    private static final String[] vehicleInvoiceType = new String[]{"83xdp", "06xdp", "006"};
    private static final String[] usedCarInvoiceType = new String[]{"84xdp", "51xdp"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter baseFilter = this.initFilters(reportQueryParam);
        HashSet<String> enterpriseNames = this.queryEnterpriseName(reportQueryParam.getFilter());
        String fields = DBUtils.getQueryFields((String[])new String[]{"salername", "salertaxno", "issuename", "issuetaxno", "totalamount", "invoiceamount", "totaltax", "invoicetype", "invoicestatus"});
        DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sim_vatinvoice_vehicles", (String)fields, (QFilter[])baseFilter.toArray(), null);
        QFilter filter = new QFilter("invoicetype", "in", (Object)vehicleInvoiceType);
        QFilter usedCarFilter = new QFilter("invoicetype", "in", (Object)usedCarInvoiceType);
        DataSet resultSet = null;
        DataSet totalSet = null;
        for (String enterpriseName : enterpriseNames) {
            DataSet smallCountSet = null;
            DataSet copy = set.copy();
            DataSet vehicleDataSet = copy.filter(filter.toString());
            QFilter nameFilter = new QFilter("salername", "=", (Object)enterpriseName);
            DataSet oneNameSet = vehicleDataSet.filter(nameFilter.toString());
            oneNameSet = oneNameSet.groupBy(new String[]{"salername", "salertaxno", "invoicetype", "invoicestatus"}).sum("totaltax").sum("invoiceamount").sum("totalamount").count().finish();
            oneNameSet = oneNameSet.select(new String[]{"salername as issuename", "salertaxno as issuetaxno", "invoicetype", "invoicestatus", "count as invoicenum", "invoiceamount", "totaltax", "totalamount"});
            resultSet = null == resultSet ? oneNameSet : resultSet.union(oneNameSet);
            smallCountSet = oneNameSet.copy();
            DataSet copyUsedCarSet = set.copy();
            DataSet usedCarDataSet = copyUsedCarSet.filter(usedCarFilter.toString());
            nameFilter = new QFilter("issuename", "=", (Object)enterpriseName);
            oneNameSet = usedCarDataSet.filter(nameFilter.toString());
            oneNameSet = oneNameSet.groupBy(new String[]{"issuename", "issuetaxno", "invoicetype", "invoicestatus"}).sum("totaltax").sum("invoiceamount").sum("totalamount").count().finish();
            oneNameSet = oneNameSet.select(new String[]{"issuename", "issuetaxno", "invoicetype", "invoicestatus", "count as invoicenum", "invoiceamount", "totaltax", "totalamount"});
            smallCountSet = smallCountSet.union(oneNameSet.copy()).groupBy(new String[]{"issuename"}).sum("invoicenum").sum("invoiceamount").sum("totaltax").sum("totalamount").finish();
            smallCountSet = smallCountSet.select(new String[]{"issuename", "'' as issuetaxno", "'\u5c0f\u8ba1' as invoicetype", "'' as invoicestatus", "invoicenum", "invoiceamount", "totaltax", "totalamount"});
            totalSet = null == totalSet ? smallCountSet.copy() : totalSet.union(smallCountSet.copy());
            if (null == resultSet) {
                resultSet = oneNameSet;
                continue;
            }
            resultSet = resultSet.union(oneNameSet).union(smallCountSet);
        }
        if (null != totalSet) {
            totalSet = totalSet.groupBy(new String[]{"invoicetype"}).sum("invoicenum").sum("invoiceamount").sum("totaltax").sum("totalamount").finish();
            totalSet = totalSet.select(new String[]{"'' as issuename", "'' as issuetaxno", "'\u603b\u8ba1' as invoicetype", "'' as invoicestatus", "invoicenum", "invoiceamount", "totaltax", "totalamount"});
            resultSet = resultSet.union(totalSet);
        }
        return resultSet;
    }

    private QFilter initFilters(ReportQueryParam param) {
        QFilter invoiceKindFilter;
        FilterInfo filterInfo = param.getFilter();
        QFilter resultFilter = this.initTimePeriodFilter(filterInfo);
        QFilter orgFilter = this.initOrgFilter(filterInfo);
        if (null != orgFilter) {
            resultFilter = resultFilter.and(orgFilter);
        }
        if (null != (invoiceKindFilter = this.initInvoiceKindFilter(filterInfo))) {
            resultFilter = resultFilter.and(invoiceKindFilter);
        }
        resultFilter.and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        return resultFilter;
    }
}

