/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.report.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.formplugin.report.AbstractReportPlugin;
import kd.imc.sim.formplugin.report.plugin.SimStatusReportDataPlugin;
import kd.imc.sim.formplugin.report.plugin.SimVehicleReportDataPlugin;

public class SimVehicleReportFormPlugin
extends AbstractReportPlugin
implements HyperLinkClickListener {
    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"close"});
        this.initBaseOrgParamFilter();
        this.initStartDayFilter();
        this.initEndDayFilter();
    }

    public void destory() {
        String pageId = this.getView().getPageId();
        CacheHelper.remove((String)pageId);
        super.destory();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.timeVerify(queryParam);
    }

    public void registerListener(EventObject e) {
        ReportList entryGrid = (ReportList)this.getView().getControl("reportlistap");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        IDataModel model = this.getModel();
        Date startDate = (Date)model.getValue("startdate");
        Date enddate = (Date)model.getValue("enddate");
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection orgList = filterInfo.getDynamicObjectCollection("org");
        String salername = rowData.getString("issuename");
        String taxno = rowData.getString("issuetaxno");
        String invoiceType = rowData.getString("invoicetype");
        String invoiceStatus = rowData.getString("invoicestatus");
        this.showInvoice(startDate, enddate, filterInfo, orgList, salername, taxno, invoiceType, null, invoiceStatus);
    }

    public void showInvoice(Date startDate, Date enddate, FilterInfo filterInfo, DynamicObjectCollection orgList, String salername, String taxno, String invoiceType, String org_Name, String invoiceStatus) {
        DynamicObject[] invoiceArray;
        QFilter orgFilter = this.getOrgFilter(orgList);
        QFilter dateFilter = this.getDateFilter(startDate, enddate);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        QFilter sellerNameFilter = null;
        if (StringUtils.isNotBlank((CharSequence)salername)) {
            if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
                sellerNameFilter = new QFilter("issuename", "=", (Object)salername);
                qFilters.add(sellerNameFilter);
            }
            if (InvoiceUtils.isVehicleInvoice((String)invoiceType)) {
                sellerNameFilter = new QFilter("salername", "=", (Object)salername);
                qFilters.add(sellerNameFilter);
            }
        }
        QFilter invoiceTypeFilter = new QFilter("invoicetype", "=", (Object)invoiceType);
        QFilter invoiceStatusFilter = new QFilter("invoicestatus", "=", (Object)invoiceStatus);
        SimStatusReportDataPlugin data = new SimStatusReportDataPlugin();
        HashSet<String> enterpriseName = data.queryEnterpriseName(filterInfo);
        Collections.addAll(qFilters, orgFilter, dateFilter, issuedFilter, invoiceTypeFilter, invoiceStatusFilter);
        if ("\u5c0f\u8ba1".equals(invoiceType) || "\u603b\u8ba1".equals(invoiceType)) {
            qFilters.remove(invoiceStatusFilter);
            qFilters.remove(invoiceTypeFilter);
            qFilters.remove(orgFilter);
            if (null != sellerNameFilter) {
                qFilters.remove(sellerNameFilter);
            }
            DynamicObjectCollection collection = filterInfo.getDynamicObjectCollection("org");
            SimVehicleReportDataPlugin dataPlugin = new SimVehicleReportDataPlugin();
            String invoiceTypeStrs = (String)this.getModel().getValue("invoicekind");
            if (StringUtils.isNotBlank((CharSequence)invoiceTypeStrs)) {
                String[] invoiceTypeArray = invoiceTypeStrs.split(",");
                Object[] invoiceTypeArrays = Arrays.stream(invoiceTypeArray).filter(o -> StringUtils.isNotBlank((CharSequence)o)).toArray();
                if (invoiceTypeArray.length > 0) {
                    qFilters.add(new QFilter("invoicetype", "in", (Object)invoiceTypeArrays));
                }
            }
            if ("\u5c0f\u8ba1".equals(invoiceType)) {
                QFilter allNameFilter = new QFilter("salername", "=", (Object)salername).or("issuename", "=", (Object)salername);
                qFilters.add(allNameFilter);
                QFilter orgIdFilter = dataPlugin.getOrgFilter(collection, null);
                qFilters.add(orgIdFilter);
            }
            if ("\u603b\u8ba1".equals(invoiceType)) {
                QFilter orgIdFilter = dataPlugin.getOrgFilter(collection, null);
                qFilters.add(orgIdFilter);
                QFilter allNameFilter = new QFilter("salername", "in", (Object)enterpriseName.toArray(new String[0])).or("issuename", "in", (Object)enterpriseName.toArray(new String[0]));
                qFilters.add(allNameFilter);
            }
        }
        if ((invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]))).length > 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject invoice : invoiceArray) {
                pks.add(invoice.getPkValue());
            }
            QFilter idFilter = new QFilter("id", "in", (Object)pks.toArray());
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("isFromGoodsReport", "isFromGoodsReport");
            ViewUtil.openListPageByMainPage((AbstractFormPlugin)this, (QFilter)idFilter, parameter, (String)"sim_vatinvoice_vehicles", null, null);
        }
    }

    public QFilter getOrgFilter(DynamicObjectCollection collection) {
        int size = collection.size();
        Object[] ids = new Object[size];
        for (int i = 0; i < collection.size(); ++i) {
            Object id;
            ids[i] = id = ((DynamicObject)collection.get(i)).get("id");
        }
        QFilter filter = ids.length == 0 ? new QFilter("orgid", "=", (Object)RequestContext.get().getOrgId()) : new QFilter("orgid", "in", (Object)ids);
        return filter;
    }
}

