/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.taxcopyandclear;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.CopyTaxAndRestHelper;
import kd.imc.sim.common.model.taxcopyandreset.CopyTaxAndRestUnlockVo;
import kd.imc.sim.common.model.taxcopyandreset.CopyTaxReturn;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import org.apache.commons.lang3.StringUtils;

public class CopyTaxAndRestPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(CopyTaxAndRestPlugin.class);
    private static final String SIM_COPY_TAX_RETURNS = "sim_copy_tax_returns";
    private static final String BTN_COPY_UNLOCK = "btn_copy_tax_reset_unlock";

    public void createNewData(BizDataEventArgs e) {
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)String.join((CharSequence)",", "devlist_tag", "epinfo"), (QFilter[])new QFilter("id", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (orgObj == null) {
            return;
        }
        String devListStr = orgObj.getString("devlist_tag").trim();
        if (StringUtils.isBlank((CharSequence)devListStr)) {
            return;
        }
        List<String> devList = Arrays.asList(devListStr.split(","));
        List devListL = devList.stream().map(m -> Long.parseLong(m.trim())).collect(Collectors.toList());
        QFilter equipmentFilter = new QFilter("id", "in", devListL);
        String selFields = PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_tax_equipment");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)selFields, (QFilter[])equipmentFilter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ArrayList<String> errMsg = new ArrayList<String>();
        for (DynamicObject equipment : dynamicObjects) {
            CopyTaxReturn copyTaxReturn = new CopyTaxReturn();
            DynamicObject epinfo = orgObj.getDynamicObject("epinfo");
            if (null == epinfo) {
                return;
            }
            String equipmentType = equipment.getString("equipmenttype");
            if (!"0".equals(equipmentType) && !"2".equals(equipmentType) && !"1".equals(equipmentType) && !EquipmentType.isLyServer((String)equipmentType)) continue;
            copyTaxReturn.setEquipmentCode(equipment.getString("equipmentno"));
            copyTaxReturn.setEquipmentName(equipment.getString("equipmentname"));
            copyTaxReturn.setEquipmentType(Integer.valueOf(equipment.getInt("equipmenttype")));
            copyTaxReturn.setEquipmentId(Long.valueOf(equipment.getLong("id")));
            Integer authStatus = equipment.getInt("authstatus") != 1 ? 2 : equipment.getInt("authstatus");
            copyTaxReturn.setEqupmentStatus(authStatus);
            copyTaxReturn.setEpInfoId(Long.valueOf(epinfo.getLong("id")));
            copyTaxReturn.setEpInfoName(epinfo.getString("name"));
            copyTaxReturn.setEpInfoTaxNo(epinfo.getString("number"));
            copyTaxReturn.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
            this.saveCopyTaxReturn(copyTaxReturn);
            HashMap<String, Object> pMap = new HashMap<String, Object>();
            pMap.put("deviceStatus", copyTaxReturn.getEqupmentStatus());
            pMap.put("copySuccessDate", copyTaxReturn.getCopySuccessMonth());
            pMap.put("taxReturnEndDate", copyTaxReturn.getTaxReturnEndDate());
            String msg = CopyTaxAndRestHelper.checkRules(pMap);
            if (StringUtils.isNotBlank((CharSequence)msg)) continue;
            try {
                this.onloadCopyTaxReturn(copyTaxReturn);
            }
            catch (Exception ex) {
                errMsg.add(ex.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            this.getView().showErrorNotification(String.join((CharSequence)",", errMsg));
        }
    }

    public void afterCreateNewData(EventObject e) {
        List devList;
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"btn_exit"});
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)String.join((CharSequence)",", "devlist_tag", "epinfo"), (QFilter[])new QFilter("id", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (null == orgObj) {
            return;
        }
        DynamicObject epinfo = orgObj.getDynamicObject("epinfo");
        if (epinfo == null) {
            return;
        }
        String devListStr = orgObj.getString("devlist_tag").trim();
        List<Object> list = devList = StringUtils.isBlank((CharSequence)devListStr) ? Collections.emptyList() : Arrays.asList(devListStr.trim().split(","));
        if (devList.isEmpty()) {
            QFilter delFilter = new QFilter("epinfo", "=", epinfo.getPkValue());
            DeleteServiceHelper.delete((String)SIM_COPY_TAX_RETURNS, (QFilter[])delFilter.toArray());
            return;
        }
        List devListL = devList.stream().map(m -> Long.parseLong(m.trim())).collect(Collectors.toList());
        QFilter cpDelFilter = new QFilter("equipment", "not in", devListL).and("epinfo", "=", epinfo.getPkValue());
        DeleteServiceHelper.delete((String)SIM_COPY_TAX_RETURNS, (QFilter[])cpDelFilter.toArray());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String btnKey = evt.getItemKey();
        if (BTN_COPY_UNLOCK.equals(btnKey)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SIM_COPYTAX_AND_RESET);
            this.copyUnlockDeal();
        }
    }

    public void setFilter(SetFilterEvent e) {
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"epinfo.id", (QFilter[])new QFilter("id", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (null == orgObj) {
            return;
        }
        QFilter qFilter = new QFilter("epinfo", "=", orgObj.get("epinfo.id"));
        e.getCustomQFilters().add(qFilter);
    }

    private void copyUnlockDeal() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (null == selectedRows || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u6284\u7a0e\u6e05\u5361\u5904\u7406!", (String)"CopyTaxAndRestPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Long copyTaxReturnId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        if (null == copyTaxReturnId) {
            return;
        }
        DynamicObject copyTaxReturnObj = BusinessDataServiceHelper.loadSingle((Object)copyTaxReturnId, (String)SIM_COPY_TAX_RETURNS);
        if (null == copyTaxReturnObj) {
            return;
        }
        DynamicObject epInfo = copyTaxReturnObj.getDynamicObject("epinfo");
        DynamicObject equipment = copyTaxReturnObj.getDynamicObject("equipment");
        if (null == epInfo || null == equipment) {
            return;
        }
        Map rMap = ApiVerifyUtil.checkAndFillOrgCode((String)epInfo.getString("number"), null, null);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)rMap.get("checkMsg")))) {
            return;
        }
        String taxNo = StringUtils.isBlank((CharSequence)epInfo.getString("number")) ? "" : epInfo.getString("number");
        String deviceNo = StringUtils.isBlank((CharSequence)equipment.getString("equipmentno")) ? "" : equipment.getString("equipmentno");
        Integer deviceType = equipment.getInt("equipmenttype");
        DynamicObject equipmentObj = BusinessDataServiceHelper.loadSingle((Object)equipment.getPkValue(), (String)"bdm_tax_equipment");
        Integer authStatus = equipmentObj.getInt("authstatus") != 1 ? 2 : equipmentObj.getInt("authstatus");
        String taxReturnEndDate = copyTaxReturnObj.getString("tax_return_end_date");
        taxReturnEndDate = StringUtils.isNotBlank((CharSequence)taxReturnEndDate) ? taxReturnEndDate : "";
        taxReturnEndDate = taxReturnEndDate.length() >= 10 ? taxReturnEndDate.substring(0, 10) : taxReturnEndDate;
        HashMap<String, Object> pMap = new HashMap<String, Object>();
        pMap.put("deviceStatus", authStatus);
        pMap.put("copySuccessDate", copyTaxReturnObj.getString("copy_success_date"));
        pMap.put("taxReturnEndDate", taxReturnEndDate);
        String msg = CopyTaxAndRestHelper.checkRules(pMap);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.getView().showTipNotification(msg, Integer.valueOf(3000));
            return;
        }
        CopyTaxAndRestUnlockVo vo = new CopyTaxAndRestUnlockVo();
        vo.setTaxNo(taxNo);
        vo.setCopyTaxReturnId(copyTaxReturnId);
        vo.setDeviceNo(deviceNo);
        vo.setDeviceType(deviceType);
        vo.setEquipmentId(Long.valueOf(Long.parseLong(equipment.getString("id"))));
        vo.setEpInfoId(Long.valueOf(Long.parseLong(epInfo.getString("id"))));
        vo.setOrgId(Long.valueOf(Long.parseLong((String)rMap.get("orgId"))));
        vo.setEqupmentStatus(authStatus);
        Map dealMsg = Optional.ofNullable(CopyTaxAndRestHelper.copyTaxAndRestUnlock((CopyTaxAndRestUnlockVo)vo)).orElseGet(HashMap::new);
        ((IListView)this.getView()).refresh();
        if (ErrorType.SUCCESS.getCode().equals(dealMsg.get("code"))) {
            this.getView().showSuccessNotification((String)dealMsg.get("msg"), Integer.valueOf(3000));
            return;
        }
        this.getView().showErrorNotification((String)dealMsg.get("msg"));
    }

    private CopyTaxReturn saveCopyTaxReturn(CopyTaxReturn copyTaxReturn) {
        if (null == copyTaxReturn) {
            return null;
        }
        QFilter saveFilter1 = new QFilter("epinfo", "=", (Object)copyTaxReturn.getEpInfoId());
        QFilter saveFilter2 = new QFilter("equipment", "=", (Object)copyTaxReturn.getEquipmentId());
        String selectFields = "id,epinfo,equipment,org,equipment_status";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)SIM_COPY_TAX_RETURNS, (String)selectFields, (QFilter[])new QFilter[]{saveFilter1, saveFilter2});
        if (null == dynamicObject) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)SIM_COPY_TAX_RETURNS);
        }
        dynamicObject.set("epinfo", (Object)copyTaxReturn.getEpInfoId());
        dynamicObject.set("equipment", (Object)copyTaxReturn.getEquipmentId());
        dynamicObject.set("org", (Object)copyTaxReturn.getOrgId());
        dynamicObject.set("equipment_status", (Object)copyTaxReturn.getEqupmentStatus());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        copyTaxReturn.setId(String.valueOf(dynamicObject.getPkValue()));
        return copyTaxReturn;
    }

    private void onloadCopyTaxReturn(CopyTaxReturn copyTaxReturn) {
        CopyTaxAndRestUnlockVo vo = new CopyTaxAndRestUnlockVo();
        vo.setTaxNo(copyTaxReturn.getEpInfoTaxNo());
        vo.setCopyTaxReturnId(Long.valueOf(Long.parseLong(copyTaxReturn.getId())));
        vo.setDeviceNo(copyTaxReturn.getEquipmentCode());
        vo.setDeviceType(copyTaxReturn.getEquipmentType());
        vo.setEquipmentId(copyTaxReturn.getEquipmentId());
        vo.setEpInfoId(copyTaxReturn.getEpInfoId());
        vo.setOrgId(copyTaxReturn.getOrgId());
        vo.setEqupmentStatus(copyTaxReturn.getEqupmentStatus());
        Map rMap = CopyTaxAndRestHelper.copyTaxAndRestUnlock((CopyTaxAndRestUnlockVo)vo);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u5217\u8868\u9875\u9762\u52a0\u8f7d\u524d\u6284\u7a0e\u6e05\u5361\u7ed3\u679c\u662f\uff1a%s", JSON.toJSONString((Object)rMap)));
        }
    }
}

